<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "256kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.workflow.vo.ManagerApprovalListVo"
%><%
ManagerApprovalListVo vo = (ManagerApprovalListVo)request.getAttribute(MospConst.ATT_VO);
String[][] aryApplication  		= vo.getEscAryApplication();
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>
<div class="Body" id="overTimeRequestList">
	<%= HtmlUtility.getMessages(vo) %>
	<div class="Select">
		<table>
			<tr>
				<td >
					<span><%= CommonConst.NAM_STATION %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<select id="<%= ManagerApprovalListVo.PRM_PLT_SECTION %>" name="<%= ManagerApprovalListVo.PRM_PLT_SECTION %>">
						<%=HtmlUtility.getSelectOption(vo.aryPltSection, vo.getPltSection())%>
					</select>
				</td>
				<td >
					<span><%= vo.NAM_APPLICATION %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<select id="<%= ManagerApprovalListVo.PRM_PLT_APPLICATION %>" name="<%= ManagerApprovalListVo.PRM_PLT_APPLICATION %>">
						<%=HtmlUtility.getSelectOption(vo.aryPltApplication, vo.getPltApplication())%>
					</select>
				</td>
				<td >
					<span><%= vo.NAM_STATUS %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<select id="<%= ManagerApprovalListVo.PRM_PLT_STATUS %>" name="<%= ManagerApprovalListVo.PRM_PLT_STATUS %>">
						<%=HtmlUtility.getSelectOption(vo.aryPltStatus, vo.getPltStatus())%>
					</select>
				</td>
				<td class="ButtonTd" rowspan="2">
					<button type="button" onclick="doSubmit(document.form, 'K2131')"><%= CommonConst.NAM_SEARCH %></button>
				</td>
			</tr>
			<tr>
				<td >
					<span><%= vo.NAM_K_CODE %><%=CommonConst.STR_TITLE_SEPARATOR%></span>
					<input type="text" class="UserIdText" id="<%= ManagerApprovalListVo.PRM_TXT_K_CODE %>" name="<%= ManagerApprovalListVo.PRM_TXT_K_CODE %>" value="<%= vo.getEscTxtKCode() %>">
				</td>
				<td >
					<span><%= vo.NAM_K_NAME %><%=CommonConst.STR_TITLE_SEPARATOR%></span>
					<input id="<%= ManagerApprovalListVo.PRM_TXT_K_NAME %>" name="<%= ManagerApprovalListVo.PRM_TXT_K_NAME %>" value="<%= vo.getEscTxtKName() %>">
				</td>
				<td >
					<span><%= vo.NAM_DATE %><%=CommonConst.STR_TITLE_SEPARATOR%></span>
					<select id="<%= ManagerApprovalListVo.PRM_PLT_YEAR %>" name="<%= ManagerApprovalListVo.PRM_PLT_YEAR %>">
						<%=HtmlUtility.getSelectOption(vo.aryPltYear, vo.getPltYear())%>
					</select><%= CommonConst.NAM_YEAR %>
					<select id="<%= ManagerApprovalListVo.PRM_PLT_MONTH %>" name="<%= ManagerApprovalListVo.PRM_PLT_MONTH %>">
						<%=HtmlUtility.getSelectOption(vo.aryPltMonth, vo.getPltMonth())%>
					</select><%= CommonConst.NAM_MONTH %>
					<select id="<%= ManagerApprovalListVo.PRM_PLT_DAY %>" name="<%= ManagerApprovalListVo.PRM_PLT_DAY %>">
						<option value=""></option>
						<%=HtmlUtility.getSelectOption(vo.aryPltDay, vo.getPltDay())%>
					</select><%= CommonConst.NAM_DAY %>
				</td>
			</tr>
		</table>
	</div>
	<%= HtmlUtility.getListInfo(vo) %>
	<div id="checkDiv">
		<button type="button" onclick="doAllBoxChecked(true)"><%= CommonConst.NAM_SELECT_CHECK_ALL %></button>
		<button type="button" onclick="doAllBoxChecked(false)"><%= CommonConst.NAM_RELEASE_CHECK_ALL %></button>
	</div>
	<div class="List">
		<table id="list">
			<thead>
				<tr>
					<th id="thButton"></th>
					<th id="thKCode" onclick="doSubmitKey(document.form, 'K2133', '<%= vo.KEY_K_CODE %>')">&nbsp;<%= vo.NAM_K_CODE %>&nbsp;<%= vo.getSortMark(vo.KEY_K_CODE ) %></th>
					<th id="thKName" onclick="doSubmitKey(document.form, 'K2133', '<%= vo.KEY_K_NAME %>')">&nbsp;<%= vo.NAM_K_NAME %>&nbsp;<%= vo.getSortMark(vo.KEY_K_NAME ) %></th>
					<th id="thSection" onclick="doSubmitKey(document.form, 'K2133', '<%= vo.KEY_SECTION %>')">&nbsp;<%= vo.NAM_SECTION %>&nbsp;<%= vo.getSortMark(vo.KEY_SECTION ) %></th>
					<th id="thDate" onclick="doSubmitKey(document.form, 'K2133', '<%= vo.KEY_DATE %>')">&nbsp;<%= vo.NAM_DATE %>&nbsp;<%= vo.getSortMark(vo.KEY_DATE ) %></th>
					<th id="thApprication" onclick="doSubmitKey(document.form, 'K2133', '<%= vo.KEY_APPLICATION %>')">&nbsp;<%= vo.NAM_APPLICATION %>&nbsp;<%= vo.getSortMark(vo.KEY_APPLICATION ) %></th>
					<th id="thStatus" onclick="doSubmitKey(document.form, 'K2133', '<%= vo.KEY_STATUS %>')">&nbsp;<%= vo.NAM_STATUS %>&nbsp;<%= vo.getSortMark(vo.KEY_STATUS ) %></th>
					<th id="thRemarks" 																			>&nbsp;<%= vo.NAM_REMARKS %>&nbsp;</th>
					<th id="thCheckBox" 																		>&nbsp;<%= vo.NAM_APPROVED %>&nbsp;</th>
				</tr>
			</thead>
			<tbody>
<%
for (int i = vo.getStart(); i <= vo.getEnd(); i++) {
%>
				<tr>
					<td class="ButtonTd">
						<button type="button" onclick="doSubmitKey(document.form, '<%= aryApplication[i][0] %>', '<%= aryApplication[i][2] %>','<%= aryApplication[i][1] %>')"><%= CommonConst.NAM_SELECT %></button>
					</td>
					<td class="kCodeTd" >	<%= aryApplication [i][2] %></td>
					<td class="KNameTd">		<%= aryApplication [i][3] %></td>
					<td class="SectionTd" >	<%= aryApplication [i][4] %></td>
					<td class="DateTd" >	<%= aryApplication [i][5] %></td>
					<td class="AppricationTd" >		<%= aryApplication [i][6] %></td>
					<td class="StatusTd" >	<%= aryApplication [i][7] %></td>
					<td class="RemarksTd" >		<%= aryApplication [i][8] %></td>
					<td class="chkTd" >
						<%= ManagerApprovalListVo.getVariableCheckBox(ManagerApprovalListVo.PRM_CKB_APPROVAL, ManagerApprovalListVo.PRM_CKB_APPROVAL, aryApplication [i][9], aryApplication [i][9]) %>
					</td>
				</tr>
<%
}
%>
			</tbody>
		</table>
	</div>
	<div class="ButtonDiv">
		<button type="button" class="ExecuteButton" onclick="submitForm(document.form)"><%= CommonConst.NAM_APPROVED %></button>
		<button type="button" class="ExecuteButton" onclick="doSubmit(document.form, 'K2100')"><%= CommonConst.NAM_TO_MENU %></button>
	</div>
</div>
<%= HtmlUtility.getFooter(vo) %>
