<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "256kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.kintai.vo.EmployeeApprovalListVo"
%><%
EmployeeApprovalListVo vo = (EmployeeApprovalListVo)request.getAttribute(MospConst.ATT_VO);
String[] arySelectDate	= vo.getArySelectDate();
String[] aryKCode       = vo.getAryKCode();
String[] aryKName       = vo.getAryKName();
String[] arySection     = vo.getArySection();
String[] aryPosition    = vo.getAryPosition();
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>
<div class="Body" id="employeeList">
	<%=HtmlUtility.getMessages(vo)%>
	<div class="Select">
		<table>
			<tr>
				<td id="tdKCode">
					<%= CommonConst.NAM_K_CODE %><%= CommonConst.STR_TITLE_SEPARATOR %><%= vo.getEscLblKCode() %>
				</td>
				<td id="tdKName">
					<%= CommonConst.NAM_K_NAME %><%= CommonConst.STR_TITLE_SEPARATOR %><%= vo.getEscLblKName() %>
				</td>
				<td id="tdStation">
					<%= CommonConst.NAM_STATION %><%= CommonConst.STR_TITLE_SEPARATOR %><%= vo.getEscLblSectionName() %>
				</td>	
				<td class="YearMonthTd">
					<select id="<%= EmployeeApprovalListVo.PRM_PLT_YEAR %>" name="<%= EmployeeApprovalListVo.PRM_PLT_YEAR %>">
						<%= HtmlUtility.getSelectOption(vo.aryPltYear, vo.getPltSelectYear()) %>
					</select><%= CommonConst.NAM_YEAR %>
					<select id="<%= EmployeeApprovalListVo.PRM_PLT_MONTH %>" name="<%= EmployeeApprovalListVo.PRM_PLT_MONTH %>">
						<%= HtmlUtility.getSelectOption(vo.aryPltMonth, vo.getPltSelectMonth()) %>
					</select><%= CommonConst.NAM_MONTH %>
				</td>
				<td class="ButtonTd">
					<button type="button" onclick="doSubmit(document.form, 'K2112')"><%= CommonConst.NAM_RE_SEARCH %></button>
				</td>
			</tr>
		</table>
	</div>	<%=HtmlUtility.getListInfo(vo)%>
	<div class="List">
		<table id="list">
			<thead>
				<tr>
					<th id="thButton"></th>
					<th id="thKCode"          onclick="doSubmitKey(document.form, 'K2113', '<%= vo.KEY_K_CODE  %>', '')">&nbsp;<%= CommonConst.NAM_K_CODE %>&nbsp;<%= vo.getSortMark(vo.KEY_K_CODE) %></th>
					<th id="thKName"          onclick="doSubmitKey(document.form, 'K2113', '<%= vo.KEY_K_NAME  %>', '')">&nbsp;<%= CommonConst.NAM_K_NAME %>&nbsp;<%= vo.getSortMark(vo.KEY_K_NAME) %></th>
					<th id="thStation"        onclick="doSubmitKey(document.form, 'K2113', '<%= vo.KEY_SECTION %>', '')">&nbsp;<%= CommonConst.NAM_STATION %>&nbsp;<%= vo.getSortMark(vo.KEY_SECTION) %></th>
					<th id="thPosition"       onclick="doSubmitKey(document.form, 'K2113', '<%= vo.KEY_POSITION %>', '')">&nbsp;<%= CommonConst.NAM_POSITION %>&nbsp;<%= vo.getSortMark(vo.KEY_POSITION) %></th>
				</tr>
			</thead>
			<tbody>
<%
for (int i = vo.getStart(); i <= vo.getEnd(); i++) {
%>
				<tr>
					<td class="ButtonTd">
						<button type="button" onclick="doSubmitKey(document.form, 'K2121', '<%= aryKCode[i] %>', '<%= arySelectDate[i] %>')"><%= CommonConst.NAM_SELECT %></button>
					</td>
					<td><%= aryKCode[i] %></td>
					<td><%= aryKName[i] %></td>
					<td><%= arySection[i] %></td>
					<td><%= aryPosition[i] %></td>
				</tr>
<%
}
%>
			</tbody>
		</table>
	
	</div>
</div>
<%= HtmlUtility.getFooter(vo) %>
