/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.MosPAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmCodeDto;
import jp.mosp.system.vo.CmCodeListVo;

/**
 * @author yoshida
 *
 */
public class CmCodeListAction extends MosPAction {
	
	// R}h
	private static final String	CMD_CODE_CARD_SHOW		= "S2000";	// \
	private static final String	CMD_CODE_CARD_SELECT	= "S2001";	// 
	private static final String	CMD_CODE_LIST_RE_SEARCH	= "S2002";	// Č
	private static final String	CMD_CODE_CARD_SORT		= "S2003";	// \[g
																	
	
	/**
	 * RXgN^
	 */
	public CmCodeListAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_CODE_CARD_SHOW)) {
			show();
		} else if (cmd.equals(CMD_CODE_CARD_SELECT)) {
			// 
			search();
		} else if (cmd.equals(CMD_CODE_LIST_RE_SEARCH)) {
			// Č
			research();
		} else if (cmd.equals(CMD_CODE_CARD_SORT)) {
			// \[g
			sortList(key1);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new CmCodeListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		CmCodeListVo vo = (CmCodeListVo)getVo();
		// R[h敪v_EXg쐬
		vo.aryPltTId = getCodeArray();
	}
	
	@Override
	protected void show() throws Exception {
		CmCodeListVo vo = (CmCodeListVo)getVo();
		// 폜tÕv_EXg쐬
		vo.setPltDelete(MospConst.DELETE_FLAG_OFF);
		// lɃZbg
		vo.setSearchmode(0);
	}
	
	@Override
	protected void search() throws Exception {
		CmCodeListVo vo = (CmCodeListVo)getVo();
		vo.setParams(request);
		searchCodeList();
		vo.setIsAscending(true);
		vo.initListInfo();
		// ɃZbg
		vo.setSearchmode(1);
	}
	
	@Override
	protected void research() throws Exception {
		CmCodeListVo vo = (CmCodeListVo)getVo();
		if (vo.getSearchmode() == 1) {
			removeSessionDto();
			searchCodeList();
			vo.setPageButton();
			sortList();
		}
	}
	
	/**
	 * R[hXg
	 * @throws Exception 	Oꍇ
	 */
	private void searchCodeList() throws Exception {
		CmCodeListVo vo = (CmCodeListVo)getVo();
		// 
		vo.setFields(part().cmcode().getCmCodeDao().findForSearch(vo.getPltTId(), vo.getTxtTCode(), vo.getTxtTName(),
				vo.getPltDelete()));
		setCodeTypeName();
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryTCode().length == 0) {
			vo.addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	/**
	 * R[h敪̐ݒ
	 * @throws Exception  	Oꍇ
	 */
	private void setCodeTypeName() throws Exception {
		CmCodeListVo vo = (CmCodeListVo)getVo();
		String[] aryCodeTypeName = new String[vo.getList().size()];
		for (int i = 0; i < vo.getList().size(); i++) {
			CmCodeDto dto = (CmCodeDto)vo.getList().get(i);
			aryCodeTypeName[i] = getCodeTypeName(dto.getTId());
		}
		vo.setAryTIdName(aryCodeTypeName);
	}
	
	@Override
	protected void sortList(String key) throws Exception {
		CmCodeListVo vo = (CmCodeListVo)getVo();
		vo.sortList(key, getComparator(key));
		vo.setFields(vo.getList());
		setCodeTypeName();
	}
	
	@Override
	protected void sortList() throws Exception {
		CmCodeListVo vo = (CmCodeListVo)getVo();
		vo.sortList(getComparator(vo.getFormerKey()));
		vo.setFields(vo.getList());
		setCodeTypeName();
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		CmCodeListVo vo = (CmCodeListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_T_ID)) {
			comp = new CompTId();
		} else if (key.equals(vo.KEY_T_CODE)) {
			comp = new CompTCode();
		} else if (key.equals(vo.KEY_T_NAME)) {
			comp = new CompTName();
		} else if (key.equals(vo.KEY_VIEWINDEX)) {
			comp = new CompViewIndex();
		} else if (key.equals(vo.KEY_DELETE)) {
			comp = new CompDeleteFlag();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * R[h敪ɂrNX
	 */
	protected static class CompTId implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 7210303772053153377L;
		

		public int compare(Object obj1, Object obj2) {
			CmCodeDto dto1 = (CmCodeDto)obj1;
			CmCodeDto dto2 = (CmCodeDto)obj2;
			return dto1.getTId().compareTo(dto2.getTId());
		}
	}
	
	/**
	 * R[hɂrNX
	 */
	protected static class CompTCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 5672044129524635759L;
		

		public int compare(Object obj1, Object obj2) {
			CmCodeDto dto1 = (CmCodeDto)obj1;
			CmCodeDto dto2 = (CmCodeDto)obj2;
			return dto1.getTCode().compareTo(dto2.getTCode());
		}
	}
	
	/**
	 * R[ĥɂrNX
	 */
	protected static class CompTName implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -8615320106870669507L;
		

		public int compare(Object obj1, Object obj2) {
			CmCodeDto dto1 = (CmCodeDto)obj1;
			CmCodeDto dto2 = (CmCodeDto)obj2;
			return dto1.getTName().compareTo(dto2.getTName());
		}
	}
	
	/**
	 * \ɂrNX
	 */
	protected static class CompViewIndex implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 2787828366453888987L;
		

		public int compare(Object obj1, Object obj2) {
			CmCodeDto dto1 = (CmCodeDto)obj1;
			CmCodeDto dto2 = (CmCodeDto)obj2;
			return dto1.getViewIndex() - (dto2.getViewIndex());
		}
	}
	
	/**
	 * 폜tOɂrNX
	 */
	static class CompDeleteFlag implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -1824284390861851592L;
		

		public int compare(Object obj1, Object obj2) {
			CmCodeDto dto1 = (CmCodeDto)obj1;
			CmCodeDto dto2 = (CmCodeDto)obj2;
			return dto2.getDeleteFlag() - dto1.getDeleteFlag();
		}
	}
	
}
