/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;

/**
 * @author yoshida
 *
 */
public class AttendanceExportCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= -3557453835533294516L;
	
	// p[^[
	/**
	 * pltYear
	 */
	public static final String	PRM_PLT_YEAR		= "pltYear";
	/**
	 * pltMonth
	 */
	public static final String	PRM_PLT_MONTH		= "pltMonth";
	/**
	 * pltSection
	 */
	public static final String	PRM_PLT_SECTION		= "pltSection";
	
	// tB[h
	private String				pltYear;
	private String				pltMonth;
	private String				pltSection;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_ATTENDANCE_INFO;
	/**
	 * 
	 */
	public String				NAM_ATTENDANCE_DATE;
	/**
	 * 
	 */
	public String				NAM_PLT_SECTION;
	
	//v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltYear;
	/**
	 * 
	 */
	public String[][]			aryPltMonth;
	/**
	 * 
	 */
	public String[][]			aryPltSection;
	

	/**
	 * RXgN^
	 */
	public AttendanceExportCardVo() {
		super();
		setViewPath(getClassName());
		pltYear = "";
		pltMonth = "";
		pltSection = "";
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.NAM_OUTPUT_ATTENDANCE_LIST;
		createAryMenu(CMD_MENU_PAYROLL, MosPMenuConst.getMenuAttendanceCalculate());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_ATTENDANCE_INFO = CommonConst.NAM_ATTENDANCE_TYPE + CommonConst.NAM_INFORMATION;
		NAM_ATTENDANCE_DATE = CommonConst.NAM_TARGET_MONTH;
		NAM_PLT_SECTION = CommonConst.NAM_STATION;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		pltYear = request.getParameter(PRM_PLT_YEAR);
		pltMonth = request.getParameter(PRM_PLT_MONTH);
		pltSection = request.getParameter(PRM_PLT_SECTION);
	}
	
	// ANZT\bh	
	/**
	 * @return pltYear
	 */
	public String getPltYear() {
		return pltYear;
	}
	
	/**
	 * @return pltMonth
	 */
	public String getPltMonth() {
		return pltMonth;
	}
	
	/**
	 * @return pltSection
	 */
	public String getPltSection() {
		return pltSection;
	}
	
	/**
	 * @param pltYear Zbg pltYear
	 */
	public void setPltYear(String pltYear) {
		this.pltYear = pltYear;
	}
	
	/**
	 * @param pltMonth Zbg pltMonth
	 */
	public void setPltMonth(String pltMonth) {
		this.pltMonth = pltMonth;
	}
	
	/**
	 * @param pltSection Zbg pltSection
	 */
	public void setPltSection(String pltSection) {
		this.pltSection = pltSection;
	}
	
}
