/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.cloudzero.mosp.exception.CloudzeroUnsupportedException;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.bonus.dao.PhBounsDao;
import jp.mosp.payroll.dto.BankTransferFBDataDto;

public class BankTransferDao extends PayrollDao {
	
	// 
	public static final String	COL_K_CODE				= PhPaymentDao.COL_KCODE;					// ЈR[h
	public static final String	COL_CALC_DATE			= PhPaymentDao.COL_CALC_MONTH;				// vZN
	public static final String	COL_BON_CALC_DATE		= PhBounsDao.COL_CALC_MONTH;				// vZN(ܗ^)
	public static final String	COL_PAYDAY				= PhPaymentDao.COL_PAY_DATE;				// ^x
	//public static final String COL_CALC_STATUS          = UdPaymentDao.COL_CALC_STATUS         ;	// vZXe[^X
	public static final String	COL_K_NAME				= MKihonPayrollDao.COL_SIMEI;				// Ј
	public static final String	COL_SCODE				= MKihonPayrollDao.COL_SCODE;				// R[h
	public static final String	COL_YCODE				= MKihonPayrollDao.COL_YCODE;				// ER[h
	public static final String	COL_MEANS_SEQUENCE		= CmPaymentMeansDao.COL_MEANS_SEQUENCE;	// x@A
	public static final String	COL_ALLOWANCE_TYPE		= CmPaymentMeansDao.COL_ALLOWANCE_TYPE;	// x敪
	public static final String	COL_CO_BANK_CODE		= CmPaymentMeansDao.COL_CO_BANK_CODE;		// ЋsR[h
	public static final String	COL_PAID_BANK_CODE		= CmPaymentMeansDao.COL_PAID_BANK_CODE;		// UsR[h
	public static final String	COL_PAID_BRANCH_CODE	= CmPaymentMeansDao.COL_PAID_BRANCH_CODE;	// UsxXR[h
	public static final String	COL_ACCOUNT_TYPE		= CmPaymentMeansDao.COL_ACCOUNT_TYPE;		// a敪
	public static final String	COL_ACCOUNT_NO			= CmPaymentMeansDao.COL_ACCOUNT_NO;			// ԍ
	public static final String	COL_HOLDER_NAME			= CmPaymentMeansDao.COL_HOLDER_NAME;		// `
	public static final String	COL_HOLDER_KANA			= CmPaymentMeansDao.COL_HOLDER_KANA;		// `ض
	public static final String	COL_PAYMENT_MEANS		= CmPaymentMeansDao.COL_PAYMENT_MEANS;		// x@
	public static final String	COL_AMOUNT_TYPE			= CmPaymentMeansDao.COL_AMOUNT_TYPE;		// z敪
																									
	public static final String	COL_BANK_PAY_AMOUNT		= "BANK_PAY_AMOUNT";
	
	public static final String	COL_PAYMENT_TOTAL		= "PAYMENT_TOTAL";
	
	public boolean				IS_PEUMENT				= true;
	

	/**
	 * RXgN^
	 */
	public BankTransferDao() {
		super();
		INSERT_DATE = "";
		INSERT_USER = "";
		UPDATE_DATE = "";
		UPDATE_USER = "";
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<BankTransferFBDataDto> mappingAll() throws SQLException {
		List<BankTransferFBDataDto> all = new ArrayList<BankTransferFBDataDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return AdjustmentListDto NR[h
	 * @throws SQLException
	 */
	private BankTransferFBDataDto mapping() throws SQLException {
		BankTransferFBDataDto dto = new BankTransferFBDataDto();
		dto.setKCode(rs.getString(COL_K_CODE)); // ЈR[h
		if (IS_PEUMENT) {
			dto.setCalcDate(rs.getDate(COL_CALC_DATE)); // vZN
		} else {
			dto.setCalcDate(rs.getDate(COL_BON_CALC_DATE));
		}
		dto.setPayday(rs.getDate(COL_PAYDAY)); // ^x
		//dto.setCalcStatus   (rs.getString(COL_CALC_STATUS       ));	// vZXe[^X
		dto.setKName(rs.getString(COL_K_NAME)); // Ј
		dto.setStationCode(rs.getString(COL_SCODE)); // R[h
		dto.setPositionCode(rs.getString(COL_YCODE)); // EʃR[h
		//dto.setBankPayAmount(rs.getInt(COL_BANK_PAY_AMOUNT       ));	// sUz
		dto.setAllowanceType(rs.getString(COL_ALLOWANCE_TYPE)); // x敪
		dto.setCoBankCode(rs.getString(COL_CO_BANK_CODE)); // ЋsR[h
		dto.setPaidBankCode(rs.getString(COL_PAID_BANK_CODE)); // UsR[h
		dto.setPaidBranchCode(rs.getString(COL_PAID_BRANCH_CODE)); // UsxXR[h
		dto.setMeansSequence(rs.getInt(COL_MEANS_SEQUENCE)); // x@A
		dto.setAccountType(rs.getString(COL_ACCOUNT_TYPE)); // a敪
		dto.setAccountNo(rs.getString(COL_ACCOUNT_NO)); // ԍ
		dto.setHolderKana(rs.getString(COL_HOLDER_KANA)); // `ض
		dto.setPaymentMeans(rs.getString(COL_PAYMENT_MEANS)); // x@
		dto.setAmountType(rs.getString(COL_AMOUNT_TYPE)); // z敪
		return dto;
	}
	
	/**
	 * ɂNf[^擾
	 * @param adjustYear N
	 * @param lastDate   NŏI
	 * @param kCode      ЈR[h
	 * @return List (DTOList)
	 * @throws SQLException
	 */
	public List<BankTransferFBDataDto> findForCondition(String coBankCode, Date calcDate, Date payday, boolean isPayment)
			throws SQLException {
		throw new CloudzeroUnsupportedException();
/*		IS_PEUMENT = isPayment;
		index = 1;
		StringBuffer sb = new StringBuffer();
		// s1U擾
		sb.append("SELECT ");
		sb.append(COL_K_CODE);
		sb.append(", ");
		if (isPayment) {
			sb.append(COL_CALC_DATE);
		} else {
			sb.append(COL_BON_CALC_DATE);
		}
		sb.append(", ");
		sb.append(COL_PAYDAY);
		//sb.append(", ");
		//sb.append(	COL_CALC_STATUS         );
		sb.append(", ");
		sb.append(COL_K_NAME);
		sb.append(", ");
		sb.append(COL_SCODE);
		sb.append(", ");
		sb.append(COL_YCODE);
		//sb.append(", ");
		//sb.append(	COL_BANK_PAY_AMOUNT       );
		sb.append(", ");
		sb.append(COL_MEANS_SEQUENCE);
		sb.append(", ");
		sb.append(COL_ALLOWANCE_TYPE);
		sb.append(", ");
		sb.append(COL_CO_BANK_CODE);
		sb.append(", ");
		sb.append(COL_PAID_BANK_CODE);
		sb.append(", ");
		sb.append(COL_PAID_BRANCH_CODE);
		sb.append(", ");
		sb.append(COL_ACCOUNT_TYPE);
		sb.append(", ");
		sb.append(COL_ACCOUNT_NO);
		sb.append(", ");
		sb.append(COL_HOLDER_NAME);
		sb.append(", ");
		sb.append(COL_HOLDER_KANA);
		sb.append(", ");
		sb.append(COL_PAYMENT_MEANS);
		sb.append(", ");
		sb.append(COL_AMOUNT_TYPE);
		sb.append(" FROM ( ");
		if (isPayment) {
			setBankPayment(sb, 1);
		} else {
			setBankBonus(sb, 1);
		}
		sb.append(" UNION ALL ");
		if (isPayment) {
			setBankPayment(sb, 2);
		} else {
			setBankBonus(sb, 2);
		}
		sb.append(" ) BANK_TRANSFER ");
		sb.append(" WHERE ");
		sb.append(COL_CO_BANK_CODE);
		sb.append(" =  ? ");
		sb.append(" ORDER BY ");
		sb.append(COL_K_CODE);
		sb.append(", ");
		sb.append(COL_CO_BANK_CODE);
		sb.append(" , ");
		sb.append(COL_PAID_BANK_CODE);
		sb.append(", ");
		sb.append(COL_PAID_BRANCH_CODE);
		
		try {
			prepareStatement(sb.toString());
			setDateParam(index++, calcDate);
			if (!isPayment) {
				// ܗ^̏ꍇxݒ
				setDateParam(index++, payday);
			}
			setDateParam(index++, calcDate);
			if (!isPayment) {
				// ܗ^̏ꍇxݒ
				setDateParam(index++, payday);
			}
			setParam(index++, coBankCode);
			// s
			executeQuery();
			List<BankTransferFBDataDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}*/
	}
	
//	private void setBankPayment(StringBuffer sb, int bankPayAmount) {
//		sb.append("SELECT ");
//		sb.append(" PHPAY.");
//		sb.append(COL_K_CODE);
//		sb.append(", ");
//		sb.append(" PHPAY.");
//		sb.append(COL_CALC_DATE);
//		sb.append(", ");
//		sb.append(" PHPAY.");
//		sb.append(COL_PAYDAY);
//		sb.append(", ");
//		//sb.append(" PHPAY.");
//		//sb.append(	COL_CALC_STATUS         );
//		//sb.append(", ");
//		sb.append(" MKIHON.");
//		sb.append(COL_K_NAME);
//		sb.append(", ");
//		sb.append(" MKIHON.");
//		sb.append(COL_SCODE);
//		sb.append(", ");
//		sb.append(" MKIHON.");
//		sb.append(COL_YCODE);
//		//sb.append(", ");
//		//if (bankPayAmount == 1) {
//		//	sb.append(" UDPAY.");
//		//	sb.append(	UdPaymentDao.COL_BANK1_PAY_AMOUNT + " " + COL_BANK_PAY_AMOUNT    );
//		
//		//} else {
//		//	sb.append(" UDPAY.");
//		//	sb.append(	UdPaymentDao.COL_BANK2_PAY_AMOUNT + " " + COL_BANK_PAY_AMOUNT    );
//		//}
//		sb.append(", ");
//		sb.append(" CMPAY.");
//		sb.append(COL_MEANS_SEQUENCE);
//		sb.append(", ");
//		sb.append(" CMPAY.");
//		sb.append(COL_ALLOWANCE_TYPE);
//		sb.append(", ");
//		sb.append(" CMPAY.");
//		sb.append(COL_CO_BANK_CODE);
//		sb.append(", ");
//		sb.append(" CMPAY.");
//		sb.append(COL_PAID_BANK_CODE);
//		sb.append(", ");
//		sb.append(" CMPAY.");
//		sb.append(COL_PAID_BRANCH_CODE);
//		sb.append(", ");
//		sb.append(" CMPAY.");
//		sb.append(COL_ACCOUNT_TYPE);
//		sb.append(", ");
//		sb.append(" CMPAY.");
//		sb.append(COL_ACCOUNT_NO);
//		sb.append(", ");
//		sb.append(" CMPAY.");
//		sb.append(COL_HOLDER_NAME);
//		sb.append(", ");
//		sb.append(" CMPAY.");
//		sb.append(COL_HOLDER_KANA);
//		sb.append(", ");
//		sb.append(" CMPAY.");
//		sb.append(COL_PAYMENT_MEANS);
//		sb.append(", ");
//		sb.append(" CMPAY.");
//		sb.append(COL_AMOUNT_TYPE);
//		sb.append(" FROM ");
//		sb.append(PhPaymentDao.TABLE + " PHPAY");
//		sb.append(", ");
//		sb.append(MKihonPayrollDao.TABLE + " MKIHON");
//		sb.append(", ");
//		sb.append(CmPaymentMeansDao.TABLE + " CMPAY");
//		sb.append(" WHERE ");
//		sb.append(" PHPAY.");
//		sb.append(COL_K_CODE);
//		sb.append(" = ");
//		sb.append(" CMPAY.");
//		sb.append(CmPaymentMeansDao.COL_K_CODE);
//		sb.append(" AND ");
//		sb.append(" CMPAY.");
//		sb.append(CmPaymentMeansDao.COL_K_CODE);
//		sb.append(" = ");
//		sb.append(" MKIHON.");
//		sb.append(COL_K_CODE);
//		sb.append(" AND ");
//		sb.append(" PHPAY.");
//		sb.append(COL_CALC_DATE);
//		sb.append(" = ? ");
//		sb.append(" AND ");
//		sb.append(" CMPAY.");
//		sb.append(COL_MEANS_SEQUENCE);
//		sb.append(" = ");
//		if (bankPayAmount == 1) {
//			sb.append(PayrollConst.PAYMENT_MEANS_SEQ_1);
//		} else {
//			sb.append(PayrollConst.PAYMENT_MEANS_SEQ_2);
//			
//		}
//		sb.append(" AND ");
//		sb.append(" CMPAY.");
//		sb.append(CmPaymentMeansDao.COL_PAYMENT_MEANS);
//		sb.append(" = '" + PayrollConst.PAYMENT_MEANS_ACCOUNT + "' ");
//		sb.append(" AND ");
//		sb.append(" PHPAY.");
//		sb.append(COL_PAYMENT_TOTAL);
//		sb.append(" <> ");
//		sb.append(PayrollConst.AMOUNT_ZERO);
//		//sb.append(" AND ");
//		//sb.append(" " + COL_CALC_STATUS + " = '" + PayrollConst.CALC_STATUS_FIX + "' ");
//		
//	}
//	
//	private void setBankBonus(StringBuffer sb, int bankPayAmount) {
//		sb.append("SELECT ");
//		sb.append(" PHBON.");
//		sb.append(COL_K_CODE);
//		sb.append(", ");
//		sb.append(" PHBON.");
//		sb.append(COL_BON_CALC_DATE);
//		sb.append(", ");
//		sb.append(" PHBON.");
//		sb.append(COL_PAYDAY);
//		//sb.append(", ");
//		//sb.append(" UDBON.");
//		//sb.append(	COL_CALC_STATUS         );
//		sb.append(", ");
//		sb.append(" MKIHON.");
//		sb.append(COL_K_NAME);
//		sb.append(", ");
//		sb.append(" MKIHON.");
//		sb.append(COL_SCODE);
//		sb.append(", ");
//		sb.append(" MKIHON.");
//		sb.append(COL_YCODE);
//		//sb.append(", ");
//		//if (bankPayAmount == 1) {
//		//	sb.append(" UDBON.");
//		//	sb.append(	UdBonusDao.COL_BANK1_PAY_AMOUNT + " " + COL_BANK_PAY_AMOUNT    );
//		
//		//} else {
//		//	sb.append(" UDBON.");
//		//	sb.append(	UdBonusDao.COL_BANK2_PAY_AMOUNT + " " + COL_BANK_PAY_AMOUNT    );
//		//}
//		sb.append(", ");
//		sb.append(" CMPAY.");
//		sb.append(COL_MEANS_SEQUENCE);
//		sb.append(", ");
//		sb.append(" CMPAY.");
//		sb.append(COL_ALLOWANCE_TYPE);
//		sb.append(", ");
//		sb.append(" CMPAY.");
//		sb.append(COL_CO_BANK_CODE);
//		sb.append(", ");
//		sb.append(" CMPAY.");
//		sb.append(COL_PAID_BANK_CODE);
//		sb.append(", ");
//		sb.append(" CMPAY.");
//		sb.append(COL_PAID_BRANCH_CODE);
//		sb.append(", ");
//		sb.append(" CMPAY.");
//		sb.append(COL_ACCOUNT_TYPE);
//		sb.append(", ");
//		sb.append(" CMPAY.");
//		sb.append(COL_ACCOUNT_NO);
//		sb.append(", ");
//		sb.append(" CMPAY.");
//		sb.append(COL_HOLDER_NAME);
//		sb.append(", ");
//		sb.append(" CMPAY.");
//		sb.append(COL_HOLDER_KANA);
//		sb.append(", ");
//		sb.append(" CMPAY.");
//		sb.append(COL_PAYMENT_MEANS);
//		sb.append(", ");
//		sb.append(" CMPAY.");
//		sb.append(COL_AMOUNT_TYPE);
//		sb.append(" FROM ");
//		sb.append(PhBounsDao.TABLE + " PHBON");
//		sb.append(", ");
//		sb.append(MKihonPayrollDao.TABLE + " MKIHON");
//		sb.append(", ");
//		sb.append(CmPaymentMeansDao.TABLE + " CMPAY");
//		sb.append(" WHERE ");
//		sb.append(" PHBON.");
//		sb.append(COL_K_CODE);
//		sb.append(" = ");
//		sb.append(" CMPAY.");
//		sb.append(CmPaymentMeansDao.COL_K_CODE);
//		sb.append(" AND ");
//		sb.append(" CMPAY.");
//		sb.append(CmPaymentMeansDao.COL_K_CODE);
//		sb.append(" = ");
//		sb.append(" MKIHON.");
//		sb.append(COL_K_CODE);
//		sb.append(" AND ");
//		sb.append(" PHBON.");
//		sb.append(COL_BON_CALC_DATE);
//		sb.append(" = ? ");
//		sb.append(" AND ");
//		sb.append(" PHBON.");
//		sb.append(PhBounsDao.COL_PAY_DATE);
//		sb.append(" = ? ");
//		sb.append(" AND ");
//		sb.append(" CMPAY.");
//		sb.append(COL_MEANS_SEQUENCE);
//		sb.append(" = ");
//		if (bankPayAmount == 1) {
//			sb.append(PayrollConst.PAYMENT_MEANS_SEQ_3);
//		} else {
//			sb.append(PayrollConst.PAYMENT_MEANS_SEQ_4);
//			
//		}
//		sb.append(" AND ");
//		sb.append(" CMPAY.");
//		sb.append(CmPaymentMeansDao.COL_PAYMENT_MEANS);
//		sb.append(" = '" + PayrollConst.PAYMENT_MEANS_ACCOUNT + "' ");
//		sb.append(" AND ");
//		sb.append(" PHBON.");
//		sb.append(COL_PAYMENT_TOTAL);
//		sb.append(" <> ");
//		sb.append(PayrollConst.AMOUNT_ZERO);
//		//sb.append(" AND ");
//		//sb.append(" " + COL_CALC_STATUS + " = '" + PayrollConst.CALC_STATUS_FIX + "' ");
//		
//	}
	
	/*	*//**
			* p[^ݒ
			* @param dto XVΏDTO
			* @param isInsert }tO(trueF}AfalseFXV)
			* @throws SQLException
			*/
	/*
	private void setParams(BankTransferFBDataDto dto, boolean isInsert) throws SQLException {
	setParam(index++, dto.getKCode         ());	// ЈR[h
	setParam(index++, dto.getCalcDate      ());	// vZN
	setParam(index++, dto.getPayday        ());	// ^x
	setParam(index++, dto.getCalcStatus    ());	// vZXe[^X
	setParam(index++, dto.getKName         ());	// Ј
	setParam(index++, dto.getStationCode   ());	// R[h
	setParam(index++, dto.getPositionCode  ());	// EʃR[h
	setParam(index++, dto.getBankPayAmount ());	// sUz
	setParam(index++, dto.getAllowanceType ());	// x敪
	setParam(index++, dto.getCoBankCode    ());	// ЋsR[h
	setParam(index++, dto.getPaidBankCode  ());	// UsR[h
	setParam(index++, dto.getPaidBranchCode());	// UsxXR[h
	setParam(index++, dto.getMeansSequence ());	// x@A
	setParam(index++, dto.getAccountType   ());	// a敪
	setParam(index++, dto.getAccountNo     ());	// ԍ
	setParam(index++, dto.getHolderKana    ());	// `ض
	setParam(index++, dto.getPaymentMeans  ());	// x@
	setParam(index++, dto.getAmountType    ());	// z敪
	setCommonParams(isInsert);
	}*/
}
