/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.bonus.dto;

import java.util.Date;

import jp.mosp.common.common.BaseDto;

public class CashKindListDto extends BaseDto {
	
	private static final long	serialVersionUID	= -2412645410611672375L;
	
	//tB[h
	protected String			kCode				= "";						// ЈR[h
	protected Date				calcDate;										// vZN
	protected Date				payday;										// ^x
	protected String			kName				= "";						// Ј
	protected int				cashAmount			= 0;						// xz
																				
	
	/**
	 * RXgN^
	 */
	public CashKindListDto() {
		super();
	}
	
	//ANZT\bh
	public String getKCode() {
		return kCode;
	} // ЈR[h
	
	public Date getCalcDate() {
		return getDateField(calcDate);
	} // vZN
	
	public Date getPayday() {
		return getDateField(payday);
	} // ^x
	
	public String getKName() {
		return kName;
	} // Ј
	
	public int getCashAmount() {
		return cashAmount;
	} // xz
	
	public void setKCode(String kCode) {
		this.kCode = kCode;
	} // ЈR[h
	
	public void setCalcDate(Date calcDate) {
		this.calcDate = getDateField(calcDate);
	} // vZN
	
	public void setPayday(Date payday) {
		this.payday = getDateField(payday);
	} // ^x
	
	public void setKName(String kName) {
		this.kName = kName;
	} // Ј
	
	public void setCashAmount(int cashAmount) {
		this.cashAmount = cashAmount;
	} // xz
	
}
