/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.action;

import jp.mosp.common.MosPAction;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.part.MosPMenuPart;
import jp.mosp.payroll.vo.AttendanceCalculateMenuVo;

/**
 * @author yoshida
 *
 */
public class AttendanceCalculateMenuAction extends MosPAction {
	
	/**
	 * RXgN^
	 */
	public AttendanceCalculateMenuAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo(false);
		//  
		init();
		// \
		show();
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new AttendanceCalculateMenuVo();
	}
	
	@Override
	protected void init() throws Exception {
		// ZbVێ̏
		initStoredData();
		// RlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
	}
	
	@Override
	protected void show() throws Exception {
		AttendanceCalculateMenuVo vo = (AttendanceCalculateMenuVo)getVo();
		// ΑӌvZ{^\ݒ
		vo.setFields(MosPMenuPart.getMenuList(MosPMenuPart.getMenuButton(part().menu().getPayrollComponentInfo(),
				false, MosPMenuConst.getCmdCalcArray())));
	}
	
}
