/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.report.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import com.google.appengine.api.datastore.Query;

import jp.cloudzero.mosp.exception.CloudzeroUnsupportedException;
import jp.getset.gae.bigtable.PreparedStatement;
import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.report.dto.CmOutPutDto;

/**
 * CM_OUTPUT(CSVo̓}X^)DAONX B
 */
public class CmOutPutDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * CM_OUTPUT(CSVo̓}X^)B
	 */
	public static final String	TABLE			= "CM_OUTPUT";
	
	/**
	 * KEY_1 = ID(ID)B
	 */
	public static final String	KEY_1			= "ID";
	
	// 
	/**
	 * ID(ID)B
	 */
	public static final String	COL_ID			= "ID";
	/**
	 * CODE(o̓R}hԍ)B
	 */
	public static final String	COL_CODE		= "CODE";
	/**
	 * NAME({^\)B
	 */
	public static final String	COL_NAME		= "NAME";
	/**
	 * SCOPE(͈)B
	 */
	public static final String	COL_SCOPE		= "SCOPE";
	/**
	 * ITEM(o͍)B
	 */
	public static final String	COL_ITEM		= "ITEM";
	/**
	 * VIEWINDEX(\)B
	 */
	public static final String	COL_VIEWINDEX	= "VIEWINDEX";
	/**
	 * DELETEFLAG(폜tO)B
	 */
	public static final String	COL_DELETEFLAG	= "DELETEFLAG";
	

	/**
	 * RXgN^
	 */
	public CmOutPutDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException SQLOꍇ
	 */
	private List<CmOutPutDto> mappingAll() throws SQLException {
		List<CmOutPutDto> all = new ArrayList<CmOutPutDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return CmOutPutDto FmOutPutR[h
	 * @throws SQLException SQLOꍇ
	 */
	private CmOutPutDto mapping() throws SQLException {
		CmOutPutDto dto = new CmOutPutDto();
		dto.setId(rs.getInt(COL_ID)); //ID
		dto.setCode(rs.getString(COL_CODE)); //o̓R}hԍ
		dto.setName(rs.getString(COL_NAME)); //{^\
		dto.setScope(rs.getString(COL_SCOPE)); //o͈͐
		dto.setItem(rs.getString(COL_ITEM)); //o͍
		dto.setViewIndex(rs.getInt(COL_VIEWINDEX)); //\
		dto.setDeleteFlag(rs.getInt(COL_DELETEFLAG)); //폜tO
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<?> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<?> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param  id	ID(L[)
	 * @return CmOutPutDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public CmOutPutDto findForKey(String id) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, id);
			executeQuery();
			CmOutPutDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param  id	ID(L[)
	 * @return CmOutPutDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public CmOutPutDto findForUpdate(String id) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, id);
			executeQuery();
			CmOutPutDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param id ID
	 * @return list (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<?> findForCondition(String id) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_ID);
		sb.append(" LIKE ? ");
		this.pob.appendLike(COL_ID);
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, id);
			executeQuery();
			List<?> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param code o̓R}h
	 * @param name o͖
	 * @param scope o͔͈
	 * @return list (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<?> findForSearch(String code, String name, String scope) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETEFLAG + " = " + MospConst.DELETE_FLAG_OFF + " ");
		this.pob.appendWhere(COL_DELETEFLAG, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
		if (!code.equals("")) {
			sb.append(" AND ");
			sb.append(COL_CODE);
			sb.append(" = ? ");
			this.pob.appendWhere(COL_CODE, Query.FilterOperator.EQUAL);
		}
		if (!name.equals("")) {
			sb.append(" AND ");
			sb.append(COL_NAME);
			sb.append(" LIKE ? ");
			this.pob.appendLike(COL_NAME);
		}
		if (!scope.equals("")) {
			sb.append(" AND ");
			sb.append(COL_SCOPE);
			sb.append(" = ? ");
			this.pob.appendWhere(COL_SCOPE, Query.FilterOperator.EQUAL);
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForViewIndex());
			if (!code.equals("")) {
				setParam(index++, "%" + code + "%");
			}
			if (!name.equals("")) {
				setParam(index++, "%" + name + "%");
			}
			if (!scope.equals("")) {
				setParam(index++, scope);
			}
			executeQuery();
			List<?> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param code o̓R}h
	 * @param name o͖
	 * @param scope o͔͈
	 * @param deleteFlag 폜tO
	 * @return list (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<?> findForSearch(String code, String name, String scope, String deleteFlag) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_CODE);
		sb.append(" LIKE ? ");
		this.pob.appendLike(COL_CODE);
		if (!name.equals("")) {
			sb.append(" AND ");
			sb.append(COL_NAME);
			sb.append(" LIKE ? ");
			this.pob.appendLike(COL_NAME);
		}
		if (!scope.equals("")) {
			sb.append(" AND ");
			sb.append(COL_SCOPE);
			sb.append(" LIKE ? ");
			this.pob.appendLike(COL_SCOPE);
		}
		if (!deleteFlag.equals("")) {
			sb.append(" AND ");
			sb.append(COL_DELETEFLAG);
			sb.append(" = ? ");
			this.pob.appendWhere(COL_DELETEFLAG, Query.FilterOperator.EQUAL);
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForViewIndex());
			if (!code.equals("")) {
				setParam(index++, code);
			}
			if (!name.equals("")) {
				setParam(index++, "%" + name + "%");
			}
			if (!scope.equals("")) {
				setParam(index++, scope);
			}
			if (!deleteFlag.equals("")) {
				setParam(index++, Integer.parseInt(deleteFlag));
			}
			executeQuery();
			List<?> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param name o͖
	 * @return dto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public CmOutPutDto findForName(String name) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_NAME);
		sb.append(" = ? ");
		this.pob.appendWhere(COL_NAME, Query.FilterOperator.EQUAL);
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, name);
			executeQuery();
			CmOutPutDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂsbN擾
	 * @param name o͖
	 * @return dto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public CmOutPutDto findForNameUpdate(String name) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_NAME);
		sb.append(" = ? ");
		this.pob.appendWhere(COL_NAME, Query.FilterOperator.EQUAL);
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()) + getForUpdate());
			setParam(index++, name);
			executeQuery();
			CmOutPutDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂSf[^擾
	 * @param code o̓R}h
	 * @param scope o͔͈
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<CmOutPutDto> findForAvailableList(String code, String scope) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETEFLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_CODE);
		sb.append(" LIKE ? AND ");
		sb.append(COL_SCOPE);
		sb.append(" LIKE ? ");
		this.pob.appendWhere(COL_DELETEFLAG, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
		this.pob.appendLike(COL_CODE);
		this.pob.appendLike(COL_SCOPE);
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, code);
			setParam(index++, scope + "%");
			executeQuery();
			List<CmOutPutDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param code o̓R}h
	 * @return dto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public CmOutPutDto findForCode(String code) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append(" WHERE ");
			sb.append(COL_DELETEFLAG + " = " + MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_CODE);
			sb.append(" = ? ");
			
			this.pob.appendWhere(COL_DELETEFLAG, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
			this.pob.appendWhere(COL_CODE, Query.FilterOperator.EQUAL);
			
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, code);
			executeQuery();
			CmOutPutDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param  id	ID(L[)
	 * @return CmOutPutDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public CmOutPutDto findForId(String id) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append(" WHERE ");
			sb.append(COL_DELETEFLAG + " = " + MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_ID);
			sb.append(" = ? ");
			
			this.pob.appendWhere(COL_DELETEFLAG, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
			this.pob.appendWhere(COL_ID, Query.FilterOperator.EQUAL);
			
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, id);
			executeQuery();
			CmOutPutDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param code o̓R}h
	 * @return dto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public CmOutPutDto findForCodeUpdate(String code) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append(" WHERE ");
			sb.append(COL_DELETEFLAG + " = " + MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_CODE);
			sb.append(" = ? ");
			
			this.pob.appendWhere(COL_DELETEFLAG, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
			this.pob.appendWhere(COL_CODE, Query.FilterOperator.EQUAL);
			
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()) + getForUpdate());
			setParam(index++, code);
			executeQuery();
			CmOutPutDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * maxl擾
	 * @return String@őA
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public String findForMax() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			String maxEno = "";
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT MAX(");
			sb.append(COL_ID);
			sb.append(") FROM ");
			sb.append(TABLE);
			
			this.setPreparedStatement(PreparedStatement.Mode.SELECT);
			this.pob.appendOperationMax(COL_ID);
			
			prepareStatement(sb.toString());
			executeQuery();
			if (rs.next()) {
				maxEno = String.valueOf(rs.getInt(1));
			}
			return maxEno;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int insert(CmOutPutDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int update(CmOutPutDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getId());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int delete(CmOutPutDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getId());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert  }tO(trueF}AfalseFXV)
	 * @throws SQLException SQLOꍇ
	 */
	private void setParams(CmOutPutDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getId()); //ID
		setParam(index++, dto.getCode()); //o̓R}hԍ
		setParam(index++, dto.getName()); //{^\
		setParam(index++, dto.getScope()); //o͈͐
		setParam(index++, dto.getItem()); //o͍
		setParam(index++, dto.getViewIndex()); //\
		setParam(index++, dto.getDeleteFlag()); //폜tO
		setCommonParams(isInsert);
	}
	
	/**
	 * \ɂבւSQL擾
	 * @return \ɂבւSQL
	 */
	private String getOrderForViewIndex() {
		throw new CloudzeroUnsupportedException("2d\[g");
/*		StringBuffer sb = new StringBuffer();
		sb.append("ORDER BY ");
		sb.append(COL_VIEWINDEX + ", ");
		sb.append(COL_CODE + " ");
		
		this.pob.appendSort(COL_VIEWINDEX);
		this.pob.appendSort(COL_CODE);
		
		return sb.toString();*/
	}
	
}
