/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.payroll.dto;

import java.util.Date;

import jp.mosp.common.common.BaseDto;

/**
 * KD_SUBSTITUTE_HOLIDAY(֋xɊǗe[u)DTONXB
 */
public class KdSubstituteHolidayDto extends BaseDto {
	
	/**
	 * 
	 */
	private static final long	serialVersionUID		= 1773596779456831229L;
	// tB[h
	private long				substituteid			= 0;
	private String				kcode					= "";
	private int					occuryear				= 0;
	private int					occurmonth				= 0;
	private Date				closedate				= null;
	private Date				limitstartdate			= null;
	private Date				limitenddate			= null;
	private String				attitudestatus			= "";
	private int					paymentacquiretime		= 0;
	private int					paymentacquireholiday	= 0;
	private int					paymentquittime			= 0;
	private int					useholidaytime			= 0;
	private String				acquisitionstatus		= "";
	private int					liquidationovertime		= 0;
	private int					liquidationweekholiday	= 0;
	private String				decisionstatus			= "";
	private int					deleteflag				= 0;
	

	/**
	 * RXgN^B
	 */
	public KdSubstituteHolidayDto() {
		super();
	}
	
	// ANZT\bh
	/**
	 * @return substituteid 	ǗIDB
	 */
	public long getSubstituteId() {
		return substituteid;
	}
	
	/**
	 * @return kcode 	ЈR[hB
	 */
	public String getKCode() {
		return kcode;
	}
	
	/**
	 * @return occuryear 	NB
	 */
	public int getOccurYear() {
		return occuryear;
	}
	
	/**
	 * @return occurmonth 	B
	 */
	public int getOccurMonth() {
		return occurmonth;
	}
	
	/**
	 * @return closedate 	ؓB
	 */
	public Date getCloseDate() {
		return (Date)closedate.clone();
	}
	
	/**
	 * @return limitstartdate 	JnB
	 */
	public Date getLimitStartDate() {
		return (Date)limitstartdate.clone();
	}
	
	/**
	 * @return limitenddate 	IB
	 */
	public Date getLimitEndDate() {
		return (Date)limitenddate.clone();
	}
	
	/**
	 * @return attitudestatus 	ӌ󋵁B
	 */
	public String getAttitudeStatus() {
		return attitudestatus;
	}
	
	/**
	 * @return paymentacquiretime 	֋xɎ擾ԊOB
	 */
	public int getPaymentAcquireTime() {
		return paymentacquiretime;
	}
	
	/**
	 * @return paymentacquireholiday 	֋xɎ擾xԊOB
	 */
	public int getPaymentAcquireHoliday() {
		return paymentacquireholiday;
	}
	
	/**
	 * @return paymentquittime 	֋xɕԊOB
	 */
	public int getPaymentQuitTime() {
		return paymentquittime;
	}
	
	/**
	 * @return useholidaytime 	pԁB
	 */
	public int getUseHolidayTime() {
		return useholidaytime;
	}
	
	/**
	 * @return acquisitionstatus 	擾󋵁B
	 */
	public String getAcquisitionStatus() {
		return acquisitionstatus;
	}
	
	/**
	 * @return liquidationovertime 	xςɂ鎞ԊOZԁB
	 */
	public int getLiquidationOverTime() {
		return liquidationovertime;
	}
	
	/**
	 * @return liquidationweekholiday 	xςɂxԊOZԁB
	 */
	public int getLiquidationWeekHoliday() {
		return liquidationweekholiday;
	}
	
	/**
	 * @return decisionstatus 	Ϗ󋵁B
	 */
	public String getDecisionStatus() {
		return decisionstatus;
	}
	
	/**
	 * @return deleteflag 	폜tOB
	 */
	public int getDeleteFlag() {
		return deleteflag;
	}
	
	/**
	 * @param substituteid 	ZbgǗIDB
	 */
	public void setSubstituteId(long substituteid) {
		this.substituteid = substituteid;
	}
	
	/**
	 * @param kcode 	ZbgЈR[hB
	 */
	public void setKCode(String kcode) {
		this.kcode = kcode;
	}
	
	/**
	 * @param occuryear 	Zbg锭NB
	 */
	public void setOccurYear(int occuryear) {
		this.occuryear = occuryear;
	}
	
	/**
	 * @param occurmonth 	Zbg锭B
	 */
	public void setOccurMonth(int occurmonth) {
		this.occurmonth = occurmonth;
	}
	
	/**
	 * @param closedate 	ZbgؓB
	 */
	public void setCloseDate(Date closedate) {
		this.closedate = (Date)closedate.clone();
	}
	
	/**
	 * @param limitstartdate 	ZbgJnB
	 */
	public void setLimitStartDate(Date limitstartdate) {
		this.limitstartdate = (Date)limitstartdate.clone();
	}
	
	/**
	 * @param limitenddate 	ZbgIB
	 */
	public void setLimitEndDate(Date limitenddate) {
		this.limitenddate = (Date)limitenddate.clone();
	}
	
	/**
	 * @param attitudestatus 	Zbgӌ󋵁B
	 */
	public void setAttitudeStatus(String attitudestatus) {
		this.attitudestatus = attitudestatus;
	}
	
	/**
	 * @param paymentacquiretime 	Zbg֋xɎ擾ԊOB
	 */
	public void setPaymentAcquireTime(int paymentacquiretime) {
		this.paymentacquiretime = paymentacquiretime;
	}
	
	/**
	 * @param paymentacquireholiday 	Zbg֋xɎ擾xԊOB
	 */
	public void setPaymentAcquireHoliday(int paymentacquireholiday) {
		this.paymentacquireholiday = paymentacquireholiday;
	}
	
	/**
	 * @param paymentquittime 	Zbg֋xɕԊOB
	 */
	public void setPaymentQuitTime(int paymentquittime) {
		this.paymentquittime = paymentquittime;
	}
	
	/**
	 * @param useholidaytime 	Zbg闘pԁB
	 */
	public void setUseHolidayTime(int useholidaytime) {
		this.useholidaytime = useholidaytime;
	}
	
	/**
	 * @param acquisitionstatus 	Zbg擾󋵁B
	 */
	public void setAcquisitionStatus(String acquisitionstatus) {
		this.acquisitionstatus = acquisitionstatus;
	}
	
	/**
	 * @param liquidationovertime 	Zbgxςɂ鎞ԊOZԁB
	 */
	public void setLiquidationOverTime(int liquidationovertime) {
		this.liquidationovertime = liquidationovertime;
	}
	
	/**
	 * @param liquidationweekholiday 	ZbgxςɂxԊOZԁB
	 */
	public void setLiquidationWeekHoliday(int liquidationweekholiday) {
		this.liquidationweekholiday = liquidationweekholiday;
	}
	
	/**
	 * @param decisionstatus 	Zbg錈Ϗ󋵁B
	 */
	public void setDecisionStatus(String decisionstatus) {
		this.decisionstatus = decisionstatus;
	}
	
	/**
	 * @param deleteflag 	Zbg폜tOB
	 */
	public void setDeleteFlag(int deleteflag) {
		this.deleteflag = deleteflag;
	}
	
}
