/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

import jp.mosp.common.dao.MosPUserDao;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.common.utils.VariousUtil;

/**
 * MosPp[UɊւPartNX
 * @author yoshida
 * 	@version	0.0.1
 */
public class MosPUserPart extends BasePart {
	
	/**
	 * RXgN^
	 */
	public MosPUserPart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo Part𗘗pۂɕKvȏ
	 */
	public MosPUserPart(PartInfo partInfo) {
		super(partInfo);
	}
	

	private MosPUserDao	userDao;
	

	/**
	 * CM_USERe[upDAO擾
	 * @return	ςMosPUserDaoCX^X
	 * @throws Exception Oꍇ
	 */
	public MosPUserDao getMosPUserDao() throws Exception {
		if (VariousUtil.isNull(userDao)) {
			userDao = (MosPUserDao)getPreparedDao(MosPUserDao.class.getCanonicalName());
		}
		return userDao;
	}
	
	/**
	 * [U[擾(CM_USER)
	 * @param userId 擾Ώۃ[U[ID
	 * @return [U[(CmUserDto)
	 * @throws Exception  Oꍇ
	 */
	public CmUserDto getUserInfo(String userId) throws Exception {
		// ̎擾
		return getMosPUserDao().findForKey(userId);
	}
	
	/**
	 * [U[擾(CM_USER)
	 * @param kcode		擾ΏێЈR[h
	 * @return [U[(CmUserDto)
	 * @throws Exception  Oꍇ
	 */
	public CmUserDto getUserInfoForKCode(String kcode) throws Exception {
		// ̎擾
		return getMosPUserDao().findForKCode(kcode);
	}
	
}
