/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import com.google.appengine.api.datastore.Query;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.MosPMenuDto;

/**
 * CM_MENU(j[Ǘ)DAONX B
 */
public class MosPMenuDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * CM_MENU(j[Ǘ)B
	 */
	public static final String	TABLE			= "CM_MENU";
	
	/**
	 * KEY_1 = AUTHORITY()B
	 */
	public static final String	KEY_1			= "AUTHORITY";
	/**
	 * KEY_2 = MENU_ID(j[ID)B
	 */
	public static final String	KEY_2			= "MENU_ID";
	
	// 
	/**
	 * AUTHORITY()B
	 */
	public static final String	COL_AUTHORITY	= "AUTHORITY";
	/**
	 * MENU_ID(j[ID)B
	 */
	public static final String	COL_MENU_ID		= "MENU_ID";
	

	/**
	 * RXgN^
	 */
	public MosPMenuDao() {
		super();
		INSERT_DATE = "";
		INSERT_USER = "";
		UPDATE_DATE = "UPDATE_DATE";
		UPDATE_USER = "UPDATE_USER";
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException SQLOꍇ
	 */
	private List<MosPMenuDto> mappingAll() throws SQLException {
		List<MosPMenuDto> all = new ArrayList<MosPMenuDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return MosPMenuDto CM_MENUR[h
	 * @throws SQLException SQLOꍇ
	 */
	private MosPMenuDto mapping() throws SQLException {
		MosPMenuDto dto = new MosPMenuDto();
		dto.setAuthority(rs.getString(COL_AUTHORITY)); //
		dto.setMenuId(rs.getString(COL_MENU_ID)); //j[ID
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<MosPMenuDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param authority (L[)
	 * @param menuId j[ID(L[)
	 * @return MosPMenuDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MosPMenuDto findForKey(String authority, String menuId) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, authority);
			setParam(index++, menuId);
			executeQuery();
			MosPMenuDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param authority (L[)
	 * @param menuId j[ID(L[)
	 * @return MosPMenuDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MosPMenuDto findForUpdate(String authority, String menuId) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, authority);
			setParam(index++, menuId);
			executeQuery();
			MosPMenuDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param autority 
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<MosPMenuDto> findForCondition(String autority) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
//		sb.append(MosPDao.equal(COL_AUTHORITY));
		this.pob.appendWhere(COL_AUTHORITY, Query.FilterOperator.EQUAL);
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, autority);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException	MosPOꍇ
	 */
	public int insert(MosPMenuDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException	MosPOꍇ
	 */
	public int update(MosPMenuDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getAuthority());
			setParam(index++, dto.getMenuId());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException	MosPOꍇ
	 */
	public int delete(MosPMenuDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getAuthority());
			setParam(index++, dto.getMenuId());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException SQLOꍇ
	 */
	private void setParams(MosPMenuDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getAuthority()); //
		setParam(index++, dto.getMenuId()); //j[ID
		setCommonParams(isInsert);
	}
	
}
