/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.common;

import java.util.HashMap;

/**
 * ϊ[eBeBB
 * <p>2008/12/05</p>
 * <p>
 * SpJipJiApJiSpJiϊ<br>
 * Ђ炪ȁpJiApJiЂ炪ȕϊ<br>
 * Ђ炪ȁSpJiASpJiЂ炪ȕϊ
 * </p>
 * @author m.yoshida
 * @since
 * @version 0.0.1
 */
public final class KanaConvertUtility {

	/**
	 * SpJi
	 */
	private static String[] aryZenkakuKana = {
			"A","C","E","G","I",
			"J","L","N","P","R",
			"T","V","X","Z","\",
			"^","`","c","e","g",
			"i","j","k","l","m",
			"n","q","t","w","z",
			"}","~","","","",
			"","","",
			"","","","","",
			"","","",
			"K","M","O","Q","S",
			"U","W","Y","[","]",
			"_","a","d","f","h",
			"o","r","u","x","{",
			"p","s","v","y","|",
			"@","B","D","F","H",
			"","","","b","[",
			"B","u","v","A","E",
			"J","K",
			"",
			"O","P","Q","R","S",
			"T","U","V","W","X",
			"","","","","",
			"","","","h","",
			"","","","","",
			"","","","","",
			"","","","","",
			"",
			"`","a","b","c","d",
			"e","f","g","h","i",
			"j","k","l","m","n",
			"o","p","q","r","s",
			"t","u","v","w","x",
			"y",		
	};

	/**
	 * pJi
	 */
	private static String[] aryHankakuKana = {
			"","","","","",
			"","","","","",
			"","","","","",
			"","","","","",
			"","","","","",
			"","","","","",
			"","","","","",
			"","","",
			"","","","","",
			"","","",
			"","","","","",
			"","","","","",
			"","","","","",
			"","","","","",
			"","","","","",
			"","","","","",
			"","","","","",
			"","","","","",
			"","",
			"",
			"0","1","2","3","4",
			"5","6","7","8","9",
			"a","b","c","d","e",
			"f","g","h","I","j",
			"k","l","m","n","o",
			"p","q","r","s","t",
			"u","v","w","x","y",
			"z",
			"A","B","C","D","E",
			"F","G","H","I","J",
			"K","L","M","N","O",
			"P","Q","R","S","T",
			"U","V","W","X","Y",
			"Z",		
	};

	/**
	 * Ђ炪
	 */
	private static String[] aryHiraGana = {
			"","","","","",
			"","","","","",
			"","","","","",
			"","","","","",
			"","","","","",
			"","","","","",
			"","","","","",
			"","","",
			"","","","","",
			"","","",
			"","","","","",
			"","","","","",
			"","","","","",
			"","","","","",
			"","","","","",
			"","","","","",
			"","","","","[",
			"B","u","v","A","E",
			"J","K",
			"J",
			"O","P","Q","R","S",
			"T","U","V","W","X",
			"","","","","",
			"","","","h","",
			"","","","","",
			"","","","","",
			"","","","","",
			"",
			"`","a","b","c","d",
			"e","f","g","h","i",
			"j","k","l","m","n",
			"o","p","q","r","s",
			"t","u","v","w","x",
			"y",		
	};

	/**
	 * SpJipJiϊ
	 * @param input SpJi܂ޕ
	 * @return SpJi𔼊pJiɕϊ
	 */
	public static String convZenkakuToHankaku(String input) {
		return convertKana(input, getAryZenkakuKana(), getAryHankakuKana());
	}

	/**
	 * Ђ炪ȁpJiϊ
	 * @param input		Ђ炪ȕ
	 * @return	pJiɕϊꂽ
	 */
	public static String convHiraGanaToHankaku(String input) {
		return convertKana(input, getAryHiraGana(), getAryHankakuKana());
	}

	/**
	 * SpJiЂ炪ȕϊ
	 * @param input		J^Ji
	 * @return Ђ炪Ȃɕϊꂽ
	 */
	public static String convKataKanaToHiraGana(String input) {
		return convertKana(input, getAryZenkakuKana(), getAryHiraGana());
	}

	/**
	 * Ђ炪ȁSpJiϊ
	 * @param input		Ђ炪ȕ
	 * @return	SpJiɕϊꂽ
	 */
	public static String convHiraGanaToKataKana(String input) {
		return convertKana(input, getAryHiraGana(), getAryZenkakuKana());
	}

	/**
	 * ϊ\bh
	 * @param input			
	 * @param aryContain	͑Ώۉz
	 * @param aryTarget		ϊΏۉz
	 * @return	output		ϊ
	 */
	private static String convertKana(String input, String[] aryContain, String[] aryTarget) {
		StringBuffer output = new StringBuffer();
		for (int i = 0; i < input.length(); i++) {
			char ch = input.charAt(i);
			for (int j = 0; j < aryContain.length; j++) {
				if (String.valueOf(ch).equals(aryContain[j])) {
					output.append(aryTarget[j]);
					break;
				} else if (!String.valueOf(ch).equals(aryContain[j])
						&& (j == aryContain.length -1)) {
					output.append(ch);
				}
			}
		}
		return output.toString();
	}

	/**
	 * Ђ炪Ȕz擾
	 * @return	Ђ炪Ȕz
	 */
	public static String[] getAryHiraGana() {
		return aryHiraGana.clone();
	}

	/**
	 * pJiz擾
	 * @return	pJiz
	 */
	public static String[] getAryHankakuKana() {
		return aryHankakuKana.clone();
	}

	/**
	 * SpJiz擾
	 * @return	SpJiz
	 */
	public static String[] getAryZenkakuKana() {
		return aryZenkakuKana.clone();
	}

	/**
	 * pJiSpJiϊ
	 * @param input pJi܂ޕ
	 * @return pJiSpJiɕϊ
	 */
	public static String convHankakuToZenkaku(String input) {
		return convertZenkaku(input, getKataKanaMap());
	}
	
	/**
	 * pJiЂ炪ȕϊ
	 * @param input		pJi
	 * @return	Ђ炪Ȃɕϊꂽ
	 */
	public static String convHankakuToHiraGana(String input) {
		return convertZenkaku(input, getHiraGanaMap());
	}

	/**
	 * pJiϊ\bh
	 * @param input			pJi
	 * @param targetMap		ϊΏۃ}bv
	 * @return	ϊΏۉɕϊꂽ
	 */
	private static String convertZenkaku(String input, HashMap<String, String> targetMap) {
		StringBuffer output = new StringBuffer();
		for (int i = 0; i < input.length(); i++) {
			char ch = input.charAt(i);
			int next = i + 1;
			char p = ' ';
			String han = String.valueOf(ch);
			if (next < input.length()) {
				p = input.charAt(next);
				han += p;
			}
			String kana = targetMap.get(han);
			if (kana == null) {
				if (targetMap.get(String.valueOf(ch)) != null) {
					output.append(targetMap.get(String.valueOf(ch)));
				} else {
					output.append(ch);
				}
			} else {
				output.append(kana);
				i++;
			}
		}
		return output.toString();
	}

	/**
	 * pJiSpJiϊp}bv
	 * @return	ϊp}bv
	 */
	private static HashMap<String, String> getKataKanaMap() {
		HashMap<String, String> kataKanaMap = new HashMap<String, String>();
		for (int i = 0; i < aryHankakuKana.length; i++) {
			kataKanaMap.put(aryHankakuKana[i], aryZenkakuKana[i]);
		}
		return kataKanaMap;
	}

	/**
	 * pJiЂ炪ȕϊp}bv
	 * @return	ϊp}bv
	 */
	private static HashMap<String, String> getHiraGanaMap() {
		HashMap<String, String> hiraGanaMap = new HashMap<String, String>();
		for (int i = 0; i < aryHankakuKana.length; i++) {
			hiraGanaMap.put(aryHankakuKana[i], aryHiraGana[i]);
		}
		return hiraGanaMap;
	}

}
