/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfStructureElement;
import com.lowagie.text.pdf.PdfStructureTreeRoot;
import com.lowagie.text.pdf.PdfWriter;
import java.util.Stack;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;

public class JRPdfExporterTagHelper {
    public static final String PROPERTY_TAG_TABLE = "net.sf.jasperreports.export.pdf.tag.table";
    public static final String PROPERTY_TAG_TR = "net.sf.jasperreports.export.pdf.tag.tr";
    public static final String PROPERTY_TAG_TH = "net.sf.jasperreports.export.pdf.tag.th";
    public static final String PROPERTY_TAG_TD = "net.sf.jasperreports.export.pdf.tag.td";
    public static final String PROPERTY_TAG_H1 = "net.sf.jasperreports.export.pdf.tag.h1";
    public static final String PROPERTY_TAG_H2 = "net.sf.jasperreports.export.pdf.tag.h2";
    public static final String PROPERTY_TAG_H3 = "net.sf.jasperreports.export.pdf.tag.h3";
    public static final String PROPERTY_TAG_COLSPAN = "net.sf.jasperreports.export.pdf.tag.colspan";
    public static final String PROPERTY_TAG_ROWSPAN = "net.sf.jasperreports.export.pdf.tag.rowspan";
    public static final String TAG_START = "start";
    public static final String TAG_END = "end";
    public static final String TAG_FULL = "full";
    protected JRPdfExporter exporter = null;
    protected PdfContentByte pdfContentByte = null;
    protected PdfWriter pdfWriter = null;
    protected PdfStructureElement allTag = null;
    protected Stack tagStack = null;
    protected boolean isTagEmpty = true;
    protected int crtCrosstabRowY = -1;
    protected int crosstabFrameDepth = 0;
    protected boolean isDataCellPrinted = false;
    protected boolean isTagged = false;

    protected JRPdfExporterTagHelper(JRPdfExporter exporter) {
        this.exporter = exporter;
    }

    protected void setTagged(boolean isTagged) {
        this.isTagged = isTagged;
    }

    protected void setPdfWriter(PdfWriter pdfWriter) {
        this.pdfWriter = pdfWriter;
        if (this.isTagged) {
            pdfWriter.setTagged();
        }
    }

    protected void init(PdfContentByte pdfContentByte) {
        this.pdfContentByte = pdfContentByte;
        if (this.isTagged) {
            PdfStructureTreeRoot root = this.pdfWriter.getStructureTreeRoot();
            this.allTag = new PdfStructureElement(root, new PdfName("All"));
            root.mapRole(new PdfName("All"), new PdfName("Sect"));
            root.mapRole(new PdfName("Anchor"), PdfName.TEXT);
            String language = this.exporter.getStringParameter(JRPdfExporterParameter.TAG_LANGUAGE, "net.sf.jasperreports.export.pdf.tag.language");
            if (language != null) {
                this.allTag.put(PdfName.LANG, (PdfObject)new PdfString(language));
            }
            this.tagStack = new Stack();
            this.tagStack.push(this.allTag);
        }
    }

    protected void startPageAnchor() {
        if (this.isTagged) {
            PdfStructureElement textTag = new PdfStructureElement(this.allTag, new PdfName("Anchor"));
            this.pdfContentByte.beginMarkedContentSequence(textTag);
        }
    }

    protected void endPageAnchor() {
        if (this.isTagged) {
            this.pdfContentByte.endMarkedContentSequence();
        }
    }

    protected void startPage() {
        this.crtCrosstabRowY = -1;
        this.crosstabFrameDepth = 0;
        this.isDataCellPrinted = false;
    }

    protected void endPage() {
        if (this.isTagged && this.crtCrosstabRowY >= 0) {
            this.pdfContentByte.endMarkedContentSequence();
            this.tagStack.pop();
            this.pdfContentByte.endMarkedContentSequence();
            this.tagStack.pop();
        }
    }

    protected void startElement(JRPrintElement element) {
        if (this.isTagged) {
            if (element instanceof JRPrintFrame) {
                boolean isCellContentsFrame;
                JRPrintFrame frame = (JRPrintFrame)element;
                boolean bl = isCellContentsFrame = frame.getPropertiesMap().hasProperties() && frame.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.type") != null;
                if (this.crtCrosstabRowY >= 0) {
                    ++this.crosstabFrameDepth;
                    if (isCellContentsFrame) {
                        if ("Data".equals(frame.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.type"))) {
                            this.isDataCellPrinted = true;
                        }
                        if (this.crtCrosstabRowY != frame.getY()) {
                            this.pdfContentByte.endMarkedContentSequence();
                            this.tagStack.pop();
                            if (this.isDataCellPrinted && ("CrosstabHeader".equals(frame.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.type")) || "ColumnHeader".equals(frame.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.type")))) {
                                this.pdfContentByte.endMarkedContentSequence();
                                this.tagStack.pop();
                                this.createTableStartTag();
                                this.isDataCellPrinted = false;
                            }
                            this.createTrStartTag();
                            this.crtCrosstabRowY = frame.getY();
                        }
                    } else if (this.crosstabFrameDepth == 1) {
                        this.pdfContentByte.endMarkedContentSequence();
                        this.tagStack.pop();
                        this.pdfContentByte.endMarkedContentSequence();
                        this.tagStack.pop();
                        this.crtCrosstabRowY = -1;
                        this.crosstabFrameDepth = 0;
                    }
                } else if (isCellContentsFrame) {
                    this.createTableStartTag();
                    this.createTrStartTag();
                    this.crtCrosstabRowY = frame.getY();
                    ++this.crosstabFrameDepth;
                    this.isDataCellPrinted = false;
                }
            } else if (this.crtCrosstabRowY >= 0 && this.crosstabFrameDepth == 0) {
                this.pdfContentByte.endMarkedContentSequence();
                this.tagStack.pop();
                this.pdfContentByte.endMarkedContentSequence();
                this.tagStack.pop();
                this.crtCrosstabRowY = -1;
                this.crosstabFrameDepth = 0;
            }
            this.createStartTags(element);
        }
    }

    protected void endElement(JRPrintElement element) {
        if (this.isTagged) {
            if (element instanceof JRPrintFrame && this.crtCrosstabRowY >= 0) {
                --this.crosstabFrameDepth;
            }
            this.createEndTags(element);
        }
    }

    protected void startImage(JRPrintImage printImage) {
        if (this.isTagged) {
            PdfStructureElement imageTag = new PdfStructureElement(this.allTag, PdfName.IMAGE);
            this.pdfContentByte.beginMarkedContentSequence(imageTag);
            if (printImage.getHyperlinkTooltip() != null) {
                imageTag.put(PdfName.ALT, (PdfObject)new PdfString(printImage.getHyperlinkTooltip()));
            }
        }
    }

    protected void endImage() {
        if (this.isTagged) {
            this.pdfContentByte.endMarkedContentSequence();
        }
    }

    protected void startText() {
        if (this.isTagged) {
            PdfStructureElement textTag = new PdfStructureElement((PdfStructureElement)this.tagStack.peek(), PdfName.TEXT);
            this.pdfContentByte.beginMarkedContentSequence(textTag);
        }
    }

    protected void endText() {
        if (this.isTagged) {
            this.pdfContentByte.endMarkedContentSequence();
            this.isTagEmpty = false;
        }
    }

    protected void createStartTags(JRPrintElement element) {
        if (element.hasProperties()) {
            PdfStructureElement headingTag;
            String prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_TABLE);
            if (prop != null && (TAG_START.equals(prop) || TAG_FULL.equals(prop))) {
                this.createTableStartTag();
            }
            if ((prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_TR)) != null && (TAG_START.equals(prop) || TAG_FULL.equals(prop))) {
                this.createTrStartTag();
            }
            if ((prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_TH)) != null && (TAG_START.equals(prop) || TAG_FULL.equals(prop))) {
                this.createThStartTag(element);
            }
            if ((prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_TD)) != null && (TAG_START.equals(prop) || TAG_FULL.equals(prop))) {
                this.createTdStartTag(element);
            }
            if ((prop = element.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.type")) != null && ("CrosstabHeader".equals(prop) || "ColumnHeader".equals(prop) || "RowHeader".equals(prop))) {
                this.createThStartTag(element);
            }
            if (prop != null && "Data".equals(prop)) {
                this.createTdStartTag(element);
            }
            if ((prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_H1)) != null && (TAG_START.equals(prop) || TAG_FULL.equals(prop))) {
                headingTag = new PdfStructureElement((PdfStructureElement)this.tagStack.peek(), new PdfName("H1"));
                this.pdfContentByte.beginMarkedContentSequence(headingTag);
                headingTag.put(PdfName.K, (PdfObject)new PdfArray());
                this.tagStack.push(headingTag);
                this.isTagEmpty = true;
            }
            if ((prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_H2)) != null && (TAG_START.equals(prop) || TAG_FULL.equals(prop))) {
                headingTag = new PdfStructureElement((PdfStructureElement)this.tagStack.peek(), new PdfName("H2"));
                this.pdfContentByte.beginMarkedContentSequence(headingTag);
                headingTag.put(PdfName.K, (PdfObject)new PdfArray());
                this.tagStack.push(headingTag);
                this.isTagEmpty = true;
            }
            if ((prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_H3)) != null && (TAG_START.equals(prop) || TAG_FULL.equals(prop))) {
                headingTag = new PdfStructureElement((PdfStructureElement)this.tagStack.peek(), new PdfName("H3"));
                this.pdfContentByte.beginMarkedContentSequence(headingTag);
                headingTag.put(PdfName.K, (PdfObject)new PdfArray());
                this.tagStack.push(headingTag);
                this.isTagEmpty = true;
            }
        }
    }

    protected void createTableStartTag() {
        PdfStructureElement tableTag = new PdfStructureElement(this.allTag, new PdfName("Table"));
        this.pdfContentByte.beginMarkedContentSequence(tableTag);
        tableTag.put(PdfName.K, (PdfObject)new PdfArray());
        this.tagStack.push(tableTag);
    }

    protected void createTrStartTag() {
        PdfStructureElement tableRowTag = new PdfStructureElement((PdfStructureElement)this.tagStack.peek(), new PdfName("TR"));
        this.pdfContentByte.beginMarkedContentSequence(tableRowTag);
        tableRowTag.put(PdfName.K, (PdfObject)new PdfArray());
        this.tagStack.push(tableRowTag);
    }

    protected void createThStartTag(JRPrintElement element) {
        PdfStructureElement tableHeaderTag = new PdfStructureElement((PdfStructureElement)this.tagStack.peek(), new PdfName("TH"));
        this.pdfContentByte.beginMarkedContentSequence(tableHeaderTag);
        tableHeaderTag.put(PdfName.K, (PdfObject)new PdfArray());
        this.tagStack.push(tableHeaderTag);
        this.isTagEmpty = true;
        this.createSpanTags(element, tableHeaderTag);
    }

    protected void createTdStartTag(JRPrintElement element) {
        PdfStructureElement tableCellTag = new PdfStructureElement((PdfStructureElement)this.tagStack.peek(), new PdfName("TD"));
        this.pdfContentByte.beginMarkedContentSequence(tableCellTag);
        tableCellTag.put(PdfName.K, (PdfObject)new PdfArray());
        this.tagStack.push(tableCellTag);
        this.isTagEmpty = true;
        this.createSpanTags(element, tableCellTag);
    }

    protected void createSpanTags(JRPrintElement element, PdfStructureElement parentTag) {
        int colSpan = 0;
        int rowSpan = 0;
        try {
            colSpan = Integer.valueOf(element.getPropertiesMap().getProperty(PROPERTY_TAG_COLSPAN));
        }
        catch (NumberFormatException e) {
            try {
                colSpan = Integer.valueOf(element.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.column.span"));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        try {
            rowSpan = Integer.valueOf(element.getPropertiesMap().getProperty(PROPERTY_TAG_ROWSPAN));
        }
        catch (NumberFormatException e) {
            try {
                rowSpan = Integer.valueOf(element.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.row.span"));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (colSpan > 1 || rowSpan > 1) {
            PdfArray a = new PdfArray();
            PdfDictionary dict = new PdfDictionary();
            if (colSpan > 1) {
                dict.put(new PdfName("ColSpan"), (PdfObject)new PdfNumber(colSpan));
            }
            if (rowSpan > 1) {
                dict.put(new PdfName("RowSpan"), (PdfObject)new PdfNumber(rowSpan));
            }
            dict.put(PdfName.O, (PdfObject)new PdfName("Table"));
            a.add((PdfObject)dict);
            parentTag.put(PdfName.A, (PdfObject)a);
        }
    }

    protected void createEndTags(JRPrintElement element) {
        if (element.hasProperties()) {
            String prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_TABLE);
            if (prop != null && (TAG_END.equals(prop) || TAG_FULL.equals(prop))) {
                this.pdfContentByte.endMarkedContentSequence();
                this.tagStack.pop();
            }
            if ((prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_TR)) != null && (TAG_END.equals(prop) || TAG_FULL.equals(prop))) {
                this.pdfContentByte.endMarkedContentSequence();
                this.tagStack.pop();
            }
            if ((prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_TH)) != null && (TAG_END.equals(prop) || TAG_FULL.equals(prop))) {
                this.pdfContentByte.endMarkedContentSequence();
                if (this.isTagEmpty) {
                    this.pdfContentByte.beginMarkedContentSequence(new PdfStructureElement((PdfStructureElement)this.tagStack.peek(), PdfName.SPAN));
                    this.pdfContentByte.endMarkedContentSequence();
                }
                this.tagStack.pop();
            }
            if ((prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_TD)) != null && (TAG_END.equals(prop) || TAG_FULL.equals(prop))) {
                this.pdfContentByte.endMarkedContentSequence();
                if (this.isTagEmpty) {
                    this.pdfContentByte.beginMarkedContentSequence(new PdfStructureElement((PdfStructureElement)this.tagStack.peek(), PdfName.SPAN));
                    this.pdfContentByte.endMarkedContentSequence();
                }
                this.tagStack.pop();
            }
            if ((prop = element.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.type")) != null && ("CrosstabHeader".equals(prop) || "ColumnHeader".equals(prop) || "RowHeader".equals(prop) || "Data".equals(prop))) {
                this.pdfContentByte.endMarkedContentSequence();
                if (this.isTagEmpty) {
                    this.pdfContentByte.beginMarkedContentSequence(new PdfStructureElement((PdfStructureElement)this.tagStack.peek(), PdfName.SPAN));
                    this.pdfContentByte.endMarkedContentSequence();
                }
                this.tagStack.pop();
            }
            if ((prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_H1)) != null && (TAG_END.equals(prop) || TAG_FULL.equals(prop))) {
                this.pdfContentByte.endMarkedContentSequence();
                if (this.isTagEmpty) {
                    this.pdfContentByte.beginMarkedContentSequence(new PdfStructureElement((PdfStructureElement)this.tagStack.peek(), PdfName.SPAN));
                    this.pdfContentByte.endMarkedContentSequence();
                }
                this.tagStack.pop();
            }
            if ((prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_H2)) != null && (TAG_END.equals(prop) || TAG_FULL.equals(prop))) {
                this.pdfContentByte.endMarkedContentSequence();
                if (this.isTagEmpty) {
                    this.pdfContentByte.beginMarkedContentSequence(new PdfStructureElement((PdfStructureElement)this.tagStack.peek(), PdfName.SPAN));
                    this.pdfContentByte.endMarkedContentSequence();
                }
                this.tagStack.pop();
            }
            if ((prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_H3)) != null && (TAG_END.equals(prop) || TAG_FULL.equals(prop))) {
                this.pdfContentByte.endMarkedContentSequence();
                if (this.isTagEmpty) {
                    this.pdfContentByte.beginMarkedContentSequence(new PdfStructureElement((PdfStructureElement)this.tagStack.peek(), PdfName.SPAN));
                    this.pdfContentByte.endMarkedContentSequence();
                }
                this.tagStack.pop();
            }
        }
    }
}

