/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * ʓǍǉ
 * @param 
 * @return 
 * @throws sO
 */
function onLoadExtra() {
	// ڔwiFݒ
	setFieldsBgColor(ARY_FIELDS_ID,     COLOR_FIELD_NORMAL);
	setFieldsBgColor(ARY_ERR_FIELDS_ID, COLOR_FIELD_ERROR);
	// tH[JXݒ
	setFocus(PRM_PLT_HOLIDAY_YEAR);
	// ڒݒ
	setMaxLength(PRM_TXT_CAUSE_COMMENT, LEN_COMMENT);
	// VKo^A
	if (MODE == 0) {
		setVisibility("btnCancel",false);
	}
	// XV\
	if (MODE == 1) {
		setReadOnly(PRM_PLT_HOLIDAY_YEAR, true);
		setReadOnly(PRM_PLT_HOLIDAY_MONTH, true);
		setReadOnly(PRM_PLT_HOLIDAY_DAY, true);
	}
	// \
	if (MODE == 2) {
		setVisibility("btnDraft",false);
		setVisibility("btnRequest",false);
	}
	// XVs
	if (MODE == 3) {
		setVisibility("btnDraft",false);
		setVisibility("btnRequest",false);
		setVisibility("btnCancel",false);
	}
	// ߍXV
	if (MODE == 4) {
		setReadOnly(PRM_PLT_HOLIDAY_YEAR, true);
		setReadOnly(PRM_PLT_HOLIDAY_MONTH, true);
		setReadOnly(PRM_PLT_HOLIDAY_DAY, true);
		setVisibility("btnDraft",false);
	}
	viewDivType();
	viewDivTime();
}

/**
 * T[o[ʐM
 * @param 
 * @return 
 * @throws sO
 */
function submitForm(objForm, key1) {
	// ̓`FbN
	if (validate()) {
		// T[o[ʐM(̓G[̏ꍇ)
		if (MODE == 0) {
			doSubmitMessageKey(objForm, 'K1427', 'QC0001', '', key1, '');
		} else if (MODE == 1 || MODE == 4) {
			doSubmitMessageKey(objForm, 'K1428', 'QC0001', '', key1, '')
		}
	}
}

/**
 * ̓`FbN
 * @param 
 * @return `FbN(trueFOKAfalseFNG)
 * @throws sO
 */
function validate() {
	// tB[hwiFݒ
	setFieldsBgColor(ARY_FIELDS_ID, COLOR_FIELD_NORMAL);
	// ̓`FbN
	var aryMessage = new Array();
	// t̃`FbN
	checkDate(PRM_PLT_HOLIDAY_YEAR, PRM_PLT_HOLIDAY_MONTH, PRM_PLT_HOLIDAY_DAY, NAM_HOLIDAY_DATE, aryMessage);
	// ԔNx
	if (USE_HOUR_HOLIDAY && getFormValue(PRM_PLT_TYPE) == "3") {
		// J@{s
		checkReformDate(aryMessage);
		// ͎
		checkTime(aryMessage);
	}
	// [
	if (getFormValue(PRM_PLT_SUBSTITUTE_YEAR) != "" 
			|| getFormValue(PRM_PLT_SUBSTITUTE_MONTH) != "" 
			|| getFormValue(PRM_PLT_SUBSTITUTE_DAY) != ""
	) {
		checkDate(PRM_PLT_SUBSTITUTE_YEAR, PRM_PLT_SUBSTITUTE_MONTH, PRM_PLT_SUBSTITUTE_DAY, NAM_SUBSTITUTE_DATE, aryMessage);
	}
	checkLength(PRM_TXT_CAUSE_COMMENT, LEN_COMMENT, NAM_CAUSE_COMMENT, aryMessage)

	if (aryMessage.length == 0) {
		return true;
	} else {
		showMessage(aryMessage);
		return false;
	}
}

function checkTime(aryMessage) {
	var starthour = getFormValue(PRM_PLT_START_HOUR);
	var startmin = getFormValue(PRM_PLT_START_MIN);
	var endhour = getFormValue(PRM_PLT_END_HOUR);
	var endmin = getFormValue(PRM_PLT_END_MIN);
	var starttime = parseInt(starthour) *60 + parseInt(startmin);
	var endtime = parseInt(endhour) *60 + parseInt(endmin);
	
	if (starttime < 0) {
		if (aryMessage.length == 0) {
			setFocus(PRM_PLT_START_HOUR);
			setMessage("WC0007", NAM_START_TIME);
		}
		setBgColor(PRM_PLT_START_HOUR, COLOR_FIELD_ERROR);
		setBgColor(PRM_PLT_START_MIN, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage("WC0007", NAM_START_TIME));
	}
	
	if (endtime < 0) {
		if (aryMessage.length == 0) {
			setFocus(PRM_PLT_END_HOUR);
			setMessage("WC0007", NAM_END_TIME);
		}
		setBgColor(PRM_PLT_END_HOUR, COLOR_FIELD_ERROR);
		setBgColor(PRM_PLT_END_MIN, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage("WC0007", NAM_END_TIME));
	}
	
	var differencetime = endtime - starttime;
	
	if (differencetime <= 0 || differencetime != HOUR_UNIT * 60) {
		setBgColor(PRM_PLT_END_HOUR, COLOR_FIELD_ERROR);
		setBgColor(PRM_PLT_END_MIN, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage("WC0007", NAM_END_TIME));
	}
	
}

function viewDivType() {
	var reason = getFormValue(PRM_PLT_REASON);
	if (reason == "0") {
		var type = getFormValue(PRM_PLT_TYPE)
		setOption(PRM_PLT_TYPE, ARY_PLT_TYPE);
		setVisibility("divType", true);
		setFormValue(PRM_PLT_TYPE, type);
		viewDivTime();
	} else if (reason == "sub") {
		if (USE_HOUR_HOLIDAY && USE_SUBSTITUTE_HOLIDAY) {
			setOption(PRM_PLT_TYPE, ARY_PLT_TYPE.slice(0, 3));
		}
		setVisibility("divType", true);
		setVisibility("divTime", false);
	} else {
		setVisibility("divType", false);
		setVisibility("divTime", false);
	}
}

function viewDivTime() {
	var type = getFormValue(PRM_PLT_TYPE);
	if (type == "3") {
		setVisibility("divTime", true);
	} else {
		setVisibility("divTime", false);
	}
}

function checkReformDate(aryMessage) {
	yyyy = getFormValue(PRM_PLT_HOLIDAY_YEAR);
	mm = getFormValue(PRM_PLT_HOLIDAY_MONTH);
	dd = getFormValue(PRM_PLT_HOLIDAY_DAY);
	
	var reform =  new Date(2010, 4 - 1, 1);
	var date = new Date(yyyy, mm - 1, dd);
	if (reform.getTime() > date.getTime()) {
		setBgColor(PRM_PLT_HOLIDAY_YEAR, COLOR_FIELD_ERROR);
		setBgColor(PRM_PLT_HOLIDAY_MONTH, COLOR_FIELD_ERROR);
		setBgColor(PRM_PLT_HOLIDAY_DAY, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage("WC0023", NAM_HOLIDAY_DATE + ',' + reform.getFullYear()  + "N" + (reform.getMonth() + 1) + "" + reform.getDate() + ""));
	}
}

function changeEndTime() {
	var startTime = parseInt(getFormValue(PRM_PLT_START_HOUR)) * 60 + parseInt(getFormValue(PRM_PLT_START_MIN));
	var endTime = startTime + (HOUR_UNIT * 60);
	if (endTime >= 24 * 60) {
		endTime = 24 * 60;
	}
	setFormValue(PRM_PLT_END_HOUR, Math.floor(endTime / 60));
	setFormValue(PRM_PLT_END_MIN, endTime % 60);
}
