/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * ʓǍǉ
 * @param 
 * @return 
 * @throws sO
 */
function onLoadExtra() {
	// ڔwiFݒ
	setFieldsBgColor(ARY_FIELDS_ID    , COLOR_FIELD_NORMAL);
	setFieldsBgColor(ARY_ERR_FIELDS_ID, COLOR_FIELD_ERROR );
	// ڒݒ
	setMaxLength(PRM_TXT_CALCULATION_DAYS 		, LEN_DAYS);
	setMaxLength(PRM_TXT_PROVIDED_DAYS 			, LEN_DAYS);
	setMaxLength(PRM_TXT_INPUT_UNIT_TIMES 		, LEN_TIME);
	setMaxLength(PRM_TXT_ALL_HOLIDAY_HOUR 		, LEN_TIME);
	setMaxLength(PRM_TXT_ALL_HOLIDAY_MIN 		, LEN_TIME);
	setMaxLength(PRM_TXT_HALF_HOLIDAY_HOUR 		, LEN_TIME);
	setMaxLength(PRM_TXT_HALF_HOLIDAY_MIN 		, LEN_TIME);
	setMaxLength(PRM_TXT_LATE_NIGHT_START_HOUR 	, LEN_TIME);
	setMaxLength(PRM_TXT_LATE_NIGHT_START_MIN 	, LEN_TIME);
	setMaxLength(PRM_TXT_LATE_NIGHT_TIME_HOUR 	, LEN_TIME);
	setMaxLength(PRM_TXT_LATE_NIGHT_TIME_MIN 	, LEN_TIME);
	
	setMaxLength(PRM_TXT_PASSWORD_TERM 	, LEN_DAYS);
	
	setMaxLength(PRM_TXT_BEFORE_OVER_TIME_HOUR 		, LEN_TIME);
	setMaxLength(PRM_TXT_BEFORE_OVER_TIME_MIN 		, LEN_TIME);
	setMaxLength(PRM_TXT_OVER_TIME_UNIT_HOUR 		, LEN_TIME);
	setMaxLength(PRM_TXT_OVER_TIME_UNIT_MIN 		, LEN_TIME);
	setMaxLength(PRM_TXT_OVER_TIME_INTERVAL_HOUR 	, LEN_TIME);
	setMaxLength(PRM_TXT_OVER_TIME_INTERVAL_MIN 	, LEN_TIME);
	
	// tH[JXݒ
	setFocus(PRM_TXT_CALCULATION_DAYS);

	changeProcessView();
	changeHourUnitView();
	//changeAmendmentView();
	changeSubstituteFunctionView();
	changeSubstituteView();

}

/**
 * T[o[ʐM
 * @param 
 * @return 
 * @throws sO
 */
function submitForm(objForm) {
	// ̓`FbN
	if (validate()) {
		// T[o[ʐM(̓G[̏ꍇ)
		doSubmitMessage(objForm, 'S2038', 'QC0001', '');
	}
}

/**
 * ̓`FbN
 * @param 
 * @return `FbN(trueFOKAfalseFNG)
 * @throws sO
 */
function validate() {
	// tB[hwiFݒ
	setFieldsBgColor(ARY_FIELDS_ID, COLOR_FIELD_NORMAL);
	// ̓`FbN
	var aryMessage = new Array();

	checkRequired(PRM_TXT_CALCULATION_DAYS		, NAM_CALCULATION				, aryMessage);
	checkRequired(PRM_TXT_PROVIDED_DAYS			, NAM_PROVIDED					, aryMessage);
	checkRequired(PRM_TXT_INPUT_UNIT_TIMES		, NAM_INPUT_UNIT_TIMES			, aryMessage);
	checkRequired(PRM_TXT_ALL_HOLIDAY_HOUR		, NAM_HOLIDAY_HOURS_ALL_HOUR	, aryMessage);
	checkRequired(PRM_TXT_ALL_HOLIDAY_MIN		, NAM_HOLIDAY_HOURS_ALL_MIN		, aryMessage);
	checkRequired(PRM_TXT_HALF_HOLIDAY_HOUR		, NAM_HOLIDAY_HOURS_HALF_HOUR	, aryMessage);
	checkRequired(PRM_TXT_HALF_HOLIDAY_MIN		, NAM_HOLIDAY_HOURS_HALF_MIN	, aryMessage);
	checkRequired(PRM_TXT_LATE_NIGHT_START_HOUR	, NAM_LATE_NIGHT_START_HOUR		, aryMessage);
	checkRequired(PRM_TXT_LATE_NIGHT_START_MIN	, NAM_LATE_NIGHT_START_MIN		, aryMessage);
	checkRequired(PRM_TXT_LATE_NIGHT_TIME_HOUR	, NAM_LATE_NIGHT_HOURS_HOUR		, aryMessage);
	checkRequired(PRM_TXT_LATE_NIGHT_TIME_MIN	, NAM_LATE_NIGHT_HOURS_MIN		, aryMessage);
	
	checkNumber(PRM_TXT_CALCULATION_DAYS		, NAM_CALCULATION				, aryMessage);
	checkNumber(PRM_TXT_PROVIDED_DAYS			, NAM_PROVIDED					, aryMessage);
	checkNumber(PRM_TXT_INPUT_UNIT_TIMES		, NAM_INPUT_UNIT_TIMES			, aryMessage);
	checkNumber(PRM_TXT_ALL_HOLIDAY_HOUR		, NAM_HOLIDAY_HOURS_ALL_HOUR	, aryMessage);
	checkNumber(PRM_TXT_ALL_HOLIDAY_MIN			, NAM_HOLIDAY_HOURS_ALL_MIN		, aryMessage);
	checkNumber(PRM_TXT_HALF_HOLIDAY_HOUR		, NAM_HOLIDAY_HOURS_HALF_HOUR	, aryMessage);
	checkNumber(PRM_TXT_HALF_HOLIDAY_MIN		, NAM_HOLIDAY_HOURS_HALF_MIN	, aryMessage);
	checkNumber(PRM_TXT_LATE_NIGHT_START_HOUR	, NAM_LATE_NIGHT_START_HOUR		, aryMessage);
	checkNumber(PRM_TXT_LATE_NIGHT_START_MIN	, NAM_LATE_NIGHT_START_MIN		, aryMessage);
	checkNumber(PRM_TXT_LATE_NIGHT_TIME_HOUR	, NAM_LATE_NIGHT_HOURS_HOUR		, aryMessage);
	checkNumber(PRM_TXT_LATE_NIGHT_TIME_MIN		, NAM_LATE_NIGHT_HOURS_MIN		, aryMessage);
	// ԁA̍vl`FbN
	checkTimeValue(PRM_TXT_ALL_HOLIDAY_HOUR		,PRM_TXT_ALL_HOLIDAY_MIN		, 24 , NAM_HOLIDAY_HOURS_ALL	,aryMessage);
	checkTimeValue(PRM_TXT_HALF_HOLIDAY_HOUR	,PRM_TXT_HALF_HOLIDAY_MIN		, 24 , NAM_HOLIDAY_HOURS_HALF	,aryMessage);
	checkTimeValue(PRM_TXT_LATE_NIGHT_START_HOUR,PRM_TXT_LATE_NIGHT_START_MIN	, 36 , NAM_LATE_NIGHT_START		,aryMessage);
	checkTimeValue(PRM_TXT_LATE_NIGHT_TIME_HOUR	,PRM_TXT_LATE_NIGHT_TIME_MIN	, 24 , NAM_LATE_NIGHT_HOURS		,aryMessage);

	// ΑӒ
	var calcDay = getFormValue(PRM_TXT_CALCULATION_DAYS);
	if ((calcDay > 31) || (calcDay < 0)) {
		setBgColor(PRM_TXT_CALCULATION_DAYS, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage("WC0006", NAM_CALCULATION));
	}
	
	// ^x
	var provide = getFormValue(PRM_TXT_PROVIDED_DAYS);
	if ((provide > 31) || (provide < 1)) {
		setBgColor(PRM_TXT_PROVIDED_DAYS, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage("WC0006", NAM_PROVIDED));
	}
	
	// ͒P
	var unit = getFormValue(PRM_TXT_INPUT_UNIT_TIMES);
	if ((unit > 60) || (unit < 1)) {
		setBgColor(PRM_TXT_INPUT_UNIT_TIMES, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage("WC2029", NAM_INPUT_UNIT_TIMES));
	}

	// SxExr`FbN
	var allHoliday = (getFormValue(PRM_TXT_ALL_HOLIDAY_HOUR) * 60 ) + eval(getFormValue(PRM_TXT_ALL_HOLIDAY_MIN));
	var halfHoliday = (getFormValue(PRM_TXT_HALF_HOLIDAY_HOUR) * 60 ) + eval(getFormValue(PRM_TXT_HALF_HOLIDAY_MIN));
	if (halfHoliday > allHoliday) {
		aryMessage.push("x͑SxԐ𒴂ȂłB");
	}

	checkRegLength(PRM_TXT_INPUT_UNIT_TIMES, LEN_TIME, NAM_INPUT_UNIT_TIMES, aryMessage);

	checkRequired(PRM_TXT_PASSWORD_TERM	, NAM_PASSWORD_TERM		, aryMessage);
	checkNumber(PRM_TXT_PASSWORD_TERM	, NAM_PASSWORD_TERM		, aryMessage);
	
	checkRequired(PRM_TXT_BEFORE_OVER_TIME_HOUR		, NAM_BEFORE_OVER_TIME_HOUR		, aryMessage);
	checkRequired(PRM_TXT_BEFORE_OVER_TIME_MIN		, NAM_BEFORE_OVER_TIME_MIN		, aryMessage);
	checkRequired(PRM_TXT_OVER_TIME_UNIT_HOUR		, NAM_OVER_TIME_UNIT_HOUR		, aryMessage);
	checkRequired(PRM_TXT_OVER_TIME_UNIT_MIN		, NAM_OVER_TIME_UNIT_MIN		, aryMessage);
	checkRequired(PRM_TXT_OVER_TIME_INTERVAL_HOUR	, NAM_OVER_TIME_INTERVAL_HOUR	, aryMessage);
	checkRequired(PRM_TXT_OVER_TIME_INTERVAL_MIN	, NAM_OVER_TIME_INTERVAL_MIN	, aryMessage);

	checkNumber(PRM_TXT_BEFORE_OVER_TIME_HOUR	, NAM_BEFORE_OVER_TIME_HOUR		, aryMessage);
	checkNumber(PRM_TXT_BEFORE_OVER_TIME_MIN	, NAM_BEFORE_OVER_TIME_MIN		, aryMessage);
	checkNumber(PRM_TXT_OVER_TIME_UNIT_HOUR		, NAM_OVER_TIME_UNIT_HOUR		, aryMessage);
	checkNumber(PRM_TXT_OVER_TIME_UNIT_MIN		, NAM_OVER_TIME_UNIT_MIN		, aryMessage);
	checkNumber(PRM_TXT_OVER_TIME_INTERVAL_HOUR	, NAM_OVER_TIME_INTERVAL_HOUR	, aryMessage);
	checkNumber(PRM_TXT_OVER_TIME_INTERVAL_MIN	, NAM_OVER_TIME_INTERVAL_MIN	, aryMessage);
	
	// cƊJnO
	var beforemin = getFormValue(PRM_TXT_BEFORE_OVER_TIME_MIN);
	if (beforemin > 59) {
		setBgColor(PRM_TXT_BEFORE_OVER_TIME_MIN, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage("WC0007", NAM_BEFORE_OVER_TIME_MIN));
	}
	var before = (getFormValue(PRM_TXT_BEFORE_OVER_TIME_HOUR) * 60) + beforemin;
	if (before > 24*60 || before < 0) {
		setBgColor(PRM_TXT_BEFORE_OVER_TIME_HOUR, COLOR_FIELD_ERROR);
		setBgColor(PRM_TXT_BEFORE_OVER_TIME_MIN, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage("WC0007", NAM_BEFORE_OVER_TIME));
	}
	// xΏےPʎ
	var unitmin = getFormValue(PRM_TXT_OVER_TIME_UNIT_MIN);
	if (unitmin > 59) {
		setBgColor(PRM_TXT_OVER_TIME_UNIT_MIN, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage("WC0007", NAM_OVER_TIME_UNIT_MIN));
	}
	var unit = (getFormValue(PRM_TXT_OVER_TIME_UNIT_HOUR) * 60) + unitmin;
	if (unit > 24*60 || unit < 0) {
		setBgColor(PRM_TXT_OVER_TIME_UNIT_HOUR, COLOR_FIELD_ERROR);
		setBgColor(PRM_TXT_OVER_TIME_UNIT_MIN, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage("WC0007", NAM_OVER_TIME_UNIT));
	}
	// cƋxe
	var breaktimemin = getFormValue(PRM_TXT_OVER_TIME_INTERVAL_MIN);
	if (breaktimemin > 59) {
		setBgColor(PRM_TXT_OVER_TIME_INTERVAL_MIN, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage("WC0007", NAM_OVER_TIME_INTERVAL_MIN));
	}
	var breakTime = (getFormValue(PRM_TXT_OVER_TIME_INTERVAL_HOUR) * 60) + breaktimemin;
	if (breakTime > 24*60 || breakTime < 0) {
		setBgColor(PRM_TXT_OVER_TIME_INTERVAL_HOUR, COLOR_FIELD_ERROR);
		setBgColor(PRM_TXT_OVER_TIME_INTERVAL_MIN, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage("WC0007", NAM_OVER_TIME_INTERVAL));
	}

	if (aryMessage.length == 0) {
		return true;
	} else {
		showMessage(aryMessage);
		return false;
	}
}

function changeProcessView() {
	setVisibility(PRM_PLT_CALCULATION_PROCESS, true);
	if (getFormValue(PRM_PLT_AUTOMATIC_CALCULATION) == "1") {
		setVisibility(PRM_PLT_CALCULATION_PROCESS, false);
	}
}

function changeHourUnitView() {
	setVisibility('divHourUnit', true);
	if (getFormValue(PRM_PLT_HOUR_HOLIDAY_FUNCTION) == "1") {
		setVisibility('divHourUnit', false);
	}
}

function changeSubstituteFunctionView() {
	changePeriodView();
	changePriorityView();
	changeAmendmentView();
}

function changePeriodView() {
	setVisibility('divPeriod', true);
	if (getFormValue(PRM_PLT_SUBSTITUTE_HOLIDAY) == "1") {
		setVisibility('divPeriod', false);
	}
}
function changePriorityView() {
	setVisibility('divPriority', true);
	if (getFormValue(PRM_PLT_SUBSTITUTE_HOLIDAY) == "1") {
		setVisibility('divPriority', false);
	}
}
function changeAmendmentView() {
/*
	setVisibility('divAmendment', true);
	if (getFormValue(PRM_PLT_SUBSTITUTE_HOLIDAY) == "1") {
		setVisibility('divAmendment', false);
	}
*/
}

function changeSubstituteView() {
	setReadOnly(PRM_PLT_SUBSTITUTE_HOLIDAY, true);
	//setReadOnly(PRM_PLT_SUBSTITUTE_AMENDMENT, true);
	setReadOnly(PRM_PLT_SUBSTITUTE_PERIOD, true);
	setReadOnly(PRM_PLT_SUBSTITUTE_PRIORITY, true);
	if (getFormValue(PRM_PLT_OVER_TIME_60_HOUR) == "0") {
		setReadOnly(PRM_PLT_SUBSTITUTE_HOLIDAY, false);
		//setReadOnly(PRM_PLT_SUBSTITUTE_AMENDMENT, false);
		setReadOnly(PRM_PLT_SUBSTITUTE_PERIOD, false);
		setReadOnly(PRM_PLT_SUBSTITUTE_PRIORITY, false);
	} else if (getFormValue(PRM_PLT_OVER_TIME_60_HOUR) == "1") {
		setFormValue(PRM_PLT_SUBSTITUTE_HOLIDAY, "1");
		changeSubstituteFunctionView();
	}
}
