/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * ʓǍǉ
 * @param 
 * @return 
 * @throws sO
 */
function onLoadExtra() {
	// ڔwiFݒ
	setFieldsBgColor(ARY_FIELDS_ID    , COLOR_FIELD_NORMAL);
	setFieldsBgColor(ARY_ERR_FIELDS_ID, COLOR_FIELD_ERROR );
	// ڒݒ
	setMaxLength(PRM_TXT_OVER_TIME_CODE			, LEN_OVER_TIME_CODE);
	setMaxLength(PRM_TXT_WORK_TYPE_NAME			, LEN_WORK_TYPE_NAME);
	setMaxLength(PRM_TXT_CAUSE					, LEN_WORK_TYPE_NAME);
	setMaxLength(PRM_TXT_OVER_TIME_RATE			, LEN_OVER_TIME_RATE);
	setMaxLength(PRM_TXT_CAUTION_MONTH_HOUR		, LEN_CAUTION_MONTH_HOUR);
	setMaxLength(PRM_TXT_CAUTION_MONTH_MIN		, LEN_CAUTION_MONTH_MIN);
	setMaxLength(PRM_TXT_MONTHLY_OVER_TIME_RATE	, LEN_MONTHLY_OVER_TIME_RATE);
	setMaxLength(PRM_TXT_SUB_ACQUIRE_RATE		, LEN_SUB_ACQUIRE_RATE);
	setMaxLength(PRM_TXT_SUB_ACQUIRE_HOLIDAY_RATE	, LEN_SUB_ACQUIRE_HOLIDAY_RATE);
	setMaxLength(PRM_TXT_SUB_QUIT_RATE			, LEN_SUB_QUIT_RATE);
	
	// o^/XV
	if (MODE == 0) {
		// ǎpݒ
		setReadOnly(PRM_PLT_DELETE_FLAG, true);
		// tH[JXݒ
		setFocus(PRM_TXT_OVER_TIME_CODE);
	} else if (MODE == 1 || MODE == 2) {
		// ǎpݒyуtH[JXݒ(UPDATȄꍇ)
		setReadOnly(PRM_TXT_OVER_TIME_CODE  , true);
		// tH[JXݒ
		setFocus(PRM_TXT_OVER_TIME_CODE);
	}
	// 폜{^AVKo^{^p
	if (MODE == 0) {
		setObjectVisibility("btnNewData", false);	
		setWidth("btnNewData", 0);
	} else if(MODE == 1){
		// ǎpݒ
		setReadOnly(PRM_TXT_OVER_TIME_CODE, true);
		// tH[JXݒ
		setFocus(PRM_TXT_WORK_TYPE_NAME);
	}
}

/**
 * T[o[ʐM
 * @param 
 * @return 
 * @throws sO
 */
function submitForm(objForm) {
	// ̓`FbN
	if (validate()) {
		// T[o[ʐM(̓G[̏ꍇ)
		if (MODE == 0) {
			doSubmitMessage(objForm, 'S2527', 'QC0001', '');
		} else if (MODE == 1) {
			doSubmitMessage(objForm, 'S2528', 'QC0001', '');
		}
	}
}

/**
 * ̓`FbN
 * @param 
 * @return `FbN(trueFOKAfalseFNG)
 * @throws sO
 */
function validate() {
	// tB[hwiFݒ
	setFieldsBgColor(ARY_FIELDS_ID, COLOR_FIELD_NORMAL);
	// ̓`FbN
	var aryMessage = new Array();
	
	checkRequired(PRM_TXT_OVER_TIME_CODE , NAM_OVER_TIME_CODE , aryMessage); 
	checkRequired(PRM_TXT_WORK_TYPE_NAME , NAM_WORK_TYPE_NAME , aryMessage); 
	checkRequired(PRM_TXT_CAUSE , NAM_CAUSE , aryMessage); 
	checkRequired(PRM_TXT_OVER_TIME_RATE , NAM_OVER_TIME_RATE , aryMessage);
	checkRequired(PRM_PLT_LIMIT_CODE , NAM_LIMIT_CODE , aryMessage);
	checkRequired(PRM_TXT_CAUTION_MONTH_HOUR , NAM_CAUTION_MONTH_HOUR , aryMessage);
	checkRequired(PRM_TXT_CAUTION_MONTH_MIN , NAM_CAUTION_MONTH_MIN , aryMessage);	
	checkRequired(PRM_TXT_MONTHLY_OVER_TIME_RATE , NAM_MONTHLY_OVER_TIME_RATE , aryMessage); 
	checkRequired(PRM_TXT_SUB_ACQUIRE_RATE , NAM_SUB_ACQUIRE_RATE , aryMessage); 
	checkRequired(PRM_TXT_SUB_ACQUIRE_HOLIDAY_RATE , NAM_SUB_ACQUIRE_HOLIDAY_RATE , aryMessage); 
	checkRequired(PRM_TXT_SUB_QUIT_RATE , NAM_SUB_QUIT_RATE , aryMessage); 
	
	checkNumber(PRM_TXT_OVER_TIME_RATE , NAM_OVER_TIME_RATE , aryMessage); 
	checkNumber(PRM_TXT_CAUTION_MONTH_HOUR , NAM_CAUTION_MONTH_HOUR , aryMessage);
	checkNumber(PRM_TXT_CAUTION_MONTH_MIN , NAM_CAUTION_MONTH_MIN , aryMessage);
	checkNumber(PRM_TXT_MONTHLY_OVER_TIME_RATE , NAM_MONTHLY_OVER_TIME_RATE , aryMessage); 
	checkNumber(PRM_TXT_SUB_ACQUIRE_RATE , NAM_SUB_ACQUIRE_RATE , aryMessage); 
	checkNumber(PRM_TXT_SUB_ACQUIRE_HOLIDAY_RATE , NAM_SUB_ACQUIRE_HOLIDAY_RATE , aryMessage); 
	checkNumber(PRM_TXT_SUB_QUIT_RATE , NAM_SUB_QUIT_RATE , aryMessage); 

	checkNumberMinValue(PRM_TXT_OVER_TIME_RATE, 125, NAM_OVER_TIME_RATE, aryMessage);
	checkNumberMinValue(PRM_TXT_MONTHLY_OVER_TIME_RATE, 150, NAM_MONTHLY_OVER_TIME_RATE, aryMessage);
	checkNumberMinValue(PRM_TXT_SUB_ACQUIRE_RATE, 125, NAM_SUB_ACQUIRE_RATE, aryMessage);
	checkNumberMinValue(PRM_TXT_SUB_ACQUIRE_HOLIDAY_RATE, 125, NAM_SUB_ACQUIRE_HOLIDAY_RATE, aryMessage);
	checkNumberMinValue(PRM_TXT_SUB_QUIT_RATE, 150, NAM_SUB_QUIT_RATE, aryMessage);

	checkTimeValue(PRM_TXT_CAUTION_MONTH_HOUR ,PRM_TXT_CAUTION_MONTH_MIN , 60 , NAM_CAUTION_MONTH ,aryMessage); 

	checkDate(PRM_PLT_START_DATE_YEAR, PRM_PLT_START_DATE_MONTH, PRM_PLT_START_DATE_DAY, NAM_START_DATE, aryMessage);


	if (aryMessage.length == 0) {
		return true;
	} else {
		showMessage(aryMessage);
		return false;
	}
}

/**
 * ŏlmF
 * @param target		mFΏ
 * @param minValue		ŏl
 * @param rep			ϊ
 * @param aryMessage	G[bZ[Wi[z
 * @return
 */
function checkNumberMinValue(target, minValue, rep, aryMessage) {
	if (checkNumberNoMsg(target)) {
		if (getFormValue(target) < minValue) {
			if (aryMessage.length == 0) {
				setFocus(target);
				setMessage("WC2026", rep + "," + minValue);
			}
			setBgColor(target, COLOR_FIELD_ERROR);
			aryMessage.push(getMessage("WC2026", rep + "," + minValue));
		}
	}
}

/**
 * 10i̐Ԃ
 * @param target Ώە
 */
function parseIntDecimal(target) {
	return parseInt(target, 10);
}
