<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "256kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.workflow.vo.HolidayRequestCardVo"
%><%
HolidayRequestCardVo vo = (HolidayRequestCardVo)request.getAttribute(MospConst.ATT_VO);
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>
<div class="Body" id="holidayRequestList">
	<%= HtmlUtility.getMessages(vo) %>
	<div class="Select">
		<table>
			<tr>
				<td id="tdKCode">
					<%= CommonConst.NAM_K_CODE %><%= CommonConst.STR_TITLE_SEPARATOR %><%= vo.getEscLblKCode() %>
				</td>
				<td id="tdKName">
					<%= CommonConst.NAM_K_NAME %><%= CommonConst.STR_TITLE_SEPARATOR %><%= vo.getEscLblKName() %>
				</td>
				<td id="tdStation">
					<%= CommonConst.NAM_STATION %><%= CommonConst.STR_TITLE_SEPARATOR %><%= vo.getEscLblSectionName() %>
				</td>
			</tr>
		</table>
	</div>
	<div class="Card">
		<table>
			<tr>
				<td class="TitleTd">
					<%= HtmlUtility.getRequiredMark() %><%= vo.NAM_HOLIDAY_DATE %><%=CommonConst.STR_TITLE_SEPARATOR%>
				</td>
				<td >
					<select id="<%= HolidayRequestCardVo.PRM_PLT_HOLIDAY_YEAR%>" name="<%= HolidayRequestCardVo.PRM_PLT_HOLIDAY_YEAR %>">
						<%=HtmlUtility.getSelectOption(vo.aryPltYear , vo.getPltHolidayYear())%>
					</select><%=CommonConst.NAM_YEAR%>
					<select id="<%= HolidayRequestCardVo.PRM_PLT_HOLIDAY_MONTH%>" name="<%= HolidayRequestCardVo.PRM_PLT_HOLIDAY_MONTH %>">
						<%=HtmlUtility.getSelectOption(vo.aryPltMonth , vo.getPltHolidayMonth())%>
					</select><%=CommonConst.NAM_MONTH%>
					<select id="<%= HolidayRequestCardVo.PRM_PLT_HOLIDAY_DAY%>" name="<%= HolidayRequestCardVo.PRM_PLT_HOLIDAY_DAY %>">
						<%=HtmlUtility.getSelectOption(vo.aryPltDay , vo.getPltHolidayDay())%>
					</select><%=CommonConst.NAM_DAY%>
				</td>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= HtmlUtility.getRequiredMark() %><%= vo.NAM_REASON %><%=CommonConst.STR_TITLE_SEPARATOR%>
				</td>
				<td class="InputTd">
					<div id="divReason">
						<select class="ReasonSelect" id="<%= HolidayRequestCardVo.PRM_PLT_REASON %>" name="<%= HolidayRequestCardVo.PRM_PLT_REASON %>" onchange="viewDivType()">
							<%=HtmlUtility.getSelectOption(vo.aryPltReason, vo.getPltReason())%>
						</select>
					</div>
					<div id="divType">
						<select class="ReasonSelect" id="<%= HolidayRequestCardVo.PRM_PLT_TYPE %>" name="<%= HolidayRequestCardVo.PRM_PLT_TYPE %>" onchange="viewDivTime()">
							<%=HtmlUtility.getSelectOption(vo.aryPltType, vo.getPltType())%>
						</select>
					</div>
					<div id="divTime">
						<%= vo.NAM_HOLIDAY_TIME %><%=CommonConst.STR_TITLE_SEPARATOR%>
						<select id="<%= HolidayRequestCardVo.PRM_PLT_START_HOUR %>" name="<%= HolidayRequestCardVo.PRM_PLT_START_HOUR %>" onchange="changeEndTime()">
							<%=HtmlUtility.getSelectOption(vo.aryPltHour, vo.getPltStartHour())%>
						</select><%= CommonConst.NAM_HOUR %>
						<select id="<%= HolidayRequestCardVo.PRM_PLT_START_MIN %>" name="<%= HolidayRequestCardVo.PRM_PLT_START_MIN %>" onchange="changeEndTime()">
							<%=HtmlUtility.getSelectOption(vo.aryPltMin, vo.getPltStartMin())%>
						</select><%= CommonConst.NAM_MINUTES %><%= CommonConst.NAM_COMMON_HTML_SPACE %><%= CommonConst.STR_TERM %><%= CommonConst.NAM_COMMON_HTML_SPACE %>
						<select id="<%= HolidayRequestCardVo.PRM_PLT_END_HOUR %>" name="<%= HolidayRequestCardVo.PRM_PLT_END_HOUR %>">
							<%=HtmlUtility.getSelectOption(vo.aryPltHour, vo.getPltEndHour())%>
						</select><%= CommonConst.NAM_HOUR %>
						<select id="<%= HolidayRequestCardVo.PRM_PLT_END_MIN %>" name="<%= HolidayRequestCardVo.PRM_PLT_END_MIN %>">
							<%=HtmlUtility.getSelectOption(vo.aryPltMin, vo.getPltEndMin())%>
						</select><%= CommonConst.NAM_MINUTES %>
					</div>
				</td>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= vo.NAM_SUBSTITUTE_DATE %><%=CommonConst.STR_TITLE_SEPARATOR%>
				</td>
				<td >
					<select id="<%= HolidayRequestCardVo.PRM_PLT_SUBSTITUTE_YEAR%>" name="<%= HolidayRequestCardVo.PRM_PLT_SUBSTITUTE_YEAR %>">
						<option value=""></option>
						<%=HtmlUtility.getSelectOption(vo.aryPltSubstituteYear , vo.getPltSubstituteYear())%>
					</select><%=CommonConst.NAM_YEAR%>
					<select id="<%= HolidayRequestCardVo.PRM_PLT_SUBSTITUTE_MONTH%>" name="<%= HolidayRequestCardVo.PRM_PLT_SUBSTITUTE_MONTH %>">
						<option value=""></option>
						<%=HtmlUtility.getSelectOption(vo.aryPltSubstituteMonth , vo.getPltSubstituteMonth())%>
					</select><%=CommonConst.NAM_MONTH%>
					<select id="<%= HolidayRequestCardVo.PRM_PLT_SUBSTITUTE_DAY%>" name="<%= HolidayRequestCardVo.PRM_PLT_SUBSTITUTE_DAY %>">
						<option value=""></option>
						<%=HtmlUtility.getSelectOption(vo.aryPltSubstituteDay , vo.getPltSubstituteDay())%>
					</select><%=CommonConst.NAM_DAY%>
				</td>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= vo.NAM_CAUSE_COMMENT %><%=CommonConst.STR_TITLE_SEPARATOR%>
				</td>
				<td >
					<input type="text" id="<%= HolidayRequestCardVo.PRM_TXT_CAUSE_COMMENT %>" name="<%= HolidayRequestCardVo.PRM_TXT_CAUSE_COMMENT %>" value="<%= vo.getEscTxtCauseComment() %>">
				</td>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= vo.NAM_STATUS %><%=CommonConst.STR_TITLE_SEPARATOR%>
				</td>
				<td >
					<%= vo.getEscLblStatus() %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= vo.NAM_APPROVER %><%=CommonConst.STR_TITLE_SEPARATOR%>
				</td>
				<td >
					<%= vo.getEscLblApprover() %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= vo.NAM_AUTHOR_COMMENT %><%=CommonConst.STR_TITLE_SEPARATOR%>
				</td>
				<td >
					<%= vo.getEscLblComment() %>
				</td>
			</tr>
		</table>		
		<input type="hidden" id="<%= HolidayRequestCardVo.PRM_HID_VOUCHER %>" name="<%= HolidayRequestCardVo.PRM_HID_VOUCHER %>" value="<%= vo.getHidVoucher() %>">
	</div>
	<div class="Footer">
		<button id="btnDraft" type="button" class="ExecuteButton" onclick="submitForm(document.form, '<%= CommonConst.CODE_DRAFT %>')"><%= CommonConst.NAME_DRAFT %></button>
		<button id="btnRequest" type="button" class="ExecuteButton" onclick="submitForm(document.form, '')"><%= CommonConst.NAM_APPLICATION %></button>
		<button id="btnCancel" type="button" class="ExecuteButton" onclick="doSubmitMessage(document.form, 'K1429', 'WF0037', '')"><%= CommonConst.NAM_CANCEL %></button>
		<button type="button" class="ExecuteButton" onclick="doSubmit(document.form,'K1422')"><%=CommonConst.NAM_TO_LIST %></button>
	</div>
</div>
<%= HtmlUtility.getFooter(vo) %>
