<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "256kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.system.vo.AccountMasterListVo"
%><%
AccountMasterListVo vo = (AccountMasterListVo)request.getAttribute(MospConst.ATT_VO);
String[] aryUserId    = vo.getEscAryUserId();
String[] aryUserName  = vo.getEscAryUserName();
String[] aryAuthority = vo.getEscAryAuthority();
String[] aryDelete    = vo.getEscAryDelete();
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>
<div class="Body" id="accountMasterList">
	<%= HtmlUtility.getMessages(vo) %>
	<div class="Search">
		<table>
			<tr>
				<td id="tdUserId">
					<span class="TitleLabel"><%= vo.NAM_USER_ID %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<input type="text" class="UserIdText" id="<%= AccountMasterListVo.PRM_TXT_USER_ID %>" name="<%= AccountMasterListVo.PRM_TXT_USER_ID %>" value="<%= vo.getEscTxtUserId() %>" />
				</td>
				<td id="tdUserName">
					<span class="TitleLabel"><%= vo.NAM_USER_NAME %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<input type="text" class="TextBox" id="<%= AccountMasterListVo.PRM_TXT_USER_NAME %>" name="<%= AccountMasterListVo.PRM_TXT_USER_NAME %>" value="<%= vo.getEscTxtUserName() %>" />
				</td>
				<td id="tdAuthority">
					<span><%= vo.NAM_AUTHORITY %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<select class="AuthoritySelect" id="<%= AccountMasterListVo.PRM_PLT_AUTHORITY %>" name="<%= AccountMasterListVo.PRM_PLT_AUTHORITY %>">
						<option value=""></option>
						<%= HtmlUtility.getSelectOption(vo.aryPltAuthority, vo.getPltAuthority()) %>
					</select>
				</td>
				<td id="tdDelete">
					<span><%= vo.NAM_DELETE %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<select class="DeleteFlagSelect" id="<%= AccountMasterListVo.PRM_PLT_DELETE %>" name="<%= AccountMasterListVo.PRM_PLT_DELETE %>">
						<option value=""></option>
						<%= HtmlUtility.getDeleteFlagSelectOption(vo.getPltDelete()) %>
					</select>
				</td>
				<td class="ButtonTd">
					<button type="button" onclick="submitForm(document.form, 'S2401')"><%= CommonConst.NAM_SEARCH %></button>
				</td>
			</tr>
		</table>
	</div>
	<%= HtmlUtility.getListInfo(vo) %>
	<div class="List">
		<table id="list">
			<thead>
				<tr>
					<th id="thButton"></th>
					<th id="thUserId" onclick="doSubmitKey(document.form, 'S2403', '<%= vo.KEY_USER_ID %>', '')">&nbsp;<%= vo.NAM_USER_ID %>&nbsp;<%= vo.getSortMark(vo.KEY_USER_ID) %></th>
					<th id="thUserName" onclick="doSubmitKey(document.form, 'S2403', '<%= vo.KEY_USER_NAME %>', '')">&nbsp;<%= vo.NAM_USER_NAME %>&nbsp;<%= vo.getSortMark(vo.KEY_USER_NAME) %></th>
					<th id="thAuthority" onclick="doSubmitKey(document.form, 'S2403', '<%= vo.KEY_AUTHORITY %>', '')">&nbsp;<%= vo.NAM_AUTHORITY %>&nbsp;<%= vo.getSortMark(vo.KEY_AUTHORITY) %></th>
					<th id="thDelete" onclick="doSubmitKey(document.form, 'S2403', '<%= vo.KEY_DELETE %>', '')">&nbsp;<%= vo.NAM_DELETE %>&nbsp;<%= vo.getSortMark(vo.KEY_DELETE) %></th>
					<th id="thPassword"></th>
				</tr>
			</thead>
			<tbody>
<%
for (int i = vo.getStart(); i <= vo.getEnd(); i++) {
%>
				<tr>
					<td class="ButtonTd">
						<button type="button" onclick="doSubmitKey(document.form, 'S2406', '<%= aryUserId[i] %>', '')"><%= CommonConst.NAM_SELECT %></button>
					</td>
					<td><%= aryUserId[i] %></td>
					<td><%= aryUserName[i] %></td>
					<td><%= aryAuthority[i] %></td>
					<td id="tdDelete"><%= aryDelete[i] %></td>
					<td class="ButtonTd">
						<button type="button" class="PasswordButton" onclick="doSubmitMessageKey(document.form, 'S2404', 'QU0004', '<%= aryUserName[i] %>', '<%= aryUserId[i] %>', '')"><%= CommonConst.NAM_INIT_PASSWORD %></button>
					</td>
				</tr>
<%
}
%>
			</tbody>
		</table>
	</div>
	<div class="ButtonDiv">
		<button type="button" class="MenuButton" onclick="doSubmit(document.form, 'S2910')"><%= CommonConst.NAM_TO_MENU %></button>	
		<button type="button" id="btnToCard" class="MenuButton" onclick="doSubmit(document.form, 'S2410')"><%= CommonConst.TTL_FIRST_HUMAN_ACCOUNT_MASTER %></button>	
	</div>
</div>
<%= HtmlUtility.getFooter(vo) %>
