<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "256kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.payroll.system.vo.DetailListVo"
%><%
DetailListVo vo  = (DetailListVo)request.getAttribute(MospConst.ATT_VO);
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>
<div class="Body">
	<%= HtmlUtility.getMessages(vo) %>
	<div class="Search">
		<table id="tabCondition">
			<tr>
				<td>
					<span class="TitleLabel"><%= vo.getName("P_DETAIL") + vo.getName("P_TYPE") + vo.getName("C_SEPARATOR") %></span>
					<select id="<%= DetailListVo.PRM_PLT_TYPE %>" name="<%= DetailListVo.PRM_PLT_TYPE %>">
						<%= HtmlUtility.getSelectOption(vo.getPitType(), vo.getPltType()) %>
					</select>
				</td>
				<td id="tdAbbr">
					<span class="TitleLabel"><%= vo.getName("P_DETAIL") + vo.getName("P_ABBREVIATE") + vo.getName("C_SEPARATOR") %></span>
					<input type="text" class="TextBox" id="<%= DetailListVo.PRM_TXT_ABBR %>" name="<%= DetailListVo.PRM_TXT_ABBR %>" value="<%= vo.getEscTxtAbbr() %>" />
				</td>
				<td>
					<span class="TitleLabel"><%= vo.getName("P_DELETE_FLAG") + vo.getName("C_SEPARATOR") %></span>
					<select id="<%= DetailListVo.PRM_PLT_DELETE %>" name="<%= DetailListVo.PRM_PLT_DELETE %>">
						<option value=""></option>
						<%= HtmlUtility.getDeleteFlagSelectOption(vo.getPltDelete()) %>
					</select>
				</td>
				<td class="ButtonTd">
					<button type="button" onclick="submitForm(document.form, 'P7011')"><%= vo.getName("C_SEARCH") %></button>
				</td>
			</tr>
		</table>
	</div>
	<%= HtmlUtility.getListInfoFlex(vo) %>
	<div class="List">
		<table id="tabList">
			<thead>
				<tr>
					<th class="ButtonTh"></th>
					<th id="thType"                                                         >&nbsp;<%= vo.getName("P_DETAIL") + vo.getName("P_TYPE"      ) %>&nbsp;                          </th>
					<th id="thCode"   onclick="doSubmitKey(document.form, 'P7013', '1', '')">&nbsp;<%= vo.getName("P_DETAIL") + vo.getName("C_CODE"      ) %>&nbsp;<%= vo.getSortMark("1") %></th>
					<th id="thName"   onclick="doSubmitKey(document.form, 'P7013', '2', '')">&nbsp;<%= vo.getName("P_DETAIL") + vo.getName("C_NAME"      ) %>&nbsp;<%= vo.getSortMark("2") %></th>
					<th id="thAbbr"   onclick="doSubmitKey(document.form, 'P7013', '3', '')">&nbsp;<%= vo.getName("P_DETAIL") + vo.getName("P_ABBREVIATE") %>&nbsp;<%= vo.getSortMark("3") %></th>
					<th id="thDelete" onclick="doSubmitKey(document.form, 'P7013', '4', '')">&nbsp;<%= vo.getName("P_DELETE_FLAG")                         %>&nbsp;<%= vo.getSortMark("4") %></th>
				</tr>
			</thead>
			<tbody>
<%
for (int i = 0; i < vo.getCount(); i++) {
%>
				<tr>
					<td class="ButtonTd">
						<button type="button" onclick="doSubmitKey(document.form, 'P7016', '<%= vo.getPltType() %>', '<%= vo.getAryCode(i) %>')">
							<%= vo.getName("C_SELECT") %>
						</button>
					</td>
					<td class="CenterTd"><%= vo.getAryType  (i) %></td>
					<td class="CenterTd"><%= vo.getAryCode  (i) %></td>
					<td                 ><%= vo.getAryName  (i) %></td>
					<td                 ><%= vo.getAryAbbr  (i) %></td>
					<td class="CenterTd"><%= vo.getAryDelete(i) %></td>
				</tr>
<%
}
%>
			</tbody>
		</table>
	</div>
</div>
<%= HtmlUtility.getFooter(vo) %>
