<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "16kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.mospcommon.system.vo.LaborAgreementCardVo"
%><%
LaborAgreementCardVo vo = (LaborAgreementCardVo)request.getAttribute(MospConst.ATT_VO);
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>
<div class="Body" id="agreementCard">
	<%= HtmlUtility.getMessages(vo) %>
	<div class="Card">
		<table>
			<tr>
				<td class="TitleTd"><%= vo.NAM_OFFICE %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td>
					<select id="<%= LaborAgreementCardVo.PRM_PLT_J_CODE %>" name="<%= LaborAgreementCardVo.PRM_PLT_J_CODE %>" onchange="doSubmit(document.form, 'S2519')">
						<%= HtmlUtility.getSelectOption(vo.aryPltJCode, vo.getPltJCode()) %>
					</select>
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= vo.NAM_STATION %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td>
					<select id="<%= LaborAgreementCardVo.PRM_PLT_S_CODE %>" name="<%= LaborAgreementCardVo.PRM_PLT_S_CODE %>" onchange="doSubmit(document.form, 'S2519')">
						<%= HtmlUtility.getSelectOption(vo.aryPltSCode, vo.getPltSCode()) %>
					</select>
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= HtmlUtility.getRequiredMark() %><%= vo.NAM_K_NAME %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td>
					<select id="<%= LaborAgreementCardVo.PRM_PLT_AGREE_CODE %>" name="<%= LaborAgreementCardVo.PRM_PLT_AGREE_CODE %>" multiple="multiple">
						<%=HtmlUtility.getSelectOption(vo.aryPltKCode, vo.getPltAgreeCode())%>
					</select>
					<input type="hidden" id="<%= LaborAgreementCardVo.PRM_HID_AGREE_TYPE %>" name="<%= LaborAgreementCardVo.PRM_HID_AGREE_TYPE %>" value="<%= vo.getEscHidAgreeType() %>" />
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= HtmlUtility.getRequiredMark() %><%= vo.NAM_OVER_TIME_CODE %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td>
					<select id="<%= LaborAgreementCardVo.PRM_PLT_OVER_TIME_CODE %>" name="<%= LaborAgreementCardVo.PRM_PLT_OVER_TIME_CODE %>">
						<%= HtmlUtility.getSelectOption(vo.aryPltOverTimeCode, vo.getPltOverTimeCode()) %>
					</select>
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= HtmlUtility.getRequiredMark() %><%= vo.NAM_WORK_ON_CODE %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td>
					<select id="<%= LaborAgreementCardVo.PRM_PLT_WORK_ON_CODE %>" name="<%= LaborAgreementCardVo.PRM_PLT_WORK_ON_CODE %>">
						<%= HtmlUtility.getSelectOption(vo.aryPltWorkOnCode, vo.getPltWorkOnCode()) %>
					</select>
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= HtmlUtility.getRequiredMark() %><%= vo.NAM_DELETE %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td>
					<select class="DeleteFlagSelect" id="<%= LaborAgreementCardVo.PRM_PLT_DELETE %>" name="<%= LaborAgreementCardVo.PRM_PLT_DELETE %>">
						<%= HtmlUtility.getDeleteFlagSelectOption(vo.getPltDelete()) %>
					</select>
				</td>
			</tr>
		</table>
	</div>
</div>
<div class="Footer">
	<button type="button" class="ExecuteButton" onclick="submitForm(document.form)"><%= CommonConst.NAM_REGIST %></button>
	<button type="button" class="ExecuteButton" onclick="doSubmit(document.form, 'S2512')"><%= CommonConst.NAM_TO_LIST %></button>
	<button type="button" class="ExecuteButton" id="btnNewData" onclick="doSubmit(document.form, 'S2515')"><%= CommonConst.NAM_MAKE_NEW_DATA %></button>
</div>
<%= HtmlUtility.getFooter(vo) %>
