/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.vo;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.kintai.common.part.KintaiCommonPart;
import jp.mosp.kintai.common.vo.MosPWorkFlowVo;
import jp.mosp.kintai.dto.MSyukkinboDto;

/**
 * @author yoshida
 *
 */
public class DayApprovalCardVo extends MosPWorkFlowVo {
	
	private static final long	serialVersionUID	= -1300635498515065334L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		MODE_SELECT			= 0;
	/**
	 * 
	 */
	public static final int		MODE_APPROVED		= 1;
	/**
	 * 
	 */
	public static final int		MODE_VIEW			= 2;
	
	// tB[h
	private String				lblDate;
	private String				lblStartQuitTime;
	private String				lblWorkType;
	private String				lblHalfHoliday;
	private String				lblWorkOnHoliday;
	private String				lblLateTime;
	private String				lblLateReason;
	private String				lblLateCertificate;
	private String				lblLateComment;
	private String				lblWorkTime;
	private String				lblBreakTime;
	private String				lblActualTime;
	private String				lblLeaveEarlyReason;
	private String				lblLeaveEarlyTime;
	private String				lblLeaveEarlyCertificate;
	private String				lblLeaveEarlyComment;
	private String				lblOverTime;
	private String				lblWorkOnHolidayTime;
	private String				lblLateNightTime;
	private String				lblSyokuji;
	private String				lblCyoku1;
	private String				lblCyoku2;
	private String				lblCyoku3;
	private String				lblHoka1;
	private String				lblHoka2;
	private String				lblHoka3;
	private String				lblHoka4;
	private String				lblHoka5;
	private String				lblStatus;
	private String				lblOverTimeRequest;
	private String[]			aryLblHolidayRequest;
	
	// ҏW[h(0F\A1FF)
	private int					mode;
	
	private boolean				isCaution;
	private boolean				isWarning;
	
	// 蓖
	private String[][]			aryAllowance;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_START_TIME;
	/**
	 * 
	 */
	public String				NAM_WORKING_TYPE;
	/**
	 * 
	 */
	public String				NAM_HALF_HOLIDAY;
	/**
	 * 
	 */
	public String				NAM_WORK_ON_HOLIDAY;
	/**
	 * 
	 */
	public String				NAM_LATE_TIME;
	/**
	 * 
	 */
	public String				NAM_LATE_REASON;
	/**
	 * 
	 */
	public String				NAM_LATE_CERTIFICATE;
	/**
	 * 
	 */
	public String				NAM_LATE_COMMENT;
	/**
	 * 
	 */
	public String				NAM_QUIT_TIME;
	/**
	 * 
	 */
	public String				NAM_WORKING_TIME;
	/**
	 * 
	 */
	public String				NAM_INTERVAL_TIME;
	/**
	 * 
	 */
	public String				NAM_ACTUAL_WORK_TIME;
	/**
	 * 
	 */
	public String				NAM_LEAVE_EARLY_REASON;
	/**
	 * 
	 */
	public String				NAM_LEAVE_EARLY_TIME;
	/**
	 * 
	 */
	public String				NAM_LEAVE_EARLY_CERTIFICATE;
	/**
	 * 
	 */
	public String				NAM_LEAVE_EARLY_COMMENT;
	/**
	 * 
	 */
	public String				NAM_OVER_TIME;
	/**
	 * 
	 */
	public String				NAM_WORK_ON_HOLIDAY_TIME;
	/**
	 * 
	 */
	public String				NAM_LATE_NIGHT;
	/**
	 * 
	 */
	public String				NAM_ALLOWANCE;
	/**
	 * 
	 */
	public String				NAM_STATUS;
	/**
	 * 
	 */
	public String				NAM_COMMENT;
	/**
	 * 
	 */
	public String				NAM_OVER_TIME_REQUEST;
	/**
	 * 
	 */
	public String				NAM_HOLIDAY_REQUEST;
	

	/**
	 * RXgN^
	 */
	public DayApprovalCardVo() {
		super();
		setViewPath(getClassName());
		mode = MODE_SELECT;
		aryAllowance = new String[0][0];
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.NAM_DAILY_APPROVAL + CommonConst.NAM_APPROVED;
		aryMenu = new String[][]{ { CMD_MENU_MAMAGE, CommonConst.NAM_TO_MENU }, MosPMenuConst.getMenuManagerApproval(), };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_START_TIME = CommonConst.NAM_START_TIME + CommonConst.NAM_TIME;
		NAM_WORKING_TYPE = CommonConst.NAM_WORKING_TYPE;
		NAM_HALF_HOLIDAY = CommonConst.NAM_VACATION_LEAVE_HALF + CommonConst.NAM_COMMON_TYPE;
		NAM_WORK_ON_HOLIDAY = CommonConst.NAM_WORK_ON_HOLIDAY + CommonConst.NAM_COMMON_TYPE;
		NAM_LATE_TIME = CommonConst.NAM_ARRIVE_LATE + CommonConst.NAM_COMMON_TIME;
		NAM_LATE_REASON = CommonConst.NAM_ARRIVE_LATE + CommonConst.NAM_REASON;
		NAM_LATE_CERTIFICATE = CommonConst.NAM_CERTIFICATE;
		NAM_LATE_COMMENT = CommonConst.NAM_COMMENT;
		NAM_QUIT_TIME = CommonConst.NAM_QUIT_TIME + CommonConst.NAM_TIME;
		NAM_WORKING_TIME = CommonConst.NAM_WORKING + CommonConst.NAM_COMMON_TIME;
		NAM_INTERVAL_TIME = CommonConst.NAM_INTERVAL_TIME + CommonConst.NAM_COMMON_TIME;
		NAM_ACTUAL_WORK_TIME = CommonConst.NAM_ACTUAL_WORK_TIME + CommonConst.NAM_COMMON_TIME;
		NAM_LEAVE_EARLY_REASON = CommonConst.NAM_LEAVE_EARLY + CommonConst.NAM_REASON;
		NAM_LEAVE_EARLY_TIME = CommonConst.NAM_LEAVE_EARLY + CommonConst.NAM_COMMON_TIME;
		NAM_LEAVE_EARLY_CERTIFICATE = CommonConst.NAM_CERTIFICATE;
		NAM_LEAVE_EARLY_COMMENT = CommonConst.NAM_COMMENT;
		NAM_OVER_TIME = CommonConst.NAM_OVERTIME + CommonConst.NAM_COMMON_TIME;
		NAM_WORK_ON_HOLIDAY_TIME = CommonConst.NAM_WORK_ON_HOLIDAY + CommonConst.NAM_COMMON_TIME;
		NAM_LATE_NIGHT = CommonConst.NAM_LATE_NIGHT + CommonConst.NAM_COMMON_TIME;
		NAM_ALLOWANCE = CommonConst.NAM_ALLOWANCE;
		NAM_STATUS = CommonConst.NAM_APPROVAL_STATE;
		NAM_COMMENT = CommonConst.NAM_APPROVED + CommonConst.NAM_COMMENT;
		NAM_OVER_TIME_REQUEST = CommonConst.NAM_OVER_TIME_REQUEST;
		NAM_HOLIDAY_REQUEST = CommonConst.NAM_HOLIDAY_REQUEST;
		super.setFieldsName();
	}
	
	/**
	 * tB[hݒ
	 * @param dto	ΏDTO
	 */
	public void setFields(MSyukkinboDto dto) {
		lblDate = DateUtil.convDateToFormatDateJP(DateUtil.convStringDateToDate(dto.getHizuke()));
		int startTime = KintaiCommonPart.getWorkStartTime(dto);
		int quitTime = KintaiCommonPart.getWorkQuitTime(dto);
		if (quitTime - startTime != 0) {
			StringBuffer sb = new StringBuffer();
			sb.append(TimeUtil.convIntegerTimeToStringTime(startTime));
			sb.append(CommonConst.STR_TERM);
			sb.append(TimeUtil.convIntegerTimeToStringTime(quitTime));
			lblStartQuitTime = sb.toString();
		}
		lblWorkType = dto.getKinmu();
		lblWorkOnHoliday = dto.getKyusyuKb();
		lblLateTime = "";
		if (dto.getTiJikan() > 0) {
			lblLateTime = TimeUtil.convIntegerTimeToJPHours(dto.getTiJikan());
		}
		lblLateReason = dto.getTiRiyuu();
		lblLateCertificate = dto.getTiSyoumei();
		lblLateComment = dto.getTiComent();
		lblWorkTime = "";
		if (dto.getKinmuJi() > 0) {
			lblWorkTime = TimeUtil.convIntegerTimeToJPHours(dto.getKinmuJi());
		}
		lblBreakTime = "";
		if (dto.getKyukeiJi() > 0) {
			lblBreakTime = TimeUtil.convIntegerTimeToJPHours(dto.getKyukeiJi());
		}
		lblLeaveEarlyTime = "";
		if (dto.getSoJikan() > 0) {
			lblLeaveEarlyTime = TimeUtil.convIntegerTimeToJPHours(dto.getSoJikan());
		}
		lblLeaveEarlyReason = dto.getSoRiyuu();
		lblLeaveEarlyCertificate = dto.getSoSyoumei();
		lblLeaveEarlyComment = dto.getSoComent();
		lblOverTime = "";
		if (dto.getZaJikan() > 0) {
			lblOverTime = TimeUtil.convIntegerTimeToJPHours(dto.getZaJikan());
		}
		lblWorkOnHolidayTime = "";
		if (dto.getKsJikan() > 0) {
			lblWorkOnHolidayTime = TimeUtil.convIntegerTimeToJPHours(dto.getKsJikan());
		}
		lblLateNightTime = "";
		if (dto.getSnJikan() > 0) {
			lblLateNightTime = TimeUtil.convIntegerTimeToJPHours(dto.getSnJikan());
		}
		lblSyokuji = "";
		if (dto.getSyokuji() > 0) {
			lblSyokuji = String.valueOf(dto.getSyokuji());
		}
		lblCyoku1 = "";
		if (dto.getCyoku1() > 0) {
			lblCyoku1 = String.valueOf(dto.getCyoku1());
		}
		lblCyoku2 = "";
		if (dto.getCyoku2() > 0) {
			lblCyoku2 = String.valueOf(dto.getCyoku2());
		}
		lblCyoku3 = "";
		if (dto.getCyoku3() > 0) {
			lblCyoku3 = String.valueOf(dto.getCyoku3());
		}
		lblHoka1 = "";
		if (dto.getHoka1() > 0) {
			lblHoka1 = String.valueOf(dto.getHoka1());
		}
		lblHoka2 = "";
		if (dto.getHoka2() > 0) {
			lblHoka2 = String.valueOf(dto.getHoka2());
		}
		lblHoka3 = "";
		if (dto.getHoka3() > 0) {
			lblHoka3 = String.valueOf(dto.getHoka3());
		}
		lblHoka4 = "";
		if (dto.getHoka4() > 0) {
			lblHoka4 = String.valueOf(dto.getHoka4());
		}
		lblHoka5 = "";
		if (dto.getHoka5() > 0) {
			lblHoka5 = String.valueOf(dto.getHoka5());
		}
		// Ԃ̃Zbg
		int actual = 0;
		if (dto.getKinmuJi() != 0) {
			//  = Ζ - xeԁicƋxeԊ܂ށj
			actual = dto.getKinmuJi() - dto.getKyukeiJi();
		}
		lblActualTime = "";
		if (actual > 0) {
			lblActualTime = TimeUtil.convIntegerTimeToJPHours(actual);
		}
		lblHalfHoliday = "";
		// x敪
		if (KintaiCommonPart.isStartHalfHoliday(dto)) {
			lblHalfHoliday = CommonConst.NAM_SHORT_START_ATTENDANCE;
			lblHalfHoliday += CommonConst.NAM_VACATION_LEAVE_HALF;
		}
		if (KintaiCommonPart.isQuitHalfHoliday(dto)) {
			lblHalfHoliday += CommonConst.NAM_SHORT_QUIT_ATTENDANCE;
			lblHalfHoliday += CommonConst.NAM_VACATION_LEAVE_HALF;
		}
		setTxtComment(dto.getSnComent());
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException	MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// 񒷊mF
		checkLength(getTxtComment(), LEN_COMMENT, NAM_COMMENT, PRM_TXT_COMMENT);
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		sb.append("var CAUTION = ");
		sb.append(isCaution);
		sb.append(";");
		sb.append("var WARNING = ");
		sb.append(isWarning);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	/**
	 * @return aryAllowance
	 */
	public String[][] getAryAllowance() {
		return aryAllowance.clone();
	}
	
	public String getEscLblDate() {
		return escapeHTML(lblDate);
	}
	
	public String getEscLblStartQuitTime() {
		return escapeHTML(lblStartQuitTime);
	}
	
	public String getEscLblWorkType() {
		return escapeHTML(lblWorkType);
	}
	
	public String getEscLblHalfHoliday() {
		return escapeHTML(lblHalfHoliday);
	}
	
	public String getEscLblWorkOnHoliday() {
		return escapeHTML(lblWorkOnHoliday);
	}
	
	public String getEscLblLateTime() {
		return escapeHTML(lblLateTime);
	}
	
	public String getEscLblLateReason() {
		return escapeHTML(lblLateReason);
	}
	
	public String getEscLblLateCertificate() {
		return escapeHTML(lblLateCertificate);
	}
	
	public String getEscLblLateComment() {
		return escapeHTML(lblLateComment);
	}
	
	public String getEscLblWorkTime() {
		return escapeHTML(lblWorkTime);
	}
	
	public String getEscLblBreakTime() {
		return escapeHTML(lblBreakTime);
	}
	
	public String getEscLblLeaveEarlyReason() {
		return escapeHTML(lblLeaveEarlyReason);
	}
	
	public String getEscLblLeaveEarlyTime() {
		return escapeHTML(lblLeaveEarlyTime);
	}
	
	public String getEscLblLeaveEarlyCertificate() {
		return escapeHTML(lblLeaveEarlyCertificate);
	}
	
	public String getEscLblLeaveEarlyComment() {
		return escapeHTML(lblLeaveEarlyComment);
	}
	
	public String getEscLblOverTime() {
		return escapeHTML(lblOverTime);
	}
	
	public String getEscLblWorkOnHolidayTime() {
		return escapeHTML(lblWorkOnHolidayTime);
	}
	
	public String getEscLblLateNightTime() {
		return escapeHTML(lblLateNightTime);
	}
	
	public String getEscLblSyokuji() {
		return escapeHTML(lblSyokuji);
	}
	
	public String getEscLblCyoku1() {
		return escapeHTML(lblCyoku1);
	}
	
	public String getEscLblCyoku2() {
		return escapeHTML(lblCyoku2);
	}
	
	public String getEscLblCyoku3() {
		return escapeHTML(lblCyoku3);
	}
	
	public String getEscLblHoka1() {
		return escapeHTML(lblHoka1);
	}
	
	public String getEscLblHoka2() {
		return escapeHTML(lblHoka2);
	}
	
	public String getEscLblHoka3() {
		return escapeHTML(lblHoka3);
	}
	
	public String getEscLblHoka4() {
		return escapeHTML(lblHoka4);
	}
	
	public String getEscLblHoka5() {
		return escapeHTML(lblHoka5);
	}
	
	public String getEscLblActualTime() {
		return escapeHTML(lblActualTime);
	}
	
	public String getEscLblStatus() {
		return escapeHTML(lblStatus);
	}
	
	public String getEscLblOverTimeRequest() {
		return escapeHTML(lblOverTimeRequest);
	}
	
	public void setLblStatus(String lblStatus) {
		this.lblStatus = lblStatus;
	}
	
	public void setLblOverTimeRequest(String lblOverTimeRequest) {
		this.lblOverTimeRequest = lblOverTimeRequest;
	}
	
	/**
	 * @param mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
	/**
	 * @return aryLblHolidayRequest
	 */
	public String[] getAryLblHolidayRequest() {
		return aryLblHolidayRequest.clone();
	}
	
	/**
	 * @param aryLblHolidayRequest Zbg aryLblHolidayRequest
	 */
	public void setAryLblHolidayRequest(String[] aryLblHolidayRequest) {
		this.aryLblHolidayRequest = aryLblHolidayRequest.clone();
	}
	
	/**
	 * @param aryAllowance Zbg aryAllowance
	 */
	public void setAryAllowance(String[][] aryAllowance) {
		this.aryAllowance = aryAllowance.clone();
	}
	
	/**
	 * @return isCaution
	 */
	public boolean isCaution() {
		return isCaution;
	}
	
	/**
	 * @return isWarning
	 */
	public boolean isWarning() {
		return isWarning;
	}
	
	/**
	 * @param isCaution Zbg isCaution
	 */
	public void setCaution(boolean isCaution) {
		this.isCaution = isCaution;
	}
	
	/**
	 * @param isWarning Zbg isWarning
	 */
	public void setWarning(boolean isWarning) {
		this.isWarning = isWarning;
	}
	
}
