/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.workflow.dto.AmRouteDto;

/**
 * @author yoshida
 *
 */
public class ApprovalRouteListVo extends MosPVo {
	
	private static final long	serialVersionUID	= 3750607946754966177L;
	
	//萔
	/**
	 * 
	 */
	public static final int		SEARCH_OFF			= 0;
	/**
	 * 
	 */
	public static final int		SEARCH_ON			= 1;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_TXT_K_CODE		= "txtKCode";
	/**
	 * 
	 */
	public static final String	PRM_TXT_K_NAME		= "txtKName";
	/**
	 * 
	 */
	public static final String	PRM_TXT_UNIT_CODE	= "txtUnitCode";
	/**
	 * 
	 */
	public static final String	PRM_TXT_ROUTE_CODE	= "txtRouteCode";
	
	// tB[h
	/**
	 * 
	 */
	private String[][]			aryRoute;
	
	// v_E
	/**
	 * 
	 */
	public String[][]			aryPltUnit;
	
	private String				txtKCode;
	private String				txtKName;
	private String				txtUnitCode;
	private String				txtRouteCode;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_K_CODE;
	/**
	 * 
	 */
	public String				NAM_K_NAME;
	/**
	 * 
	 */
	public String				NAM_UNIT_CODE;
	/**
	 * 
	 */
	public String				NAM_ROUTE_CODE;
	/**
	 * 
	 */
	public String				NAM_CODE;
	/**
	 * 
	 */
	public String				NAM_LAYER1;
	/**
	 * 
	 */
	public String				NAM_LAYER2;
	/**
	 * 
	 */
	public String				NAM_LAYER3;
	/**
	 * 
	 */
	public String				NAM_LAYER4;
	/**
	 * 
	 */
	public String				NAM_LAYER5;
	/**
	 * 
	 */
	public String				NAM_LAST_LAYER;
	/**
	 * 
	 */
	public int					LEN_CODE;
	/**
	 * 
	 */
	public int					LEN_NAME;
	
	// \[gL[
	/**
	 * 
	 */
	public final String			KEY_ROUTE_CODE		= "keyUnitCode";
	
	// [h(0FȂA1F)
	private int					searchmode;
	

	/**
	 * RXgN^
	 */
	public ApprovalRouteListVo() {
		super();
		setViewPath(getClassName());
		txtKCode = "";
		txtKName = "";
		txtUnitCode = "";
		txtRouteCode = "";
		aryRoute = new String[0][0];
		setFormerKey(KEY_ROUTE_CODE);
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_APPROVAL_ROUTE;
		createAryMenu(CMD_MENU_SYSTEM2, MosPMenuConst.getMenuApproval());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_K_CODE = CommonConst.NAM_K_CODE;
		NAM_K_NAME = CommonConst.NAM_K_NAME;
		NAM_UNIT_CODE = CommonConst.NAM_APPROVAL_UNIT + CommonConst.NAM_COMMON_CODE;
		NAM_ROUTE_CODE = CommonConst.NAM_APPROVAL_ROUTE + CommonConst.NAM_COMMON_CODE;
		NAM_CODE = CommonConst.NAM_COMMON_CODE;
		NAM_LAYER1 = CommonConst.NAM_1ST_APPROVED;
		NAM_LAYER2 = CommonConst.NAM_2ND_APPROVED;
		NAM_LAYER3 = CommonConst.NAM_3RD_APPROVED;
		NAM_LAYER4 = CommonConst.NAM_4TH_APPROVED;
		NAM_LAYER5 = CommonConst.NAM_5TH_APPROVED;
		NAM_LAST_LAYER = CommonConst.NAM_LAST_APPROVED;
		LEN_CODE = CommonConst.LEN_K_CODE;
		LEN_NAME = CommonConst.LEN_K_NAME;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtKCode = request.getParameter(PRM_TXT_K_CODE);
		txtKName = request.getParameter(PRM_TXT_K_NAME);
		txtUnitCode = request.getParameter(PRM_TXT_UNIT_CODE);
		txtRouteCode = request.getParameter(PRM_TXT_ROUTE_CODE);
	}
	
	@Override
	public void setFields(List<?> listRoute) {
		// Xg̐ݒ
		list = listRoute;
		// f[^̎擾
		count = listRoute.size();
		// z̏
		aryRoute = new String[count][7];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = listRoute.iterator();
		while (it.hasNext()) {
			AmRouteDto dto = (AmRouteDto)it.next();
			aryRoute[i][0] = escapeHTML(dto.getRtCode());
			aryRoute[i][1] = escapeHTML(getCodeName(dto.getLayer1(), aryPltUnit));
			aryRoute[i][2] = escapeHTML(getCodeName(dto.getLayer2(), aryPltUnit));
			aryRoute[i][3] = escapeHTML(getCodeName(dto.getLayer3(), aryPltUnit));
			aryRoute[i][4] = escapeHTML(getCodeName(dto.getLayer4(), aryPltUnit));
			aryRoute[i][5] = escapeHTML(getCodeName(dto.getLayer5(), aryPltUnit));
			aryRoute[i][6] = escapeHTML(getCodeName(dto.getLastLayer(), aryPltUnit));
			i++;
		}
	}
	
	// ANZT\bh
	/**
	 * @return txtKCode
	 */
	public String getEscTxtKCode() {
		return escapeHTML(txtKCode);
	}
	
	/**
	 * @return txtKName
	 */
	public String getEscTxtKName() {
		return escapeHTML(txtKName);
	}
	
	/**
	 * @return txtUnitCode
	 */
	public String getEscTxtUnitCode() {
		return escapeHTML(txtUnitCode);
	}
	
	/**
	 * @return txtRouteCode
	 */
	public String getEscTxtRouteCode() {
		return escapeHTML(txtRouteCode);
	}
	
	/**
	 * @return txtKCode
	 */
	public String getTxtKCode() {
		return txtKCode;
	}
	
	/**
	 * @return txtKName
	 */
	public String getTxtKName() {
		return txtKName;
	}
	
	/**
	 * @return txtUnitCode
	 */
	public String getTxtUnitCode() {
		return txtUnitCode;
	}
	
	/**
	 * @return txtRouteCode
	 */
	public String getTxtRouteCode() {
		return txtRouteCode;
	}
	
	/**
	 * @return searchmode
	 */
	public int getSearchmode() {
		return searchmode;
	}
	
	/**
	 * @param txtKCode Zbg txtKCode
	 */
	public void setTxtKCode(String txtKCode) {
		this.txtKCode = txtKCode;
	}
	
	/**
	 * @param txtKName Zbg txtKName
	 */
	public void setTxtKName(String txtKName) {
		this.txtKName = txtKName;
	}
	
	/**
	 * @param txtUnitCode Zbg txtUnitCode
	 */
	public void setTxtUnitCode(String txtUnitCode) {
		this.txtUnitCode = txtUnitCode;
	}
	
	/**
	 * @param txtRouteCode Zbg txtRouteCode
	 */
	public void setTxtRouteCode(String txtRouteCode) {
		this.txtRouteCode = txtRouteCode;
	}
	
	/**
	 * @param searchmode Zbg searchmode
	 */
	public void setSearchmode(int searchmode) {
		this.searchmode = searchmode;
	}
	
	/**
	 * @return aryRoute
	 */
	public String[][] getAryRoute() {
		return aryRoute.clone();
	}
	
}
