/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.dto;

import jp.mosp.common.common.BaseDto;

/**
 * @author yoshida
 *
 */
public class PmAttendanceDto extends BaseDto {
	
	private static final long	serialVersionUID	= 7016023998379009398L;
	
	// tB[h
	private int					routeid				= 0;					// [gID
	private String				scode				= "";					// R[h
	private String				kcode				= "";					// ЈR[h
	private String				rtcode				= "";					// [gR[h
	private String				jcode				= "";					// ƏR[h
	private int					deleteflag			= 0;					// 폜tO
																			
	
	/**
	 * RXgN^
	 */
	public PmAttendanceDto() {
		super();
	}
	
	// ANZT\bh
	/**
	 * @return routeid 	[gIDB
	 */
	public int getRouteId() {
		return routeid;
	}
	
	/**
	 * @return scode 	R[hB
	 */
	public String getSCode() {
		return scode;
	}
	
	/**
	 * @return kcode 	ЈR[hB
	 */
	public String getKCode() {
		return kcode;
	}
	
	/**
	 * @return rtcode 	[gR[hB
	 */
	public String getRtCode() {
		return rtcode;
	}
	
	/**
	 * @return jcode 	ƏR[hB
	 */
	public String getJCode() {
		return jcode;
	}
	
	/**
	 * @return deleteflag 	폜tOB
	 */
	public int getDeleteFlag() {
		return deleteflag;
	}
	
	/**
	 * @param routeid 	Zbg郋[gIDB
	 */
	public void setRouteId(int routeid) {
		this.routeid = routeid;
	}
	
	/**
	 * @param scode 	Zbg鏊R[hB
	 */
	public void setSCode(String scode) {
		this.scode = scode;
	}
	
	/**
	 * @param kcode 	ZbgЈR[hB
	 */
	public void setKCode(String kcode) {
		this.kcode = kcode;
	}
	
	/**
	 * @param rtcode 	Zbg郋[gR[hB
	 */
	public void setRtCode(String rtcode) {
		this.rtcode = rtcode;
	}
	
	/**
	 * @param jcode 	Zbg鎖ƏR[hB
	 */
	public void setJCode(String jcode) {
		this.jcode = jcode;
	}
	
	/**
	 * @param deleteflag 	Zbg폜tOB
	 */
	public void setDeleteFlag(int deleteflag) {
		this.deleteflag = deleteflag;
	}
	
}
