/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.dto;

import java.util.Date;

import jp.mosp.common.common.BaseDto;

/**
 * @author yoshida
 *
 */
public class KintaiAppicationDto extends BaseDto {
	
	private static final long	serialVersionUID	= -312985074765082028L;
	
	private String				kCode				= "";
	private String				cmd					= "";
	private String				key					= "";
	private String				simei				= "";
	private String				sName				= "";
	private Date				date				= null;
	private String				apprication			= "";
	private String				status				= "";
	private String				remarks				= "";
	private String				ckbValue			= "";
	

	/**
	 * RXgN^
	 */
	public KintaiAppicationDto() {
		super();
	}
	
	/**
	 * @return kCode
	 */
	public String getKCode() {
		return kCode;
	}
	
	/**
	 * @return cmd
	 */
	public String getCmd() {
		return cmd;
	}
	
	/**
	 * @return key
	 */
	public String getKey() {
		return key;
	}
	
	/**
	 * @return simei
	 */
	public String getSimei() {
		return simei;
	}
	
	/**
	 * @return sName
	 */
	public String getSName() {
		return sName;
	}
	
	/**
	 * @return date
	 */
	public Date getDate() {
		return (Date)date.clone();
	}
	
	/**
	 * @return apprication
	 */
	public String getApprication() {
		return apprication;
	}
	
	/**
	 * @return status
	 */
	public String getStatus() {
		return status;
	}
	
	/**
	 * @return remarks
	 */
	public String getRemarks() {
		return remarks;
	}
	
	/**
	 * @return ckbValue
	 */
	public String getCkbValue() {
		return ckbValue;
	}
	
	/**
	 * @param kCode Zbg kCode
	 */
	public void setKCode(String kCode) {
		this.kCode = kCode;
	}
	
	/**
	 * @param cmd Zbg cmd
	 */
	public void setCmd(String cmd) {
		this.cmd = cmd;
	}
	
	/**
	 * @param key Zbg key
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * @param simei Zbg simei
	 */
	public void setSimei(String simei) {
		this.simei = simei;
	}
	
	/**
	 * @param sName Zbg sName
	 */
	public void setSName(String sName) {
		this.sName = sName;
	}
	
	/**
	 * @param date Zbg date
	 */
	public void setDate(Date date) {
		this.date = (Date)date.clone();
	}
	
	/**
	 * @param apprication Zbg apprication
	 */
	public void setApprication(String apprication) {
		this.apprication = apprication;
	}
	
	/**
	 * @param status Zbg status
	 */
	public void setStatus(String status) {
		this.status = status;
	}
	
	/**
	 * @param remarks Zbg remarks
	 */
	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}
	
	/**
	 * @param ckbValue Zbg ckbValue
	 */
	public void setCkbValue(String ckbValue) {
		this.ckbValue = ckbValue;
	}
	
}
