/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.NumberUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.MosPWorkflowAction;
import jp.mosp.kintai.common.dto.MKihonDto;
import jp.mosp.kintai.common.part.KintaiApprovalPart;
import jp.mosp.kintai.common.part.KintaiCommonPart;
import jp.mosp.kintai.dto.MSyukkinboDto;
import jp.mosp.workflow.dto.CtOvertimeRequestDto;
import jp.mosp.workflow.dto.KintaiAppicationDto;
import jp.mosp.workflow.dto.KtHolidayRequestDto;
import jp.mosp.workflow.vo.ManagerApprovalListVo;

/**
 * @author yoshida
 *
 */
public class ManagerApprovalListAction extends MosPWorkflowAction {
	
	// R}h
	private static final String	CMD_LIST_SHOW		= "K2130";
	private static final String	CMD_LIST_SEARCH		= "K2131";
	private static final String	CMD_LIST_RE_SEARCH	= "K2132";
	private static final String	CMD_LIST_SORT		= "K2133";
	private static final String	CMD_LIST_APPROVAL	= "K2134";
	
	// tB[h
	/**
	 * \pXg
	 */
	List<KintaiAppicationDto>	listApplication;
	

	/**
	 * RXgN^
	 */
	public ManagerApprovalListAction() {
		super();
	}
	
	public void action() throws Exception {
		// VȌ
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_LIST_SHOW)) {
			show();
		} else if (cmd.equals(CMD_LIST_SEARCH)) {
			search();
		} else if (cmd.equals(CMD_LIST_RE_SEARCH)) {
			// Č
			research();
		} else if (cmd.equals(CMD_LIST_SORT)) {
			// \[g
			sortList(key1);
		} else if (cmd.equals(CMD_LIST_APPROVAL)) {
			// ꊇF
			runApprovalProcess();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new ManagerApprovalListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// [U̐ݒ
		getInfo(user.getUserId());
		// v_E̐ݒ
		ManagerApprovalListVo vo = (ManagerApprovalListVo)getVo();
		vo.aryPltSection = StringUtil.addArrayFirstRowSpace(getSectionArrayAll());
		vo.aryPltApplication = StringUtil.addArrayFirstRowSpace(getApplicationArray());
		vo.aryPltStatus = StringUtil.addArrayFirstRowSpace(part().kintaiApproval().getApprovalReasonArray());
		vo.aryPltYear = StringUtil.getYearArray(MospUtility.getYear(DateUtil.getSystemDate()));
		vo.aryPltMonth = StringUtil.getMonthArray();
		vo.aryPltDay = StringUtil.getDayArray();
	}
	
	@Override
	protected void show() throws Exception {
		ManagerApprovalListVo vo = (ManagerApprovalListVo)getVo();
		Date todayDate = DateUtil.getSystemDate();
		vo.setPltYear(String.valueOf(MospUtility.getYear(todayDate)));
		vo.setPltMonth(String.valueOf(MospUtility.getMonth(todayDate)));
		vo.setPltDay(String.valueOf(MospUtility.getDay(todayDate)));
		vo.setPltSection(userBasis.getSCode());
	}
	
	@Override
	protected void search() throws Exception {
		ManagerApprovalListVo vo = (ManagerApprovalListVo)getVo();
		vo.setParams(request);
		// ɂꗗ擾
		searchApplicationList();
		vo.setFormerKey(vo.KEY_K_CODE);
		vo.setIsAscending(true);
		vo.initListInfo();
		vo.setSearchmode(ManagerApprovalListVo.SEARCH_ON);
	}
	
	@Override
	protected void research() throws Exception {
		ManagerApprovalListVo vo = (ManagerApprovalListVo)getVo();
		if (vo.getSearchmode() == ManagerApprovalListVo.SEARCH_ON) {
			removeSessionDto();
			searchApplicationList();
			vo.setPageButton();
			sortList();
		}
	}
	
	/**
	 * ɂꗗݒ
	 * @throws Exception  Oꍇ
	 */
	private void searchApplicationList() throws Exception {
		ManagerApprovalListVo vo = (ManagerApprovalListVo)getVo();
		// Xg̏
		listApplication = new ArrayList<KintaiAppicationDto>();
		// JnN
		Date startDate;
		// IN
		Date endDate;
		if (vo.getPltDay().length() != 0) {
			startDate = DateUtil.getDate(vo.getPltYear(), vo.getPltMonth(), vo.getPltDay());
			endDate = startDate;
		} else {
			startDate = DateUtil.getFirstDateOfMonth(vo.getPltYear(), vo.getPltMonth());
			endDate = DateUtil.getLastDateOfMonth(vo.getPltYear(), vo.getPltMonth());
		}
		// FΏێЈꗗXg
		List<MKihonDto> mKihonList = getApprovalEmployeeList(startDate);
		for (MKihonDto dto : mKihonList) {
			if ((StringUtil.isNotNull(vo.getPltSection()) && !vo.getPltSection().equals(dto.getSCode()))
					|| (StringUtil.isNotNull(vo.getTxtKCode()) && !dto.getKCode().startsWith(vo.getTxtKCode()))
					|| (StringUtil.isNotNull(vo.getTxtKName()) && !dto.getSimei().matches(
							".*" + vo.getTxtKName() + ".*"))) {
				continue;
			}
			if (StringUtil.isNull(vo.getPltApplication()) || vo.getPltApplication().equals(getApplicationArray()[0][0])) {
				// Αӏǉ
				addSyukkinboInfoToList(dto, startDate, endDate, vo.getPltStatus());
			}
			if (StringUtil.isNull(vo.getPltApplication()) || vo.getPltApplication().equals(getApplicationArray()[1][0])) {
				// cƐ\ǉ
				addOverTimeRequestToList(dto, startDate, endDate, vo.getPltStatus());
			}
			if (StringUtil.isNull(vo.getPltApplication()) || vo.getPltApplication().equals(getApplicationArray()[2][0])) {
				// xɐ\ǉ
				addHolidayRequestToList(dto, startDate, endDate, vo.getPltStatus());
			}
		}
		// ЈR[hŃ\[gB
		VariousUtil.sortList(listApplication, new CompKCode());
		// VOɃZbg
		vo.setFields(listApplication);
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryApplication().length == 0) {
			vo.addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	/**
	 * Αӏǉ
	 * @param mKihonDto		ΏێЈDTO
	 * @param startDate		JnN
	 * @param endDate		IN
	 * @param snriyuu		ΏۏF
	 * @throws Exception 	Oꍇ
	 */
	private void addSyukkinboInfoToList(MKihonDto mKihonDto, Date startDate, Date endDate, String snriyuu)
			throws Exception {
		// ΏۊԓΑӈꗗ擾
		List<MSyukkinboDto> listSyukkinbo = syukkinboDao().findForApprovalList(mKihonDto.getKCode(),
				DateUtil.convDateFormatted(startDate), DateUtil.convDateFormatted(endDate), snriyuu);
		for (Object element : listSyukkinbo) {
			MSyukkinboDto dto = (MSyukkinboDto)element;
			if (!KintaiApprovalPart.isDraft(dto)) {
				KintaiAppicationDto appicationDto = new KintaiAppicationDto();
				// R}h
				appicationDto.setCmd(DayApprovalCardAction.CMD_CARD_SELECT);
				// L[
				appicationDto.setKey(dto.getHizuke());
				// ЈR[h
				appicationDto.setKCode(dto.getKCode());
				// Ј
				appicationDto.setSimei(mKihonDto.getSimei());
				// 
				appicationDto.setSName(getSectionName(mKihonDto.getSCode()));
				// t
				appicationDto.setDate(DateUtil.convStringDateToDate(dto.getHizuke()));
				// \
				appicationDto.setApprication(CommonConst.NAM_DAILY_APPROVAL);
				// F
				appicationDto.setStatus(part().kintaiApproval().getApprovalName(dto));
				// l
				StringBuffer remarks = new StringBuffer();
				// Ζ`
				remarks.append(part().worktype().getWorkTypeName(dto.getKinmu()));
				remarks.append(CommonConst.NAM_COMMON_HALF_KANA_SPACE);
				// xE
				if (dto.getTiJikan() > 0 || dto.getSoJikan() > 0) {
					remarks.append(CommonConst.NAM_LATE_AND_LEAVE_EARLY);
					remarks.append(CommonConst.NAM_COMMON_HALF_KANA_SPACE);
				}
				// x
				if (KintaiCommonPart.isHoliday(dto)) {
					remarks.append(part().mospcode().getHolidayName(dto.getKKRiyuu()));
					remarks.append(CommonConst.NAM_COMMON_HALF_KANA_SPACE);
				}
				// x
				if (KintaiCommonPart.isHalfHoliday(dto)) {
					remarks.append(CommonConst.NAM_VACATION_LEAVE_HALF);
					remarks.append(CommonConst.NAM_COMMON_HALF_KANA_SPACE);
				}
				// ԊOx(x)
				if (KintaiCommonPart.isOverTimeSubHolidayHalf(dto)) {
					remarks.append(CommonConst.NAM_SUB_HOLIDAY_HALF);
					remarks.append(CommonConst.NAM_COMMON_HALF_KANA_SPACE);
				}
				appicationDto.setRemarks(remarks.toString());
				// `FbN{bNX
				// FҊmF
				if (part().kintaiApproval().isApprover(dto.getKCode(), userBasis.getKCode(), dto.getSnRiyuu(),
						DateUtil.convStringDateToDate(dto.getHizuke()))) {
					StringBuffer sb = new StringBuffer();
					// \F
					sb.append(CommonConst.CODE_DAILY_APPROVAL);
					sb.append(CommonConst.STR_UNDER_SEPARATOR);
					// ЈR[hAt
					sb.append(dto.getKCode());
					sb.append(CommonConst.STR_UNDER_SEPARATOR);
					sb.append(dto.getHizuke());
					appicationDto.setCkbValue(sb.toString());
				}
				listApplication.add(appicationDto);
			}
		}
	}
	
	/**
	 * cƐ\ǉ
	 * @param mKihonDto		ΏێЈDTO
	 * @param startDate		JnN
	 * @param endDate		IN
	 * @param snriyuu		ΏۏF
	 * @throws Exception 	Oꍇ
	 */
	private void addOverTimeRequestToList(MKihonDto mKihonDto, Date startDate, Date endDate, String snriyuu)
			throws Exception {
		// [Nt[F󋵃R[h
		String[] aryStatus = KintaiApprovalPart.toWorkflowStatusArray(snriyuu);
		List<CtOvertimeRequestDto> listOverTime = overTimeDao().findForCondition(mKihonDto.getKCode(), startDate,
				endDate, NumberUtil.getIntParam(aryStatus[0]), aryStatus[1]);
		for (Object element : listOverTime) {
			CtOvertimeRequestDto dto = (CtOvertimeRequestDto)element;
			// ȊO
			if (!isStatusDraft(dto.getWorkflow())) {
				KintaiAppicationDto appicationDto = new KintaiAppicationDto();
				// R}h
				appicationDto.setCmd(OverTimeApprovalCardAction.CMD_CARD_SELECT);
				// L[
				appicationDto.setKey(String.valueOf(dto.getVoucher()));
				// ЈR[h
				appicationDto.setKCode(dto.getKCode());
				// Ј
				appicationDto.setSimei(mKihonDto.getSimei());
				// 
				appicationDto.setSName(getSectionName(mKihonDto.getSCode()));
				// t
				appicationDto.setDate(dto.getWorkDate());
				// \
				appicationDto.setApprication(CommonConst.NAM_OVER_TIME_REQUEST);
				String statusCode = toKintaiApprovalStatus(dto.getWorkflow());
				// F
				appicationDto.setStatus(getApprovalName(statusCode));
				// l
				StringBuffer remarks = new StringBuffer();
				remarks.append(TimeUtil.convIntegerTimeToJPHours(dto.getOverTime()));
				appicationDto.setRemarks(remarks.toString());
				// `FbN{bNX
				// FҊmF
				if (part().kintaiApproval().isApprover(dto.getKCode(), userBasis.getKCode(), statusCode,
						dto.getWorkDate())) {
					StringBuffer sb = new StringBuffer();
					// \F
					sb.append(CommonConst.CODE_OVER_TIME_REQUEST);
					sb.append(CommonConst.STR_UNDER_SEPARATOR);
					// \`[ԍ
					sb.append(dto.getVoucher());
					appicationDto.setCkbValue(sb.toString());
				}
				listApplication.add(appicationDto);
			}
		}
	}
	
	/**
	 * xɐ\ǉ
	 * @param mKihonDto		ΏێЈDTO
	 * @param startDate		JnN
	 * @param endDate		IN
	 * @param snriyuu		ΏۏF
	 * @throws Exception 	Oꍇ
	 */
	private void addHolidayRequestToList(MKihonDto mKihonDto, Date startDate, Date endDate, String snriyuu)
			throws Exception {
		// [Nt[F󋵃R[h
		String[] aryStatus = KintaiApprovalPart.toWorkflowStatusArray(snriyuu);
		List<KtHolidayRequestDto> listHoliday = holidayDao().findForCondition(mKihonDto.getKCode(), startDate, endDate,
				NumberUtil.getIntParam(aryStatus[0]), aryStatus[1]);
		for (Object element : listHoliday) {
			KtHolidayRequestDto dto = (KtHolidayRequestDto)element;
			// ȊO
			if (!isStatusDraft(dto.getWorkflow())) {
				KintaiAppicationDto appicationDto = new KintaiAppicationDto();
				// R}h
				appicationDto.setCmd(HolidayApprovalCardAction.CMD_CARD_SELECT);
				// L[
				appicationDto.setKey(String.valueOf(dto.getVoucher()));
				// ЈR[h
				appicationDto.setKCode(dto.getKCode());
				// Ј
				appicationDto.setSimei(mKihonDto.getSimei());
				// 
				appicationDto.setSName(getSectionName(mKihonDto.getSCode()));
				// t
				appicationDto.setDate(dto.getHolidayDate());
				// \
				appicationDto.setApprication(CommonConst.NAM_HOLIDAY_REQUEST);
				String statusCode = toKintaiApprovalStatus(dto.getWorkflow());
				// F
				appicationDto.setStatus(getApprovalName(statusCode));
				// l
				StringBuffer remarks = new StringBuffer();
				// xɗR
				remarks.append(part().holidayRequest().getReasonNameWithType(dto, false));
				appicationDto.setRemarks(remarks.toString());
				// `FbN{bNX
				// FҊmF
				if (part().kintaiApproval().isApprover(dto.getKCode(), userBasis.getKCode(), statusCode,
						dto.getHolidayDate())) {
					StringBuffer sb = new StringBuffer();
					// \F
					sb.append(CommonConst.CODE_HOLIDAY_REQUEST);
					sb.append(CommonConst.STR_UNDER_SEPARATOR);
					// \`[ԍ
					sb.append(dto.getVoucher());
					appicationDto.setCkbValue(sb.toString());
				}
				listApplication.add(appicationDto);
			}
		}
	}
	
	/**
	 * ꊇF
	 * @throws Exception 	Oꍇ
	 */
	private void runApprovalProcess() throws Exception {
		ManagerApprovalListVo vo = (ManagerApprovalListVo)getVo();
		String[] arySelectValue = request.getParameterValues(ManagerApprovalListVo.PRM_CKB_APPROVAL);
		Set<Boolean> hashSet = new HashSet<Boolean>();
		int count = 0;
		for (String selectValue : arySelectValue) {
			String[] aryCondition = selectValue.split(CommonConst.STR_UNDER_SEPARATOR);
			String requestType = aryCondition[0];
			String conditionValue = aryCondition[1];
			// R~bgtO
			boolean canCommit = false;
			if (CommonConst.CODE_DAILY_APPROVAL.equals(requestType)) {
				// ΑӏF
				canCommit = runDailyApprovalProcess(conditionValue, DateUtil.convStringDateToDate(aryCondition[2]), "",
						true);
			}
			if (CommonConst.CODE_OVER_TIME_REQUEST.equals(requestType)) {
				// cƐ\F
				canCommit = runOverTimeRequestApproved(getOverTimeRequest(Integer.parseInt(conditionValue)));
			}
			if (CommonConst.CODE_HOLIDAY_REQUEST.equals(requestType)) {
				// xɐ\F
				canCommit = runHolidayRequestApproved(part().holidayRequest().getHolidayRequest(
						Integer.parseInt(conditionValue)));
			}
			// F
			if (canCommit) {
				count++;
			}
			hashSet.add(canCommit);
		}
		// G[΃R~bgB
		if (!hashSet.contains(false)) {
			// R~bg
			commit();
			// bZ[W
			StringBuffer sb = new StringBuffer();
			sb.append(count);
			sb.append(CommonConst.NAM_COMMON_COUNT);
			sb.append(CommonConst.NAM_APPROVED);
			setMessage(getMessage(CommonConst.MSG_DONE, sb.toString()));
			// Č
			searchApplicationList();
			vo.setPageButton();
			sortList();
		}
	}
	
	@Override
	protected void sortList(String key) throws MospException {
		ManagerApprovalListVo vo = (ManagerApprovalListVo)getVo();
		vo.sortList(key, getComparator(key));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected void sortList() throws MospException {
		ManagerApprovalListVo vo = (ManagerApprovalListVo)getVo();
		vo.sortList(getComparator(vo.getFormerKey()));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		ManagerApprovalListVo vo = (ManagerApprovalListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_K_CODE)) {
			comp = new CompKCode();
		} else if (key.equals(vo.KEY_K_NAME)) {
			comp = new CompKName();
		} else if (key.equals(vo.KEY_SECTION)) {
			comp = new CompSection();
		} else if (key.equals(vo.KEY_DATE)) {
			comp = new CompDate();
		} else if (key.equals(vo.KEY_APPLICATION)) {
			comp = new CompApplication();
		} else if (key.equals(vo.KEY_STATUS)) {
			comp = new CompStatus();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * ЈR[hɂrNX
	 */
	protected static class CompKCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -6587672856397520392L;
		

		public int compare(Object obj1, Object obj2) {
			KintaiAppicationDto dto1 = (KintaiAppicationDto)obj1;
			KintaiAppicationDto dto2 = (KintaiAppicationDto)obj2;
			return dto1.getKCode().compareTo(dto2.getKCode());
		}
	}
	
	/**
	 * ЈɂrNX
	 */
	protected static class CompKName implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 6321920436763711779L;
		

		public int compare(Object obj1, Object obj2) {
			KintaiAppicationDto dto1 = (KintaiAppicationDto)obj1;
			KintaiAppicationDto dto2 = (KintaiAppicationDto)obj2;
			return dto1.getSimei().compareTo(dto2.getSimei());
		}
	}
	
	/**
	 * ɂrNX
	 */
	protected static class CompSection implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -6522555390412324071L;
		

		public int compare(Object obj1, Object obj2) {
			KintaiAppicationDto dto1 = (KintaiAppicationDto)obj1;
			KintaiAppicationDto dto2 = (KintaiAppicationDto)obj2;
			return dto1.getSName().compareTo(dto2.getSName());
		}
	}
	
	/**
	 * tɂrNX
	 */
	protected static class CompDate implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -2059568153842913234L;
		

		public int compare(Object obj1, Object obj2) {
			KintaiAppicationDto dto1 = (KintaiAppicationDto)obj1;
			KintaiAppicationDto dto2 = (KintaiAppicationDto)obj2;
			return dto1.getDate().compareTo(dto2.getDate());
		}
	}
	
	/**
	 * \ނɂrNX
	 */
	protected static class CompApplication implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -2395226905215857602L;
		

		public int compare(Object obj1, Object obj2) {
			KintaiAppicationDto dto1 = (KintaiAppicationDto)obj1;
			KintaiAppicationDto dto2 = (KintaiAppicationDto)obj2;
			return dto1.getApprication().compareTo(dto2.getApprication());
		}
	}
	
	/**
	 * F󋵂ɂrNX
	 */
	protected static class CompStatus implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -8920699379965954199L;
		

		public int compare(Object obj1, Object obj2) {
			KintaiAppicationDto dto1 = (KintaiAppicationDto)obj1;
			KintaiAppicationDto dto2 = (KintaiAppicationDto)obj2;
			return dto1.getStatus().compareTo(dto2.getStatus());
		}
	}
	
}
