/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.NumberUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.action.MosPWorkflowAction;
import jp.mosp.kintai.common.dto.CtWorkflowDto;
import jp.mosp.kintai.common.part.KintaiApprovalPart;
import jp.mosp.kintai.common.part.WorkflowPart;
import jp.mosp.workflow.dto.KtHolidayRequestDto;
import jp.mosp.workflow.vo.HolidayRequestCardVo;
import jp.mosp.workflow.vo.OverTimeRequestCardVo;

/**
 * @author yoshida
 *
 */
public class HolidayRequestCardAction extends MosPWorkflowAction {
	
	// R}h
	private static final String	CMD_CARD_SHOW	= "K1425";
	private static final String	CMD_CARD_SELECT	= "K1426";
	private static final String	CMD_CARD_INSERT	= "K1427";
	private static final String	CMD_CARD_UPDATE	= "K1428";
	private static final String	CMD_CARD_CANCEL	= "K1429";
	

	/**
	 * RXgN^
	 */
	public HolidayRequestCardAction() {
		super();
	}
	
	public void action() throws Exception {
		// VȌ
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_CARD_SHOW)) {
			show();
		} else if (cmd.equals(CMD_CARD_SELECT)) {
			// \(L[ŏ)
			select();
		} else if (cmd.equals(CMD_CARD_INSERT)) {
			// VKo^
			insert();
		} else if (cmd.equals(CMD_CARD_UPDATE)) {
			// XV
			update();
		} else if (cmd.equals(CMD_CARD_CANCEL)) {
			// 艺
			cancel();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new HolidayRequestCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		HolidayRequestCardVo vo = (HolidayRequestCardVo)getVo();
		// [U̎擾
		getInfo(user.getUserId());
		// [U̕\
		setLabelBasisInfo(userBasis);
		// v_ẼZbg
		vo.aryPltYear = StringUtil.getYearArray(MospUtility.getYear(DateUtil.getSystemDate()));
		vo.aryPltMonth = StringUtil.getMonthArray();
		vo.aryPltDay = StringUtil.getDayArray();
		vo.aryPltHour = StringUtil.getCountArray(0, 24, 1);
		// ͒PʎԐݒ
		setInputUnit();
		final int end = 59;
		vo.aryPltMin = StringUtil.getCountArray(0, end, inputUnit);
		vo.aryPltReason = part().mospcode().getHolidayReasonArray();
		vo.aryPltSubstituteYear = StringUtil.getYearArray(MospUtility.getYear(DateUtil.getSystemDate()));
		vo.aryPltSubstituteMonth = StringUtil.getMonthArray();
		vo.aryPltSubstituteDay = StringUtil.getDayArray();
		// ԒPʔNxΉ
		vo.aryPltType = part().holidayRequest().getHolidayRequestTypeArray();
		vo.setParams(request);
		// Lx@\
		vo.setUseHourHoliday(part().mospcode().useHourPaidHolidayFunction());
		// Pʎ
		vo.setHourUnit(part().mospcode().getHourPaidHolidayUnit());
		// x@\
		vo.setUseSubstitute(part().mospcode().useSubstituteHolidayFunction());
	}
	
	@Override
	protected void show() throws Exception {
		HolidayRequestCardVo vo = (HolidayRequestCardVo)getVo();
		// l̐ݒ
		vo.setDefaultValues();
		Date todayDate = DateUtil.getSystemDate();
		vo.setPltHolidayYear(String.valueOf(MospUtility.getYear(todayDate)));
		vo.setPltHolidayMonth(String.valueOf(MospUtility.getMonth(todayDate)));
		vo.setPltHolidayDay(String.valueOf(MospUtility.getDay(todayDate)));
		// [hݒ
		vo.setMode(HolidayRequestCardVo.MODE_INSERT);
	}
	
	@Override
	protected void select() throws Exception {
		HolidayRequestCardVo vo = (HolidayRequestCardVo)getVo();
		// f[^̎擾
		KtHolidayRequestDto dto = holidayDao().findForKey(Integer.valueOf(key1));
		chkExist(dto);
		// VOɏZbg
		vo.setFields(dto);
		setApprovalStatus(dto);
		setSessionDto(dto);
	}
	
	@Override
	protected void insert() throws Exception {
		HolidayRequestCardVo vo = (HolidayRequestCardVo)getVo();
		vo.setParams(request);
		vo.validate();
		// DTȌ
		KtHolidayRequestDto dto = new KtHolidayRequestDto();
		vo.setDtoFields(dto);
		dto.setKCode(userBasis.getKCode());
		// xɐ\̃`FbN
		if (checkHolidayRequest(dto)) {
			// e[ubN
			prepareTableLock();
			// Ώۃe[uǉ
			addTargetTable(holidayDao(), true);
			// [Nt[o^
			long workflow = requestRegist(userBasis.getKCode(), WorkflowPart.isDraft(key1));
			if (workflow != 0) {
				dto.setWorkflow(workflow);
				int voucher = 0;
				String maxVaoucher = holidayDao().findForMax();
				if (StringUtil.isNotNull(maxVaoucher)) {
					voucher = NumberUtil.getIntParam(maxVaoucher);
					holidayDao().findForUpdate(voucher);
					voucher++;
				}
				dto.setVoucher(voucher);
				holidayDao().insert(dto);
				// DTO̍Ď擾
				dto = holidayDao().findForKey(dto.getVoucher());
				chkInsert(dto);
				// R~bg
				commit();
				vo.setHidVoucher(String.valueOf(dto.getVoucher()));
				// bZ[Wݒ
				setMessage(getMessage(CommonConst.MSG_CODE_REQUEST_INSERT, ""));
			} else {
				StringBuffer sb = new StringBuffer();
				sb.append(DateUtil.convDateToFormatDateJP(dto.getHolidayDate()));
				sb.append(CommonConst.MSG_OF);
				sb.append(CommonConst.NAM_HOLIDAY_REQUEST);
				// G[bZ[Wݒ
				addErrMessage(getMessage(CommonConst.MSG_CODE_SELECT_CANNOT_INSERT, sb.toString()));
			}
			// e[ubN
			unLockTables();
		}
		// DTO̕\
		vo.setFields(dto);
		// F󋵂̐ݒ
		setApprovalStatus(dto);
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	@Override
	protected void update() throws Exception {
		// DTO̎擾
		KtHolidayRequestDto dto = (KtHolidayRequestDto)getSessionDto();
		HolidayRequestCardVo vo = (HolidayRequestCardVo)getVo();
		vo.setPltHolidayYear(String.valueOf(MospUtility.getYear(dto.getHolidayDate())));
		vo.setPltHolidayMonth(String.valueOf(MospUtility.getMonth(dto.getHolidayDate())));
		vo.setPltHolidayDay(String.valueOf(MospUtility.getDay(dto.getHolidayDate())));
		// p[^[̑ÓmF
		vo.validate();
		// DTȌ
		vo.setDtoFields(dto);
		dto.setKCode(userBasis.getKCode());
		// rmF
		chkExclusive(dto, holidayDao().findForUpdate(dto.getVoucher()));
		// XV
		holidayDao().update(dto);
		// XVmF
		chkUpdate(holidayDao().findForKey(dto.getVoucher()));
		boolean canCommit = true;
		// ̏ꍇ
		if (WorkflowPart.isDraft(key1)) {
			canCommit = true;
		} else {
			// [Nt[擾
			CtWorkflowDto workflowDto = getWorkflowDto(dto.getWorkflow());
			// F󋵂̕ύX
			workflowDto.setCurrentStatus(WorkflowPart.getStatusCodeArray()[0]);
			// ΑӏFR[h
			String statusCode = toKintaiApprovalStatus(dto.getWorkflow());
			// ߁\̏ꍇ
			if (KintaiApprovalPart.is1stReturned(statusCode) || KintaiApprovalPart.is2ndReturned(statusCode)) {
				// \ֈڍs
				workflowDto.setLayerNumber(CommonConst.NUM_REQUEST_LAYER);
			}
			// [Nt[̍XV
			canCommit = workflowUpdate(workflowDto);
		}
		if (canCommit) {
			// R~bg
			commit();
			// bZ[Wݒ
			setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		}
		// DTO̍Ď擾
		KtHolidayRequestDto retDto = holidayDao().findForKey(dto.getVoucher());
		chkExist(retDto);
		// F󋵂̐ݒ
		setApprovalStatus(retDto);
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
	/**
	 * 艺
	 * @throws Exception	Oꍇ
	 */
	private void cancel() throws Exception {
		// DTO̎擾
		KtHolidayRequestDto dto = (KtHolidayRequestDto)getSessionDto();
		// Fς݂̏ꍇA艺s
		if (!isStatusApproved(dto.getWorkflow())) {
			// _폜
			dto.setDeleteFlag(MospConst.DELETE_FLAG_ON);
			holidayDao().update(dto);
			// [Nt[
			CtWorkflowDto workflowDto = getWorkflowDto(dto.getWorkflow());
			// _폜
			workflowDto.setDeleteFlag(MospConst.DELETE_FLAG_ON);
			workflowUpdate(workflowDto);
			// R~bg
			commit();
			// ꗗ֑J
			setNextCmd(HolidayRequestListAction.CMD_LIST_RE_SEARCH);
			// bZ[WZbg
			setMessage(getMessage(CommonConst.MSG_CODE_REQUEST_WITHDRAW, ""));
		} else {
			// G[bZ[W
			addAlreadyApprovedMessage(dto.getKCode(), dto.getHolidayDate(), CommonConst.NAM_HOLIDAY_REQUEST);
		}
	}
	
	/**
	 * F󋵏̐ݒ
	 * @param dto			ΏDTO
	 * @throws Exception	Oꍇ
	 */
	private void setApprovalStatus(KtHolidayRequestDto dto) throws Exception {
		HolidayRequestCardVo vo = (HolidayRequestCardVo)getVo();
		// ΑӏFXe[^XR[h
		String statusCode = toKintaiApprovalStatus(dto.getWorkflow());
		vo.setLblStatus(getApprovalName(statusCode));
		if (isStatusDraft(dto.getWorkflow())) {
			// 
			vo.setMode(OverTimeRequestCardVo.MODE_UPDATE);
		} else if (KintaiApprovalPart.isRequest(statusCode)) {
			// \
			vo.setMode(OverTimeRequestCardVo.MODE_REQUEST);
		} else if (KintaiApprovalPart.is1stApproved(statusCode)) {
			// ꎟF
			vo.setLblApprover(getKName(getWorkflowDto(dto.getWorkflow()).getUpdateUser()));
			vo.setMode(OverTimeRequestCardVo.MODE_APPROVED);
		} else if (KintaiApprovalPart.is1stReturned(statusCode)) {
			// ꎟ
			vo.setLblApprover(getKName(getWorkflowDto(dto.getWorkflow()).getUpdateUser()));
			// ŐVRg̎擾
			vo.setLblComment(getCurrentWorkflowComment(userBasis.getKCode(), dto.getWorkflow()));
			vo.setMode(OverTimeRequestCardVo.MODE_RETURNED);
		} else if (KintaiApprovalPart.is2ndApproved(statusCode)) {
			// 񎟏F
			vo.setLblApprover(getKName(getWorkflowDto(dto.getWorkflow()).getUpdateUser()));
			vo.setMode(OverTimeRequestCardVo.MODE_APPROVED);
		} else if (KintaiApprovalPart.is2ndReturned(statusCode)) {
			// 񎟍
			vo.setLblApprover(getKName(getWorkflowDto(dto.getWorkflow()).getUpdateUser()));
			// ŐVRg̎擾
			vo.setLblComment(getCurrentWorkflowComment(userBasis.getKCode(), dto.getWorkflow()));
			vo.setMode(OverTimeRequestCardVo.MODE_RETURNED);
		}
	}
	
}
