/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.kintai.common.dto.MKaisyaDto;

/**
 * @author yoshida
 *
 */
public class KaisyaMasterListVo extends MosPVo {
	
	private static final long	serialVersionUID	= -912308350054852945L;
	
	// 萔
	public static final int		SEARCH_OFF			= 0;
	public static final int		SEARCH_ON			= 1;
	
	// p[^
	public static final String	PRM_TXT_JCODE		= "txtJCode";
	public static final String	PRM_TXT_KAIMEI		= "txtKaiMei";
	
	// tB[h
	private String[]			aryJCode;
	private String[]			aryKaimei;
	private String				txtJCode;
	private String				txtKaiMei;
	
	// tB[hyѐ
	public String				NAM_JCODE;
	public String				NAM_KAIMEI;
	public int					LEN_JCODE;
	public int					LEN_KAIMEI;
	
	// \[gL[
	public final String			KEY_JCODE			= "keyJCode";
	public final String			KEY_KAIMEI			= "keyKaimei";
	
	// [h(0FȂA1F)
	private int					searchmode;
	

	/**
	 * RXgN^
	 */
	public KaisyaMasterListVo() {
		super();
		setViewPath(getClassName());
		aryJCode = new String[0];
		aryKaimei = new String[0];
		txtJCode = "";
		txtKaiMei = "";
		setFormerKey(KEY_JCODE);
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_COMPANY_MASTER;
		aryMenu = new String[][]{ { CMD_MENU_SYSTEM2, CommonConst.NAM_TO_MENU } };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_JCODE = CommonConst.NAM_OFFICE + CommonConst.NAM_COMMON_CODE;
		NAM_KAIMEI = CommonConst.NAM_COMMON_MEISYO;
		LEN_JCODE = 10;
		LEN_KAIMEI = 50;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtJCode = request.getParameter(PRM_TXT_JCODE);
		txtKaiMei = request.getParameter(PRM_TXT_KAIMEI);
	}
	
	@Override
	public void setFields(List<?> listJigyousyo) {
		// Xg̐ݒ
		list = listJigyousyo;
		// f[^̎擾
		count = listJigyousyo.size();
		// z̏
		aryJCode = new String[count];
		aryKaimei = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = listJigyousyo.iterator();
		while (it.hasNext()) {
			MKaisyaDto dto = (MKaisyaDto)it.next();
			aryJCode[i] = escapeHTML(dto.getId());
			aryKaimei[i] = escapeHTML(dto.getKaiMei());
			i++;
		}
	}
	
	// ANZT\bh
	public String[] getEscAryJCode() {
		return aryJCode.clone();
	}
	
	public String[] getEscAryKaimei() {
		return aryKaimei.clone();
	}
	
	public String getTxtJCode() {
		return txtJCode;
	}
	
	public String getTxtKaiMei() {
		return txtKaiMei;
	}
	
	public String getEscTxtJCode() {
		return escapeHTML(txtJCode);
	}
	
	public String getEscTxtKaiMei() {
		return escapeHTML(txtKaiMei);
	}
	
	public void setSearchmode(int searchmode) {
		this.searchmode = searchmode;
	}
	
	public int getSearchmode() {
		return searchmode;
	}
	
}
