/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.dto.MCodeDto;

/**
 * @author yoshida
 *
 */
public class CodeMasterListVo extends MosPVo {
	
	private static final long	serialVersionUID	= -6348454372992171132L;
	
	// 萔
	public static final int		SEARCH_OFF			= 0;
	public static final int		SEARCH_ON			= 1;
	
	// p[^
	public static final String	PRM_PLT_T_ID		= "pltTId";
	public static final String	PRM_TXT_T_CODE		= "txtTCode";
	public static final String	PRM_TXT_T_NAME		= "txtTName";
	public static final String	PRM_TXT_T_CHANGE	= "txtTChange";
	
	// tB[h
	private String[]			aryTId;
	private String[]			aryTCode;
	private String[]			aryTName;
	private String[]			aryTChange;
	private String				pltTId;
	private String				txtTCode;
	private String				txtTName;
	private String				txtTChange;
	
	// tB[hyѐ
	public String				NAM_CODE_ID;
	public String				NAM_CODE;
	public String				NAM_NAME;
	public String				NAM_CHANGE;									//ϊ
	public int					LEN_CODE_ID;
	public int					LEN_CODE;
	public int					LEN_NAME;
	public int					LEN_CHANGE;
	
	// \[gL[
	public final String			KEY_T_ID			= "keyTId";
	public final String			KEY_T_CODE			= "keyTCode";
	public final String			KEY_T_NAME			= "keyTName";
	
	// v_EXg
	public String[][]			aryPltTId;
	
	// [h(0FȂA1F)
	private int					searchmode;
	

	/**
	 * 
	 */
	public CodeMasterListVo() {
		super();
		setViewPath(getClassName());
		pltTId = "";
		txtTCode = "";
		txtTName = "";
		txtTChange = "";
		aryTId = new String[0];
		aryTCode = new String[0];
		aryTName = new String[0];
		aryTChange = new String[0];
		setFormerKey(KEY_T_ID);
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_CODE_MASTER;
		aryMenu = new String[][]{ { CMD_MENU_SYSTEM2, CommonConst.NAM_TO_MENU } };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_CODE_ID = CommonConst.NAM_TABLE;
		NAM_CODE = CommonConst.NAM_COMMON_CODE;
		NAM_NAME = CommonConst.NAM_COMMON_MEISYO;
		NAM_CHANGE = CommonConst.NAM_CONVERSION; // ϊ
		LEN_CODE_ID = 50;
		LEN_CODE = 9;
		LEN_NAME = 25;
		LEN_CHANGE = 25;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		pltTId = request.getParameter(PRM_PLT_T_ID);
		txtTCode = request.getParameter(PRM_TXT_T_CODE);
		txtTName = request.getParameter(PRM_TXT_T_NAME);
		txtTChange = request.getParameter(PRM_TXT_T_CHANGE);
	}
	
	@Override
	public void setFields(List<?> listCode) {
		// Xg̐ݒ
		list = listCode;
		// f[^̎擾
		count = listCode.size();
		// z̏
		aryTId = new String[count];
		aryTCode = new String[count];
		aryTName = new String[count];
		aryTChange = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = listCode.iterator();
		while (it.hasNext()) {
			MCodeDto dto = (MCodeDto)it.next();
			aryTId[i] = escapeHTML(dto.getTId());
			aryTCode[i] = escapeHTML(dto.getTCode());
			aryTName[i] = escapeHTML(dto.getTName());
			aryTChange[i] = escapeHTML(dto.getTChange());
			i++;
		}
	}
	
	// ANZT\bh
	public String[] getEscAryTId() {
		return aryTId.clone();
	}
	
	public String[] getEscAryTCode() {
		return aryTCode.clone();
	}
	
	public String[] getEscAryTName() {
		return aryTName.clone();
	}
	
	public String[] getEscAryTChange() {
		return aryTChange.clone();
	}
	
	public String getPltTId() {
		return pltTId;
	}
	
	public String getTxtTCode() {
		return txtTCode;
	}
	
	public String getTxtTName() {
		return txtTName;
	}
	
	public String getTxtTChange() {
		return txtTChange;
	}
	
	public String getEscPltTId() {
		return escapeHTML(pltTId);
	}
	
	public String getEscTxtTCode() {
		return escapeHTML(txtTCode);
	}
	
	public String getEscTxtTName() {
		return escapeHTML(txtTName);
	}
	
	public String getEscTxtTChange() {
		return escapeHTML(txtTChange);
	}
	
	public void setSearchmode(int searchmode) {
		this.searchmode = searchmode;
	}
	
	public int getSearchmode() {
		return searchmode;
	}
	
}
