/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.dto.CmCodeDto;

/**
 * @author yoshida
 *
 */
public class CmCodeListVo extends MosPVo {
	
	private static final long	serialVersionUID	= 123422132321L;
	
	// p[^
	public static final String	PRM_PLT_T_ID		= "pltTId";
	public static final String	PRM_TXT_T_CODE		= "txtTCode";
	public static final String	PRM_TXT_T_NAME		= "txtTName";
	public static final String	PRM_TXT_VIEW_INDEX	= "txtViewIndex";
	public static final String	PRM_PLT_DELETE		= "pltDelete";
	
	// tB[h
	private String[]			aryTId;
	private String[]			aryTIdName;
	private String[]			aryTCode;
	private String[]			aryTName;
	private String[]			aryViewIndex;
	private String[]			aryDelete;
	private String				pltTId;
	private String				txtTCode;
	private String				txtTName;
	private String				txtViewIndex;
	private String				pltDelete;
	
	// tB[hyѐ
	public String				NAM_CODE_ID;
	public String				NAM_CODE;
	public String				NAM_NAME;
	public String				NAM_INDEX;
	public String				NAM_DELETE;
	public int					LEN_CODE_ID;
	public int					LEN_CODE;
	public int					LEN_NAME;
	
	// \[gL[
	public final String			KEY_T_ID			= "keyTId";
	public final String			KEY_T_CODE			= "keyTCode";
	public final String			KEY_T_NAME			= "keyTName";
	public final String			KEY_VIEWINDEX		= "keyViewIndex";
	public final String			KEY_DELETE			= "keyDelete";
	
	// v_EXg
	public String[][]			aryPltTId;
	
	// [h(0FȂA1F)
	private int					searchmode;
	

	/**
	 * RXgN^
	 */
	public CmCodeListVo() {
		super();
		setViewPath(getClassName());
		pltTId = "";
		txtTCode = "";
		txtTName = "";
		txtViewIndex = "";
		pltDelete = "";
		aryTId = new String[0];
		aryTIdName = new String[0];
		aryTCode = new String[0];
		aryTName = new String[0];
		aryViewIndex = new String[0];
		aryDelete = new String[0];
		setFormerKey(KEY_T_ID);
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_COMMON_CODE_MASTER;
		aryMenu = new String[][]{ { CMD_MENU_SYSTEM2, CommonConst.NAM_TO_MENU } };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_CODE_ID = CommonConst.NAM_COMMON_CODE + CommonConst.NAM_COMMON_TYPE;
		NAM_CODE = CommonConst.NAM_COMMON_CODE;
		NAM_NAME = CommonConst.NAM_COMMON_MEISYO;
		NAM_INDEX = CommonConst.NAM_SHOW_ORDER;
		NAM_DELETE = CommonConst.NAM_DELETE_FLAG;
		LEN_CODE_ID = 10;
		LEN_CODE = 8;
		LEN_NAME = 16;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		pltTId = request.getParameter(PRM_PLT_T_ID);
		txtTCode = request.getParameter(PRM_TXT_T_CODE);
		txtTName = request.getParameter(PRM_TXT_T_NAME);
		txtViewIndex = request.getParameter(PRM_TXT_VIEW_INDEX);
		pltDelete = request.getParameter(PRM_PLT_DELETE);
	}
	
	@Override
	public void setFields(List<?> listUmUser) {
		// Xg̐ݒ
		list = listUmUser;
		// f[^̎擾
		count = listUmUser.size();
		// z̏
		aryTId = new String[count];
		aryTCode = new String[count];
		aryTName = new String[count];
		aryViewIndex = new String[count];
		aryDelete = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = listUmUser.iterator();
		while (it.hasNext()) {
			CmCodeDto dto = (CmCodeDto)it.next();
			aryTId[i] = escapeHTML(dto.getTId());
			aryTCode[i] = escapeHTML(dto.getTCode());
			aryTName[i] = escapeHTML(dto.getTName());
			aryViewIndex[i] = String.valueOf(dto.getViewIndex());
			aryDelete[i] = String.valueOf(dto.getDeleteFlag());
			if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_OFF) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_OFF_NAME);
			} else if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_ON) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_ON_NAME);
			}
			i++;
		}
	}
	
	// ANZT\bh
	public String[] getEscAryTId() {
		return aryTId.clone();
	}
	
	public String[] getAryTIdName() {
		return aryTIdName.clone();
	}
	
	public String[] getEscAryTCode() {
		return aryTCode.clone();
	}
	
	public String[] getEscAryTName() {
		return aryTName.clone();
	}
	
	public String[] getEscAryViewIndex() {
		return aryViewIndex.clone();
	}
	
	public String[] getEscAryDelete() {
		return aryDelete.clone();
	}
	
	public void setAryTIdName(String[] aryTIdName) {
		this.aryTIdName = aryTIdName.clone();
	}
	
	public String getPltTId() {
		return pltTId;
	}
	
	public String getTxtTCode() {
		return txtTCode;
	}
	
	public String getTxtTName() {
		return txtTName;
	}
	
	public String getTxtViewIndex() {
		return txtViewIndex;
	}
	
	public String getPltDelete() {
		return pltDelete;
	}
	
	public String getEscPltTId() {
		return escapeHTML(pltTId);
	}
	
	public String getEscTxtTCode() {
		return escapeHTML(txtTCode);
	}
	
	public String getEscTxtTName() {
		return escapeHTML(txtTName);
	}
	
	public String getEscTxtViewIndex() {
		return escapeHTML(txtViewIndex);
	}
	
	public void setPltDelete(int pltDelete) {
		this.pltDelete = String.valueOf(pltDelete);
	}
	
	public void setSearchmode(int searchmode) {
		this.searchmode = searchmode;
	}
	
	public int getSearchmode() {
		return searchmode;
	}
}
