/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.payroll.dao.MKintaiKeisanDao;
import jp.mosp.payroll.dto.MKintaiKeisanDto;
import jp.mosp.system.vo.KeisanInformationCardVo;

/**
 * @author yoshida
 *
 */
public class KeisanInformationCardAction extends KintaiCommonAction {
	
	// R}h
	private static final String	CMD_KEISAN_INFO_SHOW	= "S1100";
	private static final String	CMD_KEISAN_INFO_UPDATE	= "S1108";
	

	/**
	 * RXgN^
	 */
	public KeisanInformationCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾yѐݒ
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_KEISAN_INFO_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_KEISAN_INFO_UPDATE)) {
			// XV
			update();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new KeisanInformationCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// vZǗmF
		confirmCalculateAuth();
		KeisanInformationCardVo vo = (KeisanInformationCardVo)getVo();
		// v_ẼZbg
		vo.aryPltMonth = StringUtil.getMonthArray();
		vo.aryPltDays = StringUtil.getDayArray();
		vo.aryPltCompleteFlag = setPltCompleteFlag();
	}
	
	@Override
	protected void show() throws Exception {
		KeisanInformationCardVo vo = (KeisanInformationCardVo)getVo();
		// DTȌ
		MKintaiKeisanDto dto = part().calculate().findForCalc();
		if (VariousUtil.isNull(dto)) {
			// ȂAݒ肳ꂽNꂼ̔NtB[hɃZbgB
			dto = new MKintaiKeisanDto();
			// ΑӌvZݒ
			Date calcMonth = getCalcMonth();
			dto.setKTNen(MospUtility.getYear(calcMonth));
			dto.setKTTuki(MospUtility.getMonth(calcMonth));
			// ^vZݒ
			Date paymentMonth = getCalcPayment(calcMonth);
			dto.setKSNen(MospUtility.getYear(paymentMonth));
			dto.setKSTuki(MospUtility.getMonth(paymentMonth));
			dto.setKShi(MospUtility.getDay(paymentMonth));
			dto.setKKanryou(CommonConst.NUM_ATT_CALCULATE_COMPLETE_FLAG_OFF);
		}
		vo.setFields(dto);
		setSessionDto(dto);
	}
	
	@Override
	protected void update() throws Exception {
		KeisanInformationCardVo vo = (KeisanInformationCardVo)getVo();
		// DTO̎擾
		MKintaiKeisanDto dto = (MKintaiKeisanDto)getSessionDto();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// DAȌ
		MKintaiKeisanDao dao = part().calculate().getKeisanDao();
		// XVOdto݂邩ǂ`FbN
		MKintaiKeisanDto currentDto = dao.findForUpdate(dto.getKTNen());
		if (chkExistDto(currentDto)) {
			// 폜
			dao.delete(currentDto);
		}
		vo.setDtoFields(dto);
		// o^	
		dao.insert(dto);
		// DTO̍Ď擾
		MKintaiKeisanDto retDto = dao.findForKey(dto.getKTNen());
		chkUpdate(retDto);
		// R~bg
		commit();
		// ZbVpDTOɃZbg
		setSessionDto(retDto);
		vo.setFields(retDto);
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_UPDATE, ""));
	}
	
	/**
	 * vZ󋵃tOv_E
	 * @return	aryPltCompleteFlag
	 */
	protected String[][] setPltCompleteFlag() {
		String[][] aryPltCompleteFlag = new String[2][2];
		aryPltCompleteFlag[0][0] = CommonConst.NUM_ATT_CALCULATE_COMPLETE_FLAG_OFF;
		aryPltCompleteFlag[0][1] = CommonConst.NAM_ATT_CALCULATE_COMPLETE_FLAG_OFF;
		aryPltCompleteFlag[1][0] = CommonConst.NUM_ATT_CALCULATE_COMPLETE_FLAG_ON;
		aryPltCompleteFlag[1][1] = CommonConst.NAM_ATT_CALCULATE_COMPLETE_FLAG_ON;
		return aryPltCompleteFlag;
	}
	
}
