/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dto;

import jp.mosp.common.common.BaseDto;

/**
 * @author yoshida
 *
 */
public class MKintaiKeisanDto extends BaseDto {
	
	private static final long	serialVersionUID	= 3115468966868261668L;
	
	// tB[h
	private int					ktnen				= 0;					//^vZN
	private int					kttuki				= 0;					//^vZ
	private int					ksnen				= 0;					//^xN
	private int					kstuki				= 0;					//^x
	private int					kshi				= 0;					//^x
	private String				kkanryou			= "";					//^
	private int					stnen				= 0;					//ܗ^vZN
	private int					sttuki				= 0;					//ܗ^vZ
	private int					ssnen				= 0;					//ܗ^xN
	private int					sstuki				= 0;					//ܗ^x
	private int					sshi				= 0;					//ܗ^x
	private String				skanryou			= "";					//ܗ^
	private int					ntnen				= 0;					//NvZN
	private String				nkanryou			= "";					//N
	private int					ttnen				= 0;					//ZvZN
	private int					tttuki				= 0;					//ZvZ
	private String				tkanryou			= "";					//Z芮
	private int					gtnen				= 0;					//όvZN
	private int					gttuki				= 0;					//όvZ
	private String				gkanryou			= "";					//ϊ
																			
	
	/**
	 * RXgN^
	 */
	public MKintaiKeisanDto() {
		super();
	}
	
	// ANZT\bh
	/**
	 * @return ktnen 	^vZNB
	 */
	public int getKTNen() {
		return ktnen;
	}
	
	/**
	 * @return kttuki 	^vZB
	 */
	public int getKTTuki() {
		return kttuki;
	}
	
	/**
	 * @return ksnen 	^xNB
	 */
	public int getKSNen() {
		return ksnen;
	}
	
	/**
	 * @return kstuki 	^xB
	 */
	public int getKSTuki() {
		return kstuki;
	}
	
	/**
	 * @return kshi 	^xB
	 */
	public int getKShi() {
		return kshi;
	}
	
	/**
	 * @return kkanryou 	^B
	 */
	public String getKKanryou() {
		return kkanryou;
	}
	
	/**
	 * @return stnen 	ܗ^vZNB
	 */
	public int getSTNen() {
		return stnen;
	}
	
	/**
	 * @return sttuki 	ܗ^vZB
	 */
	public int getSTTuki() {
		return sttuki;
	}
	
	/**
	 * @return ssnen 	ܗ^xNB
	 */
	public int getSSNen() {
		return ssnen;
	}
	
	/**
	 * @return sstuki 	ܗ^xB
	 */
	public int getSSTuki() {
		return sstuki;
	}
	
	/**
	 * @return sshi 	ܗ^xB
	 */
	public int getSSHi() {
		return sshi;
	}
	
	/**
	 * @return skanryou 	ܗ^B
	 */
	public String getSKanryou() {
		return skanryou;
	}
	
	/**
	 * @return ntnen 	NvZNB
	 */
	public int getNTNen() {
		return ntnen;
	}
	
	/**
	 * @return nkanryou 	NB
	 */
	public String getNKanryou() {
		return nkanryou;
	}
	
	/**
	 * @return ttnen 	ZvZNB
	 */
	public int getTTNen() {
		return ttnen;
	}
	
	/**
	 * @return tttuki 	ZvZB
	 */
	public int getTTTuki() {
		return tttuki;
	}
	
	/**
	 * @return tkanryou 	Z芮B
	 */
	public String getTKanryou() {
		return tkanryou;
	}
	
	/**
	 * @return gtnen 	όvZNB
	 */
	public int getGTNen() {
		return gtnen;
	}
	
	/**
	 * @return gttuki 	όvZB
	 */
	public int getGTTuki() {
		return gttuki;
	}
	
	/**
	 * @return gkanryou 	ϊB
	 */
	public String getGKanryou() {
		return gkanryou;
	}
	
	/**
	 * @param ktnen 	Zbg鋋^vZNB
	 */
	public void setKTNen(int ktnen) {
		this.ktnen = ktnen;
	}
	
	/**
	 * @param kttuki 	Zbg鋋^vZB
	 */
	public void setKTTuki(int kttuki) {
		this.kttuki = kttuki;
	}
	
	/**
	 * @param ksnen 	Zbg鋋^xNB
	 */
	public void setKSNen(int ksnen) {
		this.ksnen = ksnen;
	}
	
	/**
	 * @param kstuki 	Zbg鋋^xB
	 */
	public void setKSTuki(int kstuki) {
		this.kstuki = kstuki;
	}
	
	/**
	 * @param kshi 	Zbg鋋^xB
	 */
	public void setKShi(int kshi) {
		this.kshi = kshi;
	}
	
	/**
	 * @param kkanryou 	Zbg鋋^B
	 */
	public void setKKanryou(String kkanryou) {
		this.kkanryou = kkanryou;
	}
	
	/**
	 * @param stnen 	Zbgܗ^vZNB
	 */
	public void setSTNen(int stnen) {
		this.stnen = stnen;
	}
	
	/**
	 * @param sttuki 	Zbgܗ^vZB
	 */
	public void setSTTuki(int sttuki) {
		this.sttuki = sttuki;
	}
	
	/**
	 * @param ssnen 	Zbgܗ^xNB
	 */
	public void setSSNen(int ssnen) {
		this.ssnen = ssnen;
	}
	
	/**
	 * @param sstuki 	Zbgܗ^xB
	 */
	public void setSSTuki(int sstuki) {
		this.sstuki = sstuki;
	}
	
	/**
	 * @param sshi 	Zbgܗ^xB
	 */
	public void setSSHi(int sshi) {
		this.sshi = sshi;
	}
	
	/**
	 * @param skanryou 	Zbgܗ^B
	 */
	public void setSKanryou(String skanryou) {
		this.skanryou = skanryou;
	}
	
	/**
	 * @param ntnen 	ZbgNvZNB
	 */
	public void setNTNen(int ntnen) {
		this.ntnen = ntnen;
	}
	
	/**
	 * @param nkanryou 	ZbgNB
	 */
	public void setNKanryou(String nkanryou) {
		this.nkanryou = nkanryou;
	}
	
	/**
	 * @param ttnen 	ZbgZvZNB
	 */
	public void setTTNen(int ttnen) {
		this.ttnen = ttnen;
	}
	
	/**
	 * @param tttuki 	ZbgZvZB
	 */
	public void setTTTuki(int tttuki) {
		this.tttuki = tttuki;
	}
	
	/**
	 * @param tkanryou 	ZbgZ芮B
	 */
	public void setTKanryou(String tkanryou) {
		this.tkanryou = tkanryou;
	}
	
	/**
	 * @param gtnen 	Zbg錎όvZNB
	 */
	public void setGTNen(int gtnen) {
		this.gtnen = gtnen;
	}
	
	/**
	 * @param gttuki 	Zbg錎όvZB
	 */
	public void setGTTuki(int gttuki) {
		this.gttuki = gttuki;
	}
	
	/**
	 * @param gkanryou 	Zbg錎ϊB
	 */
	public void setGKanryou(String gkanryou) {
		this.gkanryou = gkanryou;
	}
	
}
