/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.sql.SQLException;

import com.google.appengine.api.datastore.Query;

import jp.getset.gae.bigtable.Statement.Mode;
import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.CmCompanyDto;

public class CmCompanyDao extends PayrollDao {
	
	// e[uyуL[
	public static final String	TABLE							= "CM_COMPANY";
	public static final String	KEY_1							= "COMPANY_CODE";				// ЃR[h
																								
	// 
	public static final String	COL_COMPANY_CODE				= "COMPANY_CODE";				// ЃR[h
	public static final String	COL_COMPANY_NAME				= "COMPANY_NAME";				// Ж
	public static final String	COL_COMPANY_KANA				= "COMPANY_KANA";				// ض
	public static final String	COL_COMPANY_FB_KANA				= "COMPANY_FB_KANA";			// ض
	public static final String	COL_ENTERPRENEUR				= "ENTERPRENEUR";				// Ǝ喼
	public static final String	COL_COMPANY_POSTAL				= "COMPANY_POSTAL";			// ЗX֔ԍ
	public static final String	COL_COMPANY_ADDRESS				= "COMPANY_ADDRESS";			// ЏZ
	public static final String	COL_COMPANY_FB_ADDRESS			= "COMPANY_FB_ADDRESS";		// ЏZ
	public static final String	COL_COMPANY_PHONE				= "COMPANY_PHONE";				// Гdbԍ
	public static final String	COL_COM_HEALTH_PREMIUM_RATE		= "COM_HEALTH_PREMIUM_RATE";	// Nی
	public static final String	COL_COM_NURSING_PREMIUM_RATE	= "COM_NURSING_PREMIUM_RATE";	// ی
	public static final String	COL_COM_PENSION_PREMIUM_RATE	= "COM_PENSION_PREMIUM_RATE";	// N
	public static final String	COL_COM_FUND_PREMIUM_RATE		= "COM_FUND_PREMIUM_RATE";		// N
	public static final String	COL_COM_UNEMPLOY_PREMIUM_RATE	= "COM_UNEMPLOY_PREMIUM_RATE";	// ٗpی
	public static final String	COL_HEALTH_PREMIUM_RATE			= "HEALTH_PREMIUM_RATE";		// Nی
	public static final String	COL_NURSING_PREMIUM_RATE		= "NURSING_PREMIUM_RATE";		// ی
	public static final String	COL_PENSION_PREMIUM_RATE		= "PENSION_PREMIUM_RATE";		// N
	public static final String	COL_FUND_PREMIUM_RATE			= "FUND_PREMIUM_RATE";			// N
	public static final String	COL_UNEMPLOY_PREMIUM_RATE		= "UNEMPLOY_PREMIUM_RATE";		// ٗpی
	public static final String	COL_FUND_PARTICIPATION			= "FUND_PARTICIPATION";		// N
	public static final String	COL_STATION_NO					= "STATION_NO";				// ԍ
	public static final String	COL_DISPOSE_NO					= "DISPOSE_NO";				// ԍ
																								
	
	/**
	 * RXgN^
	 */
	public CmCompanyDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	/*	private List<CmCompanyDto> mappingAll() throws SQLException {
			List<CmCompanyDto> all = new ArrayList<CmCompanyDto>();
			while (rs.next()) {
				all.add(mapping());
			}
			return all;
		}
	*/
	/**
	 * ʎ擾(DTO)
	 * @return CmCompanyDto R[h
	 * @throws SQLException
	 */
	private CmCompanyDto mapping() throws SQLException {
		CmCompanyDto dto = new CmCompanyDto();
		dto.setCompanyCode(rs.getString(COL_COMPANY_CODE)); // ЃR[h
		dto.setCompanyName(rs.getString(COL_COMPANY_NAME)); // Ж
		dto.setCompanyKana(rs.getString(COL_COMPANY_KANA)); // ض
		dto.setCompanyFbKana(rs.getString(COL_COMPANY_FB_KANA));
		dto.setEnterpreneur(rs.getString(COL_ENTERPRENEUR)); // Ǝ喼
		dto.setCompanyPostal(rs.getString(COL_COMPANY_POSTAL)); // ЗX֔ԍ
		dto.setCompanyAddress(rs.getString(COL_COMPANY_ADDRESS)); // ЏZ
		dto.setCompanyFbAddress(rs.getString(COL_COMPANY_FB_ADDRESS)); // ЏZ
		dto.setCompanyPhone(rs.getString(COL_COMPANY_PHONE)); // Гdbԍ
		dto.setComHealthPremiumRate(rs.getFloat(COL_COM_HEALTH_PREMIUM_RATE)); // Nی
		dto.setComNursingPremiumRate(rs.getFloat(COL_COM_NURSING_PREMIUM_RATE)); // ی
		dto.setComPensionPremiumRate(rs.getFloat(COL_COM_PENSION_PREMIUM_RATE)); // N
		dto.setComFundPremiumRate(rs.getFloat(COL_COM_FUND_PREMIUM_RATE)); // N
		dto.setComUnemployPremiumRate(rs.getFloat(COL_COM_UNEMPLOY_PREMIUM_RATE)); // ٗpی
		dto.setHealthPremiumRate(rs.getFloat(COL_HEALTH_PREMIUM_RATE)); // Nی
		dto.setNursingPremiumRate(rs.getFloat(COL_NURSING_PREMIUM_RATE)); // ی
		dto.setPensionPremiumRate(rs.getFloat(COL_PENSION_PREMIUM_RATE)); // N
		dto.setFundPremiumRate(rs.getFloat(COL_FUND_PREMIUM_RATE)); // N
		dto.setUnemployPremiumRate(rs.getFloat(COL_UNEMPLOY_PREMIUM_RATE)); // ٗpی
		dto.setFundParticipation(rs.getString(COL_FUND_PARTICIPATION)); // N
		dto.setStationNo(rs.getString(COL_STATION_NO)); // ԍ
		dto.setDisposeNo(rs.getString(COL_DISPOSE_NO)); // ԍ
		
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmCompanyDto findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_COMPANY_CODE + " <> '' ");
			this.pob.appendWhere(COL_COMPANY_CODE, Query.FilterOperator.NOT_EQUAL, "");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			executeQuery();
			CmCompanyDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @return CmCompanyDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmCompanyDto findForKey(String kCode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kCode);
			executeQuery();
			CmCompanyDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ЈɂsbN擾
	 * @param kCode ЈR[h(L[)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmCompanyDto findForUpdate(String kCode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_COMPANY_CODE + " = ? ");
			this.pob.appendWhere(COL_COMPANY_CODE, Query.FilterOperator.EQUAL);
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()) + getForUpdate());
			setParam(index++, kCode);
			executeQuery();
			CmCompanyDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(CmCompanyDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(CmCompanyDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getCompanyCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂf[^폜
	 * @param kCode 폜ΏێЈR[h
	 * @return int 폜()
	 * @throws SQLException
	 */
	public int deleteForEmployee(String kCode) throws SQLException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_COMPANY_CODE + " = ? ");
			
			this.setPreparedStatement(Mode.DELETE, TABLE);
			this.pob.appendWhere(COL_COMPANY_CODE, Query.FilterOperator.EQUAL);
			
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(CmCompanyDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getCompanyCode());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(CmCompanyDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getCompanyCode()); // ЃR[h
		setParam(index++, dto.getCompanyName()); // Ж
		setParam(index++, dto.getCompanyKana()); // ض
		setParam(index++, dto.getCompanyFbKana()); // ض
		setParam(index++, dto.getEnterpreneur()); // Ǝ喼
		setParam(index++, dto.getCompanyPostal()); // ЗX֔ԍ
		setParam(index++, dto.getCompanyAddress()); // ЏZ
		setParam(index++, dto.getCompanyFbAddress()); // ЏZ
		setParam(index++, dto.getCompanyPhone()); // Гdbԍ
		setParam(index++, dto.getComHealthPremiumRate()); // Nی
		setParam(index++, dto.getComNursingPremiumRate()); // ی
		setParam(index++, dto.getComPensionPremiumRate()); // N
		setParam(index++, dto.getComFundPremiumRate()); // N
		setParam(index++, dto.getComUnemployPremiumRate()); // ٗpی
		setParam(index++, dto.getHealthPremiumRate()); // Nی
		setParam(index++, dto.getNursingPremiumRate()); // ی
		setParam(index++, dto.getPensionPremiumRate()); // N
		setParam(index++, dto.getFundPremiumRate()); // N
		setParam(index++, dto.getUnemployPremiumRate()); // ٗpی
		setParam(index++, dto.getFundParticipation()); // N
		setParam(index++, dto.getStationNo()); // ԍ
		setParam(index++, dto.getDisposeNo()); // ԍ
		
		setCommonParams(isInsert);
	}
	
}
