/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.common.vo;

import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.payroll.base.Employee;
import jp.mosp.payroll.base.PayrollConst;

public class InsuranceConfSetVo extends MosPVo {
	
	private static final long	serialVersionUID			= 1833548315728482756L;
	
	// URLACSS
	private static final String	RETURN_URL					= "/jsp/payroll/common/insuranceConfSet.jsp";
	private static final String	EXTRA_JS					= "/pub/payroll/common/js/insuranceConfSet.js";
	private static final String	EXTRA_CSS					= "/pub/payroll/common/css/insuranceConfSet.css";
	
	// ʃTu^Cg
	public final String			SUB_TITLE					= PayrollConst.TTL_SANTEI_GEPPEN_CONF;
	
	// p[^
	public static final String	BTN_SYORI_SELECT			= "idButtonSyori";									// I{^
	public static final String	BTN_SIHARAI_KISO_NISU		= "idButtonKisoNisu";								// xb{^
	public static final String	BTN_HOUSYU_GETU_GAKU		= "idButtonGetuGaku";								// Vz{^
	public static final String	BTN_JYOUKEN_SELECT			= "idButtonJyouken";								// ͏{^
	public static final String	BTN_KAIGO_KUBUN				= "idButtonKaigoKubun";							// 敪{^
																												
	public static final String	PRM_SYOUKYU_TUKI			= "prmSyoukyuTuki";								// (~jv_E
//	public static final String PRM_CYOUSYU_KAISI					= "prmCyouSyuTuki";			// Jnv_E
	public static final String	PRM_CKR_SANTEI_KISO			= "prmCkrSanteikiso";								// WI{^uZbvI
	public static final String	PRM_CKR_TUKIGAKU_HENKOU		= "prmCkrTukiGakuHenkou";							// WI{^uzύXv
	public static final String	PRM_CKR_SHIHARAI_ZENGETU	= "prmCkrShiharaiZenGetu";							// WI{^uOgpvI
	public static final String	PRM_CKR_SHIHARAI_TOUGETU	= "prmCkrShiharaiTouGetu";							// WI{^ugpvI
	public static final String	PRM_CKR_HOUSYU_ZENGETU		= "prmCkrHousyuZenGetu";							// WI{^uOf[^WvvI
	public static final String	PRM_CKR_HOUSYU_TOUGETU		= "prmCkrHousyuTouGetu";							// WI{^uf[^WvvI
	public static final String	PRM_CKR_JYUNJYO_KCODE		= "prmCkrJyunjyoKcode";							// WI{^uЈvI
	public static final String	PRM_CKR_JYUNJYO_BUSHO		= "prmCkrJyunjyoBusho";							// WI{^uvI
	public static final String	PRM_CKR_JYUNJYO_KENPO		= "prmCkrJyunjyoKenpo";							// WI{^uۏvI
	public static final String	PRM_CKR_JYUNJYO_KOUNEN		= "prmCkrJyunjyoKounen";							// WI{^uNvI
	public static final String	PRM_CKR_KAIGO_KUBUN_AUTO	= "prmCkrKaigoKubunAuto";							// WI{^uΏێЈ̋敪ɂvI
	public static final String	PRM_CKR_KAIGO_KUBUN_MNAL	= "prmCkrKaigoKubunMnal";							// WI{^uΏێЈ̋敪蓮ɂvI
	public static final String	PRM_CKB_KAIGO_KUBUN_CHK		= "prmCkbKaigoKubunChk";							// `FbN{bNXu敪`FbNsvI
																												
	// tB[h
//	private int	santeiNen				;			// ZΏ۔N
//	private int	santeiTuki				;			// ZΏی
	
	public String				idButtonSyori;																	// Ie
	public String				idButtonKisoNisu;																// xb{^Ie
	public String				idButtonGetuGaku;																// Vz{^Ie
	public String				idButtonJyouken;																// ͏{^Ie
	public String				idButtonKaigoKubun;															// 敪{^Ie
																												
	public String				prmCkbKaigoKubunChk;															// u敪`FbNsvItO
																												
	public String				prmSyoukyuTuki;																// (~jv_EIe
	public String				prmCyouSyuTuki;																// Jnv_EIe
																												
	public String				syoukyuTukiStr;																// ()iaj
	public String				syoukyuTukiStr_ind;															// ()e[uINDEX
	public String				tekiyouNenGetu;																// KpNiaj	
	public String				chousyuKaisiTuki;																// Jniaj
	public String				chousyuKaisiTuki_ind;															// Jne[uINDEX
																												
	public Date					syoukyuTuki_Date;																// ijiDate^j
	public Date					tekiyouNenGetu_Date;															// KpNiDate^j	
	public Date					chousyuKaisiTuki_Date;															// JniDate^j
																												
	// 擾pz
	public String[][]			arySanteiTuki;
	public String[][]			arySanteiTukiKiso			= { { "4", "04@KpN:07" }, { "5", "05@KpN:08" },
		{ "6", "06@KpN:09" }, { "7", "07@KpN:10" }, { "8", "08@KpN:11" }, { "9", "09@KpN:12" },
		{ "10", "10@KpN:01" }, { "11", "11@KpN:02" }, { "12", "12@KpN:03" }, { "1", "01@KpN:04" },
		{ "2", "02@KpN:05" }, { "3", "03@KpN:06" }	};
	
	public String[][]			aryChyouSyuNenGetu;															//Niaje[u
	public String[][]			aryEra;																		//aNϊe[u 
	public String[]				aryKcode;																		//aNϊe[u 
	public List<Employee>		listEmployee;																	//l񃊃Xg
	// ݒe[u
	public List<MosPConfDto>	listConf;
	

	/**
	 * RXgN^
	 */
	public InsuranceConfSetVo() {
		super();
		setRetUrl(RETURN_URL);
		setExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		syoukyuTukiStr_ind = arySanteiTukiKiso[0][0];
		idButtonSyori = ""; // Ie擾
		idButtonKisoNisu = ""; // xb{^Ie擾
		idButtonGetuGaku = ""; // Vz{^Ie擾
		idButtonJyouken = ""; // ͏{^Ie擾
		idButtonKaigoKubun = ""; // 敪{^Ie擾
		prmCkbKaigoKubunChk = ""; //u敪`FbNsvI
	}
	
	/**
	 * tB[h
	 * @throws MospException 
	 */
	public void initFields() throws MospException {
		Date dateTmp;
		int tmpYear;
		int thisYear = MospUtility.getYear(DateUtil.getSystemDate());
		
		// {N̒e[ui7`10jݒ
		aryChyouSyuNenGetu = new String[4][2];
		for (int i = 0; i < 4; i++) {
			tmpYear = (thisYear * 10000) + ((7 + i) * 100) + 1;
			dateTmp = DateUtil.convIntegerDateToDate(tmpYear);
			aryChyouSyuNenGetu[i][0] = String.valueOf(tmpYear);
			aryChyouSyuNenGetu[i][1] = getMonthString(listConf, aryEra, dateTmp);
		}
		chousyuKaisiTuki_ind = aryChyouSyuNenGetu[3][0]; //@e[ufBtHgu10vɐݒ
	}
	
	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParamsAll(HttpServletRequest request) {
		idButtonSyori = getRadioButtonParam(request.getParameter(BTN_SYORI_SELECT)); // Ie擾
		idButtonKisoNisu = getRadioButtonParam(request.getParameter(BTN_SIHARAI_KISO_NISU)); // xb{^Ie擾
		idButtonGetuGaku = getRadioButtonParam(request.getParameter(BTN_HOUSYU_GETU_GAKU)); // Vz{^Ie擾
		idButtonJyouken = getRadioButtonParam(request.getParameter(BTN_JYOUKEN_SELECT)); // ͏{^Ie擾
		idButtonKaigoKubun = getRadioButtonParam(request.getParameter(BTN_KAIGO_KUBUN)); // 敪{^Ie擾
		prmCkbKaigoKubunChk = getCheckBoxParam(request.getParameter(PRM_CKB_KAIGO_KUBUN_CHK)); //u敪`FbNsvI
		prmSyoukyuTuki = request.getParameter(PRM_SYOUKYU_TUKI); // (~jv_E
//		prmCyouSyuTuki			=	request.getParameter(PRM_CYOUSYU_KAISI);							// (~jv_E
	}
	
	/**
	 * WI{^擾NULLΉ
	 * @param value WI{^Ip[^l
	 * @return ϊ`FbN{bNXNGXgp[^l
	 */
	public String getRadioButtonParam(String value) {
		if (value == null) {
			return "";
		} else {
			return value;
		}
	}
	
	/**
	 * at擾(N)
	 * @param list ݒ}X^DTOXg
	 * @param aryEra a񃊃Xg
	 * @param date 
	 * @return tN
	 * @throws MospException
	 */
	protected String getMonthString(List<MosPConfDto> list, String[][] aryEra, Date date) throws MospException {
		if (date == null || list == null) {
			return "";
		}
		String[] strDate = getJpImperialCal(list, date);
		strDate[0] = getCodeName(strDate[0], aryEra);
		for (int i = 1; i < strDate.length; i++) {
			strDate[i] = strDate[i].length() < 2 ? PayrollConst.SUPPRESS_DATE + strDate[i] : strDate[i];
		}
		return strDate[0] + strDate[1] + PayrollConst.NAM_YEAR + strDate[2] + PayrollConst.NAM_MONTH;
	}
	
	/**
	 * t擾(a)
	 * @param list a񃊃Xg
	 * @param date 
	 * @return t
	 * @throws MospException
	 */
	@Override
	protected String getDateString(List<MosPConfDto> list, String[][] aryEra, Date date) throws MospException {
		if (date == null || list == null) {
			return "";
		}
		String[] strDate = getJpImperialCal(list, date);
		strDate[0] = getCodeName(strDate[0], aryEra);
		for (int i = 1; i < strDate.length; i++) {
			strDate[i] = strDate[i].length() < 2 ? PayrollConst.SUPPRESS_DATE + strDate[i] : strDate[i];
		}
		return strDate[0] + strDate[1] + PayrollConst.NAM_YEAR + strDate[2] + PayrollConst.NAM_MONTH + strDate[3]
				+ PayrollConst.NAM_DAY;
	}
	
	public void setSyoukyuTuki(Date setDate) {
		syoukyuTuki_Date = setDate;
	} // Date^i~jNݒ
	
	public void setSyoukyuTukiJp(String setDate) {
		if (setDate.length() > 3) {
			syoukyuTukiStr = setDate.substring(0, setDate.length() - 3);
		} else {
			syoukyuTukiStr = "";
		}
	}
	
	public void setTekiyouNenGetu(Date setDate) throws MospException { // KpN̐ݒ 
		tekiyouNenGetu = getMonthString(listConf, aryEra, setDate);
		tekiyouNenGetu_Date = setDate;
	}
	
	public void setChousyuKaisiTukiStr(Date setDate) throws MospException { // N̐ݒ
		chousyuKaisiTuki = getMonthString(listConf, aryEra, setDate);
		chousyuKaisiTuki_Date = setDate;
	}
	
	public String getIdButtonSyori() {
		return idButtonSyori;
	} // Ie擾
	
	public String getIdButtonKisoNisu() {
		return idButtonKisoNisu;
	} // xb{^Ie擾
	
	public String getIdButtonGetuGaku() {
		return idButtonGetuGaku;
	} // Vz{^Ie擾
	
	public String getIdButtonJyouken() {
		return idButtonJyouken;
	} // ͏{^Ie擾
	
	public String getIdButtonKaigoKubun() {
		return idButtonKaigoKubun;
	} // 敪{^Ie擾
	
	public String getPrmCkbKaigoKubunChk() {
		return prmCkbKaigoKubunChk;
	} //u敪`FbNsvI
	
	public String getSyoukyuTukiStr() {
		return syoukyuTukiStr;
	} // ()擾iaj
	
	public String getSyoukyuTukiStrIndx() {
		return syoukyuTukiStr_ind;
	} // ()e[uCfbNX擾  
	
	public String getChousyuKaisiTukiStr() {
		return chousyuKaisiTuki;
	} // JnN擾
	
	public String getChousyuKaisiTukiStrIndx() {
		return chousyuKaisiTuki_ind;
	} // JnNe[u񏊓
	
	public String getTekiyouNenGetu() {
		return tekiyouNenGetu;
	}
	
}
