/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.mospcommon.system.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.mospcommon.system.dto.CmAgreementOverTimeDto;

/**
 * @author koike
 *
 */
public class OverTimeAgreementCardVo extends MosPVo {
	
	private static final long	serialVersionUID					= -5456388474414301215L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		MODE_INSERT							= 0;
	/**
	 * 
	 */
	public static final int		MODE_UPDATE							= 1;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_TXT_OVER_TIME_CODE				= "txtOverTimeCode";
	/**
	 * 
	 */
	public static final String	PRM_TXT_WORK_TYPE_NAME				= "txtWorkTypeName";
	/**
	 * 
	 */
	public static final String	PRM_TXT_CAUSE						= "txtCause";
	/**
	 * 
	 */
	public static final String	PRM_PLT_AGREE_TYPE					= "pltAgreeType";
	/**
	 * 
	 */
	public static final String	PRM_PLT_LIMIT_CODE					= "pltLimitCode";
	/**
	 * 
	 */
	public static final String	PRM_TXT_OVER_TIME_RATE				= "txtOverTimeRate";
	/**
	 * 
	 */
	public static final String	PRM_TXT_CAUTION_MONTH_HOUR			= "txtCautionMonthHour";
	/**
	 * 
	 */
	public static final String	PRM_TXT_CAUTION_MONTH_MIN			= "txtCautionMonthMin";
	/**
	 * 
	 */
	public static final String	PRM_TXT_MONTHLY_OVER_TIME_RATE		= "txtMonthlyOverTimeRate";
	/**
	 * 
	 */
	public static final String	PRM_TXT_SUB_ACQUIRE_RATE			= "txtSubAcquireRate";
	/**
	 * 
	 */
	public static final String	PRM_TXT_SUB_ACQUIRE_HOLIDAY_RATE	= "txtSubAcquireHolidayRate";
	/**
	 * 
	 */
	public static final String	PRM_TXT_SUB_QUIT_RATE				= "txtSubQuitRate";
	/**
	 * 
	 */
	public static final String	PRM_PLT_START_DATE_YEAR				= "pltStartDateYear";
	/**
	 * 
	 */
	public static final String	PRM_PLT_START_DATE_MONTH			= "pltStartDateMonth";
	/**
	 * 
	 */
	public static final String	PRM_PLT_START_DATE_DAY				= "pltStartDateDay";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DELETE_FLAG					= "pltDeletFlag";
	
	// tB[h
	private String				txtOverTimeCode;
	private String				txtWorkTypeName;
	private String				txtCause;
	private String				pltAgreeType;
	private String				pltLimitCode;
	private String				txtOverTimeRate;
	private String				txtCautionMonthHour;
	private String				txtCautionMonthMin;
	private String				txtMonthlyOverTimeRate;
	private String				txtSubAcquireRate;
	private String				txtSubAcquireHolidayRate;
	private String				txtSubQuitRate;
	private String				pltStartDateYear;
	private String				pltStartDateMonth;
	private String				pltStartDateDay;
	private String				pltDeletFlag;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltAgreeType;
	/**
	 * 
	 */
	public String[][]			aryPltLimitCode;
	/**
	 * 
	 */
	public String[][]			aryPltYear;
	/**
	 * 
	 */
	public String[][]			aryPltMonth;
	/**
	 * 
	 */
	public String[][]			aryPltDay;
	
	// [h(0FVKo^A1FXV)
	private int					mode;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_OVER_TIME_ID;
	/**
	 * 
	 */
	public String				NAM_OVER_TIME_CODE;
	/**
	 * 
	 */
	public String				NAM_WORK_TYPE_NAME;
	/**
	 * 
	 */
	public String				NAM_CAUSE;
	/**
	 * 
	 */
	public String				NAM_AGREE_TYPE;
	/**
	 * 
	 */
	public String				NAM_LIMIT_CODE;
	/**
	 * 
	 */
	public String				NAM_OVER_TIME_RATE;
	/**
	 * 
	 */
	public String				NAM_CAUTION_MONTH;
	/**
	 * 
	 */
	public String				NAM_CAUTION_MONTH_HOUR;
	/**
	 * 
	 */
	public String				NAM_CAUTION_MONTH_MIN;
	/**
	 * 
	 */
	public String				NAM_MONTHLY_OVER_TIME_RATE;
	/**
	 * 
	 */
	public String				NAM_SUB_ACQUIRE_RATE;
	/**
	 * 
	 */
	public String				NAM_SUB_ACQUIRE_HOLIDAY_RATE;
	/**
	 * 
	 */
	public String				NAM_SUB_QUIT_RATE;
	/**
	 * 
	 */
	public String				NAM_START_DATE;
	/**
	 * 
	 */
	public String				NAM_DELETE_FLAG;
	/**
	 * 
	 */
	public int					LEN_OVER_TIME_CODE;
	/**
	 * 
	 */
	public int					LEN_WORK_TYPE_NAME;
	/**
	 * 
	 */
	public int					LEN_CAUSE;
	/**
	 * 
	 */
	public int					LEN_AGREE_TYPE;
	/**
	 * 
	 */
	public int					LEN_LIMIT_CODE;
	/**
	 * 
	 */
	public int					LEN_OVER_TIME_RATE;
	/**
	 * 
	 */
	public int					LEN_CAUTION_MONTH_HOUR;
	/**
	 * 
	 */
	public int					LEN_CAUTION_MONTH_MIN;
	/**
	 * 
	 */
	public int					LEN_MONTHLY_OVER_TIME_RATE;
	/**
	 * 
	 */
	public int					LEN_SUB_ACQUIRE_RATE;
	/**
	 * 
	 */
	public int					LEN_SUB_ACQUIRE_HOLIDAY_RATE;
	/**
	 * 
	 */
	public int					LEN_SUB_QUIT_RATE;
	/**
	 * 
	 */
	public int					LEN_DELETE_FLAG;
	

	/**
	 * RXgN^
	 */
	public OverTimeAgreementCardVo() {
		super();
		mode = 0;
		setViewPath(getClassName());
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_OVER_TIME_AGREEMENT;
		createAryMenu(CMD_MENU_SYSTEM2, MosPMenuConst.getMenuLaborAgreement());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_OVER_TIME_CODE = CommonConst.NAM_OVER_TIME + CommonConst.NAM_AGREEMENT + CommonConst.NAM_COMMON_CODE;
		NAM_WORK_TYPE_NAME = CommonConst.NAM_WORK_TYPE_NAME;
		NAM_CAUSE = CommonConst.NAM_SPECIFICALLY + CommonConst.NAM_CAUSE;
		NAM_AGREE_TYPE = CommonConst.TID_AGREEMENT_TYPE;
		NAM_LIMIT_CODE = CommonConst.NAM_LIMIT_STANDARD + CommonConst.NAM_COMMON_MEISYO;
		NAM_CAUTION_MONTH = CommonConst.NAM_OVER_TIME + CommonConst.NAM_WARNING + CommonConst.NAM_COMMON_TIME + "("
				+ CommonConst.NAM_MONTHLY_OVER_TIME_60_HOUR + ")";
		NAM_CAUTION_MONTH_HOUR = CommonConst.NAM_MONTH + "60" + CommonConst.NAM_COMMON_TIME + CommonConst.NAM_OVER_TIME
				+ CommonConst.NAM_WARNING + CommonConst.NAM_COMMON_TIME + CommonConst.NAM_ROUND_BRACKETS_LEFT
				+ CommonConst.NAM_HOUR + CommonConst.NAM_ROUND_BRACKETS_RIGHT;
		NAM_CAUTION_MONTH_MIN = CommonConst.NAM_MONTH + "60" + CommonConst.NAM_COMMON_TIME + CommonConst.NAM_OVER_TIME
				+ CommonConst.NAM_WARNING + CommonConst.NAM_COMMON_TIME + CommonConst.NAM_ROUND_BRACKETS_LEFT
				+ CommonConst.NAM_MINUTES + CommonConst.NAM_ROUND_BRACKETS_RIGHT;
		NAM_OVER_TIME_RATE = CommonConst.NAM_WEEKDAY;
		NAM_MONTHLY_OVER_TIME_RATE = CommonConst.NAM_MONTHLY_OVER_TIME_60_HOUR;
		NAM_SUB_ACQUIRE_RATE = CommonConst.NAM_SUBSTITUTE_HOLIDAY + CommonConst.NAM_GET + "(" + CommonConst.NAM_WEEKDAY
				+ ")";
		NAM_SUB_ACQUIRE_HOLIDAY_RATE = CommonConst.NAM_SUBSTITUTE_HOLIDAY + CommonConst.NAM_GET + "("
				+ CommonConst.NAM_STANDARD_WEEK_HOLIDAY + ")";
		NAM_SUB_QUIT_RATE = CommonConst.NAM_SUBSTITUTE_HOLIDAY + CommonConst.NAM_DISCLAIMER;
		NAM_START_DATE = CommonConst.NAM_START_DATE;
		NAM_DELETE_FLAG = CommonConst.NAM_DELETE_FLAG;
		LEN_OVER_TIME_CODE = 10;
		LEN_WORK_TYPE_NAME = 20;
		LEN_CAUSE = 20;
		LEN_AGREE_TYPE = 0;
		LEN_LIMIT_CODE = 0;
		LEN_OVER_TIME_RATE = 3;
		LEN_CAUTION_MONTH_HOUR = 2;
		LEN_CAUTION_MONTH_MIN = 2;
		LEN_MONTHLY_OVER_TIME_RATE = 3;
		LEN_SUB_ACQUIRE_RATE = 3;
		LEN_SUB_ACQUIRE_HOLIDAY_RATE = 3;
		LEN_SUB_QUIT_RATE = 3;
	}
	
	/**
	 * lݒ
	 */
	public void setDefaultValues() {
		txtOverTimeCode = "";
		txtWorkTypeName = "";
		txtCause = "";
		pltAgreeType = "";
		pltLimitCode = "";
		txtOverTimeRate = "";
		txtCautionMonthHour = "";
		txtCautionMonthMin = "";
		txtMonthlyOverTimeRate = "";
		txtSubAcquireRate = "";
		txtSubAcquireHolidayRate = "";
		txtSubQuitRate = "";
		pltStartDateYear = "";
		pltStartDateMonth = "";
		pltStartDateDay = "";
		pltDeletFlag = "";
	}
	
	/**
	 * p[^ݒ
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		txtOverTimeCode = request.getParameter(PRM_TXT_OVER_TIME_CODE);
		txtWorkTypeName = request.getParameter(PRM_TXT_WORK_TYPE_NAME);
		txtCause = request.getParameter(PRM_TXT_CAUSE);
		pltAgreeType = request.getParameter(PRM_PLT_AGREE_TYPE);
		pltLimitCode = request.getParameter(PRM_PLT_LIMIT_CODE);
		txtOverTimeRate = request.getParameter(PRM_TXT_OVER_TIME_RATE);
		txtCautionMonthHour = request.getParameter(PRM_TXT_CAUTION_MONTH_HOUR);
		txtCautionMonthMin = request.getParameter(PRM_TXT_CAUTION_MONTH_MIN);
		txtMonthlyOverTimeRate = request.getParameter(PRM_TXT_MONTHLY_OVER_TIME_RATE);
		txtSubAcquireRate = request.getParameter(PRM_TXT_SUB_ACQUIRE_RATE);
		txtSubAcquireHolidayRate = request.getParameter(PRM_TXT_SUB_ACQUIRE_HOLIDAY_RATE);
		txtSubQuitRate = request.getParameter(PRM_TXT_SUB_QUIT_RATE);
		pltStartDateYear = request.getParameter(PRM_PLT_START_DATE_YEAR);
		pltStartDateMonth = request.getParameter(PRM_PLT_START_DATE_MONTH);
		pltStartDateDay = request.getParameter(PRM_PLT_START_DATE_DAY);
		pltDeletFlag = request.getParameter(PRM_PLT_DELETE_FLAG);
	}
	
	/**
	 * tB[hݒ
	 * @param dto ΏDTO
	 */
	public void setFields(CmAgreementOverTimeDto dto) {
		txtOverTimeCode = dto.getOverTimeCode();
		txtWorkTypeName = dto.getWorkTypeName();
		txtCause = dto.getCause();
		pltAgreeType = dto.getAgreeType();
		pltLimitCode = dto.getLimitCode();
		txtOverTimeRate = String.valueOf(dto.getOverTimeRate());
		txtCautionMonthHour = TimeUtil.convIntegerTimeToStringHour(dto.getCautionMonth());
		txtCautionMonthMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getCautionMonth());
		txtMonthlyOverTimeRate = String.valueOf(dto.getMonthlyOverTimeRate());
		txtSubAcquireRate = String.valueOf(dto.getSubAcquireRate());
		txtSubAcquireHolidayRate = String.valueOf(dto.getSubAcquireHolidayRate());
		txtSubQuitRate = String.valueOf(dto.getSubQuitRate());
		pltStartDateYear = String.valueOf(MospUtility.getYear(dto.getStartDate()));
		pltStartDateMonth = String.valueOf(MospUtility.getMonth(dto.getStartDate()));
		pltStartDateDay = String.valueOf(MospUtility.getDay(dto.getStartDate()));
		pltDeletFlag = String.valueOf(dto.getDeleteFlag());
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 * @throws MospException MosPOꍇ
	 */
	public void setDtoFields(CmAgreementOverTimeDto dto) throws MospException {
		dto.setOverTimeCode(txtOverTimeCode);
		dto.setWorkTypeName(txtWorkTypeName);
		dto.setCause(txtCause);
		dto.setAgreeType(pltAgreeType);
		dto.setLimitCode(pltLimitCode);
		dto.setOverTimeRate(Integer.parseInt(txtOverTimeRate));
		dto.setCautionMonth(TimeUtil.convStringTimeToIntegerTime(txtCautionMonthHour, txtCautionMonthMin));
		dto.setMonthlyOverTimeRate(Integer.parseInt(txtMonthlyOverTimeRate));
		dto.setSubAcquireRate(Integer.parseInt(txtSubAcquireRate));
		dto.setSubAcquireHolidayRate(Integer.parseInt(txtSubAcquireHolidayRate));
		dto.setSubQuitRate(Integer.parseInt(txtSubQuitRate));
		dto.setStartDate(DateUtil.getDate(pltStartDateYear, pltStartDateMonth, pltStartDateDay));
		dto.setDeleteFlag(Integer.parseInt(pltDeletFlag));
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtOverTimeCode, NAM_OVER_TIME_CODE, PRM_TXT_OVER_TIME_CODE);
		checkRequired(txtWorkTypeName, NAM_WORK_TYPE_NAME, PRM_TXT_WORK_TYPE_NAME);
		checkRequired(txtCause, NAM_CAUSE, PRM_TXT_CAUSE);
		checkRequired(String.valueOf(txtOverTimeRate), NAM_OVER_TIME_RATE, PRM_TXT_OVER_TIME_RATE);
		checkRequired(String.valueOf(txtCautionMonthHour), NAM_CAUTION_MONTH_HOUR, PRM_TXT_CAUTION_MONTH_HOUR);
		checkRequired(String.valueOf(txtCautionMonthMin), NAM_CAUTION_MONTH_MIN, PRM_TXT_CAUTION_MONTH_MIN);
		checkRequired(String.valueOf(pltLimitCode), NAM_LIMIT_CODE, PRM_PLT_LIMIT_CODE);
		checkRequired(String.valueOf(txtMonthlyOverTimeRate), NAM_MONTHLY_OVER_TIME_RATE,
				PRM_TXT_MONTHLY_OVER_TIME_RATE);
		checkRequired(String.valueOf(txtSubAcquireRate), NAM_SUB_ACQUIRE_RATE, PRM_TXT_SUB_ACQUIRE_RATE);
		checkRequired(String.valueOf(txtSubAcquireHolidayRate), NAM_SUB_ACQUIRE_HOLIDAY_RATE,
				PRM_TXT_SUB_ACQUIRE_HOLIDAY_RATE);
		checkRequired(String.valueOf(txtSubQuitRate), NAM_SUB_QUIT_RATE, PRM_TXT_SUB_QUIT_RATE);
		// ^CvmF
		checkCode(txtOverTimeCode, NAM_OVER_TIME_CODE, PRM_TXT_OVER_TIME_CODE);
		checkNumber(String.valueOf(txtCautionMonthHour), NAM_CAUTION_MONTH_HOUR, PRM_TXT_CAUTION_MONTH_HOUR);
		checkNumber(String.valueOf(txtCautionMonthMin), NAM_CAUTION_MONTH_MIN, PRM_TXT_CAUTION_MONTH_MIN);
		checkNumber(String.valueOf(txtMonthlyOverTimeRate), NAM_MONTHLY_OVER_TIME_RATE, PRM_TXT_MONTHLY_OVER_TIME_RATE);
		checkNumber(String.valueOf(txtSubAcquireHolidayRate), NAM_SUB_ACQUIRE_HOLIDAY_RATE,
				PRM_TXT_SUB_ACQUIRE_HOLIDAY_RATE);
		checkNumber(String.valueOf(txtSubQuitRate), NAM_SUB_QUIT_RATE, PRM_TXT_SUB_QUIT_RATE);
		// 񒷊mF
		checkLength(txtOverTimeCode, LEN_OVER_TIME_CODE, NAM_OVER_TIME_CODE, PRM_TXT_OVER_TIME_CODE);
		checkLength(txtWorkTypeName, LEN_WORK_TYPE_NAME, NAM_WORK_TYPE_NAME, PRM_TXT_WORK_TYPE_NAME);
		checkLength(txtCause, LEN_CAUSE, NAM_CAUSE, PRM_TXT_CAUSE);
		checkLength(String.valueOf(txtOverTimeRate), LEN_OVER_TIME_RATE, NAM_OVER_TIME_RATE, PRM_TXT_OVER_TIME_RATE);
		checkLength(String.valueOf(txtCautionMonthHour), LEN_CAUTION_MONTH_HOUR, NAM_CAUTION_MONTH_HOUR,
				PRM_TXT_CAUTION_MONTH_HOUR);
		checkLength(String.valueOf(txtCautionMonthMin), LEN_CAUTION_MONTH_MIN, NAM_CAUTION_MONTH_MIN,
				PRM_TXT_CAUTION_MONTH_MIN);
		checkLength(String.valueOf(txtMonthlyOverTimeRate), LEN_MONTHLY_OVER_TIME_RATE, NAM_MONTHLY_OVER_TIME_RATE,
				PRM_TXT_MONTHLY_OVER_TIME_RATE);
		checkLength(String.valueOf(txtSubAcquireRate), LEN_SUB_ACQUIRE_RATE, NAM_SUB_ACQUIRE_RATE,
				PRM_TXT_SUB_ACQUIRE_RATE);
		checkLength(String.valueOf(txtSubAcquireHolidayRate), LEN_SUB_ACQUIRE_HOLIDAY_RATE,
				NAM_SUB_ACQUIRE_HOLIDAY_RATE, PRM_TXT_SUB_ACQUIRE_HOLIDAY_RATE);
		checkLength(String.valueOf(txtSubQuitRate), LEN_SUB_QUIT_RATE, NAM_SUB_QUIT_RATE, PRM_TXT_SUB_QUIT_RATE);
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @return txtOverTimeCode
	 */
	public String getEscTxtOverTimeCode() {
		return escapeHTML(txtOverTimeCode);
	}
	
	/**
	 * @return txtWorkTypeName
	 */
	public String getEscTxtWorkTypeName() {
		return escapeHTML(txtWorkTypeName);
	}
	
	/**
	 * @return txtCause
	 */
	public String getEscTxtCause() {
		return escapeHTML(txtCause);
	}
	
	/**
	 * @return pltAgreeType
	 */
	public String getPltAgreeType() {
		return pltAgreeType;
	}
	
	/**
	 * @return pltLimitCode
	 */
	public String getPltLimitCode() {
		return pltLimitCode;
	}
	
	/**
	 * @return txtOverTimeRate
	 */
	public String getEscTxtOverTimeRate() {
		return escapeHTML(txtOverTimeRate);
	}
	
	/**
	 * @return txtCautionMonthHour
	 */
	public String getEscTxtCautionMonthHour() {
		return escapeHTML(txtCautionMonthHour);
	}
	
	/**
	 * @return txtCautionMonthMin
	 */
	public String getEscTxtCautionMonthMin() {
		return escapeHTML(txtCautionMonthMin);
	}
	
	/**
	 * @return txtMonthlyOverTimeRate
	 */
	public String getEscTxtMonthlyOverTimeRate() {
		return escapeHTML(txtMonthlyOverTimeRate);
	}
	
	/**
	 * @return txtSubAcquireRate
	 */
	public String getEscTxtSubAcquireRate() {
		return escapeHTML(txtSubAcquireRate);
	}
	
	/**
	 * @return txtSubAcquireHolidayRate
	 */
	public String getEscTxtSubAcquireHolidayRate() {
		return escapeHTML(txtSubAcquireHolidayRate);
	}
	
	/**
	 * @return txtSubQuitRate
	 */
	public String getEscTxtSubQuitRate() {
		return escapeHTML(txtSubQuitRate);
	}
	
	/**
	 * @return pltStartDateYear
	 */
	public String getPltStartDateYear() {
		return pltStartDateYear;
	}
	
	/**
	 * @return pltStartDateMonth
	 */
	public String getPltStartDateMonth() {
		return pltStartDateMonth;
	}
	
	/**
	 * @return pltStartDateDay
	 */
	public String getPltStartDateDay() {
		return pltStartDateDay;
	}
	
	/**
	 * @return pltDeletFlag
	 */
	public String getPltDeletFlag() {
		return pltDeletFlag;
	}
	
	/**
	 * @param txtOverTimeCode Zbg txtOverTimeCode
	 */
	public void setTxtOverTimeCode(String txtOverTimeCode) {
		this.txtOverTimeCode = txtOverTimeCode;
	}
	
	/**
	 * @param txtWorkTypeName Zbg txtWorkTypeName
	 */
	public void setTxtWorkTypeName(String txtWorkTypeName) {
		this.txtWorkTypeName = txtWorkTypeName;
	}
	
	/**
	 * @param txtCause Zbg txtCause
	 */
	public void setTxtCause(String txtCause) {
		this.txtCause = txtCause;
	}
	
	/**
	 * @param pltAgreeType Zbg pltAgreeType
	 */
	public void setPltAgreeType(String pltAgreeType) {
		this.pltAgreeType = pltAgreeType;
	}
	
	/**
	 * @param pltLimitCode Zbg pltLimitCode
	 */
	public void setTxtLimitCode(String pltLimitCode) {
		this.pltLimitCode = pltLimitCode;
	}
	
	/**
	 * @param txtOverTimeRate Zbg txtOverTimeRate
	 */
	public void setTxtOverTimeRate(String txtOverTimeRate) {
		this.txtOverTimeRate = txtOverTimeRate;
	}
	
	/**
	 * @param txtCautionMonthHour Zbg txtCautionMonthHour
	 */
	public void setTxtCautionMonthHour(String txtCautionMonthHour) {
		this.txtCautionMonthHour = txtCautionMonthHour;
	}
	
	/**
	 * @param txtCautionMonthMin Zbg txtCautionMonthMin
	 */
	public void setTxtCautionMonthMin(String txtCautionMonthMin) {
		this.txtCautionMonthMin = txtCautionMonthMin;
	}
	
	/**
	 * @param txtMonthlyOverTimeRate Zbg txtMonthlyOverTimeRate
	 */
	public void setTxtMonthlyOverTimeRate(String txtMonthlyOverTimeRate) {
		this.txtMonthlyOverTimeRate = txtMonthlyOverTimeRate;
	}
	
	/**
	 * @param txtSubAcquireRate Zbg txtSubAcquireRate
	 */
	public void setTxtSubAcquireRate(String txtSubAcquireRate) {
		this.txtSubAcquireRate = txtSubAcquireRate;
	}
	
	/**
	 * @param txtSubAcquireHolidayRate Zbg txtSubAcquireHolidayRate
	 */
	public void setTxtSubAcquireHolidayRate(String txtSubAcquireHolidayRate) {
		this.txtSubAcquireHolidayRate = txtSubAcquireHolidayRate;
	}
	
	/**
	 * @param txtSubQuitRate Zbg txtSubQuitRate
	 */
	public void setTxtSubQuitRate(String txtSubQuitRate) {
		this.txtSubQuitRate = txtSubQuitRate;
	}
	
	/**
	 * @param pltStartDateYear Zbg pltStartDateYear
	 */
	public void setPltStartDateYear(String pltStartDateYear) {
		this.pltStartDateYear = pltStartDateYear;
	}
	
	/**
	 * @param pltStartDateMonth Zbg pltStartDateMonth
	 */
	public void setPltStartDateMonth(String pltStartDateMonth) {
		this.pltStartDateMonth = pltStartDateMonth;
	}
	
	/**
	 * @param pltStartDateDay Zbg pltStartDateDay
	 */
	public void setPltStartDateDay(String pltStartDateDay) {
		this.pltStartDateDay = pltStartDateDay;
	}
	
	/**
	 * @param pltDeletFlag Zbg pltDeletFlag
	 */
	public void setPltDeletFlag(String pltDeletFlag) {
		this.pltDeletFlag = pltDeletFlag;
	}
	
}
