/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.report.action;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.PoiUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.kintai.common.action.AttendanceTotalAction;
import jp.mosp.kintai.common.part.KintaiCommonPart;
import jp.mosp.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.vo.AttendanceListVo;

import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.dom.spreadsheet.SpreadSheet;

/**
 * @author yoshida
 *
 */
public class AttendanceTableAction extends AttendanceTotalAction {
	
	// vOϐ
	/**
	 * Row(s) 0`
	 */
	private int					r					= 0;
	/**
	 * y[W
	 */
	private int					pageno				= 0;
	/**
	 * 1y[W̍ŏIs
	 */
	private static final int	END_PAGE_L			= 72;
	/**
	 * ׂ̉s
	 */
	private int					gyol				= 2;
	/**
	 * 1y[W̃^Cgʒu
	 */
	private int					titlel				= 3;
	/**
	 * 1y[W̖׊Jnʒu
	 */
	private int					firstl				= 7;
	/**
	 * 1y[W̍vs
	 */
	private static final int	TOTAL_L				= 69;
	private int					printcnt			= 0;
	
	// GNZEZԍ
	private static final int[]	CC					= { 1, 4, 6, 8, 13, 18, 23, 28, 33, 39, 43, 47, 51, 55, 61 };
	
	private int					workDays			= 0;
	private int					totalWork			= 0;
	private int					totalOver			= 0;
	private int					totalLateNight		= 0;
	private int					totalLate			= 0;
	private int					totalLeaveEarly		= 0;
	private int					totalHolidayWork	= 0;
	private int					totalBreak			= 0;
	private int					totalVacation		= 0;
	private int					totalSyokuji		= 0;
	private int					totalCyoku1			= 0;
	private int					totalCyoku2			= 0;
	private int					totalCyoku3			= 0;
	private int					totalHoka1			= 0;
	private int					totalHoka2			= 0;
	// ߑOxivj
	private int					totalSHankyu		= 0;
	// ߌ㔼xivj
	private int					totalTHankyu		= 0;
	
	// OpenDocumentp
	/**
	 * 1y[W̖׊Jnʒu
	 */
	private static final int	DETAIL_ROW			= 6;
	/**
	 * 1y[W̍vs
	 */
	private static final int	TOTAL_ROW			= 68;
	/**
	 * N
	 */
	private static final String	CELL_YEAR			= "H3";
	/**
	 * 
	 */
	private static final String	CELL_MONTH			= "M3";
	/**
	 * Ј
	 */
	private static final String	CELL_K_NAME			= "Y3";
	/**
	 * 
	 */
	private static final String	CELL_SECTION		= "AR3";
	/**
	 * Ώ۔N
	 */
	private Date				targetMonth;
	/**
	 * ΏێЈR[h
	 */
	private String				kCode;
	/**
	 * POI
	 */
	private PoiUtility			poi;
	/**
	 * V[g
	 */
	private Sheet				sheet;
	

	/**
	 * RXgN^
	 */
	public AttendanceTableAction() {
		super();
		setNeedProcSeq(false);
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// [ݒ
		StringBuffer fileName = new StringBuffer();
		fileName.append(DateUtil.convDateToStringYearMonth(targetMonth));
		fileName.append(CommonConst.FILE_NAME_SEPARATOR);
		fileName.append(kCode);
		fileName.append(CommonConst.FILE_NAME_SEPARATOR);
		// [쐬
		if (StringUtil.isNotNull(cfg.getProperty(CommonConst.PPT_KINTAI_USE_ODF))) {
			// t@C
			fileName.append(CommonConst.FILE_ATTENDANCE_TABLE_ODS);
			// ODS
			ods();
		} else {
			// t@C
			fileName.append(CommonConst.FILE_ATTENDANCE_TABLE);
			// XLS
			xls();
		}
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName.toString());
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new AttendanceListVo();
	}
	
	@Override
	protected void init() throws Exception {
		AttendanceListVo vo = (AttendanceListVo)getVo();
		// p[^擾
		vo.setParams(request);
		// \
		targetMonth = DateUtil.getYearMonth(vo.getPltYear(), vo.getPltMonth());
		// f[^擾
		kCode = request.getParameter(AttendanceListVo.PRM_HID_K_CODE);
	}
	
	/**
	 * Ζ\(ODS)쐬
	 * @throws Exception	Oꍇ
	 */
	private void ods() throws Exception {
		// ev[gt@C
		StringBuffer sb = new StringBuffer();
		sb.append(cfg.getProperty(MospConst.PPT_APP_DOCBASE));
		sb.append(CommonConst.TEMPLATE_M_KINMUHYO_ODS);
		// [쐬
		SpreadSheet ss = SpreadSheet.createFromFile(new File(sb.toString()));
		// V[g
		sheet = ss.getSheet(0);
		// N
		sheet.getCellAt(CELL_YEAR).setValue(MospUtility.getYear(targetMonth));
		// 
		sheet.getCellAt(CELL_MONTH).setValue(MospUtility.getMonth(targetMonth));
		// Ј
		sheet.getCellAt(CELL_K_NAME).setValue(getKName(kCode));
		// 
		sheet.getCellAt(CELL_SECTION).setValue(part().section().getBelongSectionName(kCode));
		// Wvf[^z쐬
		makeAttendance();
		// ׈
		printDetail();
		// v
		printTotal();
		// ODS
		request.setAttribute(MospConst.ATT_FILE_OBJECT, ss);
	}
	
	/**
	 * Ζ\(XLS)쐬
	 * @throws Exception	Oꍇ
	 */
	private void xls() throws Exception {
		// [쐬
		poi = new PoiUtility();
		poi.crtNewDocR(0, cfg.getProperty(MospConst.PPT_APP_DOCBASE) + CommonConst.TEMPLATE_M_KINMUHYO);
		// wb_[ݒ
		prtTitle();
		// Wvf[^z쐬
		makeAttendance();
		// f[^ݒ
		prtDetail();
		if (printcnt > 0) {
			// v
			prtTotal();
		}
		// XLS
		request.setAttribute(MospConst.ATT_FILE_OBJECT, poi.getWorkbook());
	}
	
	/**
	 * ^Cg\bh
	 * @throws Exception   	Oꍇ
	 */
	private void prtTitle() throws Exception {
		// y[W
		pageno += 1;
		// ^CgʒuZo
		r = (pageno - 1) * END_PAGE_L + (titlel - 1);
		// N
		poi.prtItem(r, 7, MospUtility.getYear(targetMonth));
		poi.prtItem(r, 12, MospUtility.getMonth(targetMonth));
		// 
		poi.prtItem(r, 24, getKName(kCode));
		// 
		final int ccNum = 43;
		poi.prtItem(r, ccNum, part().section().getBelongSectionName(kCode));
	}
	
	/**
	 * ׈\bh
	 * @throws Exception   	Oꍇ
	 */
	private void prtDetail() throws Exception {
		// ׈ʒuZo
		r = (pageno - 1) * END_PAGE_L + (firstl - 1 - gyol);
		// s
		r += gyol;
		// iڐݒ
		for (String[] element : aryAttendance) {
			// Ž
			poi.addMergedRegion(r, 8, r, 12);
			poi.addMergedRegion(r, 13, r, 17);
			poi.addMergedRegion(r, 18, r, 22);
			poi.addMergedRegion(r, 23, r, 27);
			poi.addMergedRegion(r, 28, r, 32);
			poi.addMergedRegion(r, 33, r, 38);
			poi.addMergedRegion(r, 39, r, 42);
			poi.addMergedRegion(r, 43, r, 46);
			poi.addMergedRegion(r, 47, r, 50);
			poi.addMergedRegion(r, 51, r, 54);
			poi.addMergedRegion(r, 55, r, 60);
			poi.addMergedRegion(r, 61, r, 67);
			
			poi.addMergedRegion(r + 1, 8, r + 1, 12);
			poi.addMergedRegion(r + 1, 13, r + 1, 17);
			poi.addMergedRegion(r + 1, 18, r + 1, 22);
			poi.addMergedRegion(r + 1, 23, r + 1, 27);
			poi.addMergedRegion(r + 1, 28, r + 1, 32);
			poi.addMergedRegion(r + 1, 33, r + 1, 38);
			poi.addMergedRegion(r + 1, 39, r + 1, 42);
			poi.addMergedRegion(r + 1, 43, r + 1, 46);
			poi.addMergedRegion(r + 1, 47, r + 1, 50);
			poi.addMergedRegion(r + 1, 51, r + 1, 54);
			poi.addMergedRegion(r + 1, 55, r + 1, 60);
			poi.addMergedRegion(r + 1, 61, r + 1, 67);
			// i
			poi.prtItem(r, CC[0], element[1]);
			poi.prtItem(r, CC[1], element[2]);
			poi.prtItem(r, CC[2], element[3]);
			poi.prtItem(r, CC[3], element[4]);
			poi.prtItem(r, CC[4], element[5]);
			poi.prtItem(r, CC[5], element[6]);
			poi.prtItem(r, CC[6], element[7]);
			poi.prtItem(r, CC[7], element[8]);
			poi.prtItem(r, CC[8], element[9]);
			poi.prtItem(r, CC[9], element[10]);
			poi.prtItem(r, CC[10], element[11]);
			poi.prtItem(r, CC[11], element[12]);
			poi.prtItem(r, CC[12], element[13]);
			poi.prtItem(r, CC[13], element[14]);
			poi.prtItem(r, CC[14], element[15]);
			// i
			poi.prtItem(r + 1, CC[3], element[16]);
			poi.prtItem(r + 1, CC[4], element[17]);
			poi.prtItem(r + 1, CC[5], element[18]);
			poi.prtItem(r + 1, CC[7], element[19]);
			poi.prtItem(r + 1, CC[8], element[20]);
			poi.prtItem(r + 1, CC[9], element[21]);
			poi.prtItem(r + 1, CC[10], element[22]);
			poi.prtItem(r + 1, CC[11], element[23]);
			poi.prtItem(r + 1, CC[12], element[24]);
			poi.prtItem(r + 1, CC[13], element[25]);
			r += 2;
			// ׈
			printcnt++;
		}
	}
	
	/**
	 * v\bh
	 * @throws Exception   	Oꍇ
	 */
	private void prtTotal() throws Exception {
		// vʒuZo
		r = (pageno - 1) * END_PAGE_L + (TOTAL_L - 1);
		poi.addMergedRegion(r, 8, r, 12);
		poi.addMergedRegion(r, 13, r, 17);
		poi.addMergedRegion(r, 18, r, 22);
		poi.addMergedRegion(r, 23, r, 27);
		poi.addMergedRegion(r, 28, r, 32);
		poi.addMergedRegion(r, 33, r, 38);
		poi.addMergedRegion(r, 39, r, 42);
		poi.addMergedRegion(r, 43, r, 46);
		poi.addMergedRegion(r, 47, r, 50);
		poi.addMergedRegion(r, 51, r, 54);
		poi.addMergedRegion(r, 55, r, 60);
		poi.addMergedRegion(r, 61, r, 67);
		poi.addMergedRegion(r + 1, 8, r + 1, 12);
		poi.addMergedRegion(r + 1, 13, r + 1, 17);
		poi.addMergedRegion(r + 1, 18, r + 1, 22);
		poi.addMergedRegion(r + 1, 23, r + 1, 27);
		poi.addMergedRegion(r + 1, 28, r + 1, 32);
		poi.addMergedRegion(r + 1, 33, r + 1, 38);
		poi.addMergedRegion(r + 1, 39, r + 1, 42);
		poi.addMergedRegion(r + 1, 43, r + 1, 46);
		poi.addMergedRegion(r + 1, 47, r + 1, 50);
		poi.addMergedRegion(r + 1, 51, r + 1, 54);
		poi.addMergedRegion(r + 1, 55, r + 1, 60);
		poi.addMergedRegion(r + 1, 61, r + 1, 67);
		// i
		poi.prtItem(r, CC[2], workDays);
		poi.prtItem(r, CC[4], getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalWork)));
		poi.prtItem(r, CC[5], getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalOver)));
		poi.prtItem(r, CC[6], getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalLateNight)));
		poi.prtItem(r, CC[7], getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalLate)));
		poi.prtItem(r, CC[9], totalSyokuji);
		poi.prtItem(r, CC[10], totalCyoku2);
		poi.prtItem(r, CC[11], totalHoka1);
		poi.prtItem(r, CC[12], totalSHankyu);
		poi.prtItem(r, CC[13], getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalVacation)));
		// i
		poi.prtItem(r + 1, CC[4], getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalBreak)));
		poi.prtItem(r + 1, CC[5], getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalHolidayWork)));
		poi.prtItem(r + 1, CC[7], getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalLeaveEarly)));
		poi.prtItem(r + 1, CC[9], totalCyoku1);
		poi.prtItem(r + 1, CC[10], totalCyoku3);
		poi.prtItem(r + 1, CC[11], totalHoka2);
		poi.prtItem(r + 1, CC[12], totalTHankyu);
		// ׈
		printcnt++;
	}
	
	/**
	 * ׈\bh
	 * @throws Exception   	Oꍇ
	 */
	private void printDetail() throws Exception {
		// ڐݒ
		int row = DETAIL_ROW;
		for (String[] element : aryAttendance) {
			// i
			sheet.getCellAt(CC[0], row).setValue(element[1]);
			sheet.getCellAt(CC[1], row).setValue(element[2]);
			sheet.getCellAt(CC[2], row).setValue(element[3]);
			sheet.getCellAt(CC[3], row).setValue(element[4]);
			sheet.getCellAt(CC[4], row).setValue(element[5]);
			sheet.getCellAt(CC[5], row).setValue(element[6]);
			sheet.getCellAt(CC[6], row).setValue(element[7]);
			sheet.getCellAt(CC[7], row).setValue(element[8]);
			sheet.getCellAt(CC[8], row).setValue(element[9]);
			sheet.getCellAt(CC[9], row).setValue(element[10]);
			sheet.getCellAt(CC[10], row).setValue(element[11]);
			sheet.getCellAt(CC[11], row).setValue(element[12]);
			sheet.getCellAt(CC[12], row).setValue(element[13]);
			sheet.getCellAt(CC[13], row).setValue(element[14]);
			sheet.getCellAt(CC[14], row).setValue(element[15]);
			// i
			int lower = row + 1;
			sheet.getCellAt(CC[3], lower).setValue(element[16]);
			sheet.getCellAt(CC[4], lower).setValue(element[17]);
			sheet.getCellAt(CC[5], lower).setValue(element[18]);
			sheet.getCellAt(CC[7], lower).setValue(element[19]);
			sheet.getCellAt(CC[8], lower).setValue(element[20]);
			sheet.getCellAt(CC[9], lower).setValue(element[21]);
			sheet.getCellAt(CC[10], lower).setValue(element[22]);
			sheet.getCellAt(CC[11], lower).setValue(element[23]);
			sheet.getCellAt(CC[12], lower).setValue(element[24]);
			sheet.getCellAt(CC[13], lower).setValue(element[25]);
			row += 2;
		}
	}
	
	/**
	 * v\bh
	 * @throws Exception   	Oꍇ
	 */
	private void printTotal() throws Exception {
		// i
		int upper = TOTAL_ROW;
		sheet.getCellAt(CC[2], upper).setValue(workDays);
		sheet.getCellAt(CC[4], upper).setValue(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalWork)));
		sheet.getCellAt(CC[5], upper).setValue(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalOver)));
		sheet.getCellAt(CC[6], upper).setValue(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalLateNight)));
		sheet.getCellAt(CC[7], upper).setValue(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalLate)));
		sheet.getCellAt(CC[9], upper).setValue(totalSyokuji);
		sheet.getCellAt(CC[10], upper).setValue(totalCyoku2);
		sheet.getCellAt(CC[11], upper).setValue(totalHoka1);
		sheet.getCellAt(CC[12], upper).setValue(totalSHankyu);
		sheet.getCellAt(CC[13], upper).setValue(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalVacation)));
		// i
		int lower = upper + 1;
		sheet.getCellAt(CC[4], lower).setValue(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalBreak)));
		sheet.getCellAt(CC[5], lower).setValue(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalHolidayWork)));
		sheet.getCellAt(CC[7], lower).setValue(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalLeaveEarly)));
		sheet.getCellAt(CC[9], lower).setValue(totalCyoku1);
		sheet.getCellAt(CC[10], lower).setValue(totalCyoku3);
		sheet.getCellAt(CC[11], lower).setValue(totalHoka2);
		sheet.getCellAt(CC[12], lower).setValue(totalTHankyu);
	}
	
	/**
	 * Wvf[^z쐬
	 * @throws Exception   	Oꍇ
	 */
	private void makeAttendance() throws Exception {
		// Αӌꗗf[^擾 
		getAttendanceList(kCode, targetMonth);
		// f[^擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(MospUtility.getDate(startDate));
		int count = 0;
		while (MospUtility.getDate(endDate).compareTo(cal.getTime()) >= 0) {
			cal.add(Calendar.DAY_OF_MONTH, 1);
			count++;
		}
		// z񏉊
		final int childSize = 40;
		aryAttendance = StringUtil.getBlankArray(count, childSize);
		// tݒ
		cal.setTime(MospUtility.getDate(startDate));
		for (int i = 0; i < aryAttendance.length; i++) {
			// tipj
			aryAttendance[i][0] = MospUtility.getDateString(cal.getTime(), CommonConst.FORMAT_DATE);
			// t
			aryAttendance[i][1] = String.valueOf(cal.get(Calendar.DAY_OF_MONTH));
			// j
			aryAttendance[i][2] = getDayOfWeek(cal.get(Calendar.DAY_OF_WEEK));
			cal.add(Calendar.DAY_OF_MONTH, 1);
		}
		// f[^̐ݒ
		Iterator<MSyukkinboDto> it = attendanceList.iterator();
		while (it.hasNext()) {
			cal.setTime(MospUtility.getDate(startDate));
			MSyukkinboDto dto = it.next();
			Date attendanceDate = MospUtility.getDate(dto.getHizuke());
			for (int i = 0; i < aryAttendance.length; i++) {
				if (attendanceDate.compareTo(cal.getTime()) == 0) {
					// Ζ`
					if (KintaiCommonPart.isAvailableWorkType(dto)) {
						aryAttendance[i][4] = dto.getSyJikoku();
						aryAttendance[i][5] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getKinmuJi()));
						aryAttendance[i][6] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getZaJikan()));
						aryAttendance[i][7] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getSnJikan()));
						aryAttendance[i][8] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getTiJikan()));
						aryAttendance[i][9] = part().mospcode().getTName(CommonConst.TID_LATE_REASON, dto.getTiRiyuu());
						aryAttendance[i][10] = String.valueOf(dto.getSyokuji());
						aryAttendance[i][11] = String.valueOf(dto.getCyoku2());
						aryAttendance[i][12] = String.valueOf(dto.getHoka1());
						aryAttendance[i][13] = dto.getSHankyuKb();
						aryAttendance[i][16] = dto.getTaJikoku();
						aryAttendance[i][17] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getKyukeiJi()));
						aryAttendance[i][18] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getKsJikan()));
						aryAttendance[i][19] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getSoJikan()));
						aryAttendance[i][20] = part().mospcode().getTName(CommonConst.TID_LEAVE_EARLY_REASON,
								dto.getSoRiyuu());
						aryAttendance[i][21] = String.valueOf(dto.getCyoku1());
						aryAttendance[i][22] = String.valueOf(dto.getCyoku3());
						aryAttendance[i][23] = String.valueOf(dto.getHoka2());
						aryAttendance[i][24] = dto.getTHankyuKb();
						totalWork += dto.getKinmuJi();
						totalOver += dto.getZaJikan();
						totalLateNight += dto.getSnJikan();
						totalLate += dto.getTiJikan();
						totalBreak += dto.getKyukeiJi();
						totalHolidayWork += dto.getKsJikan();
						totalLeaveEarly += dto.getSoJikan();
						totalSyokuji += dto.getSyokuji();
						totalCyoku1 += dto.getCyoku1();
						totalCyoku2 += dto.getCyoku2();
						totalCyoku3 += dto.getCyoku3();
						totalHoka1 += dto.getHoka1();
						totalHoka2 += dto.getHoka2();
						workDays++;
						if (KintaiCommonPart.isStartHalfHoliday(dto)) {
							totalSHankyu++;
						}
						if (KintaiCommonPart.isQuitHalfHoliday(dto)) {
							totalTHankyu++;
						}
					}
					// xɎ
					aryAttendance[i][14] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getKKJikan()));
					totalVacation += dto.getKKJikan();
					// Ζ`Ԗ
					String workTypeName = "";
					if (KintaiCommonPart.isOfficialHoliday(dto)) {
						// @x@x
						workTypeName = CommonConst.NAM_OFFICIAL_HOLIDAY_SHORT;
					} else if (KintaiCommonPart.isWeekHoliday(dto)) {
						// xx
						workTypeName = CommonConst.NAM_STANDARD_WEEK_HOLIDAY_SHORT;
					} else {
						workTypeName = part().worktype().getWorkTypeName(dto.getKinmu());
					}
					aryAttendance[i][3] = workTypeName;
					// xɗR
					aryAttendance[i][15] = part().mospcode().getHolidayName(dto.getKKRiyuu());
					// x[
					aryAttendance[i][25] = dto.getDaiKyuJyu();
					break;
				}
				cal.add(Calendar.DAY_OF_MONTH, 1);
			}
		}
	}
	
}
