/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.payroll.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.NumberUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.payroll.dao.KdSubstituteHolidayDao;
import jp.mosp.kintai.payroll.dto.KdSubstituteHolidayDto;
import jp.mosp.kintai.payroll.dto.KdWorkDto;
import jp.mosp.kintai.payroll.vo.SubHolidayAttitudeCardVo;

/**
 * @author matsusita
 *
 */
public class SubHolidayAttitudeCardAction extends KintaiCommonAction {
	
	// R}h
	/**
	 * 
	 */
	public static final String	CMD_ATTITUDE_CARD_SHOW		= "K1150";
	private static final String	CMD_ATTITUDE_CARD_DRAFT		= "K1152";
	private static final String	CMD_ATTITUDE_CARD_UPDATE	= "K1153";
	

	/**
	 * RXgN^
	 */
	public SubHolidayAttitudeCardAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_ATTITUDE_CARD_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_ATTITUDE_CARD_DRAFT)) {
			// 
			regist(true);
		} else if (cmd.equals(CMD_ATTITUDE_CARD_UPDATE)) {
			regist(false);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new SubHolidayAttitudeCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		SubHolidayAttitudeCardVo vo = (SubHolidayAttitudeCardVo)getVo();
		// [U[擾
		getInfo(user.getUserId());
		vo.aryPltAttitudeStatus = getAttitudeChoiceArray();
	}
	
	@Override
	protected void show() throws Exception {
		SubHolidayAttitudeCardVo vo = (SubHolidayAttitudeCardVo)getVo();
		// 
		vo.setDefaultValues();
		Date todayDate = DateUtil.getSystemDate();
		// Jg
		setLaborAgreementInfo(userBasis.getKCode(), todayDate);
		// DTȌ
		KdSubstituteHolidayDto dto = part().subHoliday().getCloseDate(userBasis.getKCode(), todayDate);
		if (VariousUtil.isNull(dto)) {
			// [hݒ
			vo.setMode(SubHolidayAttitudeCardVo.MODE_DISABLED);
			// bZ[Wݒ
			setMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		} else {
			vo.setFields(dto);
			if (dto.getPaymentAcquireTime() + dto.getPaymentAcquireHoliday() == 0) {
				// ֋xɎ擾ԊO + ֋xɎ擾xԊO0̏ꍇ
				vo.setPltAttitudeStatus(CommonConst.CODE_ATTITUDE_CHOICE_PREMIUM);
			} else if (dto.getPaymentQuitTime() == 0) {
				// ֋xɕԊO0̏ꍇ
				vo.setPltAttitudeStatus(CommonConst.CODE_ATTITUDE_CHOICE_SUBSTITUTE);
			} else {
				vo.setPltAttitudeStatus(CommonConst.CODE_ATTITUDE_CHOICE_COMBINATION);
			}
			if (VariousUtil.isNotNull(agreement)) {
				// Z
				double rate = Double.valueOf(agreement.getSubQuitRate() - agreement.getSubAcquireRate())
						/ CommonConst.NUM_PERCENTAGE;
				vo.setHidRate(NumberUtil.getNumberString(rate, 1, 2));
				// xZ
				double holidayRate = Double.valueOf(agreement.getSubQuitRate() - agreement.getSubAcquireHolidayRate())
						/ CommonConst.NUM_PERCENTAGE;
				vo.setHidHolidayRate(NumberUtil.getNumberString(holidayRate, 1, 2));
				KdWorkDto workDto = part().compile().getKdWorkInfo(userBasis.getKCode(), dto.getOccurYear(),
						dto.getOccurMonth());
				if (VariousUtil.isNotNull(workDto)) {
					int convertedOverTime = Double.valueOf(workDto.getMonthlyOverTime() * rate).intValue();
					int convertedWeekHoliday = Double.valueOf(workDto.getMonthlyWeekHoliday() * holidayRate).intValue();
					vo.setHidConvertedMonthlyOverTimeHour(TimeUtil.convIntegerTimeToStringHour(convertedOverTime));
					vo.setHidConvertedMonthlyOverTimeMin(TimeUtil.convIntegerTimeToStringMinutes(convertedOverTime));
					vo
						.setHidConvertedMonthlyWeekHolidayHour(TimeUtil
							.convIntegerTimeToStringHour(convertedWeekHoliday));
					vo.setHidConvertedMonthlyWeekHolidayMin(TimeUtil
						.convIntegerTimeToStringMinutes(convertedWeekHoliday));
				}
			}
			// [hݒ
			vo.setMode(SubHolidayAttitudeCardVo.MODE_POSSIBLE);
			// ZbVDTOZbg
			setSessionDto(dto);
		}
	}
	
	private void regist(boolean isDraft) throws Exception {
		// DTO̎擾
		KdSubstituteHolidayDto dto = (KdSubstituteHolidayDto)getSessionDto();
		SubHolidayAttitudeCardVo vo = (SubHolidayAttitudeCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// DTȌ
		vo.setDtoFields(dto);
		// f
		if (isDraft) {
			dto.setAttitudeStatus(CommonConst.CODE_ATTITUDE_STATUS_INIT);
		} else {
			// mFς݂֕ύX
			dto.setAttitudeStatus(CommonConst.CODE_ATTITUDE_STATUS_FIXED);
			// SĊ̏ꍇA擾ς݂֕ύXB
			if (CommonConst.CODE_ATTITUDE_CHOICE_PREMIUM.equals(vo.getPltAttitudeStatus())) {
				dto.setAcquisitionStatus(CommonConst.CODE_ACQUISITION_STATUS_FINISH);
			} else {
				dto.setAcquisitionStatus(CommonConst.CODE_ACQUISITION_STATUS_REMAIN);
			}
		}
		// DAȌ
		KdSubstituteHolidayDao dao = part().subHoliday().getKdSubstituteHolidayDao();
		// rmF
		chkExclusive(dto, dao.findForUpdate(dto.getSubstituteId()));
		// f[^̍XV
		dao.update(dto);
		// DTO̍Ď擾
		KdSubstituteHolidayDto retDto = dao.findForKey(dto.getSubstituteId());
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(SubHolidayAttitudeCardVo.MODE_POSSIBLE);
		// bZ[Wݒ
		setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
	private String[][] getAttitudeChoiceArray() {
		return new String[][]{ { CommonConst.CODE_ATTITUDE_CHOICE_PREMIUM, CommonConst.NAM_ATTITUDE_CHOICE_PREMIUM },
			{ CommonConst.CODE_ATTITUDE_CHOICE_COMBINATION, CommonConst.NAM_ATTITUDE_CHOICE_COMBINATION },
			{ CommonConst.CODE_ATTITUDE_CHOICE_SUBSTITUTE, CommonConst.NAM_ATTITUDE_CHOICE_SUBSTITUTE } };
	}
	
}
