/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.payroll.action;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.HumanBasisDtoInterface;
import jp.mosp.common.part.MosPCodePart;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.common.dto.MKihonDto;
import jp.mosp.kintai.payroll.vo.EmployeePaidHolidayListVo;

/**
 * @author yoshida
 *
 */
public class EmployeePaidHolidayListAction extends KintaiCommonAction {
	
	// R}h
	private static final String	CMD_LIST_SHOW		= "P1110";
	private static final String	CMD_LIST_SEARCH		= "P1111";
	private static final String	CMD_LIST_RE_SEARCH	= "P1112";
	private static final String	CMD_LIST_SORT		= "P1113";
	

	/**
	 * RXgN^
	 */
	public EmployeePaidHolidayListAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (CMD_LIST_SHOW.equals(cmd)) {
			// \
			show();
		} else if (CMD_LIST_SEARCH.equals(cmd)) {
			// 
			search();
		} else if (CMD_LIST_RE_SEARCH.equals(cmd)) {
			// Č
			research();
		} else if (CMD_LIST_SORT.equals(cmd)) {
			// \[g
			sortList(key1);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new EmployeePaidHolidayListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// RlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// [U[擾
		getInfo(user.getUserId());
		EmployeePaidHolidayListVo vo = (EmployeePaidHolidayListVo)getVo();
		vo.aryPltSection = getSectionArrayForHuman();
		vo.aryPltYear = StringUtil.getYearArray(MospUtility.getYear(getCalcPayment()));
		vo.aryPltMonth = StringUtil.getMonthArray();
	}
	
	@Override
	protected void show() throws Exception {
		EmployeePaidHolidayListVo vo = (EmployeePaidHolidayListVo)getVo();
		vo.setPltSection(userBasis.getSCode());
		Date calcPayment = getCalcPayment();
		vo.setPltYear(String.valueOf(MospUtility.getYear(calcPayment)));
		vo.setPltMonth(String.valueOf(MospUtility.getMonth(calcPayment)));
	}
	
	@Override
	protected void search() throws Exception {
		EmployeePaidHolidayListVo vo = (EmployeePaidHolidayListVo)getVo();
		vo.setParams(request);
		searchEmployeeList();
		vo.setFormerKey(vo.KEY_K_CODE);
		vo.setIsAscending(true);
		vo.initListInfo();
	}
	
	@Override
	protected void research() throws Exception {
		EmployeePaidHolidayListVo vo = (EmployeePaidHolidayListVo)getVo();
		removeSessionDto();
		if (StringUtil.isNotNull(vo.getPltSection())) {
			searchEmployeeList();
			vo.setPageButton();
			sortList();
		} else {
			vo.setPltSection(userBasis.getSCode());
		}
	}
	
	/**
	 * Јꗗ
	 * @throws Exception  Oꍇ
	 */
	private void searchEmployeeList() throws Exception {
		EmployeePaidHolidayListVo vo = (EmployeePaidHolidayListVo)getVo();
		// Wv擾
		Date targetDate = DateUtil.getYearMonth(vo.getPltYear(), vo.getPltMonth());
		List<MKihonDto> list = part().human().getMKihonDao().findForCondition(vo.getTxtKCode(), vo.getTxtKName(),
				vo.getPltSection(), userBasis.getJCode(), userBasis.getKCode(), user.getDataLevel(),
				DateUtil.convDateToInteger(getStartDate(targetDate)),
				DateUtil.convDateToInteger(getEndDate(targetDate)));
		// JڐR}h
		String btnCommand = PaidHolidayOldCardAction.CMD_CARD_SELECT;
		// J@{s̏ꍇB
		if (MosPCodePart.afterLegalReformDate(targetDate)) {
			btnCommand = PaidHolidayCardAction.CMD_CARD_SELECT;
		}
		// INݒB
		vo.setHidSelectYearMonth(DateUtil.convDateToStringYearMonthShort(targetDate));
		// AE擾
		for (MKihonDto dto : list) {
			dto.setSCode(getSectionName(dto.getSCode()));
			dto.setYCode(part().position().getPositionName(dto.getYCode(), dto.getTokyu()));
			// ƏR[hɑJڐR}hݒB
			dto.setJCode(btnCommand);
		}
		// VOݒ
		vo.setFields(list);
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryEmployee().length == 0) {
			addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	@Override
	protected void sortList(String key) throws Exception {
		EmployeePaidHolidayListVo vo = (EmployeePaidHolidayListVo)getVo();
		vo.sortList(key, getComparator(key));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected void sortList() throws Exception {
		EmployeePaidHolidayListVo vo = (EmployeePaidHolidayListVo)getVo();
		vo.sortList(getComparator(vo.getFormerKey()));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		EmployeePaidHolidayListVo vo = (EmployeePaidHolidayListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_K_CODE)) {
			comp = new CompKCode();
		} else if (key.equals(vo.KEY_K_NAME)) {
			comp = new CompKName();
		} else if (key.equals(vo.KEY_SECTION)) {
			comp = new CompSection();
		} else if (key.equals(vo.KEY_POSITION)) {
			comp = new CompPosition();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * ЈR[hɂrNX
	 * @author yoshida
	 *
	 */
	protected static class CompKCode implements Comparator<Object>, Serializable {
		
		/**
		 * 
		 */
		private static final long	serialVersionUID	= -1581340681339890095L;
		

		public int compare(Object obj1, Object obj2) {
			HumanBasisDtoInterface dto1 = (HumanBasisDtoInterface)obj1;
			HumanBasisDtoInterface dto2 = (HumanBasisDtoInterface)obj2;
			return dto1.getKCode().compareTo(dto2.getKCode());
		}
	}
	
	/**
	 * ЈɂrNX
	 * @author yoshida
	 *
	 */
	protected static class CompKName implements Comparator<Object>, Serializable {
		
		/**
		 * 
		 */
		private static final long	serialVersionUID	= 3897086338946016564L;
		

		public int compare(Object obj1, Object obj2) {
			HumanBasisDtoInterface dto1 = (HumanBasisDtoInterface)obj1;
			HumanBasisDtoInterface dto2 = (HumanBasisDtoInterface)obj2;
			return dto1.getSimei().compareTo(dto2.getSimei());
		}
	}
	
	/**
	 * ɂrNX
	 * @author yoshida
	 *
	 */
	protected static class CompSection implements Comparator<Object>, Serializable {
		
		/**
		 * 
		 */
		private static final long	serialVersionUID	= 909429646691581747L;
		

		public int compare(Object obj1, Object obj2) {
			HumanBasisDtoInterface dto1 = (HumanBasisDtoInterface)obj1;
			HumanBasisDtoInterface dto2 = (HumanBasisDtoInterface)obj2;
			return dto1.getSCode().compareTo(dto2.getSCode());
		}
	}
	
	/**
	 * EʂɂrNX
	 * @author yoshida
	 *
	 */
	protected static class CompPosition implements Comparator<Object>, Serializable {
		
		/**
		 * 
		 */
		private static final long	serialVersionUID	= -3277992757191523836L;
		

		public int compare(Object obj1, Object obj2) {
			HumanBasisDtoInterface dto1 = (HumanBasisDtoInterface)obj1;
			HumanBasisDtoInterface dto2 = (HumanBasisDtoInterface)obj2;
			return dto1.getYCode().compareTo(dto2.getYCode());
		}
	}
	
}
