/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.part;

import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.part.PartInfo;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.dao.CtWorkflowCommentDao;
import jp.mosp.kintai.common.dao.CtWorkflowDao;
import jp.mosp.kintai.common.dto.CtWorkflowCommentDto;
import jp.mosp.kintai.common.dto.CtWorkflowDto;

/**
 * [Nt[ɊւPartNX
 * @author yoshida
 *	@version	0.0.7
 */
public class WorkflowPart extends KintaiBasePart {
	
	/**
	 * RXgN^
	 */
	public WorkflowPart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo Part𗘗pۂɕKvȏ
	 */
	public WorkflowPart(PartInfo partInfo) {
		super(partInfo);
	}
	

	/**
	 * CtWorkflowDaoCX^X
	 */
	private CtWorkflowDao	workflowDao;
	

	/**
	 * [Nt[e[uDAO̎擾
	 * @return	ςCtWorkflowDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	public CtWorkflowDao getCtWorkflowDao() throws Exception {
		if (VariousUtil.isNull(workflowDao)) {
			workflowDao = (CtWorkflowDao)getPreparedDao(CtWorkflowDao.class.getCanonicalName());
		}
		return workflowDao;
	}
	

	/**
	 * CtWorkflowCommentDaoCX^X
	 */
	private CtWorkflowCommentDao	commentDao;
	

	/**
	 * [Nt[Rge[upDAO̎擾
	 * @since	0.0.2
	 * @return	ςCtWorkflowCommentDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	public CtWorkflowCommentDao getCtWorkflowCommentDao() throws Exception {
		if (VariousUtil.isNull(commentDao)) {
			commentDao = (CtWorkflowCommentDao)getPreparedDao(CtWorkflowCommentDao.class.getCanonicalName());
		}
		return commentDao;
	}
	
	/**
	 * Xe[^XR[hXg擾
	 * @return Xe[^XR[hXgz
	 * <p>
	 * [0]cFi\j
	 * [1]cF
	 * [2]cߒ
	 * [3]cF
	 * [4]c
	 * </p>
	 */
	public static String[] getStatusCodeArray() {
		// z̍쐬
		String[] aryStatus = new String[5];
		aryStatus[0] = CommonConst.CODE_REQUEST;
		aryStatus[1] = CommonConst.CODE_APPROVED;
		aryStatus[2] = CommonConst.CODE_RETURNED;
		aryStatus[3] = CommonConst.CODE_UNLOCK;
		aryStatus[4] = CommonConst.CODE_DRAFT;
		return aryStatus;
	}
	
	/**
	 * Xe[^XXg擾
	 * @return Xe[^XXgz
	 * <p>
	 * [0]cFi\j
	 * [1]cF
	 * [2]cߒ
	 * [3]cF
	 * [4]c
	 * </p>
	 */
	public static String[][] getStatusArray() {
		// z̍쐬
		String[][] aryStatus = new String[5][2];
		aryStatus[0][0] = getStatusCodeArray()[0];
		aryStatus[0][1] = CommonConst.NAM_REMAIN_APPROVED;
		aryStatus[1][0] = getStatusCodeArray()[1];
		aryStatus[1][1] = CommonConst.NAME_APPROVED;
		aryStatus[2][0] = getStatusCodeArray()[2];
		aryStatus[2][1] = CommonConst.NAME_RETURNED;
		aryStatus[3][0] = getStatusCodeArray()[3];
		aryStatus[3][1] = CommonConst.NAME_UNLOCK;
		aryStatus[4][0] = getStatusCodeArray()[4];
		aryStatus[4][1] = CommonConst.NAME_DRAFT;
		return aryStatus;
	}
	
	/**
	 * [Nt[擾
	 * @param workflow		[Nt[ԍ
	 * @return	(DTO)
	 * @throws Exception	Oꍇ
	 */
	public CtWorkflowDto getWorkflowDto(long workflow) throws Exception {
		return getCtWorkflowDao().findForKey(workflow);
	}
	
	/**
	 * F󋵃R[h擾
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return	F󋵃R[h
	 * @throws Exception 	Oꍇ
	 */
	public String getStatusCode(long workflow) throws Exception {
		return getStatusCode(getWorkflowDto(workflow));
	}
	
	/**
	 * F󋵃R[h擾
	 * @since	0.0.7
	 * @param dto	ΏDTO
	 * @return	F󋵃R[h
	 */
	public static String getStatusCode(CtWorkflowDto dto) {
		if (VariousUtil.isNotNull(dto)) {
			return dto.getCurrentStatus();
		}
		return "";
	}
	
	/**
	 * F󋵂̊mF
	 * @since	0.0.4
	 * @param code		ΏۃR[h
	 * @return	F󋵂̐
	 */
	public static boolean isRequest(String code) {
		return getStatusCodeArray()[0].equals(code);
	}
	
	/**
	 * F󋵂̊mF
	 * @since	0.0.7
	 * @param dto	ΏDTO
	 * @return	F󋵂̐
	 */
	public static boolean isStatusRequest(CtWorkflowDto dto) {
		return isRequest(getStatusCode(dto));
	}
	
	/**
	 * F󋵂̊mF
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return	F󋵂̐
	 * @throws Exception 	Oꍇ
	 */
	public boolean isStatusRequest(long workflow) throws Exception {
		return isRequest(getStatusCode(workflow));
	}
	
	/**
	 * Fςݏ󋵂̊mF
	 * @since	0.0.4
	 * @param code		ΏۃR[h
	 * @return	Fςݏ󋵂̐
	 */
	public static boolean isApproved(String code) {
		return getStatusCodeArray()[1].equals(code);
	}
	
	/**
	 * Fςݏ󋵂̊mF
	 * @since	0.0.7
	 * @param dto	ΏDTO
	 * @return	Fςݏ󋵂̐
	 */
	public static boolean isStatusApproved(CtWorkflowDto dto) {
		return isApproved(getStatusCode(dto));
	}
	
	/**
	 * Fςݏ󋵂̊mF
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return	Fςݏ󋵂̐
	 * @throws Exception 	Oꍇ
	 */
	public boolean isStatusApproved(long workflow) throws Exception {
		return isApproved(getStatusCode(workflow));
	}
	
	/**
	 * ߏ󋵂̊mF
	 * @since	0.0.4
	 * @param code		ΏۃR[h
	 * @return	ߏ󋵂̐
	 */
	public static boolean isReturned(String code) {
		return getStatusCodeArray()[2].equals(code);
	}
	
	/**
	 * ߏ󋵂̊mF
	 * @param workflow 	[Nt[ԍ
	 * @return	ߏ󋵂̐
	 * @throws Exception 	Oꍇ
	 */
	public boolean isStatusReturned(long workflow) throws Exception {
		return isReturned(getStatusCode(workflow));
	}
	
	/**
	 * ߏ󋵂̊mF
	 * @since	0.0.7
	 * @param dto 	ΏDTO
	 * @return	ߏ󋵂̐
	 */
	public static boolean isStatusReturned(CtWorkflowDto dto) {
		return isReturned(getStatusCode(dto));
	}
	
	/**
	 * f
	 * @since	0.0.3
	 * @param code		ΏۃR[h
	 * @return	󋵂̐
	 */
	public static boolean isDraft(String code) {
		return getStatusCodeArray()[4].equals(code);
	}
	
	/**
	 * 󋵂̊mF
	 * @since	0.0.3
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return	󋵂̐
	 * @throws Exception 	Oꍇ
	 */
	public boolean isStatusDraft(long workflow) throws Exception {
		return isDraft(getStatusCode(workflow));
	}
	
	/**
	 * 󋵂̊mF
	 * @since	0.0.7
	 * @param dto	ΏDTO
	 * @return	󋵂̐
	 */
	public static boolean isStatusDraft(CtWorkflowDto dto) {
		return isDraft(getStatusCode(dto));
	}
	
	/**
	 * FҌRg擾
	 * @since	0.0.2
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return				ŐṼRg
	 * @throws Exception	Oꍇ
	 */
	public CtWorkflowCommentDto getWorkflowCommentForApprover(long workflow) throws Exception {
		CtWorkflowCommentDto dto = new CtWorkflowCommentDto();
		CtWorkflowDto workflowDto = getWorkflowDto(workflow);
		if (VariousUtil.chkExistDto(workflowDto)) {
			dto = getCtWorkflowCommentDao().findForMaxApprover(workflowDto.getRtCode(), workflow);
		}
		return dto;
	}
	
	/**
	 * ΏێҌRg擾
	 * @since	0.0.2
	 * @param target		RgΏێЈR[h	
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return				ŐṼRg
	 * @throws Exception	Oꍇ
	 */
	public CtWorkflowCommentDto getWorkflowCommentForTarget(String target, long workflow) throws Exception {
		CtWorkflowCommentDto dto = new CtWorkflowCommentDto();
		if (VariousUtil.chkExistDto(getWorkflowDto(workflow))) {
			dto = getCtWorkflowCommentDao().findForMaxTarget(target, workflow);
		}
		return dto;
	}
	
	/**
	 * ΏێҌRgꗗ
	 * @since	0.0.2
	 * @param target		RgΏێЈR[h	
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return	Rgꗗ	ŐṼRg珇ɐ
	 * @throws Exception	Oꍇ
	 */
	public List<CtWorkflowCommentDto> getWorkflowCommentListForTarget(String target, long workflow) throws Exception {
		List<CtWorkflowCommentDto> listComment = new ArrayList<CtWorkflowCommentDto>();
		if (VariousUtil.chkExistDto(getWorkflowDto(workflow))) {
			listComment = getCtWorkflowCommentDao().findForTarget(target, workflow);
		}
		return listComment;
	}
	
	/**
	 * Rgꗗz
	 * @since	0.0.2
	 * @param target		RgΏێЈR[h	
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return				Rgꗗz
	 * @throws Exception	Oꍇ
	 */
	public String[][] getWorkflowCommentArray(String target, long workflow) throws Exception {
		List<CtWorkflowCommentDto> list = getWorkflowCommentListForTarget(target, workflow);
		String[][] aryComments = new String[list.size()][2];
		for (int i = 0; i < aryComments.length; i++) {
			CtWorkflowCommentDto dto = list.get(i);
			aryComments[i][0] = part().human().getKName(dto.getKCode());
			aryComments[i][1] = dto.getAuthorComment();
		}
		return aryComments;
	}
	
	/**
	 * ΑӏFXe[^XR[h擾
	 * @since	0.0.3
	 * @param workflow			Ώۃ[Nt[ԍ
	 * @return	ΑӏFXe[^XR[h
	 * @throws Exception	Oꍇ
	 */
	public String toKintaiApprovalStatus(long workflow) throws Exception {
		String status = "";
		CtWorkflowDto dto = getWorkflowDto(workflow);
		if (isStatusDraft(dto)) {
			// 
			status = getStatusCodeArray()[4];
		} else if (isStatusRequest(dto)) {
			// Fi\j
			status = VariousUtil.getApprovalStatusCodeArray()[0];
		} else if (isStatus1stApproved(dto)) {
			// ꎟF
			status = VariousUtil.getApprovalStatusCodeArray()[1];
		} else if (isStatus1stReturned(dto)) {
			// ꎟ
			status = VariousUtil.getApprovalStatusCodeArray()[2];
		} else if (isStatusLastApproved(dto)) {
			// 񎟏F
			status = VariousUtil.getApprovalStatusCodeArray()[3];
		} else if (isStatusLastReturned(dto)) {
			// 񎟍
			status = VariousUtil.getApprovalStatusCodeArray()[4];
		}
		return status;
	}
	
	/**
	 * FKw擾
	 * @since	0.0.5
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return	FKw
	 * @throws Exception	Oꍇ
	 */
	public int getWorkflowLayer(long workflow) throws Exception {
		return getWorkflowLayer(getWorkflowDto(workflow));
	}
	
	/**
	 * FKw擾
	 * @since	0.0.7
	 * @param dto	ΏDTO
	 * @return	FKw
	 */
	public static int getWorkflowLayer(CtWorkflowDto dto) {
		if (VariousUtil.isNotNull(dto)) {
			return dto.getLayerNumber();
		}
		return 0;
	}
	
	/**
	 * FKwiKグAFς݂֕ύX
	 * @since	0.0.6
	 * @param dto	ΏDTO
	 */
	public static void shiftApproved(CtWorkflowDto dto) {
		dto.setCurrentStatus(WorkflowPart.getStatusCodeArray()[1]);
		int layer = dto.getLayerNumber();
		if (!isLastLayer(dto)) {
			layer++;
			dto.setLayerNumber(layer);
		}
	}
	
	/**
	 * ŏIFς݂֕ύX
	 * @since	0.0.6
	 * @param dto	ΏDTO
	 */
	public static void shiftLastApproved(CtWorkflowDto dto) {
		dto.setCurrentStatus(WorkflowPart.getStatusCodeArray()[1]);
		dto.setLayerNumber(CommonConst.NUM_LAST_LAYER);
	}
	
	/**
	 * FKwiKグAFς݂֕ύX
	 * @since	0.0.6
	 * @param dto	ΏDTO
	 */
	public static void shiftReturned(CtWorkflowDto dto) {
		dto.setCurrentStatus(WorkflowPart.getStatusCodeArray()[2]);
		int layer = dto.getLayerNumber();
		if (!isLastLayer(dto)) {
			layer++;
			dto.setLayerNumber(layer);
		}
	}
	
	/**
	 * ŏI߂֕ύX
	 * @since	0.0.6
	 * @param dto	ΏDTO
	 */
	public static void shiftLastReturned(CtWorkflowDto dto) {
		dto.setCurrentStatus(WorkflowPart.getStatusCodeArray()[2]);
		dto.setLayerNumber(CommonConst.NUM_LAST_LAYER);
	}
	
	/**
	 * ꎟFf
	 * @since	0.0.7
	 * @param dto	ΏDTO
	 * @return	ꎟF̏ꍇtrueAłȂfalse
	 */
	public static boolean isStatus1stApproved(CtWorkflowDto dto) {
		if (isStatusApproved(dto)) {
			return is1stLayer(dto);
		}
		return false;
	}
	
	/**
	 * ꎟFf
	 * @since	0.0.7
	 * @param workflow 	[Nt[ԍ
	 * @return	ꎟF̏ꍇtrueAłȂfalse
	 * @throws Exception	Oꍇ
	 */
	public boolean isStatus1stApproved(long workflow) throws Exception {
		return isStatus1stApproved(getWorkflowDto(workflow));
	}
	
	/**
	 * ꎟߔf
	 * @since	0.0.7
	 * @param dto	ΏDTO
	 * @return	ꎟ߂̏ꍇtrueAłȂfalse
	 */
	public static boolean isStatus1stReturned(CtWorkflowDto dto) {
		if (isStatusReturned(dto)) {
			return is1stLayer(dto);
		}
		return false;
	}
	
	/**
	 * ꎟߔf
	 * @since	0.0.7
	 * @param workflow 	[Nt[ԍ
	 * @return	ꎟ߂̏ꍇtrueAłȂfalse
	 * @throws Exception	Oꍇ
	 */
	public boolean isStatus1stReturned(long workflow) throws Exception {
		return isStatus1stReturned(getWorkflowDto(workflow));
	}
	
	/**
	 * ŏIFf
	 * @since	0.0.7
	 * @param dto	ΏDTO
	 * @return	ŏIF̏ꍇtrueAłȂfalse
	 */
	public static boolean isStatusLastApproved(CtWorkflowDto dto) {
		if (isStatusApproved(dto)) {
			return isLastLayer(dto);
		}
		return false;
	}
	
	/**
	 * ŏIFf
	 * @since	0.0.7
	 * @param workflow 	[Nt[ԍ
	 * @return	ŏIF̏ꍇtrueAłȂfalse
	 * @throws Exception	Oꍇ
	 */
	public boolean isStatusLastApproved(long workflow) throws Exception {
		return isStatusLastApproved(getWorkflowDto(workflow));
	}
	
	/**
	 * ŏIߔf
	 * @since	0.0.7
	 * @param dto	ΏDTO
	 * @return	ŏI߂̏ꍇtrueAłȂfalse
	 */
	public static boolean isStatusLastReturned(CtWorkflowDto dto) {
		if (isStatusReturned(dto)) {
			return isLastLayer(dto);
		}
		return false;
	}
	
	/**
	 * ŏIߔf
	 * @since	0.0.7
	 * @param workflow 	[Nt[ԍ
	 * @return	ŏI߂̏ꍇtrueAłȂfalse
	 * @throws Exception	Oꍇ
	 */
	public boolean isStatusLastReturned(long workflow) throws Exception {
		return isStatusLastReturned(getWorkflowDto(workflow));
	}
	
	/**
	 * \FKwf
	 * @since	0.0.7
	 * @param dto	ΏDTO
	 * @return	\FKw̏ꍇtrueAłȂꍇfalse
	 */
	public static boolean isRequestLayer(CtWorkflowDto dto) {
		return CommonConst.NUM_REQUEST_LAYER == getWorkflowLayer(dto);
	}
	
	/**
	 * ꎟFKwf
	 * @since	0.0.7
	 * @param dto	ΏDTO
	 * @return	ꎟFKw̏ꍇtrueAłȂꍇfalse
	 */
	public static boolean is1stLayer(CtWorkflowDto dto) {
		return CommonConst.NUM_LAYER1 == getWorkflowLayer(dto);
	}
	
	/**
	 * ŏIFKwf
	 * @since	0.0.7
	 * @param dto	ΏDTO
	 * @return	ŏIFKw̏ꍇtrueAłȂꍇfalse
	 */
	public static boolean isLastLayer(CtWorkflowDto dto) {
		return CommonConst.NUM_LAST_LAYER == getWorkflowLayer(dto);
	}
	
}
