/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.common.part;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.part.BasePart;
import jp.mosp.common.part.PartInfo;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.NumberUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.legal.LegalConst;
import jp.mosp.mospcommon.system.AgreementBaseInfo;
import jp.mosp.mospcommon.system.LaborAgreementManager;

/**
 * JgɊւPartNX
 * @author yoshida
 *	@version 0.0.1
 */
public class LaborAgreementPart extends BasePart {
	
	/**
	 * RXgN^
	 */
	public LaborAgreementPart() {
		super();
	}
	
	/**
	 * @param partInfo	Part𗘗pۂɕKvȏ
	 */
	public LaborAgreementPart(PartInfo partInfo) {
		super(partInfo);
	}
	

	private LaborAgreementManager	manager;
	

	/**
	 * JgǗNX擾B
	 * @return agreement JgǗNXCX^X
	 */
	public LaborAgreementManager getManager() {
		if (VariousUtil.isNull(manager)) {
			manager = new LaborAgreementManager(cfg, cmd, aspUser, user, conn);
		}
		return manager;
	}
	
	/**
	 * Jg擾B
	 * @param targetCode ΏۃR[h
	 * @param targetDate 	Ώ۔N
	 * @return Jg
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public AgreementBaseInfo getUserLaborAgreement(String targetCode, Date targetDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		return getManager().getAgreementInfo(targetCode, targetDate);
	}
	
	/**
	 * @xj擾B
	 * @param info Jg
	 * @return @xj
	 */
	public static int getOfficialHoliday(AgreementBaseInfo info) {
		if (VariousUtil.isNotNull(info)) {
			return NumberUtil.getIntParam(info.getOfficialHoliday());
		}
		return 0;
	}
	
	/**
	 * xj擾B
	 * @param info Jg
	 * @return xj
	 */
	public static int[] getWeekHolidayArray(AgreementBaseInfo info) {
		int[] aryWeekHoliday = new int[0];
		if (VariousUtil.isNotNull(info)) {
			String[] array = StringUtil.divideByComma(info.getStandardWeekHoliday());
			aryWeekHoliday = new int[array.length];
			for (int i = 0; i < aryWeekHoliday.length; i++) {
				aryWeekHoliday[i] = 0;
				if (array[i].length() != 0) {
					aryWeekHoliday[i] = Integer.parseInt(array[i]);
				}
			}
		}
		return aryWeekHoliday;
	}
	
	/**
	 * Ԑݒ擾B
	 * @param info Jg
	 * @return 
	 * <p>
	 * [0]cA[1]cԎ
	 * </p>
	 * @throws Exception  Oꍇ
	 */
	public String[] getTermTypeInfo(AgreementBaseInfo info) throws Exception {
		String code = "";
		if (VariousUtil.isNotNull(info)) {
			code = part().mospcode().findTchange(CommonConst.TID_LIMIT_STANDARD_TERM, info.getTermType());
		}
		return StringUtil.divideByComma(code);
	}
	
	/**
	 * ԓJnNXg擾B
	 * @param termStartDate ԊJnN
	 * @param info Jg
	 * @return ԊJnNXg
	 * <p>
	 * [0]cJnA[1]cI̔z̃Xg
	 * </p>
	 * @throws Exception  Oꍇ
	 */
	public List<Date[]> getUserTermList(Date termStartDate, AgreementBaseInfo info) throws Exception {
		List<Date[]> list = new ArrayList<Date[]>();
		String[] aryCode = getTermTypeInfo(info);
		Date startDate = termStartDate;
		Date endDate = null;
		Date termEndDate = DateUtil.addDay(DateUtil.addYear(termStartDate, 1), -1);
		int round = 0;
		if (aryCode.length == 2) {
			int amount = NumberUtil.getIntParam(aryCode[0]);
			// TP
			if (CommonConst.TCHANGE_TERM_WEEK.equals(aryCode[1])) {
				round = Double
					.valueOf(Math.ceil(DateUtil.getDateRemainder(termEndDate, termStartDate) / (7d * amount)))
					.intValue();
				for (int i = 0; i < round; i++) {
					endDate = getTermEndDate(startDate, CommonConst.TCHANGE_TERM_WEEK, amount);
					if (i == round - 1) {
						endDate = termEndDate;
					}
					list.add(new Date[]{ startDate, endDate });
					startDate = DateUtil.addDay(endDate, 1);
				}
			}
			// P
			if (CommonConst.TCHANGE_TERM_MONTH.equals(aryCode[1])) {
				round = Double.valueOf(12d / amount).intValue();
				for (int i = 0; i < round; i++) {
					endDate = getTermEndDate(startDate, CommonConst.TCHANGE_TERM_MONTH, amount);
					list.add(new Date[]{ startDate, endDate });
					startDate = DateUtil.addDay(endDate, 1);
				}
			}
		}
		return list;
	}
	
	/**
	 * ԏI擾B
	 * @param startDate ԊJn
	 * @param termType Ԏ
	 * @param amount Z
	 * @return ԏI
	 * @throws Exception Oꍇ
	 */
	public static Date getTermEndDate(Date startDate, String termType, int amount) throws Exception {
		Date endDate = null;
		// TP
		if (CommonConst.TCHANGE_TERM_WEEK.equals(termType)) {
			endDate = DateUtil.addWeek(startDate, amount);
		}
		// P
		if (CommonConst.TCHANGE_TERM_MONTH.equals(termType)) {
			endDate = DateUtil.addMonth(startDate, amount);
		}
		return DateUtil.addDay(endDate, -1);
	}
	
	/**
	 * ̏jptO
	 * @param info Jg
	 * @return
	 * <p>
	 * ̏j𗘗pꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean useJapaneseHoliday(AgreementBaseInfo info) {
		if (VariousUtil.isNotNull(info)) {
			return StringUtil.isFlagOff(info.getJapaneseHolidayFlag());
		}
		return false;
	}
	
	/**
	 * jՓ}X^ptO
	 * @param info Jg
	 * @return
	 * <p>
	 * jՓ}X^𗘗pꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean userHolidayMaster(AgreementBaseInfo info) {
		if (VariousUtil.isNotNull(info)) {
			return StringUtil.isFlagOff(info.getHolidayMasterFlag());
		}
		return false;
	}
	
	/**
	 * @param targetDate Ώ۔N
	 * @param info Jg
	 * @return
	 * <p>
	 * Ώ۔Nx̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 * @throws Exception 	Oꍇ
	 */
	public boolean isStandardHoliday(Date targetDate, AgreementBaseInfo info) throws Exception {
		int dayOfWeek = DateUtil.getDayOfWeek(targetDate);
		int[] aryStandard = getWeekHolidayArray(info);
		for (int i : aryStandard) {
			if (i == dayOfWeek) {
				return true;
			}
		}
		return part().jpholiday().isStandardHoliday(targetDate, useJapaneseHoliday(info), userHolidayMaster(info));
	}
	
	/**
	 * @param targetDate Ώ۔N
	 * @param info Jg
	 * @return
	 * <p>
	 * Ώ۔N@x̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 */
	public static boolean isOfficialHoliday(Date targetDate, AgreementBaseInfo info) {
		return getOfficialHoliday(info) == DateUtil.getDayOfWeek(targetDate);
	}
	
	/**
	 * JԎ擾
	 * @param info Jg
	 * @return Jԁij
	 */
	public static int getPrescribedTime(AgreementBaseInfo info) {
		// @J
		int prescribedTime = LegalConst.LEGAL_HOURS_PER_DAY * CommonConst.NUM_1HOUR_MIN;
		if (VariousUtil.isNotNull(info)) {
			prescribedTime = info.getPrescribedTime();
		}
		return prescribedTime;
	}
	
}
