/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.action;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.ValidateUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.NumberUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.AttendanceTotalAction;
import jp.mosp.kintai.common.part.KintaiCommonPart;
import jp.mosp.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.vo.AttendanceListVo;
import jp.mosp.kintai.vo.EmployeeAttendanceListVo;

/**
 * @author yoshida
 *
 */
public class AttendanceListAction extends AttendanceTotalAction {
	
	// R}h
	private static final String	CMD_ATTENDANCE_LIST_SHOW		= "K1010";
	private static final String	CMD_ATTENDANCE_LIST_SELECT		= "K1011";
	private static final String	CMD_ATTENDANCE_LIST_SEARCH		= "K1012";
	/**
	 * Č
	 */
	public static final String	CMD_ATTENDANCE_LIST_RE_SEARCH	= "K1013";
	private static final String	CMD_ATTENDANCE_CARD_SELECT		= "K1014";
	

	/**
	 * RXgN^
	 */
	public AttendanceListAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_ATTENDANCE_LIST_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_ATTENDANCE_LIST_SELECT)) {
			// I
			select();
		} else if (cmd.equals(CMD_ATTENDANCE_LIST_SEARCH)) {
			// 
			search();
		} else if (cmd.equals(CMD_ATTENDANCE_LIST_RE_SEARCH)) {
			// Č
			research();
		} else if (cmd.equals(CMD_ATTENDANCE_CARD_SELECT)) {
			// 
			searchAttendance();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new AttendanceListVo();
	}
	
	@Override
	protected void init() throws Exception {
		AttendanceListVo vo = (AttendanceListVo)getVo();
		// [U[擾
		getInfo(user.getUserId());
		// ΑӊǗR}h
		if (VariousUtil.isNotNull(getStoredVo(EmployeeAttendanceListVo.class.getName()))) {
			// ԑJڊmF
			vo.setCmdMenuButton(CommonConst.CMD_MENU_MAMAGE);
			vo.setCmdListButton(EmployeeAttendanceListAction.CMD_EMPLOYEE_LIST_RE_SEARCH);
			vo.setNamListButton(CommonConst.TTL_EMPLOYEE_SELECT);
			// j[R}h̐ݒ
			vo.setAryMenu(true);
		} else {
			vo.setCmdMenuButton(CommonConst.CMD_MENU_INPUT);
			vo.setCmdListButton(CommonConst.CMD_MENU_INPUT);
			vo.setNamListButton(CommonConst.NAM_MENU);
			// j[R}h̐ݒ
			vo.setAryMenu(false);
		}
		// v_E擾
		vo.aryPltYear = StringUtil.getYearArray(MospUtility.getYear(DateUtil.getSystemDate()), 3, 1);
		vo.aryPltMonth = StringUtil.getMonthArray();
		// ΑӏF@\mF
		if (isAttendanceApprovalFunction()) {
			vo.setMode(AttendanceListVo.MODE_POSSIBLE);
		} else {
			vo.setMode(AttendanceListVo.MODE_IMPOSSIBLE);
		}
	}
	
	@Override
	protected void show() throws Exception {
		AttendanceListVo vo = (AttendanceListVo)getVo();
		// ΏێЈݒ
		vo.setSelectKCode(userBasis.getKCode());
		// \
		Date current = DateUtil.getSystemDate();
		// Ώ۔Nݒ
		vo.setPltYear(String.valueOf(MospUtility.getYear(current)));
		vo.setPltMonth(String.valueOf(MospUtility.getMonth(current)));
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		vo.setHidDay(String.valueOf(MospUtility.getDay(current)));
		// 
		searchAttendanceList();
	}
	
	@Override
	protected void select() throws Exception {
		AttendanceListVo vo = (AttendanceListVo)getVo();
		// ΏێЈݒ
		vo.setSelectKCode(key1);
		// \
		Date current = DateUtil.getSystemDate();
		// Ώ۔Nݒ
		vo.setPltYear(String.valueOf(MospUtility.getYear(current)));
		vo.setPltMonth(String.valueOf(MospUtility.getMonth(current)));
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		vo.setHidDay(String.valueOf(MospUtility.getDay(current)));
		// 
		searchAttendanceList();
	}
	
	@Override
	protected void search() throws Exception {
		AttendanceListVo vo = (AttendanceListVo)getVo();
		// Ώ۔Nݒ
		vo.setParams(request);
		// 
		searchAttendanceList();
	}
	
	@Override
	protected void research() throws Exception {
		removeSessionDto();
		AttendanceListVo vo = (AttendanceListVo)getVo();
		// ΏێЈݒ
		vo.setSelectKCode(request.getParameter(AttendanceListVo.PRM_HID_K_CODE));
		// Ώ۔Nݒ
		vo.setPltYear(request.getParameter(AttendanceListVo.PRM_HID_YEAR));
		vo.setPltMonth(request.getParameter(AttendanceListVo.PRM_HID_MONTH));
		vo.setHidDay(request.getParameter(AttendanceListVo.PRM_HID_DAY));
		// 
		searchAttendanceList();
	}
	
	/**
	 * Αӈꗗ
	 * @throws Exception	Oꍇ
	 */
	private void searchAttendanceList() throws Exception {
		AttendanceListVo vo = (AttendanceListVo)getVo();
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		// ΏۊԐݒ
		Date targetMonth;
		if (StringUtil.isNotNull(vo.getHidDay())) {
			int day = NumberUtil.getIntParam(vo.getHidDay());
			while (!ValidateUtility.chkDate(NumberUtil.getIntParam(vo.getPltYear()), NumberUtil.getIntParam(vo
				.getPltMonth()) - 1, day)) {
				// ݂Ȃt̏ꍇ1}CiX
				day--;
			}
			targetMonth = DateUtil.getDate(vo.getPltYear(), vo.getPltMonth(), String.valueOf(day));
		} else {
			targetMonth = DateUtil.getYearMonth(vo.getPltYear(), vo.getPltMonth());
		}
		// ΑӃf[^擾
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		getAttendanceListForView(vo.getSelectKCode(), targetMonth);
		// Jg擾
		setLaborAgreementInfo(vo.getSelectKCode(), DateUtil.convStringDateToDate(startDate));
		// Αӏݒ
		setCalcParam();
		// Wvf[^z쐬
		makeAttendanceArray(vo.getSelectKCode(), attendanceList);
		// Wv
		totalAttendanceDaily(vo.getSelectKCode(), attendanceList);
		// I̐ݒ
		setLabelBasisInfo(part().human().getBasisInfo(vo.getSelectKCode()));
		// FΎ蓖ݒ
		// E擾
		if (!part().position().isApplyAttendanceAllowance(vo.getSelectKCode())) {
			aryAttendanceCompile[17][1] = "";
		}
		// Wvf[^ƃx𕪗
		String[] aryLabel = new String[aryAttendanceCompile.length];
		String[] aryCompile = new String[aryAttendanceCompile.length];
		for (int i = 0; i < aryAttendanceCompile.length; i++) {
			aryLabel[i] = aryAttendanceCompile[i][0];
			aryCompile[i] = aryAttendanceCompile[i][1];
		}
		// VOݒ
		vo.setFields(aryAttendance, aryCompile, aryLabel);
	}
	
	/**
	 * Wvf[^z쐬
	 * @param kCode					ΏێЈR[h
	 * @param attendanceList		ΏۏoΕ냊Xg
	 * @throws Exception	Oꍇ
	 */
	private void makeAttendanceArray(String kCode, List<MSyukkinboDto> attendanceList) throws Exception {
		// f[^擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(MospUtility.getDate(startDate));
		int count = 0;
		while (MospUtility.getDate(endDate).compareTo(cal.getTime()) >= 0) {
			cal.add(Calendar.DAY_OF_MONTH, 1);
			count++;
		}
		// z񏉊
		final int childSize = 40;
		aryAttendance = StringUtil.getBlankArray(count, childSize);
		// tݒ
		cal.setTime(MospUtility.getDate(startDate));
		for (int i = 0; i < aryAttendance.length; i++) {
			// tipj
			aryAttendance[i][0] = DateUtil.convDateFormatted(cal.getTime());
			// tiM/dj
			aryAttendance[i][1] = DateUtil.convDateToMonthDayShort(cal.getTime());
			// j
			aryAttendance[i][2] = getDayOfWeek(cal.get(Calendar.DAY_OF_WEEK));
			// j̐F
			aryAttendance[i][17] = getDayOfWeekColorClass(cal.getTime());
			// lijՓAxj
			StringBuffer remark = new StringBuffer();
			String holidayName = getPublicHolidayName(cal.getTime());
			if (StringUtil.isNotNull(holidayName)) {
				remark.append(holidayName);
				remark.append(CommonConst.NAM_COMMON_HALF_KANA_SPACE);
			}
			aryAttendance[i][16] = remark.toString();
			// cƐ\
			if (part().overtime().isOverTimeRequest(kCode, cal.getTime())) {
				aryAttendance[i][16] += CommonConst.NAM_OVER_TIME_REQUEST_SHORT;
				aryAttendance[i][16] += CommonConst.NAM_COMMON_HALF_KANA_SPACE;
			}
			// xɐ\
			if (part().holidayRequest().existHolidayRequest(kCode, cal.getTime())) {
				aryAttendance[i][16] += CommonConst.NAM_HOLIDAY_REQUEST_SHORT;
				aryAttendance[i][16] += CommonConst.NAM_COMMON_HALF_KANA_SPACE;
			}
			cal.add(Calendar.DAY_OF_MONTH, 1);
		}
		// 1̎ԊO
		int overTimeMonthly = 0;
		// f[^̐ݒ
		for (MSyukkinboDto dto : attendanceList) {
			cal.setTime(MospUtility.getDate(startDate));
			Date attendanceDate = MospUtility.getDate(dto.getHizuke());
			for (int i = 0; i < aryAttendance.length; i++) {
				if (attendanceDate.compareTo(cal.getTime()) == 0) {
					// Ζ`
					String kinmuName = "";
					// o΂̏ꍇ
					if (KintaiCommonPart.isAvailableWorkType(dto)) {
						kinmuName = part().worktype().getWorkTypeName(dto.getKinmu());
						// oΎ
						aryAttendance[i][4] = dto.getSyJikoku();
						// ދΎ
						aryAttendance[i][5] = dto.getTaJikoku();
						// Ζ
						aryAttendance[i][6] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getKinmuJi()));
						// xe
						aryAttendance[i][7] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getKyukeiJi()));
						// x
						aryAttendance[i][8] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getTiJikan()));
						// ގ
						aryAttendance[i][9] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getSoJikan()));
						// cƎ
						aryAttendance[i][10] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getZaJikan()));
						// ԊOxΉ
						overTimeMonthly += dto.getZaJikan();
						String cssClass = "TimeTd";
						if (checkCautionOverTime(overTimeMonthly, 0)) {
							cssClass = CommonConst.CSS_CLASS_CAUTION_TD;
						}
						if (checkWarningOverTime(overTimeMonthly, 0)) {
							cssClass = CommonConst.CSS_CLASS_WARNING_TD;
						}
						aryAttendance[i][18] = cssClass;
						// xo
						aryAttendance[i][11] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getKsJikan()));
						// [鎞
						aryAttendance[i][12] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getSnJikan()));
					} else if (KintaiCommonPart.isWeekHoliday(dto) || KintaiCommonPart.isOfficialHoliday(dto)) {
						// TxxA@x\
						kinmuName = part().worktype().getWorkTypeName(dto.getKinmu());
					} else {
						// xɗR
						kinmuName = part().mospcode().getHolidayName(dto.getKKRiyuu());
					}
					aryAttendance[i][3] = kinmuName;
					// ꎟFA񎟏F
					String[] result = getApproval(dto.getSnRiyuu());
					aryAttendance[i][13] = result[0];
					aryAttendance[i][14] = result[1];
					// 蓖
					StringBuffer sb = new StringBuffer();
					sb.append(dto.getSyokuji());
					sb.append(CommonConst.STR_SLASH_SEPARATOR);
					sb.append(dto.getCyoku1());
					sb.append(dto.getCyoku2());
					sb.append(dto.getCyoku3());
					sb.append(CommonConst.STR_SLASH_SEPARATOR);
					sb.append(dto.getHoka1());
					sb.append(dto.getHoka2());
					sb.append(dto.getHoka3());
					sb.append(dto.getHoka4());
					sb.append(dto.getHoka5());
					aryAttendance[i][15] = sb.toString();
					// x
					if (KintaiCommonPart.isHalfHoliday(dto)) {
						aryAttendance[i][16] += CommonConst.NAM_VACATION_LEAVE_HALF;
						aryAttendance[i][16] += CommonConst.NAM_COMMON_HALF_KANA_SPACE;
					}
					// xo
					if (KintaiCommonPart.isWorkOnHoliday(dto)) {
						aryAttendance[i][16] += CommonConst.NAM_WORK_ON_HOLIDAY;
						aryAttendance[i][16] += CommonConst.NAM_COMMON_HALF_KANA_SPACE;
					}
					// ԊOx()
					if (KintaiCommonPart.isOverTimeSubHolidayHalf(dto)) {
						aryAttendance[i][16] += CommonConst.NAM_SUB_HOLIDAY_HALF;
						aryAttendance[i][16] += CommonConst.NAM_COMMON_HALF_KANA_SPACE;
					}
					break;
				}
				cal.add(Calendar.DAY_OF_MONTH, 1);
			}
		}
	}
	
}
