/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.human.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.dto.MKihonDto;

/**
 * @author yoshida
 *
 */
public class HumanKihonCardVo extends HumanCardVo {
	
	private static final long	serialVersionUID			= 4153484055869768269L;
	
	// p[^
	public static final String	PRM_TXT_K_CODE				= "txtKCode";
	public static final String	PRM_TXT_K_NAME				= "txtKName";
	public static final String	PRM_TXT_K_KANA				= "txtKKana";
	public static final String	PRM_PLT_OFFICE				= "pltOffice";
	public static final String	PRM_PLT_SECTION				= "pltSection";
	public static final String	PRM_PLT_POSITION			= "pltPosition";
	public static final String	PRM_PLT_RETIREMENT			= "pltRetirement";
	public static final String	PRM_PLT_ENTRANCE_YEAR		= "pltEntranceYear";
	public static final String	PRM_PLT_ENTRANCE_MONTH		= "pltEntranceMonth";
	public static final String	PRM_PLT_ENTRANCE_DAY		= "pltEntranceDay";
	public static final String	PRM_PLT_RETIREMENT_YEAR		= "pltRetirementYear";
	public static final String	PRM_PLT_RETIREMENT_MONTH	= "pltRetirementMonth";
	public static final String	PRM_PLT_RETIREMENT_DAY		= "pltRetirementDay";
	public static final String	PRM_TXT_E_MAIL				= "txtEMail";
	
	public static final String	PRM_HID_K_NAME				= "hidKName";
	public static final String	PRM_HID_K_KANA				= "hidKKana";
	public static final String	PRM_HID_OFFICE				= "hidOffice";
	public static final String	PRM_HID_SECTION				= "hidSection";
	public static final String	PRM_HID_POSITION			= "hidPosition";
	public static final String	PRM_HID_RETIREMENT			= "hidRetirement";
	public static final String	PRM_HID_ENTRANCE_YEAR		= "hidEntranceYear";
	public static final String	PRM_HID_ENTRANCE_MONTH		= "hidEntranceMonth";
	public static final String	PRM_HID_ENTRANCE_DAY		= "hidEntranceDay";
	public static final String	PRM_HID_RETIREMENT_YEAR		= "hidRetirementYear";
	public static final String	PRM_HID_RETIREMENT_MONTH	= "hidRetirementMonth";
	public static final String	PRM_HID_RETIREMENT_DAY		= "hidRetirementDay";
	public static final String	PRM_HID_E_MAIL				= "hidEMail";
	
	// tB[hyѐ
	public String				NAM_MAKE_NEW_DATA;
	public String				NAM_K_CODE;
	public String				NAM_K_NAME;
	public String				NAM_K_KANA;
	public String				NAM_OFFICE;
	public String				NAM_SECTION;
	public String				NAM_POSITION;
	public String				NAM_RETIREMENT_TYPE;
	public String				NAM_ENTRANCE_DATE;
	public String				NAM_RETIREMENT_DATE;
	public String				NAM_RETIREMENT_DATE_YEAR;
	public String				NAM_RETIREMENT_DATE_MONTH;
	public String				NAM_RETIREMENT_DATE_DAY;
	public String				NAM_E_MAIL;
	public int					LEN_K_CODE;
	public int					LEN_K_NAME;
	public int					LEN_K_KANA;
	public int					LEN_E_MAIL;
	
	// ҏW[htO
	public static final int		MODE_INSERT					= 0;
	public static final int		MODE_UPDATE					= 1;
	
	// ҏW[h
	public static final String	NAM_MODE_INSERT				= CommonConst.NAM_HU_MODE_INSERT;
	public static final String	NAM_MODE_UPDATE				= CommonConst.NAM_HU_MODE_UPDATE;
	
	// tB[h	
	private String				txtKCode;
	private String				txtKName;
	private String				txtKKana;
	private String				pltOffice;
	private String				pltSection;
	private String				pltPosition;
	private String				pltRetirement;
	private String				pltEntranceYear;
	private String				pltEntranceMonth;
	private String				pltEntranceDay;
	private String				pltRetirementYear;
	private String				pltRetirementMonth;
	private String				pltRetirementDay;
	private String				txtEMail;
	
	// tB[h(\̂)
	private String				lblOffice;
	private String				lblSection;
	private String				lblPosition;
	private String				lblRetirement;
	private String				lblEntranceDate;
	private String				lblRetirementDate;
	private String				lblEMail;
	
	// tB[h(ύXmFp)
	private String				hidKName;
	private String				hidKKana;
	private String				hidOffice;
	private String				hidSection;
	private String				hidPosition;
	private String				hidRetirement;
	private String				hidEntranceYear;
	private String				hidEntranceMonth;
	private String				hidEntranceDay;
	private String				hidRetirementYear;
	private String				hidRetirementMonth;
	private String				hidRetirementDay;
	private String				hidEMail;
	
	// ҏW[h(0FVKo^A1FXV)
	private int					mode;
	
	// v_EXg
	public String[][]			aryPltOfficeAll;
	public String[][]			aryPltOffice;
	public String[][]			aryPltSectionAll;
	public String[][]			aryPltSection;
	public String[][]			aryPltPositionAll;
	public String[][]			aryPltPosition;
	public String[][]			aryPltRetirement;
	public String[][]			aryPltYear;
	public String[][]			aryPltMonth;
	public String[][]			aryPltDay;
	

	/**
	 * RXgN^
	 */
	public HumanKihonCardVo() {
		super();
		setViewPath(getClassName());
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_HUMAN_KIHON;
		aryMenu = new String[][]{ { CMD_MENU_HUMAN, CommonConst.NAM_TO_MENU } };
	}
	
	@Override
	protected void setFieldsName() {
		super.setFieldsName();
		NAM_MAKE_NEW_DATA = CommonConst.NAM_MAKE_NEW_DATA;
		NAM_K_CODE = CommonConst.NAM_K_CODE;
		NAM_K_NAME = CommonConst.NAM_K_NAME;
		NAM_K_KANA = CommonConst.NAM_K_KANA;
		NAM_OFFICE = CommonConst.NAM_OFFICE;
		NAM_SECTION = CommonConst.NAM_STATION;
		NAM_POSITION = CommonConst.NAM_POSITION1;
		NAM_RETIREMENT_TYPE = CommonConst.NAM_RETIREMENT_TYPE;
		NAM_ENTRANCE_DATE = CommonConst.NAM_ENTRANCE_DATE;
		NAM_RETIREMENT_DATE = CommonConst.NAM_RETIREMENT_DATE;
		NAM_RETIREMENT_DATE_YEAR = NAM_RETIREMENT_DATE + CommonConst.MSG_YEAR;
		NAM_RETIREMENT_DATE_MONTH = NAM_RETIREMENT_DATE + CommonConst.MSG_MONTH;
		NAM_RETIREMENT_DATE_DAY = NAM_RETIREMENT_DATE + CommonConst.MSG_DAY;
		NAM_E_MAIL = CommonConst.NAM_EMAIL;
		LEN_K_CODE = CommonConst.LEN_K_CODE;
		LEN_K_NAME = CommonConst.LEN_K_NAME;
		LEN_K_KANA = CommonConst.LEN_K_NAME;
		LEN_E_MAIL = 50;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		super.setParams(request);
		if (request.getParameter(PRM_TXT_K_CODE) != null) {
			txtKCode = request.getParameter(PRM_TXT_K_CODE);
		} else {
			txtKCode = txtChangeKCode;
		}
		txtKName = request.getParameter(PRM_TXT_K_NAME);
		txtKKana = request.getParameter(PRM_TXT_K_KANA);
		pltOffice = request.getParameter(PRM_PLT_OFFICE);
		pltSection = request.getParameter(PRM_PLT_SECTION);
		pltPosition = request.getParameter(PRM_PLT_POSITION);
		pltRetirement = request.getParameter(PRM_PLT_RETIREMENT);
		pltEntranceYear = request.getParameter(PRM_PLT_ENTRANCE_YEAR);
		pltEntranceMonth = request.getParameter(PRM_PLT_ENTRANCE_MONTH);
		pltEntranceDay = request.getParameter(PRM_PLT_ENTRANCE_DAY);
		pltRetirementYear = request.getParameter(PRM_PLT_RETIREMENT_YEAR);
		pltRetirementMonth = request.getParameter(PRM_PLT_RETIREMENT_MONTH);
		pltRetirementDay = request.getParameter(PRM_PLT_RETIREMENT_DAY);
		txtEMail = request.getParameter(PRM_TXT_E_MAIL);
	}
	
	/**
	 * tB[hݒ
	 * @param dto	ΏDTO
	 * @throws MospException 	MosPOꍇ
	 */
	public void setFields(MKihonDto dto) throws MospException {
		// f[^̐ݒ
		txtKCode = dto.getKCode();
		txtKName = dto.getSimei();
		txtKKana = dto.getFurigana();
		pltOffice = dto.getJCode();
		pltSection = dto.getSCode();
		pltPosition = dto.getYCode() + CommonConst.STR_TIME_SEPARATOR + dto.getTokyu();
		pltRetirement = dto.getKnKubun();
		if (dto.getNyDate() > 0) {
			pltEntranceYear = DateUtil.convIntegerDateToArray(dto.getNyDate())[0];
			pltEntranceMonth = DateUtil.convIntegerDateToArray(dto.getNyDate())[1];
			pltEntranceDay = DateUtil.convIntegerDateToArray(dto.getNyDate())[2];
		}
		if (dto.getTsDate() > 0) {
			pltRetirementYear = DateUtil.convIntegerDateToArray(dto.getTsDate())[0];
			pltRetirementMonth = DateUtil.convIntegerDateToArray(dto.getTsDate())[1];
			pltRetirementDay = DateUtil.convIntegerDateToArray(dto.getTsDate())[2];
		}
		txtEMail = dto.getEmail();
		
		setLblKCode(dto.getKCode());
		setLblKName(dto.getSimei());
		lblKKana = dto.getFurigana();
		lblOffice = escapeHTML(getCodeName(dto.getJCode(), aryPltOfficeAll));
		lblSection = escapeHTML(getCodeName(dto.getSCode(), aryPltSectionAll));
		for (String[] element : aryPltPositionAll) {
			if (element[0].equals(dto.getYCode()) && element[2].equals(dto.getTokyu())) {
				lblPosition = escapeHTML(element[1]);
				break;
			}
		}
		lblRetirement = escapeHTML(getCodeName(dto.getKnKubun(), aryPltRetirement));
		if (dto.getNyDate() > 0) {
			lblEntranceDate = DateUtil.convIntegerDateToJPDate(dto.getNyDate());
		}
		if (dto.getTsDate() > 0) {
			lblRetirementDate = DateUtil.convIntegerDateToJPDate(dto.getTsDate());
		}
		lblEMail = dto.getEmail();
		
		hidKName = dto.getSimei();
		hidKKana = dto.getFurigana();
		hidOffice = dto.getJCode();
		hidSection = dto.getSCode();
		hidPosition = dto.getYCode() + CommonConst.STR_TIME_SEPARATOR + dto.getTokyu();
		hidRetirement = dto.getKnKubun();
		if (dto.getNyDate() > 0) {
			hidEntranceYear = DateUtil.convIntegerDateToArray(dto.getNyDate())[0];
			hidEntranceMonth = DateUtil.convIntegerDateToArray(dto.getNyDate())[1];
			hidEntranceDay = DateUtil.convIntegerDateToArray(dto.getNyDate())[2];
		}
		if (dto.getTsDate() > 0) {
			hidRetirementYear = DateUtil.convIntegerDateToArray(dto.getTsDate())[0];
			hidRetirementMonth = DateUtil.convIntegerDateToArray(dto.getTsDate())[1];
			hidRetirementDay = DateUtil.convIntegerDateToArray(dto.getTsDate())[2];
		}
		hidEMail = dto.getEmail();
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto	ΏDTO
	 */
	public void setDtoFields(MKihonDto dto) {
		dto.setKCode(txtKCode);
		dto.setSimei(txtKName);
		dto.setFurigana(txtKKana);
		dto.setSCode(pltSection);
		dto.setYCode(pltPosition.split(CommonConst.STR_TIME_SEPARATOR)[0]);
		if (pltPosition.endsWith(CommonConst.STR_TIME_SEPARATOR)) {
			dto.setTokyu("");
		} else {
			dto.setTokyu(pltPosition.split(CommonConst.STR_TIME_SEPARATOR)[1]);
		}
		dto.setJCode(pltOffice);
		/*						
		 *  	2009/07/02	m.yoshida	tϊΉ
		 */
		// Г
		if (StringUtil.isNull(pltEntranceYear) && StringUtil.isNull(pltEntranceMonth)
				&& StringUtil.isNull(pltEntranceDay)) {
			dto.setNyDate(0);
		} else {
			dto.setNyDate(DateUtil.convStringDateToInteger(pltEntranceYear, pltEntranceMonth, pltEntranceDay));
		}
		/*						
		 *  	2009/07/02	m.yoshida	tϊΉ
		 */
		// ގГ
		if (StringUtil.isNull(pltRetirementYear) && StringUtil.isNull(pltRetirementMonth)
				&& StringUtil.isNull(pltRetirementDay)) {
			dto.setTsDate(0);
		} else {
			dto.setTsDate(DateUtil.convStringDateToInteger(pltRetirementYear, pltRetirementMonth, pltRetirementDay));
		}
		dto.setKnKubun(pltRetirement);
		dto.setEmail(txtEMail);
		// ΑNij
		dto.setKinzoku(DateUtil.getMonthRemainder(DateUtil.getSystemDate(), DateUtil.getYearMonth(pltEntranceYear,
				pltEntranceMonth)));
		// VKo^̂m_kihoñftHglZbg
		if (mode == MODE_INSERT) {
			dto.setKyKubun("");
			dto.setTxKubun("1");
			dto.setTxKubunx("");
			dto.setKmKubun("1");
			dto.setPtKubun("1");
			dto.setShKubun("1");
			dto.setSiwakeCd("99999");
			dto.setHaigusya("0");
			dto.setFuyosu(0);
			dto.setYukyu(0);
			dto.setNenrei(0);
			dto.setKenpoNo("");
			dto.setKohoNo("");
			dto.setKUser("");
			dto.setPassw("");
			dto.setNinsyo("");
			dto.setDataLvl(0);
			dto.setProgLevel(0);
		}
	}
	
	@Override
	public void initFields() {
		super.initFields();
		txtKCode = "";
		txtKName = "";
		txtKKana = "";
		pltOffice = "";
		pltSection = "";
		pltPosition = "";
		pltRetirement = "";
		pltEntranceYear = "";
		pltEntranceMonth = "";
		pltEntranceDay = "";
		pltRetirementYear = "";
		pltRetirementMonth = "";
		pltRetirementDay = "";
		txtEMail = "";
		
		lblKKana = "";
		lblOffice = "";
		lblSection = "";
		lblPosition = "";
		lblRetirement = "";
		lblEntranceDate = "";
		lblRetirementDate = "";
		lblEMail = "";
		
		hidKName = "";
		hidKKana = "";
		hidOffice = "";
		hidSection = "";
		hidPosition = "";
		hidRetirement = "";
		hidEntranceYear = "";
		hidEntranceMonth = "";
		hidEntranceDay = "";
		hidRetirementYear = "";
		hidRetirementMonth = "";
		hidRetirementDay = "";
		hidEMail = "";
		
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException	MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtKCode, NAM_K_CODE, PRM_TXT_K_CODE);
		// R[hmF
		checkCode(txtKCode, NAM_K_CODE, PRM_TXT_K_CODE);
		// mF
		checkLength(txtKCode, LEN_K_CODE, NAM_K_CODE, PRM_TXT_K_CODE);
		checkLength(txtKName, LEN_K_NAME, NAM_K_NAME, PRM_TXT_K_NAME);
		checkLength(txtKKana, LEN_K_KANA, NAM_K_KANA, PRM_TXT_K_KANA);
		checkLength(txtEMail, LEN_E_MAIL, NAM_E_MAIL, PRM_TXT_E_MAIL);
		// tmF
		checkDate(getIntParam(pltEntranceYear), getIntParam(pltEntranceMonth), getIntParam(pltEntranceDay),
				NAM_ENTRANCE_DATE, PRM_PLT_ENTRANCE_YEAR);
		// ސE`FbN
		if (pltRetirement.equals(String.valueOf(CommonConst.RETIREMENT_FLAG_ON))) {
			checkDate(getIntParam(pltRetirementYear), getIntParam(pltRetirementMonth), getIntParam(pltRetirementDay),
					NAM_RETIREMENT_DATE, PRM_PLT_RETIREMENT_YEAR);
			checkDateBeforeAfter(getDate(pltEntranceYear, pltEntranceMonth, pltEntranceDay), getDate(pltRetirementYear,
					pltRetirementMonth, pltRetirementDay), false, NAM_ENTRANCE_DATE, NAM_RETIREMENT_DATE,
					PRM_PLT_RETIREMENT_YEAR, PRM_PLT_RETIREMENT_MONTH, PRM_PLT_RETIREMENT_DAY);
		}
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	public String getEscTxtKCode() {
		return escapeHTML(txtKCode);
	}
	
	public String getEscTxtKName() {
		return escapeHTML(txtKName);
	}
	
	public String getEscTxtKKana() {
		return escapeHTML(txtKKana);
	}
	
	public String getEscTxtEMail() {
		return escapeHTML(txtEMail);
	}
	
	public String getEscLblOffice() {
		return escapeHTML(lblOffice);
	}
	
	public String getEscLblSection() {
		return escapeHTML(lblSection);
	}
	
	public String getEscLblPosition() {
		return escapeHTML(lblPosition);
	}
	
	public String getEscLblRetirement() {
		return escapeHTML(lblRetirement);
	}
	
	public String getEscLblEntranceDate() {
		return escapeHTML(lblEntranceDate);
	}
	
	public String getEscLblRetirementDate() {
		return escapeHTML(lblRetirementDate);
	}
	
	public String getEscLblEMail() {
		return escapeHTML(lblEMail);
	}
	
	public String getEscHidKName() {
		return escapeHTML(hidKName);
	}
	
	public String getEscHidKKana() {
		return escapeHTML(hidKKana);
	}
	
	public String getEscHidOffice() {
		return escapeHTML(hidOffice);
	}
	
	public String getEscHidSection() {
		return escapeHTML(hidSection);
	}
	
	public String getEscHidPosition() {
		return escapeHTML(hidPosition);
	}
	
	public String getEscHidRetirement() {
		return escapeHTML(hidRetirement);
	}
	
	public String getEscHidEntranceYear() {
		return escapeHTML(hidEntranceYear);
	}
	
	public String getEscHidEntranceMonth() {
		return escapeHTML(hidEntranceMonth);
	}
	
	public String getEscHidEntranceDay() {
		return escapeHTML(hidEntranceDay);
	}
	
	public String getEscHidRetirementYear() {
		return escapeHTML(hidRetirementYear);
	}
	
	public String getEscHidRetirementMonth() {
		return escapeHTML(hidRetirementMonth);
	}
	
	public String getEscHidRetirementDay() {
		return escapeHTML(hidRetirementDay);
	}
	
	public String getEscHidEMail() {
		return escapeHTML(hidEMail);
	}
	
	/**
	 * @return txtKCode
	 */
	public String getTxtKCode() {
		return txtKCode;
	}
	
	/**
	 * @return txtKName
	 */
	public String getTxtKName() {
		return txtKName;
	}
	
	/**
	 * @return txtKKana
	 */
	public String getTxtKKana() {
		return txtKKana;
	}
	
	/**
	 * @return pltOffice
	 */
	public String getPltOffice() {
		return pltOffice;
	}
	
	/**
	 * @return pltSection
	 */
	public String getPltSection() {
		return pltSection;
	}
	
	/**
	 * @return pltPosition
	 */
	public String getPltPosition() {
		return pltPosition;
	}
	
	/**
	 * @return pltRetirement
	 */
	public String getPltRetirement() {
		return pltRetirement;
	}
	
	/**
	 * @return pltEntranceYear
	 */
	public String getPltEntranceYear() {
		return pltEntranceYear;
	}
	
	/**
	 * @return pltEntranceMonth
	 */
	public String getPltEntranceMonth() {
		return pltEntranceMonth;
	}
	
	/**
	 * @return pltEntranceDay
	 */
	public String getPltEntranceDay() {
		return pltEntranceDay;
	}
	
	/**
	 * @return pltRetirementYear
	 */
	public String getPltRetirementYear() {
		return pltRetirementYear;
	}
	
	/**
	 * @return pltRetirementMonth
	 */
	public String getPltRetirementMonth() {
		return pltRetirementMonth;
	}
	
	/**
	 * @return pltRetirementDay
	 */
	public String getPltRetirementDay() {
		return pltRetirementDay;
	}
	
	/**
	 * @return txtEMail
	 */
	public String getTxtEMail() {
		return txtEMail;
	}
	
	/**
	 * @return lblOffice
	 */
	public String getLblOffice() {
		return lblOffice;
	}
	
	/**
	 * @return lblSection
	 */
	public String getLblSection() {
		return lblSection;
	}
	
	/**
	 * @return lblPosition
	 */
	public String getLblPosition() {
		return lblPosition;
	}
	
	/**
	 * @return lblRetirement
	 */
	public String getLblRetirement() {
		return lblRetirement;
	}
	
	/**
	 * @return lblEntranceDate
	 */
	public String getLblEntranceDate() {
		return lblEntranceDate;
	}
	
	/**
	 * @return lblRetirementDate
	 */
	public String getLblRetirementDate() {
		return lblRetirementDate;
	}
	
	/**
	 * @return lblEMail
	 */
	public String getLblEMail() {
		return lblEMail;
	}
	
	/**
	 * @return hidKName
	 */
	public String getHidKName() {
		return hidKName;
	}
	
	/**
	 * @return hidKKana
	 */
	public String getHidKKana() {
		return hidKKana;
	}
	
	/**
	 * @return hidOffice
	 */
	public String getHidOffice() {
		return hidOffice;
	}
	
	/**
	 * @return hidSection
	 */
	public String getHidSection() {
		return hidSection;
	}
	
	/**
	 * @return hidPosition
	 */
	public String getHidPosition() {
		return hidPosition;
	}
	
	/**
	 * @return hidRetirement
	 */
	public String getHidRetirement() {
		return hidRetirement;
	}
	
	/**
	 * @return hidEntranceYear
	 */
	public String getHidEntranceYear() {
		return hidEntranceYear;
	}
	
	/**
	 * @return hidEntranceMonth
	 */
	public String getHidEntranceMonth() {
		return hidEntranceMonth;
	}
	
	/**
	 * @return hidEntranceDay
	 */
	public String getHidEntranceDay() {
		return hidEntranceDay;
	}
	
	/**
	 * @return hidRetirementYear
	 */
	public String getHidRetirementYear() {
		return hidRetirementYear;
	}
	
	/**
	 * @return hidRetirementMonth
	 */
	public String getHidRetirementMonth() {
		return hidRetirementMonth;
	}
	
	/**
	 * @return hidRetirementDay
	 */
	public String getHidRetirementDay() {
		return hidRetirementDay;
	}
	
	/**
	 * @return hidEMail
	 */
	public String getHidEMail() {
		return hidEMail;
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @param txtKCode Zbg txtKCode
	 */
	public void setTxtKCode(String txtKCode) {
		this.txtKCode = txtKCode;
	}
	
	/**
	 * @param txtKName Zbg txtKName
	 */
	public void setTxtKName(String txtKName) {
		this.txtKName = txtKName;
	}
	
	/**
	 * @param txtKKana Zbg txtKKana
	 */
	public void setTxtKKana(String txtKKana) {
		this.txtKKana = txtKKana;
	}
	
	/**
	 * @param pltOffice Zbg pltOffice
	 */
	public void setPltOffice(String pltOffice) {
		this.pltOffice = pltOffice;
	}
	
	/**
	 * @param pltSection Zbg pltSection
	 */
	public void setPltSection(String pltSection) {
		this.pltSection = pltSection;
	}
	
	/**
	 * @param pltPosition Zbg pltPosition
	 */
	public void setPltPosition(String pltPosition) {
		this.pltPosition = pltPosition;
	}
	
	/**
	 * @param pltRetirement Zbg pltRetirement
	 */
	public void setPltRetirement(String pltRetirement) {
		this.pltRetirement = pltRetirement;
	}
	
	/**
	 * @param pltEntranceYear Zbg pltEntranceYear
	 */
	public void setPltEntranceYear(String pltEntranceYear) {
		this.pltEntranceYear = pltEntranceYear;
	}
	
	/**
	 * @param pltEntranceMonth Zbg pltEntranceMonth
	 */
	public void setPltEntranceMonth(String pltEntranceMonth) {
		this.pltEntranceMonth = pltEntranceMonth;
	}
	
	/**
	 * @param pltEntranceDay Zbg pltEntranceDay
	 */
	public void setPltEntranceDay(String pltEntranceDay) {
		this.pltEntranceDay = pltEntranceDay;
	}
	
	/**
	 * @param pltRetirementYear Zbg pltRetirementYear
	 */
	public void setPltRetirementYear(String pltRetirementYear) {
		this.pltRetirementYear = pltRetirementYear;
	}
	
	/**
	 * @param pltRetirementMonth Zbg pltRetirementMonth
	 */
	public void setPltRetirementMonth(String pltRetirementMonth) {
		this.pltRetirementMonth = pltRetirementMonth;
	}
	
	/**
	 * @param pltRetirementDay Zbg pltRetirementDay
	 */
	public void setPltRetirementDay(String pltRetirementDay) {
		this.pltRetirementDay = pltRetirementDay;
	}
	
	/**
	 * @param txtEMail Zbg txtEMail
	 */
	public void setTxtEMail(String txtEMail) {
		this.txtEMail = txtEMail;
	}
	
	/**
	 * @param lblOffice Zbg lblOffice
	 */
	public void setLblOffice(String lblOffice) {
		this.lblOffice = lblOffice;
	}
	
	/**
	 * @param lblSection Zbg lblSection
	 */
	public void setLblSection(String lblSection) {
		this.lblSection = lblSection;
	}
	
	/**
	 * @param lblPosition Zbg lblPosition
	 */
	public void setLblPosition(String lblPosition) {
		this.lblPosition = lblPosition;
	}
	
	/**
	 * @param lblRetirement Zbg lblRetirement
	 */
	public void setLblRetirement(String lblRetirement) {
		this.lblRetirement = lblRetirement;
	}
	
	/**
	 * @param lblEntranceDate Zbg lblEntranceDate
	 */
	public void setLblEntranceDate(String lblEntranceDate) {
		this.lblEntranceDate = lblEntranceDate;
	}
	
	/**
	 * @param lblRetirementDate Zbg lblRetirementDate
	 */
	public void setLblRetirementDate(String lblRetirementDate) {
		this.lblRetirementDate = lblRetirementDate;
	}
	
	/**
	 * @param lblEMail Zbg lblEMail
	 */
	public void setLblEMail(String lblEMail) {
		this.lblEMail = lblEMail;
	}
	
	/**
	 * @param hidKName Zbg hidKName
	 */
	public void setHidKName(String hidKName) {
		this.hidKName = hidKName;
	}
	
	/**
	 * @param hidKKana Zbg hidKKana
	 */
	public void setHidKKana(String hidKKana) {
		this.hidKKana = hidKKana;
	}
	
	/**
	 * @param hidOffice Zbg hidOffice
	 */
	public void setHidOffice(String hidOffice) {
		this.hidOffice = hidOffice;
	}
	
	/**
	 * @param hidSection Zbg hidSection
	 */
	public void setHidSection(String hidSection) {
		this.hidSection = hidSection;
	}
	
	/**
	 * @param hidPosition Zbg hidPosition
	 */
	public void setHidPosition(String hidPosition) {
		this.hidPosition = hidPosition;
	}
	
	/**
	 * @param hidRetirement Zbg hidRetirement
	 */
	public void setHidRetirement(String hidRetirement) {
		this.hidRetirement = hidRetirement;
	}
	
	/**
	 * @param hidEntranceYear Zbg hidEntranceYear
	 */
	public void setHidEntranceYear(String hidEntranceYear) {
		this.hidEntranceYear = hidEntranceYear;
	}
	
	/**
	 * @param hidEntranceMonth Zbg hidEntranceMonth
	 */
	public void setHidEntranceMonth(String hidEntranceMonth) {
		this.hidEntranceMonth = hidEntranceMonth;
	}
	
	/**
	 * @param hidEntranceDay Zbg hidEntranceDay
	 */
	public void setHidEntranceDay(String hidEntranceDay) {
		this.hidEntranceDay = hidEntranceDay;
	}
	
	/**
	 * @param hidRetirementYear Zbg hidRetirementYear
	 */
	public void setHidRetirementYear(String hidRetirementYear) {
		this.hidRetirementYear = hidRetirementYear;
	}
	
	/**
	 * @param hidRetirementMonth Zbg hidRetirementMonth
	 */
	public void setHidRetirementMonth(String hidRetirementMonth) {
		this.hidRetirementMonth = hidRetirementMonth;
	}
	
	/**
	 * @param hidRetirementDay Zbg hidRetirementDay
	 */
	public void setHidRetirementDay(String hidRetirementDay) {
		this.hidRetirementDay = hidRetirementDay;
	}
	
	/**
	 * @param hidEMail Zbg hidEMail
	 */
	public void setHidEMail(String hidEMail) {
		this.hidEMail = hidEMail;
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
