/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.human.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;

/**
 * @author yoshida
 *
 */
public abstract class HumanCardVo extends MosPVo {
	
	static final long			serialVersionUID		= 1L;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_TXT_CHANGE_K_CODE	= "txtChangeKCode";
	/**
	 * 
	 */
	public static final String	PRM_HID_SELECT_LIST_CMD	= "hidSelectListCmd";
	
	// tB[h
	/**
	 * 
	 */
	protected String			txtChangeKCode;
	/**
	 * 
	 */
	protected String			lblKKana;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_HUMAN_INFO;
	
	// {^eύX
	private String				cmdListButton1;
	private String				namListButton1;
	
	private String				hidSelectListCmd;
	
	private String[][]			aryFunction;
	

	/**
	 * RXgN^
	 */
	public HumanCardVo() {
		super();
	}
	
	@Override
	protected void setFieldsName() {
		NAM_HUMAN_INFO = CommonConst.NAM_HUMAN_INFO + CommonConst.NAM_MENU;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtChangeKCode = request.getParameter(PRM_TXT_CHANGE_K_CODE);
		hidSelectListCmd = request.getParameter(PRM_HID_SELECT_LIST_CMD);
	}
	
	/**
	 * p[^
	 */
	public void initFields() {
		txtChangeKCode = "";
	}
	
	// ANZT\bh
	/**
	 * @return txtChangeKCode
	 */
	public String getTxtChangeKCode() {
		return txtChangeKCode;
	}
	
	/**
	 * @return txtChangeKCode
	 */
	public String getEscTxtChangeKCode() {
		return escapeHTML(txtChangeKCode);
	}
	
	/**
	 * @return lblKKana
	 */
	public String getEscLblKKana() {
		return escapeHTML(lblKKana);
	}
	
	/**
	 * @param txtChangeKCode
	 */
	public void setTxtChangeKCode(String txtChangeKCode) {
		this.txtChangeKCode = txtChangeKCode;
	}
	
	/**
	 * @param lblKKana
	 */
	public void setLblKKana(String lblKKana) {
		this.lblKKana = lblKKana;
	}
	
	/**
	 * @param cmdListButton1
	 */
	public void setCmdListButton1(String cmdListButton1) {
		this.cmdListButton1 = cmdListButton1;
	}
	
	/**
	 * @param namListButton1
	 */
	public void setNamListButton1(String namListButton1) {
		this.namListButton1 = namListButton1;
	}
	
	/**
	 * @return cmdListButton1
	 */
	public String getCmdListButton1() {
		return cmdListButton1;
	}
	
	/**
	 * @return namListButton1
	 */
	public String getNamListButton1() {
		return namListButton1;
	}
	
	/**
	 * @param hidSelectListCmd
	 */
	public void setHidSelectListCmd(String hidSelectListCmd) {
		this.hidSelectListCmd = hidSelectListCmd;
	}
	
	/**
	 * @return hidSelectListCmd
	 */
	public String getHidSelectListCmd() {
		return hidSelectListCmd;
	}
	
	/**
	 * @param aryFunction Zbg aryFunction
	 */
	public void setAryFunction(String[][] aryFunction) {
		this.aryFunction = aryFunction.clone();
	}
	
	/**
	 * @return aryFunction
	 */
	public String[][] getAryFunction() {
		return aryFunction.clone();
	}
	
}
