/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

import jp.mosp.common.common.MospException;

/**
 * MosPɊւPartێNX
 * @author yoshida
 *	@version	0.0.4
 */
public class PartStore extends BaseStore {
	
	/**
	 * RXgN^
	 */
	public PartStore() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo	Part𗘗pۂɕKvȏ
	 */
	private PartStore(PartInfo partInfo) {
		this();
		setPartInfo(partInfo);
	}
	
	/**
	 * StoreCX^X
	 * @param partInfo		Part𗘗pۂɕKvȏ
	 * @return	PartStoreCX^X
	 */
	public static PartStore getInstance(PartInfo partInfo) {
		return new PartStore(partInfo);
	}
	
	/**
	 * CmCodePartCX^X擾
	 * @return	ςCmCodePartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public CmCodePart cmcode() throws MospException {
		return (CmCodePart)get(CmCodePart.class);
	}
	
	/**
	 * MosPConfPartCX^X擾
	 * @return	ςMosPConfPartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public MosPConfPart mospconf() throws MospException {
		return (MosPConfPart)get(MosPConfPart.class);
	}
	
	/**
	 * MosPCodePartCX^X擾
	 * @return	ςMosPCodePartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public MosPCodePart mospcode() throws MospException {
		return (MosPCodePart)get(MosPCodePart.class);
	}
	
	/**
	 * MosPUserPartCX^X擾
	 * @return	ςMosPUserPartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public MosPUserPart mospuser() throws MospException {
		return (MosPUserPart)get(MosPUserPart.class);
	}
	
	/**
	 * AuthorityPartCX^X擾
	 * @return	ςAuthorityPartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public AuthorityPart authority() throws MospException {
		return (AuthorityPart)get(AuthorityPart.class);
	}
	
	/**
	 * ComponentPartCX^X擾
	 * @return	ςComponentPartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public ComponentPart component() throws MospException {
		return (ComponentPart)get(ComponentPart.class);
	}
	
	/**
	 * JPDatePartCX^X擾
	 * @return	ςJPDatePartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public JPDatePart jpdate() throws MospException {
		return (JPDatePart)get(JPDatePart.class);
	}
	
	/**
	 * JPHolidayPartCX^X擾
	 * @return	ςJPHolidayPartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public JPHolidayPart jpholiday() throws MospException {
		return (JPHolidayPart)get(JPHolidayPart.class);
	}
	
	/**
	 * MosPMenuPartCX^X擾
	 * @return	ςMosPMenuPartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public MosPMenuPart menu() throws MospException {
		return (MosPMenuPart)get(MosPMenuPart.class);
	}
	
}
