/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;

/**
 * aɊւPartNX
 * @author yoshida
 *	@version	0.0.1
 */
public class JPDatePart extends BasePart {
	
	/**
	 * RXgN^
	 */
	public JPDatePart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo Part𗘗pۂɕKvȏ
	 */
	public JPDatePart(PartInfo partInfo) {
		super(partInfo);
	}
	
	/**
	 * a\ݒ
	 * @param targetDate	Ώ۔N
	 * @return	a\
	 * @throws Exception	Oꍇ
	 */
	public String getJapaneseDate(Date targetDate) throws Exception {
		return getDateString(part().mospconf().getConfList(CommonConst.CONF_ID_JP_IMP_CAL), part().cmcode()
			.getJPCalendarGengo(), targetDate);
	}
	
	/**
	 * a\ݒ
	 * @param targetDate	Ώ۔N(yyyy-MM-dd)
	 * @return	a\
	 * @throws Exception	Oꍇ
	 */
	public String getJapaneseDate(String targetDate) throws Exception {
		return getJapaneseDate(DateUtil.convHyphenDateToDate(targetDate));
	}
	
	/**
	 * t擾(a)
	 * @param list a񃊃Xg
	 * @param aryEra a\z
	 * @param date 
	 * @return t
	 * @throws MospException	MosPOꍇ
	 */
	private String getDateString(List<MosPConfDto> list, String[][] aryEra, Date date) throws MospException {
		if (date == null || list == null) {
			return "";
		}
		String[] strDate = getJpImperialCal(list, date);
		strDate[0] = StringUtil.getCodeName(strDate[0], aryEra);
		for (int i = 1; i < strDate.length; i++) {
			strDate[i] = strDate[i].length() < 2 ? CommonConst.SUPPRESS_DATE + strDate[i] : strDate[i];
		}
		StringBuffer sb = new StringBuffer();
		sb.append(strDate[0]);
		sb.append(strDate[1]);
		sb.append(CommonConst.NAM_YEAR);
		sb.append(strDate[2]);
		sb.append(CommonConst.NAM_MONTH);
		sb.append(strDate[3]);
		sb.append(CommonConst.NAM_DAY);
		return sb.toString();
	}
	
	/**
	 * a擾
	 * @param list a񃊃Xg
	 * @param date t
	 * @return tz
	 * @throws MospException 	MosPOꍇ
	 */
	private String[] getJpImperialCal(List<MosPConfDto> list, Date date) throws MospException {
		String[] aryJpDate = new String[4];
		if (date == null) {
			return aryJpDate;
		}
		for (MosPConfDto dto : list) {
			Date startDate = getDate(dto.getConfCode());
			Date endDate = getDate(dto.getConfValue());
			if (startDate.compareTo(date) <= 0 && endDate.compareTo(date) >= 0) {
				int year = MospUtility.getYear(date) - MospUtility.getYear(startDate) + 1;
				aryJpDate[0] = dto.getConfId();
				aryJpDate[1] = String.valueOf(year);
				aryJpDate[2] = String.valueOf(MospUtility.getMonth(date));
				aryJpDate[3] = String.valueOf(MospUtility.getDay(date));
				return aryJpDate;
			}
		}
		throw new MospException(MospConst.EX_DATE_INVALID);
	}
	
	/**
	 * t擾(/p)
	 * @param strDate t
	 * @return t
	 * @throws MospException 	MosPOꍇ
	 */
	private Date getDate(String strDate) throws MospException {
		if (strDate == null || strDate.length() != 8) {
			throw new MospException(MospConst.EX_DATE_INVALID);
		}
		return MospUtility.getDate(strDate.substring(0, 4) + CommonConst.SEPARATOR_DATE + strDate.substring(4, 6)
				+ CommonConst.SEPARATOR_DATE + strDate.substring(6, 8));
	}
	

	/* a֘A */
	/**
	 * 
	 */
	public static final String		CODE_JC_MEIJI		= "JC_MEIJI";
	/**
	 * 
	 */
	public static final String		CODE_JC_TAISHO		= "JC_TAISH";
	/**
	 * 
	 */
	public static final String		CODE_JC_SHOUWA		= "JC_SHOUW";
	/**
	 * 
	 */
	public static final String		CODE_JC_HEISEI		= "JC_HEISE";
	/**
	 * 
	 */
	public static final String		NAME_JC_MEIJI		= "";
	/**
	 * 
	 */
	public static final String		NAME_JC_TAISHO		= "吳";
	/**
	 * 
	 */
	public static final String		NAME_JC_SHOUWA		= "a";
	/**
	 * 
	 */
	public static final String		NAME_JC_HEISEI		= "";
	
	private static final String[][]	JP_CALENDAR_GENGO	= { { CODE_JC_MEIJI, NAME_JC_MEIJI },
		{ CODE_JC_TAISHO, NAME_JC_TAISHO }, { CODE_JC_SHOUWA, NAME_JC_SHOUWA }, { CODE_JC_HEISEI, NAME_JC_HEISEI }, };
	

	/**
	 * @return R[hÂ̔z
	 */
	public static final String[][] getJpCalendarGengo() {
		return JP_CALENDAR_GENGO.clone();
	}
	
}
