/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.dao;

import com.google.appengine.api.datastore.Query;

import jp.getset.gae.GaeUnsupportedException;
import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospConst;

/**
 * @author yoshida
 *
 */
public class MosPDao extends BaseDao {
	
	/**
	 * RXgN^
	 */
	private MosPDao() {
		// Do not use.
	}
	
	private static MosPDao getInstance() {
		return new MosPDao();
	}
	
	/**
	 * @return	DESC LIMIT 1
	 */
	public static String getDESCLimit1() {
		return " DESC LIMIT 1";
	}
	
	/**
	 * Ov
	 * @param param Ώۃp[^
	 * @return param + %
	 */
	public static String startWithParam(String param) {
		StringBuffer sb = new StringBuffer();
		sb.append(param);
		sb.append("%");
		return sb.toString();
	}
	
	/**
	 * v
	 * @param param Ώۃp[^
	 * @return % + param
	 */
	public static String endWithParam(String param) {
		StringBuffer sb = new StringBuffer();
		sb.append("%");
		sb.append(param);
		return sb.toString();
	}
	
	/**
	 * v
	 * @param param Ώۃp[^
	 * @return % + param + %
	 */
	public static String containsParam(String param) {
		StringBuffer sb = new StringBuffer();
		sb.append("%");
		sb.append(param);
		sb.append("%");
		return sb.toString();
	}
	
	/**
	 * p[^NULL`FbN
	 * @param param Ώۃp[^
	 * @return null̏ꍇtrueAłȂꍇfalseB
	 */
	public static boolean isNull(Object param) {
		return param == null;
	}
	
	/**
	 * p[^()NULL`FbN
	 * @param param Ώۃp[^
	 * @return paramnullłȂ񒷂0łȂꍇtrueAłȂꍇfalse
	 */
	public static boolean isNotNull(String param) {
		return !isNull(param) && param.length() != 0;
	}
	
	/**
	 * @return AND
	 */
	public String and() {
		return " AND ";
	}
	
	/**
	 * @param column ΏۃJ
	 * @return column = ?
	 */
	// GAE Ăяo
	// this.pob.appendWhere(column, Query.FilterOperator.EQUAL);
/*	public static String equal(String column) {
		StringBuffer sb = new StringBuffer();
		sb.append(column);
		sb.append(" = ? ");
		return sb.toString();
	}*/
	
	/**
	 * @param column ΏۃJ
	 * @return column LIKE ?
	 */
	// GAE Ăяo
	// this.pob.appendLike(column);
/*	public static String like(String column) {
		StringBuffer sb = new StringBuffer();
		sb.append(column);
		sb.append(" LIKE ? ");
		return sb.toString();
	}*/
	
	/**
	 * @param colDeleteFlag Ώۍ폜tOJ
	 * @return colDeleteFlag = {@link MospConst#DELETE_FLAG_OFF}
	 */
	// GAE Ăяo
	// this.pob.appendWhere(colDeleteFlag, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
/*	public static String deleteFlagOff(String colDeleteFlag) {
		StringBuffer sb = new StringBuffer();
		sb.append(colDeleteFlag);
		sb.append(" = ");
		sb.append(MospConst.DELETE_FLAG_OFF);
		sb.append(" ");
		return sb.toString();
	}*/
	
	/**
	 * @param column ΏۃJ
	 * @return ORDER BY column 
	 */
/*	public static String getOrderByColumn(String column) {
		StringBuffer sb = new StringBuffer();
		sb.append(getInstance().getOrderBy());
		sb.append(column);
		sb.append(" ");
		return sb.toString();
	}*/
	
	/**
	 * @param column ΏۃJ
	 * @return ORDER BY column 
	 */
/*	public static String getOrderByColumnDESCLimit1(String column) {
		StringBuffer sb = new StringBuffer();
		sb.append(getOrderByColumn(column));
		sb.append(getDESCLimit1());
		return sb.toString();
	}*/
	
}
