/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common;

/**
 * @author yoshida
 *
 */
public class MosPMenuConst {
	
	/**
	 * 
	 */
	private MosPMenuConst() {
		// Do not use.
	}
	

	/*l֘A*/
	private static final String[]	MENU_HUMAN						= { "H1010", "Јꗗ" };
	private static final String[]	MENU_HUMAN_INSERT				= { "H1020", "ЈVKo^" };
	
	/*ΑӏWv֘A*/
	private static final String[]	MENU_ATTENDANCE_CALCULATE		= { "P1010", "ΑӌvZ" };
	private static final String[]	MENU_ATTENDANCE_CALCULATE_START	= { "P1020", "vZJn" };
	private static final String[]	MENU_ATTENDANCE_COMPILE			= { "P1030", "ΑӏWv" };
	private static final String[]	MENU_COMPILE_AMENDMENT			= { "P1040", "ΑӏC" };
	private static final String[]	MENU_ATTENDANCE_EXPORT			= { "P1050", "[o" };
	private static final String[]	MENU_ATTENDANCE_CALCULATE_END	= { "P1060", "vZI" };
	private static final String[]	MENU_KEISAN_INFORMATION			= { "S1100", "ΑӌvZ" };
	private static final String[]	MENU_EXPORT						= { "S1200", "GNX|[g" };
	private static final String[]	MENU_COMPILE_EXPORT				= { "S1230", "GNX|[g(Α)" };
	private static final String[]	MENU_COMPILE_IMPORT				= { "S1240", "C|[g(Α)" };
	
	/*Lx֘A*/
	private static final String[]	MENU_PAID_HOLIDAY_MANAGEMENT	= { "P1100", "LxǗ" };
	
	/*x֘A*/
	private static final String[]	MENU_SUB_HOLIDAY_MANAGEMENT		= { "P1300", "xǗ" };
	private static final String[]	MENU_SUB_HOLIDAY_ATTITUDE		= { "K1150", "xӌmF" };
	
	/*Αӊ֘A*/
	private static final String[]	MENU_ATTENDANCE					= { "K1010", "Α" };
	private static final String[]	MENU_SCHEDULE					= { "K1200", "XPW[" };
	private static final String[]	MENU_PAID_HOLIDAY_CONFIRM		= { "K1300", "LxmF" };
	private static final String[]	MENU_MOSP_PASSWORD				= { "C1050", "pX[hύX" };
	private static final String[]	MENU_EMPLOYEE_ATTENDANCE		= { "K2010", "Јꗗ" };
	
	/*VXe֘A*/
	private static final String[]	MENU_CM_CODE					= { "S2000", "ʃR[hێ" };
	private static final String[]	MENU_KAISYA_MASTER				= { "S2010", "Ə}X^ێ" };
	private static final String[]	MENU_CODE_MASTER				= { "S2020", "R[h}X^ێ" };
	private static final String[]	MENU_WORK_SYSTEM				= { "S2030", "Αӏێ" };
	private static final String[]	MENU_SYOZOKU_MASTER				= { "S2100", "}X^ێ" };
	private static final String[]	MENU_YAKUSYOKU_MASTER			= { "S2200", "E}X^ێ" };
	private static final String[]	MENU_REASON_MASTER				= { "S2300", "e헝Rݒ" };
	private static final String[]	MENU_ACCOUNT_MASTER				= { "S2400", "AJEgǗ" };
	private static final String[]	MENU_LABOR_AGREEMENT			= { "S2500", "Jgێ" };
	private static final String[]	MENU_YUKYU_INFORMATION			= { "S2700", "Lxݒ" };
	private static final String[]	MENU_WORK_TYPE_MASTER			= { "S2600", "Ζ`ԃ}X^ێ" };
	private static final String[]	MENU_HOLIDAY_MASTER				= { "S2710", "jՓ}X^ێ" };
	private static final String[]	MENU_APPROVAL					= { "S2800", "Fݒ" };
	
	private static final String[]	MENU_OPTION_FUNCTION			= { "O9910", "IvVێ" };
	
	/*\֘A*/
	private static final String[]	MENU_APPLICATION				= { "K1400", "e\" };
	private static final String[]	MENU_OVER_TIME_REQUEST			= { "K1410", "cƐ\" };
	private static final String[]	MENU_HOLIDAY_REQUEST			= { "K1420", "xɐ\" };
	
	/*F֘A*/
	private static final String[]	MENU_MANAGER_APPROVAL			= { "K2100", "e폳F" };
	private static final String[]	MENU_EMPLOYEE_APPROVAL			= { "K2110", "ΑӏF" };
	private static final String[]	MENU_RELEVANT_KINTAI			= { "K2130", "Αӊ֘AF" };
	

	/**
	 * ^(vZ@\)pR}h̔z쐬 cmd,name
	 * @return array
	 */
	public static String[][] getPayrollRestrictCalcArray() {
		return new String[][]{ getMenuAttendanceCompile(), getMenuCompileAmendment(), getMenuAttendanceExport(),
			getMenuPaidHolidayManagement(), getMenuSubHolidayManagement() };
	}
	
	/**
	 * ^o^ʕ\pR}h̔z쐬 cmd,name
	 * @return array
	 */
	public static String[][] getViewPayrollCmdArray() {
		return new String[][]{
			{ getMenuAttendanceCalculateStart()[0],
				CommonConst.NAM_ATTENDANCE_CALCULATE_VIEW + getMenuAttendanceCalculateStart()[1] },
			{ getMenuAttendanceCompile()[0], CommonConst.NAM_ATTENDANCE_CALCULATE_VIEW + getMenuAttendanceCompile()[1] },
			{ getMenuCompileAmendment()[0], CommonConst.NAM_ATTENDANCE_CALCULATE_VIEW + getMenuCompileAmendment()[1] },
			{ getMenuAttendanceExport()[0], CommonConst.NAM_ATTENDANCE_CALCULATE_VIEW + getMenuAttendanceExport()[1] },
			{ getMenuAttendanceCalculateEnd()[0],
				CommonConst.NAM_ATTENDANCE_CALCULATE_VIEW + getMenuAttendanceCalculateEnd()[1] },
			getMenuPaidHolidayManagement(), getMenuSubHolidayManagement(), getMenuKeisanInformation(), getMenuExport() };
	}
	
	/**
	 * e\j[R}hz擾
	 * @return	e\j[R}hz
	 */
	public static String[][] getApplicationCmdArray() {
		return new String[][]{ getMenuOverTimeRequest(), getMenuHolidayRequest(), };
	}
	
	/**
	 * e폳Fj[R}hz擾
	 * @return	e폳Fj[R}hz
	 */
	public static String[][] getApprovalCmdArray() {
		return new String[][]{ getMenuEmployeeApproval(), getMenuRelevantKintai() };
	}
	
	// ANZT\bh
	
	/**
	 * ]ƈpR}h̔z
	 * @return CMD_EMPLOYEE_ARRAY
	 */
	public static String[][] getCmdEmployeeArray() {
		return new String[][]{ getMenuAttendance(), getMenuSchedule(), getMenuPaidHolidayConfirm(),
			getMenuApplication(), getMenuMospPassword() };
	}
	
	/**
	 * }l[W[pR}h̔z
	 * @return CMD_MANAGER_ARRAY
	 */
	public static String[][] getCmdManagerArray() {
		return new String[][]{ getMenuEmployeeAttendance(), getMenuManagerApproval(), };
	}
	
	/**
	 * ^pR}h̔z
	 * @return CMD_PAYROLL_ARRAY
	 */
	public static String[][] getCmdPayrollArray() {
		return new String[][]{ getMenuAttendanceCalculate(), getMenuAttendanceCalculateStart(),
			getMenuAttendanceCompile(), getMenuCompileAmendment(), getMenuAttendanceExport(),
			getMenuAttendanceCalculateEnd(), getMenuPaidHolidayManagement(), getMenuSubHolidayManagement(),
			getMenuKeisanInformation(), getMenuExport(), getMenuCompileExport(), getMenuCompileImport() };
	}
	
	/**
	 * lpR}h̔z
	 * @return CMD_HUMAN_ARRAY
	 */
	public static String[][] getCmdHumanArray() {
		return new String[][]{ getMenuHuman(), getMenuHumanInsert() };
	}
	
	/**
	 * ΑӌvZpR}h̔z
	 * @return CMD_CALC_ARRAY
	 */
	public static String[] getCmdCalcArray() {
		return new String[]{ getMenuAttendanceCalculate()[0], getMenuAttendanceCalculateStart()[0],
			getMenuAttendanceCompile()[0], getMenuCompileAmendment()[0], getMenuAttendanceExport()[0],
			getMenuAttendanceCalculateEnd()[0], getMenuCompileExport()[0], getMenuCompileImport()[0], };
	}
	
	/**
	 * VXepR}h̔z
	 * @return CMD_SYSTEM_ARRAY
	 */
	public static String[][] getCmdSystemArray() {
		return new String[][]{ getMenuKaisyaMaster(), getMenuSyozokuMaster(), getMenuYakusyokuMaster(),
			getMenuWorkSystem(), getMenuLaborAgreement(), getMenuReasonMaster(), getMenuYukyuInformation(),
			getMenuWorkTypeMaster(), getMenuHolidayMaster(), getMenuAccountMaster(), getMenuMospPassword(),
			getMenuCodeMaster(), getMenuCmCode(), getMenuApproval(), getMenuOptionFunction() };
	}
	
	/**
	 * @return menuHuman
	 */
	public static String[] getMenuHuman() {
		return MENU_HUMAN.clone();
	}
	
	/**
	 * @return menuHumanInsert
	 */
	public static String[] getMenuHumanInsert() {
		return MENU_HUMAN_INSERT.clone();
	}
	
	/**
	 * @return menuAttendanceCalculate
	 */
	public static String[] getMenuAttendanceCalculate() {
		return MENU_ATTENDANCE_CALCULATE.clone();
	}
	
	/**
	 * @return menuAttendanceCalculateStart
	 */
	public static String[] getMenuAttendanceCalculateStart() {
		return MENU_ATTENDANCE_CALCULATE_START.clone();
	}
	
	/**
	 * @return menuAttendanceCompile
	 */
	public static String[] getMenuAttendanceCompile() {
		return MENU_ATTENDANCE_COMPILE.clone();
	}
	
	/**
	 * @return menuCompileAmendment
	 */
	public static String[] getMenuCompileAmendment() {
		return MENU_COMPILE_AMENDMENT.clone();
	}
	
	/**
	 * @return menuAttendanceExport
	 */
	public static String[] getMenuAttendanceExport() {
		return MENU_ATTENDANCE_EXPORT.clone();
	}
	
	/**
	 * @return menuAttendanceCalculateEnd
	 */
	public static String[] getMenuAttendanceCalculateEnd() {
		return MENU_ATTENDANCE_CALCULATE_END.clone();
	}
	
	/**
	 * @return menuKeisanInformation
	 */
	public static String[] getMenuKeisanInformation() {
		return MENU_KEISAN_INFORMATION.clone();
	}
	
	/**
	 * @return menuExport
	 */
	public static String[] getMenuExport() {
		return MENU_EXPORT.clone();
	}
	
	/**
	 * @return menuPaidHolidayManagement
	 */
	public static String[] getMenuPaidHolidayManagement() {
		return MENU_PAID_HOLIDAY_MANAGEMENT.clone();
	}
	
	/**
	 * @return menuSubHolidayManagement
	 */
	public static String[] getMenuSubHolidayManagement() {
		return MENU_SUB_HOLIDAY_MANAGEMENT.clone();
	}
	
	/**
	 * @return menuSubHolidayAttitude
	 */
	public static String[] getMenuSubHolidayAttitude() {
		return MENU_SUB_HOLIDAY_ATTITUDE.clone();
	}
	
	/**
	 * @return menuAttendance
	 */
	public static String[] getMenuAttendance() {
		return MENU_ATTENDANCE.clone();
	}
	
	/**
	 * @return menuSchedule
	 */
	public static String[] getMenuSchedule() {
		return MENU_SCHEDULE.clone();
	}
	
	/**
	 * @return menuPaidHolidayConfirm
	 */
	public static String[] getMenuPaidHolidayConfirm() {
		return MENU_PAID_HOLIDAY_CONFIRM.clone();
	}
	
	/**
	 * @return menuMospPassword
	 */
	public static String[] getMenuMospPassword() {
		return MENU_MOSP_PASSWORD.clone();
	}
	
	/**
	 * @return menuEmployeeAttendance
	 */
	public static String[] getMenuEmployeeAttendance() {
		return MENU_EMPLOYEE_ATTENDANCE.clone();
	}
	
	/**
	 * @return menuKaisyaMaster
	 */
	public static String[] getMenuKaisyaMaster() {
		return MENU_KAISYA_MASTER.clone();
	}
	
	/**
	 * @return menuCodeMaster
	 */
	public static String[] getMenuCodeMaster() {
		return MENU_CODE_MASTER.clone();
	}
	
	/**
	 * @return menuSyozokuMaster
	 */
	public static String[] getMenuSyozokuMaster() {
		return MENU_SYOZOKU_MASTER.clone();
	}
	
	/**
	 * @return menuYakusyokuMaster
	 */
	public static String[] getMenuYakusyokuMaster() {
		return MENU_YAKUSYOKU_MASTER.clone();
	}
	
	/**
	 * @return menuReasonMaster
	 */
	public static String[] getMenuReasonMaster() {
		return MENU_REASON_MASTER.clone();
	}
	
	/**
	 * @return menuWorkSystem
	 */
	public static String[] getMenuWorkSystem() {
		return MENU_WORK_SYSTEM.clone();
	}
	
	/**
	 * @return menuYukyuInformation
	 */
	public static String[] getMenuYukyuInformation() {
		return MENU_YUKYU_INFORMATION.clone();
	}
	
	/**
	 * @return menuWorkTypeMaster
	 */
	public static String[] getMenuWorkTypeMaster() {
		return MENU_WORK_TYPE_MASTER.clone();
	}
	
	/**
	 * @return menuHolidayMaster
	 */
	public static String[] getMenuHolidayMaster() {
		return MENU_HOLIDAY_MASTER.clone();
	}
	
	/**
	 * @return menuAccountMaster
	 */
	public static String[] getMenuAccountMaster() {
		return MENU_ACCOUNT_MASTER.clone();
	}
	
	/**
	 * @return menuCmCode
	 */
	public static String[] getMenuCmCode() {
		return MENU_CM_CODE.clone();
	}
	
	/**
	 * @return MENU_APPROVAL
	 */
	public static String[] getMenuApproval() {
		return MENU_APPROVAL.clone();
	}
	
	/**
	 * @return menuOptionFunction
	 */
	public static String[] getMenuOptionFunction() {
		return MENU_OPTION_FUNCTION.clone();
	}
	
	/**
	 * @return MENU_APPLICATION
	 */
	public static String[] getMenuApplication() {
		return MENU_APPLICATION.clone();
	}
	
	/**
	 * @return menuOverTimeRequest
	 */
	public static String[] getMenuOverTimeRequest() {
		return MENU_OVER_TIME_REQUEST.clone();
	}
	
	/**
	 * @return menuHolidayRequest
	 */
	public static String[] getMenuHolidayRequest() {
		return MENU_HOLIDAY_REQUEST.clone();
	}
	
	/**
	 * @return menuManagerApproval
	 */
	public static String[] getMenuManagerApproval() {
		return MENU_MANAGER_APPROVAL.clone();
	}
	
	/**
	 * @return menuEmployeeApproval
	 */
	public static String[] getMenuEmployeeApproval() {
		return MENU_EMPLOYEE_APPROVAL.clone();
	}
	
	/**
	 * @return menuRelevantKintai
	 */
	public static String[] getMenuRelevantKintai() {
		return MENU_RELEVANT_KINTAI.clone();
	}
	
	/**
	 * @return menuLaborAgreement
	 */
	public static String[] getMenuLaborAgreement() {
		return MENU_LABOR_AGREEMENT.clone();
	}
	
	/**
	 * @return menuCompileExport
	 */
	public static String[] getMenuCompileExport() {
		return MENU_COMPILE_EXPORT.clone();
	}
	
	/**
	 * @return menuCompileImport
	 */
	public static String[] getMenuCompileImport() {
		return MENU_COMPILE_IMPORT.clone();
	}
	
}
