/*
 * Decompiled with CFR 0.152.
 */
package jp.getset.gae.bigtable;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Query;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.getset.gae.GaeUnsupportedException;
import jp.getset.gae.bigtable.PreparedOption;
import jp.getset.gae.bigtable.option.PreparedConditionLike;
import jp.getset.gae.bigtable.option.PreparedDistinct;
import jp.getset.gae.bigtable.option.PreparedLimit;
import jp.getset.gae.bigtable.option.PreparedProperty;
import jp.getset.gae.bigtable.option.PreparedSort;
import jp.getset.gae.bigtable.option.operation.Operatable;

public class ResultSet
implements java.sql.ResultSet {
    private Iterator<Entity> entities = null;
    private Map<String, Object> currentRecord = null;
    private Object[] currentKeys = null;
    private Entity currentEntity = null;

    private void clear() {
        this.entities = null;
        this.currentRecord = null;
        this.currentKeys = null;
        this.currentEntity = null;
    }

    public ResultSet(Iterable<Entity> entities, PreparedOption preparedOption, String kind) {
        PreparedLimit preparedLimit;
        List<Entity> entityList = this.toList(entities);
        List<PreparedConditionLike> preparedConditionLikes = preparedOption.getPreparedConditionsLike();
        for (PreparedConditionLike preparedConditionLike : preparedConditionLikes) {
            entityList = this.calcLikeCondition(entityList, preparedConditionLike);
        }
        List<PreparedDistinct> preparedDistincts = preparedOption.getPreparedDistinct();
        if (preparedDistincts.size() > 0) {
            entityList = this.getDistincted(entityList, preparedDistincts);
        }
        List<PreparedProperty> preparedProperties = preparedOption.getPreparedProperties();
        entityList = this.calcPropertyOperation(preparedProperties, entityList, kind);
        List<PreparedSort> preparedSorts = preparedOption.getPreparedSorts();
        if (preparedSorts.size() > 0) {
            entityList = this.getSorted(entityList, preparedSorts);
        }
        if ((preparedLimit = preparedOption.getPreparedLimit()) != null && preparedLimit.getLimit() != null) {
            int limit = preparedLimit.getLimit();
            int entitySize = entityList.size();
            ArrayList<Entity> newEntityList = new ArrayList<Entity>();
            int i = 0;
            while (i < limit || i < entitySize) {
                newEntityList.add(entityList.get(i));
                ++i;
            }
            entityList = newEntityList;
        }
        this.entities = entityList.iterator();
    }

    private List<Entity> calcPropertyOperation(List<PreparedProperty> preparedProperties, List<Entity> entities, String kind) {
        for (PreparedProperty preparedProperty : preparedProperties) {
            if (!preparedProperty.hasOperation()) continue;
            Operatable operation = preparedProperty.getOperation();
            entities = operation.exec(entities, preparedProperty.getName(), kind);
        }
        return entities;
    }

    private List<Entity> calcLikeCondition(Iterable<Entity> entities, PreparedConditionLike preparedConditionLike) {
        ArrayList<Entity> ret = new ArrayList<Entity>();
        for (Entity entity : entities) {
            Object property = entity.getProperty(preparedConditionLike.getName());
            if (!property.toString().matches(preparedConditionLike.getValue().toString())) continue;
            ret.add(entity);
        }
        return ret;
    }

    private List<Entity> toList(Iterable<Entity> entities) {
        ArrayList<Entity> ret = new ArrayList<Entity>();
        for (Entity e : entities) {
            ret.add(e);
        }
        return ret;
    }

    private List<Entity> getDistincted(List<Entity> entities, List<PreparedDistinct> preparedDistincts) {
        ArrayList<Entity> ret = new ArrayList<Entity>();
        ArrayList<PreparedSort> sorts = new ArrayList<PreparedSort>();
        for (PreparedDistinct preparedDistinct : preparedDistincts) {
            sorts.add(new PreparedSort(preparedDistinct.getName()));
        }
        Collections.sort(entities, new EntityComparator(sorts));
        Entity preEntity = null;
        block1: for (Entity entity : entities) {
            if (preEntity == null) {
                preEntity = entity;
                ret.add(entity);
                continue;
            }
            for (PreparedDistinct preparedDistinct : preparedDistincts) {
                String property = preparedDistinct.getName();
                if (preEntity.getProperty(property).toString().equals(entity.getProperty(property).toString())) continue;
                ret.add(entity);
                preEntity = entity;
                continue block1;
            }
        }
        return ret;
    }

    private List<Entity> getSorted(List<Entity> entities, List<PreparedSort> preparedSorts) {
        Collections.sort(entities, new EntityComparator(preparedSorts));
        return entities;
    }

    private Object get(String s) {
        return this.currentRecord.get(s.toUpperCase());
    }

    public Entity getEntity() {
        return this.currentEntity;
    }

    public Key getKey() {
        return this.currentEntity.getKey();
    }

    @Override
    public boolean absolute(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void afterLast() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void close() throws SQLException {
        this.clear();
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public int findColumn(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean first() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Array getArray(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public InputStream getAsciiStream(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public InputStream getAsciiStream(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public BigDecimal getBigDecimal(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public BigDecimal getBigDecimal(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public BigDecimal getBigDecimal(int i, int j) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public BigDecimal getBigDecimal(String s, int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public InputStream getBinaryStream(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public InputStream getBinaryStream(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Blob getBlob(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean getBoolean(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean getBoolean(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public byte getByte(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public byte getByte(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public byte[] getBytes(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public byte[] getBytes(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Reader getCharacterStream(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Reader getCharacterStream(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Clob getClob(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Date getDate(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Date getDate(String s) throws SQLException {
        String val = this.getString(s);
        java.util.Date date = null;
        if (val != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            try {
                date = format.parse(val);
            }
            catch (ParseException e) {
                format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    date = format.parse(val);
                }
                catch (ParseException ee) {
                    throw new RuntimeException(ee);
                }
            }
        }
        return new Date(date.getTime());
    }

    @Override
    public Date getDate(int i, Calendar calendar) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Date getDate(String s, Calendar calendar) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public double getDouble(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public double getDouble(String s) throws SQLException {
        String val = this.getString(s);
        return val == null ? 0.0 : Double.parseDouble(val);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public float getFloat(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public float getFloat(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public int getInt(int i) throws SQLException {
        return this.getInt(this.getString(i));
    }

    @Override
    public int getInt(String s) throws SQLException {
        String val = this.getString(s);
        return val == null ? 0 : Integer.parseInt(val);
    }

    @Override
    public long getLong(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public long getLong(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Reader getNCharacterStream(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Reader getNCharacterStream(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public NClob getNClob(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public NClob getNClob(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public String getNString(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public String getNString(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Object getObject(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Object getObject(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Ref getRef(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public int getRow() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public RowId getRowId(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public RowId getRowId(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public SQLXML getSQLXML(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public SQLXML getSQLXML(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public short getShort(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public short getShort(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public String getString(int i) throws SQLException {
        return this.getString(this.currentKeys[i - 1].toString());
    }

    @Override
    public String getString(String s) throws SQLException {
        Object val = this.get(s);
        return val == null ? null : val.toString();
    }

    @Override
    public Time getTime(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Time getTime(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Time getTime(int i, Calendar calendar) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Time getTime(String s, Calendar calendar) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Timestamp getTimestamp(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Timestamp getTimestamp(String s) throws SQLException {
        String data = this.getString(s);
        return data == null ? null : Timestamp.valueOf(data);
    }

    @Override
    public Timestamp getTimestamp(int i, Calendar calendar) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Timestamp getTimestamp(String s, Calendar calendar) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public int getType() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public URL getURL(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public URL getURL(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public InputStream getUnicodeStream(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public InputStream getUnicodeStream(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void insertRow() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean last() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean next() throws SQLException {
        boolean hasNext = this.entities.hasNext();
        if (hasNext) {
            this.currentEntity = this.entities.next();
            this.currentRecord = this.currentEntity.getProperties();
            this.currentKeys = this.currentRecord.keySet().toArray();
        } else {
            this.currentEntity = null;
            this.currentRecord = null;
            this.currentKeys = null;
        }
        return hasNext;
    }

    @Override
    public boolean previous() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean relative(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setFetchDirection(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setFetchSize(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateArray(int i, Array array) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateArray(String s, Array array) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateAsciiStream(int i, InputStream inputstream) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateAsciiStream(String s, InputStream inputstream) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateAsciiStream(int i, InputStream inputstream, int j) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateAsciiStream(String s, InputStream inputstream, int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateAsciiStream(int i, InputStream inputstream, long l) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateAsciiStream(String s, InputStream inputstream, long l) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateBigDecimal(int i, BigDecimal bigdecimal) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateBigDecimal(String s, BigDecimal bigdecimal) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateBinaryStream(int i, InputStream inputstream) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateBinaryStream(String s, InputStream inputstream) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateBinaryStream(int i, InputStream inputstream, int j) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateBinaryStream(String s, InputStream inputstream, int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateBinaryStream(int i, InputStream inputstream, long l) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateBinaryStream(String s, InputStream inputstream, long l) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateBlob(int i, Blob blob) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateBlob(String s, Blob blob) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateBlob(int i, InputStream inputstream) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateBlob(String s, InputStream inputstream) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateBlob(int i, InputStream inputstream, long l) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateBlob(String s, InputStream inputstream, long l) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateBoolean(int i, boolean flag) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateBoolean(String s, boolean flag) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateByte(int i, byte byte0) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateByte(String s, byte byte0) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateBytes(int i, byte[] abyte0) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateBytes(String s, byte[] abyte0) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateCharacterStream(int i, Reader reader) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateCharacterStream(String s, Reader reader) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateCharacterStream(int i, Reader reader, int j) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateCharacterStream(String s, Reader reader, int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateCharacterStream(int i, Reader reader, long l) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateCharacterStream(String s, Reader reader, long l) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateClob(int i, Clob clob) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateClob(String s, Clob clob) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateClob(int i, Reader reader) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateClob(String s, Reader reader) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateClob(int i, Reader reader, long l) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateClob(String s, Reader reader, long l) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateDate(int i, Date date) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateDate(String s, Date date) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateDouble(int i, double d) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateDouble(String s, double d) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateFloat(int i, float f) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateFloat(String s, float f) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateInt(int i, int j) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateInt(String s, int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateLong(int i, long l) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateLong(String s, long l) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateNCharacterStream(int i, Reader reader) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateNCharacterStream(String s, Reader reader) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateNCharacterStream(int i, Reader reader, long l) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateNCharacterStream(String s, Reader reader, long l) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateNClob(int i, NClob nclob) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateNClob(String s, NClob nclob) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateNClob(int i, Reader reader) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateNClob(String s, Reader reader) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateNClob(int i, Reader reader, long l) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateNClob(String s, Reader reader, long l) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateNString(int i, String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateNString(String s, String s1) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateNull(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateNull(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateObject(int i, Object obj) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateObject(String s, Object obj) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateObject(int i, Object obj, int j) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateObject(String s, Object obj, int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateRef(int i, Ref ref) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateRef(String s, Ref ref) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateRow() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateRowId(int i, RowId rowid) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateRowId(String s, RowId rowid) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateSQLXML(int i, SQLXML sqlxml) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateSQLXML(String s, SQLXML sqlxml) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateShort(int i, short word0) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateShort(String s, short word0) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateString(int i, String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateString(String s, String s1) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateTime(int i, Time time) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateTime(String s, Time time) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateTimestamp(int i, Timestamp timestamp) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void updateTimestamp(String s, Timestamp timestamp) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean wasNull() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new GaeUnsupportedException();
    }

    private class EntityComparator
    implements Comparator<Entity> {
        private List<PreparedSort> sorts = new ArrayList<PreparedSort>();

        private EntityComparator(List<PreparedSort> sorts) {
            this.sorts = sorts;
        }

        @Override
        public int compare(Entity o1, Entity o2) {
            int ret = 0;
            for (PreparedSort sort : this.sorts) {
                Object obj2;
                Object obj1 = o1.getProperty(sort.getName());
                if (obj1 == (obj2 = o2.getProperty(sort.getName()))) continue;
                ret = obj1.toString().compareTo(obj2.toString());
                if (sort.getDirection() != Query.SortDirection.DESCENDING) break;
                ret *= -1;
                break;
            }
            return ret;
        }
    }
}

