/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.j2ee.servlets;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.util.FileBufferedOutputStream;
import net.sf.jasperreports.j2ee.servlets.BaseHttpServlet;

public class XmlServlet
extends BaseHttpServlet {
    private static final long serialVersionUID = 10200L;
    public static final String START_PAGE_INDEX_REQUEST_PARAMETER = "startPage";
    public static final String END_PAGE_INDEX_REQUEST_PARAMETER = "endPage";
    public static final String PAGE_INDEX_REQUEST_PARAMETER = "page";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Boolean isBuffered;
        List jasperPrintList = BaseHttpServlet.getJasperPrintList(request);
        if (jasperPrintList == null) {
            throw new ServletException("No JasperPrint documents found on the HTTP session.");
        }
        int startPageIndex = -1;
        String startPageStr = request.getParameter(START_PAGE_INDEX_REQUEST_PARAMETER);
        try {
            startPageIndex = Integer.parseInt(startPageStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        int endPageIndex = -1;
        String endPageStr = request.getParameter(END_PAGE_INDEX_REQUEST_PARAMETER);
        try {
            endPageIndex = Integer.parseInt(endPageStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        int pageIndex = -1;
        String pageStr = request.getParameter(PAGE_INDEX_REQUEST_PARAMETER);
        try {
            pageIndex = Integer.parseInt(pageStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (pageIndex >= 0) {
            startPageIndex = pageIndex;
            endPageIndex = pageIndex;
        }
        if ((isBuffered = Boolean.valueOf(request.getParameter("buffered"))).booleanValue()) {
            FileBufferedOutputStream fbos = new FileBufferedOutputStream();
            JRXmlExporter exporter = this.getExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, jasperPrintList);
            if (startPageIndex >= 0) {
                exporter.setParameter(JRExporterParameter.START_PAGE_INDEX, new Integer(startPageIndex));
            }
            if (endPageIndex >= 0) {
                exporter.setParameter(JRExporterParameter.END_PAGE_INDEX, new Integer(endPageIndex));
            }
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, fbos);
            try {
                exporter.exportReport();
                fbos.close();
                if (fbos.size() <= 0) return;
                response.setContentType("text/xml");
                response.setHeader("Content-Disposition", "inline; filename=\"file.jrpxml\"");
                response.setContentLength(fbos.size());
                ServletOutputStream ouputStream = response.getOutputStream();
                try {
                    fbos.writeData((OutputStream)ouputStream);
                    fbos.dispose();
                    ouputStream.flush();
                    return;
                }
                finally {
                    if (ouputStream != null) {
                        try {
                            ouputStream.close();
                        }
                        catch (IOException ex) {}
                    }
                }
            }
            catch (JRException e) {
                throw new ServletException((Throwable)e);
            }
            finally {
                fbos.close();
                fbos.dispose();
            }
        }
        response.setContentType("text/xml");
        response.setHeader("Content-Disposition", "inline; filename=\"file.jrpxml\"");
        JRXmlExporter exporter = this.getExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, jasperPrintList);
        if (startPageIndex >= 0) {
            exporter.setParameter(JRExporterParameter.START_PAGE_INDEX, new Integer(startPageIndex));
        }
        if (endPageIndex >= 0) {
            exporter.setParameter(JRExporterParameter.END_PAGE_INDEX, new Integer(endPageIndex));
        }
        ServletOutputStream ouputStream = response.getOutputStream();
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, ouputStream);
        try {
            exporter.exportReport();
            return;
        }
        catch (JRException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (ouputStream != null) {
                try {
                    ouputStream.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public JRXmlExporter getExporter() {
        return new JRXmlExporter();
    }
}

