/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGenericElement;
import net.sf.jasperreports.engine.JRGenericElementParameter;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRRecordedValuesGenericPrintElement;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplateGenericElement;
import net.sf.jasperreports.engine.fill.JRTemplateGenericPrintElement;

public class JRFillGenericElement
extends JRFillElement
implements JRGenericElement {
    private JRGenericElementParameter[] parameters;
    private Map parameterValues = new HashMap();

    public JRFillGenericElement(JRBaseFiller filler, JRGenericElement element, JRFillObjectFactory factory) {
        super(filler, element, factory);
        this.parameters = element.getParameters();
    }

    public JRFillGenericElement(JRFillGenericElement element, JRFillCloneFactory factory) {
        super(element, factory);
        this.parameters = element.parameters;
    }

    protected void evaluate(byte evaluation) throws JRException {
        this.initDelayedEvaluations();
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if ((this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) && this.isEvaluateNow()) {
            this.evaluateElement(evaluation);
        }
    }

    protected void collectDelayedEvaluations() {
        super.collectDelayedEvaluations();
        for (int i = 0; i < this.parameters.length; ++i) {
            JRGenericElementParameter parameter = this.parameters[i];
            this.collectDelayedEvaluations(parameter.getValueExpression());
        }
    }

    protected void evaluateElement(byte evaluation) throws JRException {
        this.evaluateProperties(evaluation);
        this.parameterValues.clear();
        for (int i = 0; i < this.parameters.length; ++i) {
            JRGenericElementParameter parameter = this.parameters[i];
            Object value = null;
            JRExpression valueExpression = parameter.getValueExpression();
            if (valueExpression != null) {
                value = this.evaluateExpression(valueExpression, evaluation);
            }
            if (value == null && parameter.isSkipWhenEmpty()) continue;
            this.parameterValues.put(parameter.getName(), value);
        }
    }

    protected boolean prepare(int availableHeight, boolean isOverflow) throws JRException {
        boolean willOverflow = false;
        super.prepare(availableHeight, isOverflow);
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
            isToPrint = false;
        }
        if (isToPrint && availableHeight < this.getRelativeY() + this.getHeight()) {
            isToPrint = false;
            willOverflow = true;
        }
        if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isPrintRepeatedValues())) {
            isReprinted = true;
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }

    protected JRPrintElement fill() throws JRException {
        JRTemplateGenericPrintElement printElement;
        if (this.isEvaluateAuto()) {
            JRRecordedValuesGenericPrintElement recordedValuesElement = new JRRecordedValuesGenericPrintElement(this.getTemplate());
            this.copyBasicAttributes(recordedValuesElement);
            this.initDelayedEvaluationPrint(recordedValuesElement);
            printElement = recordedValuesElement;
        } else {
            printElement = new JRTemplateGenericPrintElement(this.getTemplate());
            this.copyBasicAttributes(printElement);
            if (this.isEvaluateNow()) {
                this.copy(printElement);
            } else {
                this.filler.addBoundElement((JRFillElement)this, (JRPrintElement)printElement, this.getEvaluationTime(), this.getEvaluationGroupName(), this.band);
            }
        }
        return printElement;
    }

    protected void copyBasicAttributes(JRGenericPrintElement printElement) {
        printElement.setX(this.getX());
        printElement.setY(this.getRelativeY());
        printElement.setWidth(this.getWidth());
        printElement.setHeight(this.getStretchHeight());
    }

    protected JRTemplateGenericElement getTemplate() {
        return (JRTemplateGenericElement)this.getElementTemplate();
    }

    protected JRTemplateElement createElementTemplate() {
        return new JRTemplateGenericElement(this.getElementOrigin(), this.filler.getJasperPrint().getDefaultStyleProvider(), this);
    }

    protected void copy(JRGenericPrintElement printElement) {
        Iterator it = this.parameterValues.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            printElement.setParameterValue(name, value);
        }
        this.transferProperties(printElement);
    }

    protected void resolveElement(JRPrintElement element, byte evaluation) throws JRException {
        JRGenericPrintElement genericElement = (JRGenericPrintElement)element;
        this.evaluateElement(evaluation);
        this.copy(genericElement);
    }

    protected void rewind() throws JRException {
    }

    public JRGenericElementType getGenericType() {
        return ((JRGenericElement)this.parent).getGenericType();
    }

    public JRGenericElementParameter[] getParameters() {
        return this.parameters;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void visit(JRVisitor visitor) {
        visitor.visitGenericElement(this);
    }

    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillGenericElement(this, factory);
    }

    public byte getEvaluationTime() {
        return ((JRGenericElement)this.parent).getEvaluationTime();
    }

    public String getEvaluationGroupName() {
        return ((JRGenericElement)this.parent).getEvaluationGroupName();
    }
}

