/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.gadgetholder.views;

import com.hisagisoft.eclipse.gadgetholder.GadgetManager;
import com.hisagisoft.eclipse.gadgetholder.model.Gadget;
import com.hisagisoft.eclipse.gadgetholder.views.GadgetView;
import java.util.Collections;
import java.util.logging.Logger;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DragDetectEvent;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TabReorderListener
implements DragDetectListener,
MouseListener {
    private static Logger logger = Logger.getLogger(TabReorderListener.class.getName());
    private CTabFolder folder;
    private GadgetManager manager;
    private GadgetView view;

    public TabReorderListener(CTabFolder folder, GadgetView view) {
        this.folder = folder;
        this.view = view;
        this.manager = GadgetManager.getInstance();
    }

    public void dragDetected(DragDetectEvent e) {
        ((Control)e.widget).setCursor(new Cursor((Device)e.display, 21));
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        try {
            ((Control)e.widget).setCursor(new Cursor((Device)e.display, 0));
            CTabItem item = this.folder.getSelection();
            if (item == null) {
                return;
            }
            Gadget gadget = (Gadget)item.getData(Gadget.class.getName());
            if (gadget == null) {
                return;
            }
            int fromIndex = this.folder.indexOf(item);
            CTabItem toItem = this.folder.getItem(new Point(e.x, e.y));
            if (toItem == null) {
                return;
            }
            int toIndex = this.folder.indexOf(toItem);
            if (fromIndex == toIndex) {
                return;
            }
            logger.fine("from [" + fromIndex + "] to [" + toIndex + "]");
            CTabItem newItem = new CTabItem(this.folder, 0, toIndex);
            newItem.setImage(item.getImage());
            Browser browser = new Browser((Composite)this.folder, 0);
            browser.setUrl(gadget.getFile().getAbsolutePath());
            newItem.setControl((Control)browser);
            newItem.setData(Gadget.class.getName(), (Object)gadget);
            this.folder.setSelection(newItem);
            this.view.addContextMenuToBrowser(browser, gadget);
            item.getControl().dispose();
            item.dispose();
            this.view.syncGadgetOrder();
            Collections.sort(this.manager.getGadgets());
            this.manager.getGadgets().setChanged();
            this.manager.getGadgets().notifyObservers();
            this.manager.saveProperties();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

